/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapesurface;

import java.text.NumberFormat;
import org.jmol.shapesurface.IsosurfaceMesh;
import org.jmol.shapesurface.IsosurfaceRenderer;
import org.jmol.shapesurface.MolecularOrbital;

public class MolecularOrbitalRenderer
extends IsosurfaceRenderer {
    private NumberFormat nf;

    protected void render() {
        this.imageFontScaling = this.viewer.getImageFontScaling();
        MolecularOrbital molecularOrbital = (MolecularOrbital)this.shape;
        int n = this.viewer.getCurrentModelIndex();
        int n2 = molecularOrbital.meshCount;
        while (--n2 >= 0) {
            this.imesh = (IsosurfaceMesh)molecularOrbital.meshes[n2];
            if (!this.render1(this.imesh) || n < 0) continue;
            this.renderInfo();
        }
    }

    private void renderInfo() {
        if (this.mesh.title == null || this.exportType != 0 || !this.g3d.setColix(this.viewer.getColixBackgroundContrast())) {
            return;
        }
        if (this.nf == null) {
            this.nf = NumberFormat.getInstance();
        }
        if (this.nf != null) {
            this.nf.setMaximumFractionDigits(3);
            this.nf.setMinimumFractionDigits(3);
        }
        byte by = this.g3d.getFontFid("Monospaced", 14.0f * this.imageFontScaling);
        this.g3d.setFont(by);
        int n = (int)(15.0f * this.imageFontScaling);
        int n2 = (int)(5.0f * this.imageFontScaling);
        int n3 = n;
        for (int i = 0; i < this.mesh.title.length; ++i) {
            if (this.mesh.title[i].length() <= 0) continue;
            this.g3d.drawStringNoSlab(this.mesh.title[i], null, n2, n3, 0);
            n3 += n;
        }
    }
}

