---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, mots, abréviations
---

# Comment gérer des abréviations ?

La notion d'abréviation recouvre plusieurs cas, décrits ci-après.


## Des abréviations dans le code

### Avec l'extension <ctanpkg:xspace>

LaTeX permet simplement de définir des commandes qui peuvent raccourcir 
la saisie au clavier de textes courts et sécuriser aussi cette saisie 
en ayant une fois pour toutes une version bien écrite à un endroit du document.
Prenons l'exemple de l'expression 
"[Inégalité de Bienaymé-Tchebychev](wpfr:In%C3%A9galit%C3%A9_de_Bienaym%C3%A9-Tchebychev)". 
Voici un code qui, intuitivement, devrait répondre au besoin.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

  \newcommand{\InBT}{inégalité de Bienaymé-Tchebychev}

\begin{document}
Parlons donc de l'\InBT. L'\InBT est une inégalité de concentration...
\end{document}
```

L'exemple ci-dessus montre que notre commande gère mal l'espacement après elle
(du moins, elle suit la méthode usuelle de LaTeX). 
Une solution pourrait alors consister à insérer une espace dans la commande. 
Ce qui donne le résultat suivant :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

  \newcommand{\InBT}{inégalité de Bienaymé-Tchebychev }

\begin{document}
Parlons donc de l'\InBT. L'\InBT est une inégalité de concentration...
\end{document}
```

Là, c'est l'espace avant le point qui est gênante. 
De fait, pour traiter ce point, il existe ici deux possibilités :

- ajouter `{}` immédiatement après le nom de la commande ;
- utiliser l'extension <ctanpkg:xspace>. Cette extension crée une commande 
  `\xspace` qui gère l'espacement après votre commande.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{xspace}

  \newcommand{\InBT}{inégalité de Bienaymé-Tchebychev}
  \newcommand{\InBTc}{inégalité de Bienaymé-Tchebychev\xspace}

\begin{document}
Parlons donc de l'\InBT{}. L'\InBT{} est une inégalité de concentration...

Parlons donc de l'\InBTc. L'\InBTc est une inégalité de concentration...
\end{document}
```


## Des abréviations dans le texte

### Avec l'extension <ctanpkg:abbrevs>

L'extension <ctanpkg:abbrevs> permet d'avoir une mécanique d'abréviation 
dans le code mais aussi dans le texte :

- elle gère l'espacement qui doit être placé après la commande ;
- et elle permet également de définir des abréviations qui s'adaptent : 
  elles sont développées d'une certaine façon la première fois 
  qu'elles sont utilisées, et d'une autre façon ensuite.

Voici un exemple d'utilisation :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{abbrevs}

  \newabbrev\InBT{Inégalité de Bienaymé-Tchebychev (IBT)}[IBT]

\begin{document}
Parlons donc de l'\InBT. L'\InBT est une inégalité de concentration...
\end{document}
```

Ici (et ce n'est pas systématique), nous nous retrouvons avec le problème 
vu précédemment : un espacement mal géré après la commande ! 
Pour ce cas, l'extension <ctanpkg:xspace> n'est d'aucune aide. 
Il faut modifier le code de l'extension <ctanpkg:abbrevs> en rédéfinissant 
une mécanique interne (pour plus détails, vous pouvez consulter les sources 
en bas de cette page).

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{abbrevs}

  \newabbrev\InBT{Inégalité de Bienaymé-Tchebychev (IBT)}[IBT]

  \makeatletter
  \renewcommand\maybe@space@{%
    % \@tempswatrue % <= le code d'origine
    \maybe@ictrue   % <= la correction apportée
    \expandafter   \@tfor
    \expandafter \reserved@a
    \expandafter :%
    \expandafter =%
                 \nospacelist
                 \do \t@st@ic
    % \if@tempswa % <= le code d'origine
    \ifmaybe@ic   % <= la correction apportée
      \space
    \fi
  }
  \makeatother

\begin{document}
Parlons donc de l'\InBT. L'\InBT est une inégalité de concentration...
\end{document}
```


### Des acronymes, avec des listes d'acronymes

L'extension <ctanpkg:acronym> permet de placer une liste des acronymes utilisés
dans le document, et de s'assurer que tous sont écrits au moins une fois 
sous forme développée.


### Des abréviations avec une mise en exposant

La commande `\textsuperscript` permet d'obtenir un exposant sans passer 
en mode mathématique. Il est également possible de définir 
une nouvelle commande `\abrev` qui compose son argument en texte surélevé 
de taille réduite. Les deux méthodes sont illustrées dans l'exemple 
ci-dessous.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

  \newcommand{\abrev}[1]{\raisebox{1ex}{\footnotesize #1}}

\begin{document}
Voici un premier \abrev{test}, ainsi qu'un second \textsuperscript{test}.
\end{document}
```

:::{sources}
- [How to prevent getting a space after an abbreviation using the abbrevs package?](https://tex.stackexchange.com/q/59840),
sur [Tex Stack Exchange](https://tex.stackexchange.com/)
:::