## TFSA-2021-062: Division by 0 in `MaxPoolGradWithArgmax`

### CVE Number
CVE-2021-29573

### Impact
The implementation of `tf.raw_ops.MaxPoolGradWithArgmax` is vulnerable to a
division by 0:

```python
import tensorflow as tf

input = tf.constant([], shape=[0, 0, 0, 0], dtype=tf.float32)
grad = tf.constant([], shape=[0, 0, 0, 0], dtype=tf.float32)
argmax = tf.constant([], shape=[0], dtype=tf.int64)
ksize = [1, 1, 1, 1]
strides = [1, 1, 1, 1]

tf.raw_ops.MaxPoolGradWithArgmax(
  input=input, grad=grad, argmax=argmax, ksize=ksize, strides=strides,
  padding='SAME', include_batch_in_index=False)
```

The
[implementation](https://github.com/tensorflow/tensorflow/blob/279bab6efa22752a2827621b7edb56a730233bd8/tensorflow/core/kernels/maxpooling_op.cc#L1033-L1034)
fails to validate that the batch dimension of the tensor is non-zero, before
dividing by this quantity.

### Patches
We have patched the issue in GitHub commit
[376c352a37ce5a68b721406dc7e77ac4b6cf483d](https://github.com/tensorflow/tensorflow/commit/376c352a37ce5a68b721406dc7e77ac4b6cf483d).

The fix will be included in TensorFlow 2.5.0. We will also cherrypick this
commit on TensorFlow 2.4.2, TensorFlow 2.3.3, TensorFlow 2.2.3 and TensorFlow
2.1.4, as these are also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by Ying Wang and Yakun Zhang of Baidu
X-Team.
