# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, List, Mapping, Optional, TYPE_CHECKING, Union, overload

from .. import _model_base
from .._model_base import rest_field

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class AcceptedAge(_model_base.Model):
    """A person's age, given as a number (value) and a unit (e.g. years, months).

    All required parameters must be populated in order to send to Azure.

    :ivar unit: Possible units for a person's age. Required. Known values are: "years", "months",
     and "days".
    :vartype unit: str or ~azure.healthinsights.clinicalmatching.models.AgeUnit
    :ivar value: The number of years/months/days that represents the person's age. Required.
    :vartype value: float
    """

    unit: Union[str, "_models.AgeUnit"] = rest_field()
    """Possible units for a person's age. Required. Known values are: \"years\", \"months\", and \"days\"."""
    value: float = rest_field()
    """The number of years/months/days that represents the person's age. Required. """

    @overload
    def __init__(
        self,
        *,
        unit: Union[str, "_models.AgeUnit"],
        value: float,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AcceptedAgeRange(_model_base.Model):
    """A definition of the range of ages accepted by a clinical trial. Contains a minimum age and/or a
    maximum age.

    :ivar minimum_age: A person's age, given as a number (value) and a unit (e.g. years, months).
    :vartype minimum_age: ~azure.healthinsights.clinicalmatching.models.AcceptedAge
    :ivar maximum_age: A person's age, given as a number (value) and a unit (e.g. years, months).
    :vartype maximum_age: ~azure.healthinsights.clinicalmatching.models.AcceptedAge
    """

    minimum_age: Optional["_models.AcceptedAge"] = rest_field(name="minimumAge")
    """A person's age, given as a number (value) and a unit (e.g. years, months). """
    maximum_age: Optional["_models.AcceptedAge"] = rest_field(name="maximumAge")
    """A person's age, given as a number (value) and a unit (e.g. years, months). """

    @overload
    def __init__(
        self,
        *,
        minimum_age: Optional["_models.AcceptedAge"] = None,
        maximum_age: Optional["_models.AcceptedAge"] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AreaGeometry(_model_base.Model):
    """``GeoJSON`` geometry, representing the area circle's center.

    All required parameters must be populated in order to send to Azure.

    :ivar type: ``GeoJSON`` geometry type. Required. "Point"
    :vartype type: str or ~azure.healthinsights.clinicalmatching.models.GeoJsonGeometryType
    :ivar coordinates: Coordinates of the area circle's center, represented according to the
     ``GeoJSON`` standard.
     This is an array of 2 decimal numbers, longitude and latitude (precisely in this order).
     Required.
    :vartype coordinates: list[float]
    """

    type: Union[str, "_models.GeoJsonGeometryType"] = rest_field()
    """``GeoJSON`` geometry type. Required. \"Point\""""
    coordinates: List[float] = rest_field()
    """Coordinates of the area circle's center, represented according to the ``GeoJSON`` standard.
This is an array of 2 decimal numbers, longitude and latitude (precisely in this order). Required. """

    @overload
    def __init__(
        self,
        *,
        type: Union[str, "_models.GeoJsonGeometryType"], # pylint: disable=redefined-builtin
        coordinates: List[float],
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AreaProperties(_model_base.Model):
    """``GeoJSON`` object properties.

    All required parameters must be populated in order to send to Azure.

    :ivar sub_type: ``GeoJSON`` object sub-type. Required. "Circle"
    :vartype sub_type: str or
     ~azure.healthinsights.clinicalmatching.models.GeoJsonPropertiesSubType
    :ivar radius: The radius of the area's circle, in meters. Required.
    :vartype radius: float
    """

    sub_type: Union[str, "_models.GeoJsonPropertiesSubType"] = rest_field(name="subType")
    """``GeoJSON`` object sub-type. Required. \"Circle\""""
    radius: float = rest_field()
    """The radius of the area's circle, in meters. Required. """

    @overload
    def __init__(
        self,
        *,
        sub_type: Union[str, "_models.GeoJsonPropertiesSubType"],
        radius: float,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ClinicalCodedElement(_model_base.Model):
    """A piece of clinical information, expressed as a code in a clinical coding system.

    All required parameters must be populated in order to send to Azure.

    :ivar system: The clinical coding system, e.g. ICD-10, SNOMED-CT, UMLS. Required.
    :vartype system: str
    :ivar code: The code within the given clinical coding system. Required.
    :vartype code: str
    :ivar name: The name of this coded concept in the coding system.
    :vartype name: str
    :ivar value: A value associated with the code within the given clinical coding system.
    :vartype value: str
    """

    system: str = rest_field()
    """The clinical coding system, e.g. ICD-10, SNOMED-CT, UMLS. Required. """
    code: str = rest_field()
    """The code within the given clinical coding system. Required. """
    name: Optional[str] = rest_field()
    """The name of this coded concept in the coding system. """
    value: Optional[str] = rest_field()
    """A value associated with the code within the given clinical coding system. """

    @overload
    def __init__(
        self,
        *,
        system: str,
        code: str,
        name: Optional[str] = None,
        value: Optional[str] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ClinicalNoteEvidence(_model_base.Model):
    """A piece of evidence from a clinical note (text document).

    All required parameters must be populated in order to send to Azure.

    :ivar id: The identifier of the document containing the evidence. Required.
    :vartype id: str
    :ivar text: The actual text span which is evidence for the inference.
    :vartype text: str
    :ivar offset: The start index of the evidence text span in the document (0 based). Required.
    :vartype offset: int
    :ivar length: The length of the evidence text span. Required.
    :vartype length: int
    """

    id: str = rest_field()
    """The identifier of the document containing the evidence. Required. """
    text: Optional[str] = rest_field()
    """The actual text span which is evidence for the inference. """
    offset: int = rest_field()
    """The start index of the evidence text span in the document (0 based). Required. """
    length: int = rest_field()
    """The length of the evidence text span. Required. """

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        offset: int,
        length: int,
        text: Optional[str] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ClinicalTrialDemographics(_model_base.Model):
    """Demographic criteria for a clinical trial.

    :ivar accepted_sex: Indication of the sex of people who may participate in the clinical trial.
     Known values are: "all", "female", and "male".
    :vartype accepted_sex: str or
     ~azure.healthinsights.clinicalmatching.models.ClinicalTrialAcceptedSex
    :ivar accepted_age_range: A definition of the range of ages accepted by a clinical trial.
     Contains a minimum age and/or a maximum age.
    :vartype accepted_age_range: ~azure.healthinsights.clinicalmatching.models.AcceptedAgeRange
    """

    accepted_sex: Optional[Union[str, "_models.ClinicalTrialAcceptedSex"]] = rest_field(name="acceptedSex")
    """Indication of the sex of people who may participate in the clinical trial. Known values are: \"all\",
    \"female\", and \"male\". """
    accepted_age_range: Optional["_models.AcceptedAgeRange"] = rest_field(name="acceptedAgeRange")
    """A definition of the range of ages accepted by a clinical trial. Contains a minimum age and/or a maximum age. """

    @overload
    def __init__(
        self,
        *,
        accepted_sex: Optional[Union[str, "_models.ClinicalTrialAcceptedSex"]] = None,
        accepted_age_range: Optional["_models.AcceptedAgeRange"] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ClinicalTrialDetails(_model_base.Model):
    """A description of a clinical trial.

    All required parameters must be populated in order to send to Azure.

    :ivar id: A given identifier for the clinical trial. Has to be unique within a list of clinical
     trials. Required.
    :vartype id: str
    :ivar eligibility_criteria_text: The eligibility criteria of the clinical trial (inclusion and
     exclusion), given as text.
    :vartype eligibility_criteria_text: str
    :ivar demographics: Demographic criteria for a clinical trial.
    :vartype demographics: ~azure.healthinsights.clinicalmatching.models.ClinicalTrialDemographics
    :ivar metadata: Trial data which is of interest to the potential participant. Required.
    :vartype metadata: ~azure.healthinsights.clinicalmatching.models.ClinicalTrialMetadata
    """

    id: str = rest_field()
    """A given identifier for the clinical trial. Has to be unique within a list of clinical trials. Required. """
    eligibility_criteria_text: Optional[str] = rest_field(name="eligibilityCriteriaText")
    """The eligibility criteria of the clinical trial (inclusion and exclusion), given as text. """
    demographics: Optional["_models.ClinicalTrialDemographics"] = rest_field()
    """Demographic criteria for a clinical trial. """
    metadata: "_models.ClinicalTrialMetadata" = rest_field()
    """Trial data which is of interest to the potential participant. Required. """

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        metadata: "_models.ClinicalTrialMetadata",
        eligibility_criteria_text: Optional[str] = None,
        demographics: Optional["_models.ClinicalTrialDemographics"] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ClinicalTrialMetadata(_model_base.Model):
    """Trial data which is of interest to the potential participant.

    All required parameters must be populated in order to send to Azure.

    :ivar phases: Phases which are relevant for the clinical trial.
     Each clinical trial can be in a certain phase or in multiple phases.
    :vartype phases: list[str or ~azure.healthinsights.clinicalmatching.models.ClinicalTrialPhase]
    :ivar study_type: Possible study types of a clinical trial. Known values are: "interventional",
     "observational", "expandedAccess", and "patientRegistries".
    :vartype study_type: str or
     ~azure.healthinsights.clinicalmatching.models.ClinicalTrialStudyType
    :ivar recruitment_status: Possible recruitment status of a clinical trial. Known values are:
     "unknownStatus", "notYetRecruiting", "recruiting", and "enrollingByInvitation".
    :vartype recruitment_status: str or
     ~azure.healthinsights.clinicalmatching.models.ClinicalTrialRecruitmentStatus
    :ivar conditions: Medical conditions and their synonyms which are relevant for the clinical
     trial, given as strings. Required.
    :vartype conditions: list[str]
    :ivar sponsors: Sponsors/collaborators involved with the trial.
    :vartype sponsors: list[str]
    :ivar contacts: Contact details of the trial administrators, for patients that want to
     participate in the trial.
    :vartype contacts: list[~azure.healthinsights.clinicalmatching.models.ContactDetails]
    :ivar facilities: Research facilities where the clinical trial is conducted.
    :vartype facilities:
     list[~azure.healthinsights.clinicalmatching.models.ClinicalTrialResearchFacility]
    """

    phases: Optional[List[Union[str, "_models.ClinicalTrialPhase"]]] = rest_field()
    """Phases which are relevant for the clinical trial.
Each clinical trial can be in a certain phase or in multiple phases. """
    study_type: Optional[Union[str, "_models.ClinicalTrialStudyType"]] = rest_field(name="studyType")
    """Possible study types of a clinical trial. Known values are: \"interventional\", \"observational\",
    \"expandedAccess\", and \"patientRegistries\". """
    recruitment_status: Optional[Union[str, "_models.ClinicalTrialRecruitmentStatus"]] = rest_field(
        name="recruitmentStatus"
    )
    """Possible recruitment status of a clinical trial. Known values are: \"unknownStatus\", \"notYetRecruiting\",
    \"recruiting\", and \"enrollingByInvitation\". """
    conditions: List[str] = rest_field()
    """Medical conditions and their synonyms which are relevant for the clinical trial, given as strings. Required. """
    sponsors: Optional[List[str]] = rest_field()
    """Sponsors/collaborators involved with the trial. """
    contacts: Optional[List["_models.ContactDetails"]] = rest_field()
    """Contact details of the trial administrators, for patients that want to participate in the trial. """
    facilities: Optional[List["_models.ClinicalTrialResearchFacility"]] = rest_field()
    """Research facilities where the clinical trial is conducted. """

    @overload
    def __init__(
        self,
        *,
        conditions: List[str],
        phases: Optional[List[Union[str, "_models.ClinicalTrialPhase"]]] = None,
        study_type: Optional[Union[str, "_models.ClinicalTrialStudyType"]] = None,
        recruitment_status: Optional[Union[str, "_models.ClinicalTrialRecruitmentStatus"]] = None,
        sponsors: Optional[List[str]] = None,
        contacts: Optional[List["_models.ContactDetails"]] = None,
        facilities: Optional[List["_models.ClinicalTrialResearchFacility"]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ClinicalTrialRegistryFilter(_model_base.Model):  # pylint: disable=too-many-instance-attributes
    """A filter defining a subset of clinical trials from a given clinical trial registry (e.g.
    clinicaltrials.gov).

    :ivar conditions: Trials with any of the given medical conditions will be included in the
     selection (provided that other limitations are satisfied).
     Leaving this list empty will not limit the medical conditions.
    :vartype conditions: list[str]
    :ivar study_types: Trials with any of the given study types will be included in the selection
     (provided that other limitations are satisfied).
     Leaving this list empty will not limit the study types.
    :vartype study_types: list[str or
     ~azure.healthinsights.clinicalmatching.models.ClinicalTrialStudyType]
    :ivar recruitment_statuses: Trials with any of the given recruitment statuses will be included
     in the selection (provided that other limitations are satisfied).
     Leaving this list empty will not limit the recruitment statuses.
    :vartype recruitment_statuses: list[str or
     ~azure.healthinsights.clinicalmatching.models.ClinicalTrialRecruitmentStatus]
    :ivar sponsors: Trials with any of the given sponsors will be included in the selection
     (provided that other limitations are satisfied).
     Leaving this list empty will not limit the sponsors.
    :vartype sponsors: list[str]
    :ivar phases: Trials with any of the given phases will be included in the selection (provided
     that other limitations are satisfied).
     Leaving this list empty will not limit the phases.
    :vartype phases: list[str or ~azure.healthinsights.clinicalmatching.models.ClinicalTrialPhase]
    :ivar purposes: Trials with any of the given purposes will be included in the selection
     (provided that other limitations are satisfied).
     Leaving this list empty will not limit the purposes.
    :vartype purposes: list[str or
     ~azure.healthinsights.clinicalmatching.models.ClinicalTrialPurpose]
    :ivar ids: Trials with any of the given identifiers will be included in the selection (provided
     that other limitations are satisfied).
     Leaving this list empty will not limit the trial identifiers.
    :vartype ids: list[str]
    :ivar sources: Trials with any of the given sources will be included in the selection (provided
     that other limitations are satisfied).
     Leaving this list empty will not limit the sources.
    :vartype sources: list[str or
     ~azure.healthinsights.clinicalmatching.models.ClinicalTrialSource]
    :ivar facility_names: Trials with any of the given facility names will be included in the
     selection (provided that other limitations are satisfied).
     Leaving this list empty will not limit the trial facility names.
    :vartype facility_names: list[str]
    :ivar facility_locations: Trials with any of the given facility locations will be included in
     the selection (provided that other limitations are satisfied).
     Leaving this list empty will not limit the trial facility locations.
    :vartype facility_locations:
     list[~azure.healthinsights.clinicalmatching.models.GeographicLocation]
    :ivar facility_areas: Trials with any of the given facility area boundaries will be included in
     the selection (provided that other limitations are satisfied).
     Leaving this list empty will not limit the trial facility area boundaries.
    :vartype facility_areas: list[~azure.healthinsights.clinicalmatching.models.GeographicArea]
    """

    conditions: Optional[List[str]] = rest_field()
    """Trials with any of the given medical conditions will be included in the selection (provided that other
    limitations are satisfied). Leaving this list empty will not limit the medical conditions. """
    study_types: Optional[List[Union[str, "_models.ClinicalTrialStudyType"]]] = rest_field(name="studyTypes")
    """Trials with any of the given study types will be included in the selection (provided that other limitations
    are satisfied). Leaving this list empty will not limit the study types. """
    recruitment_statuses: Optional[List[Union[str, "_models.ClinicalTrialRecruitmentStatus"]]] = rest_field(
        name="recruitmentStatuses"
    )
    """Trials with any of the given recruitment statuses will be included in the selection (provided that other
    limitations are satisfied). Leaving this list empty will not limit the recruitment statuses. """
    sponsors: Optional[List[str]] = rest_field()
    """Trials with any of the given sponsors will be included in the selection (provided that other limitations are
    satisfied). Leaving this list empty will not limit the sponsors. """
    phases: Optional[List[Union[str, "_models.ClinicalTrialPhase"]]] = rest_field()
    """Trials with any of the given phases will be included in the selection (provided that other limitations are
    satisfied). Leaving this list empty will not limit the phases. """
    purposes: Optional[List[Union[str, "_models.ClinicalTrialPurpose"]]] = rest_field()
    """Trials with any of the given purposes will be included in the selection (provided that other limitations are
    satisfied). Leaving this list empty will not limit the purposes. """
    ids: Optional[List[str]] = rest_field()
    """Trials with any of the given identifiers will be included in the selection (provided that other limitations
    are satisfied). Leaving this list empty will not limit the trial identifiers. """
    sources: Optional[List[Union[str, "_models.ClinicalTrialSource"]]] = rest_field()
    """Trials with any of the given sources will be included in the selection (provided that other limitations are
    satisfied). Leaving this list empty will not limit the sources. """
    facility_names: Optional[List[str]] = rest_field(name="facilityNames")
    """Trials with any of the given facility names will be included in the selection (provided that other limitations
    are satisfied). Leaving this list empty will not limit the trial facility names. """
    facility_locations: Optional[List["_models.GeographicLocation"]] = rest_field(name="facilityLocations")
    """Trials with any of the given facility locations will be included in the selection (provided that other
    limitations are satisfied). Leaving this list empty will not limit the trial facility locations. """
    facility_areas: Optional[List["_models.GeographicArea"]] = rest_field(name="facilityAreas")
    """Trials with any of the given facility area boundaries will be included in the selection (provided that other
    limitations are satisfied). Leaving this list empty will not limit the trial facility area boundaries. """

    @overload
    def __init__(
        self,
        *,
        conditions: Optional[List[str]] = None,
        study_types: Optional[List[Union[str, "_models.ClinicalTrialStudyType"]]] = None,
        recruitment_statuses: Optional[List[Union[str, "_models.ClinicalTrialRecruitmentStatus"]]] = None,
        sponsors: Optional[List[str]] = None,
        phases: Optional[List[Union[str, "_models.ClinicalTrialPhase"]]] = None,
        purposes: Optional[List[Union[str, "_models.ClinicalTrialPurpose"]]] = None,
        ids: Optional[List[str]] = None,
        sources: Optional[List[Union[str, "_models.ClinicalTrialSource"]]] = None,
        facility_names: Optional[List[str]] = None,
        facility_locations: Optional[List["_models.GeographicLocation"]] = None,
        facility_areas: Optional[List["_models.GeographicArea"]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ClinicalTrialResearchFacility(_model_base.Model):
    """Details of a research facility where a clinical trial is conducted.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The facility's name. Required.
    :vartype name: str
    :ivar city: City name.
    :vartype city: str
    :ivar state: State name.
    :vartype state: str
    :ivar country_or_region: Country/region name. Required.
    :vartype country_or_region: str
    """

    name: str = rest_field()
    """The facility's name. Required. """
    city: Optional[str] = rest_field()
    """City name. """
    state: Optional[str] = rest_field()
    """State name. """
    country_or_region: str = rest_field(name="countryOrRegion")
    """Country/region name. Required. """

    @overload
    def __init__(
        self,
        *,
        name: str,
        country_or_region: str,
        city: Optional[str] = None,
        state: Optional[str] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ClinicalTrials(_model_base.Model):
    """The clinical trials that the patient(s) should be matched to.
    The trial selection can be given as a list of custom clinical trials and/or a list of filters
    to known clinical trial registries.
    In case both are given, the resulting trial set is a union of the two sets.

    :ivar custom_trials: A list of clinical trials.
    :vartype custom_trials:
     list[~azure.healthinsights.clinicalmatching.models.ClinicalTrialDetails]
    :ivar registry_filters: A list of filters, each one creating a selection of trials from a given
     clinical trial registry.
    :vartype registry_filters:
     list[~azure.healthinsights.clinicalmatching.models.ClinicalTrialRegistryFilter]
    """

    custom_trials: Optional[List["_models.ClinicalTrialDetails"]] = rest_field(name="customTrials")
    """A list of clinical trials. """
    registry_filters: Optional[List["_models.ClinicalTrialRegistryFilter"]] = rest_field(name="registryFilters")
    """A list of filters, each one creating a selection of trials from a given
clinical trial registry. """

    @overload
    def __init__(
        self,
        *,
        custom_trials: Optional[List["_models.ClinicalTrialDetails"]] = None,
        registry_filters: Optional[List["_models.ClinicalTrialRegistryFilter"]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ContactDetails(_model_base.Model):
    """A person's contact details.

    :ivar name: The person's name.
    :vartype name: str
    :ivar email: The person's email.
    :vartype email: str
    :ivar phone: A person's phone number.
    :vartype phone: str
    """

    name: Optional[str] = rest_field()
    """The person's name. """
    email: Optional[str] = rest_field()
    """The person's email. """
    phone: Optional[str] = rest_field()
    """A person's phone number. """

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        email: Optional[str] = None,
        phone: Optional[str] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class DocumentContent(_model_base.Model):
    """The content of the patient document.

    All required parameters must be populated in order to send to Azure.

    :ivar source_type: The type of the content's source.
     In case the source type is 'inline', the content is given as a string (for instance, text).
     In case the source type is 'reference', the content is given as a URI. Required. Known values
     are: "inline" and "reference".
    :vartype source_type: str or
     ~azure.healthinsights.clinicalmatching.models.DocumentContentSourceType
    :ivar value: The content of the document, given either inline (as a string) or as a reference
     (URI). Required.
    :vartype value: str
    """

    source_type: Union[str, "_models.DocumentContentSourceType"] = rest_field(name="sourceType")
    """The type of the content's source. In case the source type is 'inline', the content is given as a string (for
    instance, text). In case the source type is 'reference', the content is given as a URI. Required. Known values
    are: \"inline\" and \"reference\". """
    value: str = rest_field()
    """The content of the document, given either inline (as a string) or as a reference (URI). Required. """

    @overload
    def __init__(
        self,
        *,
        source_type: Union[str, "_models.DocumentContentSourceType"],
        value: str,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class Error(_model_base.Model):
    """The error object.

    All required parameters must be populated in order to send to Azure.

    :ivar code: One of a server-defined set of error codes. Required.
    :vartype code: str
    :ivar message: A human-readable representation of the error. Required.
    :vartype message: str
    :ivar target: The target of the error.
    :vartype target: str
    :ivar details: An array of details about specific errors that led to this reported error.
     Required.
    :vartype details: list[~azure.healthinsights.clinicalmatching.models.Error]
    :ivar innererror: An object containing more specific information than the current object about
     the error.
    :vartype innererror: ~azure.healthinsights.clinicalmatching.models.InnerError
    """

    code: str = rest_field()
    """One of a server-defined set of error codes. Required. """
    message: str = rest_field()
    """A human-readable representation of the error. Required. """
    target: Optional[str] = rest_field()
    """The target of the error. """
    details: List["_models.Error"] = rest_field()
    """An array of details about specific errors that led to this reported error. Required. """
    innererror: Optional["_models.InnerError"] = rest_field()
    """An object containing more specific information than the current object about the error. """

    @overload
    def __init__(
        self,
        *,
        code: str,
        message: str,
        details: List["_models.Error"],
        target: Optional[str] = None,
        innererror: Optional["_models.InnerError"] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ExtendedClinicalCodedElement(_model_base.Model):
    """A piece of clinical information, expressed as a code in a clinical coding system, extended by
    semantic information.

    All required parameters must be populated in order to send to Azure.

    :ivar system: The clinical coding system, e.g. ICD-10, SNOMED-CT, UMLS. Required.
    :vartype system: str
    :ivar code: The code within the given clinical coding system. Required.
    :vartype code: str
    :ivar name: The name of this coded concept in the coding system.
    :vartype name: str
    :ivar value: A value associated with the code within the given clinical coding system.
    :vartype value: str
    :ivar semantic_type: The `UMLS semantic type
     <https://www.nlm.nih.gov/research/umls/META3_current_semantic_types.html>`_ associated with the
     coded concept.
    :vartype semantic_type: str
    :ivar category: The bio-medical category related to the coded concept, e.g. Diagnosis, Symptom,
     Medication, Examination.
    :vartype category: str
    """

    system: str = rest_field()
    """The clinical coding system, e.g. ICD-10, SNOMED-CT, UMLS. Required. """
    code: str = rest_field()
    """The code within the given clinical coding system. Required. """
    name: Optional[str] = rest_field()
    """The name of this coded concept in the coding system. """
    value: Optional[str] = rest_field()
    """A value associated with the code within the given clinical coding system. """
    semantic_type: Optional[str] = rest_field(name="semanticType")
    """The `UMLS semantic type <https://www.nlm.nih.gov/research/umls/META3_current_semantic_types.html>`_ associated
    with the coded concept. """
    category: Optional[str] = rest_field()
    """The bio-medical category related to the coded concept, e.g. Diagnosis, Symptom, Medication, Examination. """

    @overload
    def __init__(
        self,
        *,
        system: str,
        code: str,
        name: Optional[str] = None,
        value: Optional[str] = None,
        semantic_type: Optional[str] = None,
        category: Optional[str] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class GeographicArea(_model_base.Model):
    """A geographic area, expressed as a ``Circle`` geometry represented using a ``GeoJSON Feature``
    (see `GeoJSON spec <https://tools.ietf.org/html/rfc7946>`_ ).

    All required parameters must be populated in order to send to Azure.

    :ivar type: ``GeoJSON`` type. Required. "Feature"
    :vartype type: str or ~azure.healthinsights.clinicalmatching.models.GeoJsonType
    :ivar geometry: ``GeoJSON`` geometry, representing the area circle's center. Required.
    :vartype geometry: ~azure.healthinsights.clinicalmatching.models.AreaGeometry
    :ivar properties: ``GeoJSON`` object properties. Required.
    :vartype properties: ~azure.healthinsights.clinicalmatching.models.AreaProperties
    """

    type: Union[str, "_models.GeoJsonType"] = rest_field() # pylint: disable=redefined-builtin
    """``GeoJSON`` type. Required. \"Feature\""""
    geometry: "_models.AreaGeometry" = rest_field()
    """``GeoJSON`` geometry, representing the area circle's center. Required. """
    properties: "_models.AreaProperties" = rest_field()
    """``GeoJSON`` object properties. Required. """

    @overload
    def __init__(
        self,
        *,
        type: Union[str, "_models.GeoJsonType"], # pylint: disable=redefined-builtin
        geometry: "_models.AreaGeometry",
        properties: "_models.AreaProperties",
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class GeographicLocation(_model_base.Model):
    """A location given as a combination of city, state and country/region. It could specify a city, a
    state or a country/region.
    In case a city is specified, either state +country/region or country/region (for
    countries/regions where there are no states) should be added.
    In case a state is specified (without a city), country/region should be added.

    All required parameters must be populated in order to send to Azure.

    :ivar city: City name.
    :vartype city: str
    :ivar state: State name.
    :vartype state: str
    :ivar country_or_region: Country/region name. Required.
    :vartype country_or_region: str
    """

    city: Optional[str] = rest_field()
    """City name. """
    state: Optional[str] = rest_field()
    """State name. """
    country_or_region: str = rest_field(name="countryOrRegion")
    """Country/region name. Required. """

    @overload
    def __init__(
        self,
        *,
        country_or_region: str,
        city: Optional[str] = None,
        state: Optional[str] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class InnerError(_model_base.Model):
    """An object containing more specific information about the error. As per Microsoft One API
    guidelines -
    https://github.com/Microsoft/api-guidelines/blob/vNext/Guidelines.md#7102-error-condition-responses.

    All required parameters must be populated in order to send to Azure.

    :ivar code: One of a server-defined set of error codes. Required.
    :vartype code: str
    :ivar innererror: Inner error.
    :vartype innererror: ~azure.healthinsights.clinicalmatching.models.InnerError
    """

    code: str = rest_field()
    """One of a server-defined set of error codes. Required. """
    innererror: Optional["_models.InnerError"] = rest_field()
    """Inner error. """

    @overload
    def __init__(
        self,
        *,
        code: str,
        innererror: Optional["_models.InnerError"] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class PatientDocument(_model_base.Model):
    """A clinical document related to a patient. Document here is in the wide sense - not just a text
    document (note).

    All required parameters must be populated in order to send to Azure.

    :ivar type: The type of the patient document, such as 'note' (text document) or 'fhirBundle'
     (FHIR JSON document). Required. Known values are: "note", "fhirBundle", "dicom", and
     "genomicSequencing".
    :vartype type: str or ~azure.healthinsights.clinicalmatching.models.DocumentType
    :ivar clinical_type: The type of the clinical document. Known values are: "consultation",
     "dischargeSummary", "historyAndPhysical", "procedure", "progress", "imaging", "laboratory", and
     "pathology".
    :vartype clinical_type: str or
     ~azure.healthinsights.clinicalmatching.models.ClinicalDocumentType
    :ivar id: A given identifier for the document. Has to be unique across all documents for a
     single patient. Required.
    :vartype id: str
    :ivar language: A 2 letter ISO 639-1 representation of the language of the document.
    :vartype language: str
    :ivar created_date_time: The date and time when the document was created.
    :vartype created_date_time: ~datetime.datetime
    :ivar content: The content of the patient document. Required.
    :vartype content: ~azure.healthinsights.clinicalmatching.models.DocumentContent
    """

    type: Union[str, "_models.DocumentType"] = rest_field() # pylint: disable=redefined-builtin
    """The type of the patient document, such as 'note' (text document) or 'fhirBundle' (FHIR JSON document).
    Required. Known values are: \"note\", \"fhirBundle\", \"dicom\", and \"genomicSequencing\". """
    clinical_type: Optional[Union[str, "_models.ClinicalDocumentType"]] = rest_field(name="clinicalType")
    """The type of the clinical document. Known values are: \"consultation\", \"dischargeSummary\",
    \"historyAndPhysical\", \"procedure\", \"progress\", \"imaging\", \"laboratory\", and \"pathology\". """
    id: str = rest_field()
    """A given identifier for the document. Has to be unique across all documents for a single patient. Required. """
    language: Optional[str] = rest_field()
    """A 2 letter ISO 639-1 representation of the language of the document. """
    created_date_time: Optional[datetime.datetime] = rest_field(name="createdDateTime")
    """The date and time when the document was created. """
    content: "_models.DocumentContent" = rest_field()
    """The content of the patient document. Required. """

    @overload
    def __init__(
        self,
        *,
        type: Union[str, "_models.DocumentType"], # pylint: disable=redefined-builtin
        id: str,  # pylint: disable=redefined-builtin
        content: "_models.DocumentContent",
        clinical_type: Optional[Union[str, "_models.ClinicalDocumentType"]] = None,
        language: Optional[str] = None,
        created_date_time: Optional[datetime.datetime] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class PatientInfo(_model_base.Model):
    """Patient structured information, including demographics and known structured clinical
    information.

    :ivar sex: The patient's sex. Known values are: "female", "male", and "unspecified".
    :vartype sex: str or ~azure.healthinsights.clinicalmatching.models.PatientInfoSex
    :ivar birth_date: The patient's date of birth.
    :vartype birth_date: ~datetime.date
    :ivar clinical_info: Known clinical information for the patient, structured.
    :vartype clinical_info:
     list[~azure.healthinsights.clinicalmatching.models.ClinicalCodedElement]
    """

    sex: Optional[Union[str, "_models.PatientInfoSex"]] = rest_field()
    """The patient's sex. Known values are: \"female\", \"male\", and \"unspecified\"."""
    birth_date: Optional[datetime.date] = rest_field(name="birthDate")
    """The patient's date of birth. """
    clinical_info: Optional[List["_models.ClinicalCodedElement"]] = rest_field(name="clinicalInfo")
    """Known clinical information for the patient, structured. """

    @overload
    def __init__(
        self,
        *,
        sex: Optional[Union[str, "_models.PatientInfoSex"]] = None,
        birth_date: Optional[datetime.date] = None,
        clinical_info: Optional[List["_models.ClinicalCodedElement"]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class PatientRecord(_model_base.Model):
    """A patient record, including their clinical information and data.

    All required parameters must be populated in order to send to Azure.

    :ivar id: A given identifier for the patient. Has to be unique across all patients in a single
     request. Required.
    :vartype id: str
    :ivar info: Patient structured information, including demographics and known structured
     clinical information.
    :vartype info: ~azure.healthinsights.clinicalmatching.models.PatientInfo
    :ivar data: Patient unstructured clinical data, given as documents.
    :vartype data: list[~azure.healthinsights.clinicalmatching.models.PatientDocument]
    """

    id: str = rest_field()
    """A given identifier for the patient. Has to be unique across all patients in a single request. Required. """
    info: Optional["_models.PatientInfo"] = rest_field()
    """Patient structured information, including demographics and known structured clinical information. """
    data: Optional[List["_models.PatientDocument"]] = rest_field()
    """Patient unstructured clinical data, given as documents. """

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        info: Optional["_models.PatientInfo"] = None,
        data: Optional[List["_models.PatientDocument"]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class TrialMatcherData(_model_base.Model):
    """TrialMatcherData.

    All required parameters must be populated in order to send to Azure.

    :ivar patients: The list of patients, including their clinical information and data. Required.
    :vartype patients: list[~azure.healthinsights.clinicalmatching.models.PatientRecord]
    :ivar configuration: Configuration affecting the Trial Matcher model's inference.
    :vartype configuration:
     ~azure.healthinsights.clinicalmatching.models.TrialMatcherModelConfiguration
    """

    patients: List["_models.PatientRecord"] = rest_field()
    """The list of patients, including their clinical information and data. Required. """
    configuration: Optional["_models.TrialMatcherModelConfiguration"] = rest_field()
    """Configuration affecting the Trial Matcher model's inference. """

    @overload
    def __init__(
        self,
        *,
        patients: List["_models.PatientRecord"],
        configuration: Optional["_models.TrialMatcherModelConfiguration"] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class TrialMatcherInference(_model_base.Model):
    """An inference made by the Trial Matcher model regarding a patient.

    All required parameters must be populated in order to send to Azure.

    :ivar type: The type of the Trial Matcher inference. Required. "trialEligibility"
    :vartype type: str or ~azure.healthinsights.clinicalmatching.models.TrialMatcherInferenceType
    :ivar value: The value of the inference, as relevant for the given inference type. Required.
    :vartype value: str
    :ivar description: The description corresponding to the inference value.
    :vartype description: str
    :ivar confidence_score: Confidence score for this inference.
    :vartype confidence_score: float
    :ivar evidence: The evidence corresponding to the inference value.
    :vartype evidence:
     list[~azure.healthinsights.clinicalmatching.models.TrialMatcherInferenceEvidence]
    :ivar id: The identifier of the clinical trial.
    :vartype id: str
    :ivar source: Possible sources of a clinical trial. Known values are: "custom" and
     "clinicaltrials.gov".
    :vartype source: str or ~azure.healthinsights.clinicalmatching.models.ClinicalTrialSource
    :ivar metadata: Trial data which is of interest to the potential participant.
    :vartype metadata: ~azure.healthinsights.clinicalmatching.models.ClinicalTrialMetadata
    """

    type: Union[str, "_models.TrialMatcherInferenceType"] = rest_field() # pylint: disable=redefined-builtin
    """The type of the Trial Matcher inference. Required. \"trialEligibility\""""
    value: str = rest_field()
    """The value of the inference, as relevant for the given inference type. Required. """
    description: Optional[str] = rest_field()
    """The description corresponding to the inference value. """
    confidence_score: Optional[float] = rest_field(name="confidenceScore")
    """Confidence score for this inference. """
    evidence: Optional[List["_models.TrialMatcherInferenceEvidence"]] = rest_field()
    """The evidence corresponding to the inference value. """
    id: Optional[str] = rest_field()
    """The identifier of the clinical trial. """
    source: Optional[Union[str, "_models.ClinicalTrialSource"]] = rest_field()
    """Possible sources of a clinical trial. Known values are: \"custom\" and \"clinicaltrials.gov\"."""
    metadata: Optional["_models.ClinicalTrialMetadata"] = rest_field()
    """Trial data which is of interest to the potential participant. """

    @overload
    def __init__(
        self,
        *,
        type: Union[str, "_models.TrialMatcherInferenceType"], # pylint: disable=redefined-builtin
        value: str,
        description: Optional[str] = None,
        confidence_score: Optional[float] = None,
        evidence: Optional[List["_models.TrialMatcherInferenceEvidence"]] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        source: Optional[Union[str, "_models.ClinicalTrialSource"]] = None,
        metadata: Optional["_models.ClinicalTrialMetadata"] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class TrialMatcherInferenceEvidence(_model_base.Model):
    """A piece of evidence corresponding to a Trial Matcher inference.

    :ivar eligibility_criteria_evidence: A piece of evidence from the eligibility criteria text of
     a clinical trial.
    :vartype eligibility_criteria_evidence: str
    :ivar patient_data_evidence: A piece of evidence from a clinical note (text document).
    :vartype patient_data_evidence:
     ~azure.healthinsights.clinicalmatching.models.ClinicalNoteEvidence
    :ivar patient_info_evidence: A piece of clinical information, expressed as a code in a clinical
     coding
     system.
    :vartype patient_info_evidence:
     ~azure.healthinsights.clinicalmatching.models.ClinicalCodedElement
    :ivar importance: A value indicating how important this piece of evidence is for the inference.
    :vartype importance: float
    """

    eligibility_criteria_evidence: Optional[str] = rest_field(name="eligibilityCriteriaEvidence")
    """A piece of evidence from the eligibility criteria text of a clinical trial. """
    patient_data_evidence: Optional["_models.ClinicalNoteEvidence"] = rest_field(name="patientDataEvidence")
    """A piece of evidence from a clinical note (text document). """
    patient_info_evidence: Optional["_models.ClinicalCodedElement"] = rest_field(name="patientInfoEvidence")
    """A piece of clinical information, expressed as a code in a clinical coding
system. """
    importance: Optional[float] = rest_field()
    """A value indicating how important this piece of evidence is for the inference. """

    @overload
    def __init__(
        self,
        *,
        eligibility_criteria_evidence: Optional[str] = None,
        patient_data_evidence: Optional["_models.ClinicalNoteEvidence"] = None,
        patient_info_evidence: Optional["_models.ClinicalCodedElement"] = None,
        importance: Optional[float] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class TrialMatcherModelConfiguration(_model_base.Model):
    """Configuration affecting the Trial Matcher model's inference.

    All required parameters must be populated in order to send to Azure.

    :ivar verbose: An indication whether the model should produce verbose output.
    :vartype verbose: bool
    :ivar include_evidence: An indication whether the model's output should include evidence for
     the inferences.
    :vartype include_evidence: bool
    :ivar clinical_trials: The clinical trials that the patient(s) should be matched to. :code:`<br
     />`The trial
     selection can be given as a list of custom clinical trials and/or a list of
     filters to known clinical trial registries. In case both are given, the
     resulting trial set is a union of the two sets. Required.
    :vartype clinical_trials: ~azure.healthinsights.clinicalmatching.models.ClinicalTrials
    """

    verbose: bool = rest_field(default=False)
    """An indication whether the model should produce verbose output. """
    include_evidence: bool = rest_field(name="includeEvidence", default=True)
    """An indication whether the model's output should include evidence for the inferences. """
    clinical_trials: "_models.ClinicalTrials" = rest_field(name="clinicalTrials")
    """The clinical trials that the patient(s) should be matched to. :code:`<br />`The trial
selection can be given as a list of custom clinical trials and/or a list of
filters to known clinical trial registries. In case both are given, the
resulting trial set is a union of the two sets. Required. """

    @overload
    def __init__(
        self,
        *,
        clinical_trials: "_models.ClinicalTrials",
        verbose: bool = False,
        include_evidence: bool = True,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class TrialMatcherPatientResult(_model_base.Model):
    """The results of the model's work for a single patient.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The identifier given for the patient in the request. Required.
    :vartype id: str
    :ivar inferences: The model's inferences for the given patient. Required.
    :vartype inferences: list[~azure.healthinsights.clinicalmatching.models.TrialMatcherInference]
    :ivar needed_clinical_info: Clinical information which is needed to provide better trial
     matching results for the patient. Clinical information which is needed to provide better trial
     matching results for the patient.
    :vartype needed_clinical_info:
     list[~azure.healthinsights.clinicalmatching.models.ExtendedClinicalCodedElement]
    """

    id: str = rest_field()
    """The identifier given for the patient in the request. Required. """
    inferences: List["_models.TrialMatcherInference"] = rest_field()
    """The model's inferences for the given patient. Required. """
    needed_clinical_info: Optional[List["_models.ExtendedClinicalCodedElement"]] = rest_field(name="neededClinicalInfo")
    """Clinical information which is needed to provide better trial matching results for the patient. Clinical
    information which is needed to provide better trial matching results for the patient. """

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        inferences: List["_models.TrialMatcherInference"],
        needed_clinical_info: Optional[List["_models.ExtendedClinicalCodedElement"]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class TrialMatcherResult(_model_base.Model):
    """The response for the Trial Matcher request.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar job_id: A processing job identifier. Required.
    :vartype job_id: str
    :ivar created_date_time: The date and time when the processing job was created. Required.
    :vartype created_date_time: ~datetime.datetime
    :ivar expiration_date_time: The date and time when the processing job is set to expire.
     Required.
    :vartype expiration_date_time: ~datetime.datetime
    :ivar last_update_date_time: The date and time when the processing job was last updated.
     Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar status: The status of the processing job. Required. Known values are: "notStarted",
     "running", "succeeded", "failed", and "partiallyCompleted".
    :vartype status: str or ~azure.healthinsights.clinicalmatching.models.JobStatus
    :ivar errors: An array of errors, if any errors occurred during the processing job.
    :vartype errors: list[~azure.healthinsights.clinicalmatching.models.Error]
    :ivar results: The inference results for the Trial Matcher request.
    :vartype results: ~azure.healthinsights.clinicalmatching.models.TrialMatcherResults
    """

    job_id: str = rest_field(name="jobId", readonly=True)
    """A processing job identifier. Required. """
    created_date_time: datetime.datetime = rest_field(name="createdDateTime", readonly=True)
    """The date and time when the processing job was created. Required. """
    expiration_date_time: datetime.datetime = rest_field(name="expirationDateTime", readonly=True)
    """The date and time when the processing job is set to expire. Required. """
    last_update_date_time: datetime.datetime = rest_field(name="lastUpdateDateTime", readonly=True)
    """The date and time when the processing job was last updated. Required. """
    status: Union[str, "_models.JobStatus"] = rest_field(readonly=True)
    """The status of the processing job. Required. Known values are: \"notStarted\", \"running\", \"succeeded\",
    \"failed\", and \"partiallyCompleted\". """
    errors: Optional[List["_models.Error"]] = rest_field(readonly=True)
    """An array of errors, if any errors occurred during the processing job. """
    results: Optional["_models.TrialMatcherResults"] = rest_field(readonly=True)
    """The inference results for the Trial Matcher request. """


class TrialMatcherResults(_model_base.Model):
    """The inference results for the Trial Matcher request.

    All required parameters must be populated in order to send to Azure.

    :ivar patients: Results for the patients given in the request. Required.
    :vartype patients:
     list[~azure.healthinsights.clinicalmatching.models.TrialMatcherPatientResult]
    :ivar model_version: The version of the model used for inference, expressed as the model date.
     Required.
    :vartype model_version: str
    :ivar knowledge_graph_last_update_date: The date when the clinical trials knowledge graph was
     last updated.
    :vartype knowledge_graph_last_update_date: ~datetime.date
    """

    patients: List["_models.TrialMatcherPatientResult"] = rest_field()
    """Results for the patients given in the request. Required. """
    model_version: str = rest_field(name="modelVersion")
    """The version of the model used for inference, expressed as the model date. Required. """
    knowledge_graph_last_update_date: Optional[datetime.date] = rest_field(name="knowledgeGraphLastUpdateDate")
    """The date when the clinical trials knowledge graph was last updated. """

    @overload
    def __init__(
        self,
        *,
        patients: List["_models.TrialMatcherPatientResult"],
        model_version: str,
        knowledge_graph_last_update_date: Optional[datetime.date] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)
