# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ApplicationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of application being monitored."""

    WEB = "web"
    OTHER = "other"


class FlowType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Used by the Application Insights system to determine what kind of flow this component was
    created by. This is to be set to 'Bluefield' when creating/updating a component via the REST
    API.
    """

    BLUEFIELD = "Bluefield"


class IngestionMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates the flow of the ingestion."""

    APPLICATION_INSIGHTS = "ApplicationInsights"
    APPLICATION_INSIGHTS_WITH_DIAGNOSTIC_SETTINGS = "ApplicationInsightsWithDiagnosticSettings"
    LOG_ANALYTICS = "LogAnalytics"


class PublicNetworkAccessType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The network access type for operating on the Application Insights Component. By default it is
    Enabled.
    """

    ENABLED = "Enabled"
    """Enables connectivity to Application Insights through public DNS."""
    DISABLED = "Disabled"
    """Disables public connectivity to Application Insights through public DNS."""


class PurgeState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status of the operation represented by the requested Id."""

    PENDING = "pending"
    COMPLETED = "completed"


class RequestSource(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes what tool created this Application Insights component. Customers using this API
    should set this to the default 'rest'.
    """

    REST = "rest"
