// Copyright (c) Microsoft Corporation.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception


// Copyright 2018 Ulf Adams
// Copyright (c) Microsoft Corporation. All rights reserved.

// Boost Software License - Version 1.0 - August 17th, 2003

// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:

// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.


// This file contains test cases derived from:
// https://github.com/ulfjack/ryu
// See xcharconv_ryu.h for the exact commit.
// (Keep the cgmanifest.json commitHash in sync.)


#ifndef DOUBLE_FIXED_PRECISION_TO_CHARS_TEST_CASES_3_HPP
#define DOUBLE_FIXED_PRECISION_TO_CHARS_TEST_CASES_3_HPP

#include <charconv>

#include "test.hpp"
using namespace std;

inline constexpr DoublePrecisionToCharsTestCase double_fixed_precision_to_chars_test_cases_3[] = {
    // Ryu Printf d2fixed_test.cc D2fixedTest AllBinaryExponents
    // These values test every binary exponent.
    // The mantissas were randomly generated.
    {0x0.63b831e8bd9d7p-1022, chars_format::fixed, 1074,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000008667315560"
        "1518373204745615934992065170006880827787289636461039456117181014435225731420739682086431846196084055971776"
        "1976781401452617612090003075542930260777812518669659241729724010681746641686623499848468215594968202107915"
        "3402945471922988971873909012440740220527800911244244822910902773084448896950002963160859062629660988288537"
        "4947604962348974323036144310657614326754120115556509383797380330234783520222245524583876671362471849408043"
        "1858617260899963028423305531253945552260335123939000593240656910669298632181747412649714974019858835628576"
        "1402581880926947783051518340651609793980053160313425027619711896255545853478748493923212623215309262429188"
        "9535798750202922731324119623206905408779063259071595105183391812893811664489504206776437911230459576472640"
        "03753662109375"},
    {0x1.8777195166b0cp-1022, chars_format::fixed, 1072,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000034024962888"
        "5488918707803802237219634159360572672157684890228809310363407096641170467659879771805264411927667980233377"
        "8493381613983963619886353435618596864780020416582962791672696335498871803986814670850483660459156676370951"
        "5096631215158510441977866477856881896988317751492854297037574001592689593245951090014597401089987064349011"
        "8898178199420014167358923990328782986564433565017977882465941632972037475759286148645435617069627150190560"
        "6610044637601532768006545677482036919081933078680182749619038785085197654630878239258803610922679880731846"
        "1295595610061523269781283221357431760026778081133972233612002223605221826818897235077493324279732240457324"
        "0208707312500506083305050530743859909422095574730572935613200283098897446182155845928463122618268243968486"
        "785888671875"},
    {0x1.4668b84fe57a0p-1021, chars_format::fixed, 1068,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000056740958740"
        "6416315113843845367765611463402272605773579309805044238876264896175716378374414880313837549557854086594144"
        "6517571068268270820532248191376149517571648221869547136333897392941241920946002959571014115138922292227756"
        "5675579700156979183315496460915138087093250268282674126774708694126428169237269531699329932826961970700281"
        "7860044551711084995833922394577051992453091701226019440181486036346841321732890759392314160217956773831481"
        "0836998109083129295391451373564751392901299926267367714488145730269066445855381488848672338113942395343914"
        "7931259731375390972529039085122338240869687761572122993383754664276573025666127187344547915597384296829871"
        "1175582031872758195259747569288096497941384426647703960591649037179391408883266656459909427212551236152648"
        "92578125"},
    {0x1.befe59a615135p-1020, chars_format::fixed, 1072,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000155405261736"
        "2235237599344524566268329346499410781820240377373211399724292118817533439328423661067387776003211400451369"
        "3088093284719809466733351558863675884965219358948864762862301475919926006238764851665875890220244143133239"
        "4990914215952953745660507019834777919259824309540394759202512511945735293837981431982027834358977473029612"
        "0303664088965600921426179216076245193704452662458429835783277758594438863220080552115251534233085611706230"
        "8503464635136074518967164258938058608025448494327947396239370394992669778837860314635821269578123701586483"
        "9016649103853253096649589094048656135137787361348031132374178952614572001907211566747518775736907525882271"
        "0974186182997578768175923453881771250830539545867001930118621195145977916950326414013971998429042287170886"
        "993408203125"},
    {0x1.1e3d1ff2f0c7dp-1019, chars_format::fixed, 1071,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000199032000513"
        "5142880561598924319312704477072269270245936137839955953465230545195415127755767083901447533947828678376962"
        "8840827353272482512734186549366506777424260696503583584763933654973123255607415124268905380654726960778878"
        "0455364488415004387840662750774569999550709914737717510587715348152633060357249935862626075624081617450315"
        "4885783858040748854022822093131458054271092923292182143582852711297479202477529680286154546026438265660119"
        "0666964359310825902834425266702229494789747194864674154539719905344544705996332452876246842805615529643436"
        "3330985188230759038449117763080644432854364707566853651485305297515523425163520740729706771939538840583142"
        "0311524001253621714021938613841338246896203505202451193812218773931269549326908419040194075932959094643592"
        "83447265625"},
    {0x1.6f434a1f8b19bp-1018, chars_format::fixed, 1070,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000510741853904"
        "6846927047373682830132718075006256443666199351873286782041441258279676361749462207484160512079462800015135"
        "1247641526009378027445855026174588417177058971036936098000778820888042031017906554373258977780010263225403"
        "4985134368614288894180981269713098266814859393907435942503999009239804035089734298703368406224788919100457"
        "8703872406975692839527795367059563095996889887433505152749668146313379417615714580759187210921661443825061"
        "5079726743650989704965620642901239809189450397279529801654706466234792028552787228839089551760441918109416"
        "4246004056408218871243893690629186700027052396055033266400221089830267330844275401596778964865771996400585"
        "2935700696823519264465123996032196818637410241732060994427104056094504278256324125706555605574976652860641"
        "4794921875"},
    {0x1.587345c18153ep-1017, chars_format::fixed, 1068,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000958034150713"
        "4764786508271836926643404057427002697780971266720840479203611958030287584788324659120693742922007657201247"
        "5701432533443920920943404653989371931593878000743154963499391621521760536226285826940742684233420125807325"
        "1475122129361059576300349579506194683866694625320913445655672698919325929161890237571835547216240424390568"
        "4503604058791100485208980042190187445440799433710816373805294721006156102426371505496796959141102703635606"
        "8282898610242996821028731917836326909139019066634183567364278468611980916064135979863051465895296219949754"
        "3645034872914477180174891107535697767424819637337145925449261230552011300809574685296849175758943122326736"
        "0016445450314712551946974418885474268936771312658360117220892077307970715813190132337240356719121336936950"
        "68359375"},
    {0x1.f1b6b87277fdep-1016, chars_format::fixed, 1067,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002768624646153"
        "3842708986290401534510677245449052480438452772935563477911887903937433332521175778793903095384041223955723"
        "1923283555660292437990927601776574893980601557250737329754310915661825472040213756951830291482697155616984"
        "2700521540676609741125857389706633023242364855348478771230295850829291438723530923932923590702415161133831"
        "9751130631733719608246390666274473865694983392385750305737090058291815147877218349104719543513706308913668"
        "3774947602824936693432977762482651171413713941775960038695919756102724251419600380177635071493624586144398"
        "8258956704733318591666199586331239518529031729048520377213164363192327716960117074516227535950936913289772"
        "7641328747183370449707056957130139385301002356826323260325258247061322707666120024327938153874129056930541"
        "9921875"},
    {0x1.72a498409980ap-1015, chars_format::fixed, 1066,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004123539674247"
        "7088973208679969440262899254505285796142223814175822702981218018251380021070120502969772416262035601116862"
        "1659532952906006748436531426296108744371485218418489239052308056360753777114430810169989395269594614007716"
        "4320660032095927443769046869340226546265147500705839457828617891438915581029354085740892509908612620206500"
        "3470601897807688053820010379771148507245760602767529755342564783534772481563133530608872155816317027321781"
        "0752940595356441071317848377916852111771962558733789348917288503698641911641096452799678633118324142847003"
        "8337938910339876846473513908343996450852057201827354601830122948746860487681564435359569830201224403457687"
        "8689343471222581935495027065359114155162611459186679259780987690986908851542569465209453483112156391143798"
        "828125"},
    {0x1.ce91e910d066ap-1014, chars_format::fixed, 1065,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010292523314007"
        "6692326385741229598904670825352808317734627817052485596428748937263427579368777377894657327312479354581078"
        "4168520162117480372890622941534124448870772252012602868730161774020407765816726274221052686557419196324208"
        "4715821192601015609484863570373655101393795400044083081325937387959984377717529567097636750383014741316553"
        "2296085557798963633773657299527935426265350193083637673227681353297917537837040452104722871743258998969100"
        "5987271282509672399868182403468494296246048065289295098149422654468288628128861924787217849829763922746869"
        "6498494503455447606065743273997995338245842660162359635250494954539395011676725002188222864503213932415104"
        "3434437466649570437521385841177305817305146442292695750907213149985758651738798619135195622220635414123535"
        "15625"},
    {0x1.a41cd0fb8478fp-1013, chars_format::fixed, 1065,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000018695629667714"
        "5895916750114590693491523617790849939055674886628194086158815830540057384771933110599023450761887740398618"
        "5824526219439376956126341760163322548493370609238456330600806577305257232320501329017953024287747627232037"
        "4572663686511555161745450335781058166365489962041606001461174122457962935078569449571467063040254113362718"
        "6270376597920952277811842692283769740789234856500541032298070456110972851620621529465978994343606420788243"
        "5523527518948000764505675072290355683463164250772690889284988502644183665525616575696351007686952407174842"
        "7534905766691870864059461860337314739734261516944168507075000763370610415995639606879253113685553781567772"
        "1698849612362059270919596759679334039324781881079759845171743998123959837331931055359746096655726432800292"
        "96875"},
    {0x1.3e41d54eded4ap-1012, chars_format::fixed, 1063,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000028325827575460"
        "1010515391461536595545429499538498991017040932231183342824512646699604684458146742737342772784980027834494"
        "0826857661781276292472081843809864410394521611902853735829998834742158468857697790386059626657678189248144"
        "5265662942795816062763062880205368461416441764978817899328156614741166754420207438171074196786033403238981"
        "1562883073602025172957382372382340446938272102534472564616360448591956313016751702183344954371143800460586"
        "5651843981130671659574810922103783984979009729510987301074119123340693948685620445541815789689681881384571"
        "9863898666697465652428037545729301943625700762708492646428142876480594651159481998644386165302340702226649"
        "3420721660512347699421921315325612490897898554760724211631142191989730927392798776054405607283115386962890"
        "625"},
    {0x1.59221b87422dcp-1011, chars_format::fixed, 1061,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000061435754675809"
        "8837646073896440391226534816436897514942795483804072267347155569125119595580491351990480913034570147895374"
        "9199275969705612822746490917273049925735363788261777654916069143307907122518136274038077410603228952574550"
        "1894977879086594931372343135335203122952344387060517702808821656121476327893372871287902363583684228396504"
        "2552837102397922174874664511453596393052110185322246667762253606317075736272542989625758436326997585642760"
        "2393018166303632030454315402968032670946012485516681270764073451032999719873203349131460740206557039826594"
        "4836102598855186999874252382364402869617545149531825646529605517647352402816777252637898126613360122856215"
        "3297584372631820351071291137909988929778674731782707342702834301100683900287435790232848376035690307617187"
        "5"},
    {0x1.922a6e54c4bcbp-1010, chars_format::fixed, 1062,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000143175758120767"
        "8327909696250760734478106796867078939935710607595708573102607339856178147302943011543601422950427382699571"
        "9719448226349739066691249962145223646872006733056733177952965276951071879207560520825522978044535983860163"
        "5063151499836135276583501528784180827303324409079815563661661810073697306944122825275004360202036872430423"
        "1730496903611600686763522497807086760639060265790948955651670281170776489599001405555481916829703134521996"
        "2049561733515970274623532308359345306507214497299752967076056620391451927843542333198029013832277189655932"
        "7003259554334471200742545952329769103656526541210519870252214162081769755690283719852718057095066069103438"
        "8286525048452890343118312657240371183075690897644137388980693277205566427134897367068333551287651062011718"
        "75"},
    {0x1.072696ae9ff91p-1009, chars_format::fixed, 1061,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000187369544044078"
        "4291437168256570360327506576425988595810379182000643821407577934103660676935011263322031392440132868733732"
        "7819429571347328935398026964825400882351174079562591710725763861350852064930712839397819262007054683145461"
        "2780065823082780248832842288655503722395814417931461558621625008415876667488081682041201864635065571426334"
        "0405276148348836991757774602316265058289810704660352544391098522007138900938734431720321349687880063890794"
        "9709313371539376131216980483491496783060831614106142375317162155275223986726898573134529318360000096717296"
        "5143050437935935892946724098972506000684771103211681358055518407789793900084808470241680962256248128922853"
        "0618262874396186671763441010328385573357333169766190506328011882320599967854946044099051505327224731445312"
        "5"},
    {0x1.0f9b544278c4bp-1008, chars_format::fixed, 1060,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000386780857037671"
        "1567970796017679738247589622247284651871120320458105704644504432357204561914952702147103351310377425294926"
        "6522585529115860650409630476395436935935507513474968265776334027719389758555490887642752812234042372625443"
        "7003602105036202827450917721436713168500906698052919896534518850932069398418985212286909672403077626688044"
        "8498682233610964812352992899821397333236093549925309032199246559964137142197652767564372214748185530284478"
        "9634362218477877578958247021052670972459957651572193372191075738314273872600135872061638159242292718022325"
        "3091674188986794275627204849031519506259253092951584828274906785555947413973379382135394648484451886157711"
        "823604868006218023272010337471584057274727293089669987057330278589634131591878940525930374860763549804687"
        "5"},
    {0x1.0c159c101694ep-1007, chars_format::fixed, 1058,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000763529751430495"
        "2261443821158790115458810239952267930887072096693486627813429923330320913248325488240687702430323149784113"
        "2668378588282844988957673108519903635709387991611919147754896201845081043636843712353787917153989017063736"
        "6932138547129575358975875396466265445790571512067390465956520149044782555700513502538083461702835278243119"
        "7582947539338933804403231554930541964237271712749234912326942139379518950109342558327795161374824729966907"
        "0645661865847799037929906255545116191400664691706275381307240314885435819146724738014196031743697185913499"
        "1743063453593039715400411684846294312720981800565410139278357031636119321693824562320610441540921048911338"
        "48306373809820626535624355866825082456994424052303706479922855952791049816141821793280541896820068359375"},
    {0x1.5dea4ce8e9d1cp-1006, chars_format::fixed, 1056,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001993183345740184"
        "3380206268213719062063350814301599018679933261580130337290316898735876549592164313534803701036771696187184"
        "3460238736763173540738894631496044341513014086769607675313389734660544429847137223449237368185473282818899"
        "0763143676913549798050111000449048160356662711177445920457729101143615093098470889673928997872159077848989"
        "8585846173250830089770352087321756188087231770443888379781496362819885950130996391895508049596794526555364"
        "9325413439043352821440085193375901604390558169700922107887759422298045475048448298435182127152924989867102"
        "5481762571674803699881589864389977475085144039107611461508367830308205819849065857072705384254490978027536"
        "459817993513291304840523425775112141496214071257787596000063921886091833357568248175084590911865234375"},
    {0x1.f54052ccfbd85p-1005, chars_format::fixed, 1057,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005710443944044190"
        "3852943648577406503088003161021002627368323935629069966209695533414405887372311247087423593978194334966196"
        "9952724399972643565145643565596680341154191365245563840621127630622979641166875699011127504856846210492539"
        "1744823983638657336393276468809438060554239207107070390674319071138242241936104300064142641425316186292876"
        "8191727964756739054251002351820210559683067678277426478312879053806872980671807735494036931597606968803747"
        "0882986462600191569302988629020903776604825882710768551646760758983546554323851915180357433146496665776619"
        "8572115325587926099638392334145329333710974022615959231083135651027696907010536501610597578068435532320904"
        "0588603358187555694328693197982659012778489710933784939697285300275186870067045674659311771392822265625"},
    {0x1.0090aa3ec4669p-1004, chars_format::fixed, 1056,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005845773229837182"
        "3574823131482226670449533326157358746716791953135062569212292668611641801097780408195948596588837344740206"
        "4062727322207217975101640660738989340741657280509189289276615212047497934355406431806641278847883402312309"
        "8163293513531622437049966284424578880391547670271754853142196587321184864022163506030620064283346385358597"
        "4609101781931276219629563822287439933439020777086511705876102130660051067922171320065746506246599474937571"
        "3082577376195362056859759924579898568161899707504166498745404902069366067260964218815046333952411377650629"
        "1985183641972212962838327237136002597053343023166906014203406467918165849951752439662675714851568453713696"
        "999227239301169029854864368002366842252656116249943591260695464895125184057178557850420475006103515625"},
    {0x1.68e98ac55ee26p-1003, chars_format::fixed, 1054,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016446596413123795"
        "5496522777053303591275019495978878844846436113300880266183458890074114483112001652990041532139330705876914"
        "7931204601218918457779787534281968243383197085376948804904484155483575710841719547823710139827936080983236"
        "7310569254298888979285082470600025912273776655596072801476943857591614720191994310220487539252764806264502"
        "0023888520863214641824353895255575638074536400353005626823857188489512901031327512343674332673547866665016"
        "5049446488498649673464767822603396054217556395696443674379523864848838394183411800390626841460528189649358"
        "0856602004955530161376182324364433356271439175620899551166489231616354720849782465783774866022112969364460"
        "3102397975669649131600761665002532724955406576363194307423103157628219150865334086120128631591796875"},
    {0x1.87db0e29f0009p-1002, chars_format::fixed, 1054,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000035713345155797761"
        "7610792878229505570226756358469896911919377105068137826586828649404727968260620169232867708166475001047504"
        "8111775029985548082700855953146127275470476240362930600538807521258481943527749576808605590290184599616254"
        "1846749805790846105326505422770593434773819010873491570027088825238135898601918199194638645572473742585546"
        "0042359579974778458859418696543460213592095168174624769832598626020025085824933983826300131126260391727473"
        "7077701597408770546536826007815061861863878219345146805938471244598864512590567375912282127533791281642861"
        "0226307164803685258847872420371124674464082326064123043271224908418295695531191416257587024691172442399017"
        "5156552477624283439156405949424531825414560528190620328410111172789953570827492512762546539306640625"},
    {0x1.1ebac54ed6e41p-1001, chars_format::fixed, 1053,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000052264507616884437"
        "5698058090407392073363666940952778105547306570912930855963880587815215988005244769961306374980627154903920"
        "2577080249977927392021364007921809496051524796096624912662285949137122585722498527523998551285095014756776"
        "2895554588799427559673865771118036682097147368320276001640375343800006580702811100203326519987841007167969"
        "2989050499741043577435715581470077666354778579928550640390691438050605710431110522225336076906939348214560"
        "5809107751188268682005099869148951108398761525370973305398559682309093811078973750072903988378385138191514"
        "6710101115251870548115971597103922009910991277759144615181140737633537081068270245133990756049414344541691"
        "511157350304779944771415413564368359181745069897590897094359629893034480119240470230579376220703125"},
    {0x1.26d300e06c7a2p-1000, chars_format::fixed, 1051,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000107479972537888434"
        "9002591708831714014935426753194183154300531753894711710626048627725959770241731634484316278231555944004086"
        "4068960179163231231879379245227770021788137500855177795500847910430675168458379864001111773312371956782280"
        "6226662250753080318042176493313687445777034547389630877431167690917476995346565873313653117306467438260736"
        "9955012283179212129357477946380958365891562954818745714107417513297964491278143411211987964497322424618499"
        "2767489380272657401336731570937923770881934128877584144038050995144315844786026271102120245128418421698397"
        "3666369609678050583111455989070311087100154293624874535866388069907047758018717555500470604262934072224772"
        "3902377618834842156673903433698480020775608092608474045288879938908621625159867107868194580078125"},
    {0x1.05d0c9256bd0dp-999, chars_format::fixed, 1051,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000190892926200005014"
        "6246109184641947605537081104324320091424275239881358691794611711727670645040801753875872256603903100157907"
        "4117272136518386432913664549165447650838094687054485497396164457724638108265725028655437867246843186135519"
        "7603365817074407495992907452548985192207846909020732206018231589776116670138494034579664823906926825506391"
        "6895324452269427403961247476556898979817349667497675420979079930454125061487858631618590818324348506617419"
        "3837808794729928192158724968573011652615506712770263804093560900759819690351122605383339463689895499253299"
        "3062766970887678113838307812351896769519964147208086459095207951677451629103665277817776597541497215541395"
        "3814454153462956899623245175859438180611960265891792845084629082208493855432607233524322509765625"},
    {0x1.d161118863a28p-998, chars_format::fixed, 1047,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000678627268276378223"
        "0838381983740574462538627006938330369010760005283210472937468617690271829803643955687653670078357664384731"
        "5850357334123342099135674182764104627918354063120311333624666154673642334968649978203709306412298553137595"
        "8742662333631894713141488626368453672515176764212534710900244814738983099412252627437078976170183585539748"
        "0023329148528522435511879625527696702064745017607821933043748687600890171795457338357909910477142886261852"
        "6510348200725081223743044674000271753348231462705442545938227394702232735449601014985791669981798312694471"
        "6921886272884729180867056629180582090341046115889341965333287053999468745767913532019182182102123704212662"
        "886623891441087681874017124137900152328702188653090400516365576777388923801481723785400390625"},
    {0x1.a15ea25a19660p-997, chars_format::fixed, 1044,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000001217237261310228099"
        "3179252931186926982692345919033968631102111765103315033304380176933385417160002408427950029547023800373790"
        "3138964229170029641147550066555294617444125756680352014437431112856968897249350959816759223604652482795967"
        "2222373231938825328608517533711548379199837592813292143627291147239524233411932374697495007614762032590063"
        "3348562563414895932402962713954954623414922689851738589686706046155327824502166704335474048380283048951935"
        "5136211942835589461562419698678550112002073553337267646181096609192841991425028505763676531064365863007797"
        "4934313260104372537119221193415761606516937805300536262521389430432123931165919988196641744515354119527516"
        "627448597478758769526591885977945190412930384876548373096483146582613699138164520263671875"},
    {0x1.3405ef09605c0p-996, chars_format::fixed, 1042,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000001796667664366212833"
        "5665392247768118683231502978059871166650153469309831612890500966882039821861868400342764656165871202066209"
        "9545587837211036370546812947350494432238004683763664567568973440673650283854843511596346369844271953549611"
        "5538726433986266863862950537061969082882291651460484133576667255869437876496100220690327162754077519560211"
        "3421651211440307831129924696845524348946549788527717960851496934136922932274256932207250250473001752070024"
        "9939263105447824182001422269657481368614500917398558972900508936492536325012033905462034273351706791432421"
        "3319731475850729738988853204799698138245429919661266017564480782965092181767914524772807011403834355276543"
        "4718432890065190765206137218078347442517180856079439532635433351970277726650238037109375"},
    {0x1.d446d39179d61p-995, chars_format::fixed, 1047,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000005462819694528703087"
        "8864501228515552805464723717056197760606756889643903510249553048439017711133773671440354639386335467946363"
        "5258948740705694069667341257396888036371466715243466156053378293733554928216028872449926627028194020003476"
        "6664065924797146527366094882988718989577228548661057271640470276933597886851166967309922049028614618566248"
        "7877704337685653857174654805590027514341847429667755625338708736633025559983835650906911708214459739844502"
        "2686629737262804848201604027875209019963234888348727732753557137541010501446542044860603307612488978949804"
        "5902945493217533531235155103049453504888178998390271594265142786559200789840036462465329069941137693873004"
        "796208275584924267266632096981173837936942963677930569510454716919412021525204181671142578125"},
    {0x1.2a6191841a2f8p-994, chars_format::fixed, 1043,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000006961706248722051462"
        "1989094015930584333539423148144476551620642624680348776495275585358068724521997148409410638391145465795792"
        "7017181245452872915474622111096382221071681697520914214818303865707205751044498351025044453688419836560516"
        "6521031955111219642419220298954347889214534531094837790091823656984057353139300007125800329303520470602016"
        "7948760755422183994450699458391794656901738793039684960506013257067218773020004462578765143900984223269242"
        "8211132570873279618568830654102695286917053708082753966210260483718165254879075265420369865879763466609644"
        "4025144902359009191385276894101485935046230814418030394044362489237345080002513507196221229272533013931878"
        "75344385870254336857446723410797249302829991612732996042467448205570690333843231201171875"},
    {0x1.43dd16d8c3d1dp-993, chars_format::fixed, 1045,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000015112507155402444702"
        "0135306022393565196762089755575456624338495151308209685256453809677900586317175819989462383489016678007812"
        "8257051031812975438500637988525335792799955185122494381194781947242274154359276094785530478989334370229123"
        "2578133321237095332394795413283832150988339299341446907213468318738317581991050115126670141483262312008742"
        "6760602897763558894964250015209221575190675349103449428597587562568657357560934571444329997703898734942358"
        "0768701256013775365443771733885337641114591771941836216818733412905512656103173434643853672019620647251124"
        "8650423697903231660849991114857078523790278047758844805828089772138726744675213995976355584951293948756727"
        "5285870905514013401789321488674482336764102707025482497105173251839005388319492340087890625"},
    {0x1.1e84f4437de27p-992, chars_format::fixed, 1044,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000026739808737490122536"
        "4009190269428022346895766923714793667844056434839900624330085514973193324262004035356895030064921783009805"
        "7918884705807964199330848477612812938804273799622712378519478003286575370136489884812949516962024244211760"
        "9607483360980909948460156496553861705524933111620692577199003799030305070085885260314199767588940990499498"
        "8078689242985218461431861416650687300826323297128877359071851056100330924999478855370872777021779956743000"
        "7545478335135816334783842422798567071342281048609259270742047112691073337142757755314683776136264937390122"
        "1873542271412143094297154950828903295388934717444104032709543164412117129850006101772698944311067042059526"
        "539301195418948431941957516625083848704359299592279997082044928902178071439266204833984375"},
    {0x1.c7925872b0513p-991, chars_format::fixed, 1043,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000085033691573552436743"
        "0323595018676754258445568824857213848746280704072236823268383060174370779364946428938559999659947344275015"
        "0581379957883082860514723669360341807003760516126412415812793589694396310117558079412640180009205258501662"
        "8168299988567681700239036505371609193017146078988594512058175724878949384378830226335983376290822291404418"
        "9248632446027235425101963979115169194359369052429197321029095626722937610274060480758657835985167284620389"
        "4634678489005824269693355199622645770717771904806998788414597121681720429667752369447431326712331419045036"
        "4414271762903198285517145494958139622568612777791641778831814314868966462936027519211973383768944719374984"
        "21558727010629900424393170314473940204826819442250618319434352088137529790401458740234375"},
    {0x1.627c15354010bp-990, chars_format::fixed, 1042,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000132331069010968920653"
        "7939780857239039544548016633334237413237030012119277536525667655183086798246156040464737778965504678479790"
        "1474884457846727559831433511307559536909759330053748585588483826065566236369058902865464984070903402002662"
        "7323204785317407458069469681884433078585615253137057737022751348523239464068872849303111358475731358182415"
        "8502490046319712249459640319924660673321900548594141665580600670298168713356715944526652647848979125983846"
        "7839220086418924382938642559837439793813090896823728294937356571010588743924249642142134571267294351604717"
        "9447180198284565221387942070716104062289822563870293702055361674097594361411801121077029800561858618979754"
        "7525922561378864683438391102840453976506918695559000820338724224711768329143524169921875"},
    {0x1.1d2de00ed154dp-989, chars_format::fixed, 1041,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000212917897767202319747"
        "4417184045234455038251105719793602087695352964073068726597457261574546506799204162006987775011216832563456"
        "0635491340196070442302984208136777483158675150452452277667442374906278069217074864671270429435465616153992"
        "9432660458951455065381945835228296653375005117467866235836194378970814659593732987749891400034868404843486"
        "7379969507431598347670943694548493918720371503317755078814637245395045814662285721966172731060086325202379"
        "8327662484462321083041143497819466891858512956512833365948538251133632051079775839484970665348326549120564"
        "9633701698994828372260402174673318251741533123437069536319726151119995618020513531694305619149713245476241"
        "680154186797493041998623136670913061162976041319760955872197882854379713535308837890625"},
    {0x1.17d753cb61bd0p-988, chars_format::fixed, 1036,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000417864861523554613747"
        "7685826354126061495049537861130696785666437631785670860809373661431538965440533278098806894269459412201201"
        "5342190405410686311749676095764013989212813042022776259075503972980415783422270319986285895393209990480525"
        "5458610171011481897913394796621253230590592528977454294886104079907963730807782157087030725023771729623579"
        "2871419986889904702428266107609034227421206913924373960475229255293263340951844946909235155930998157636257"
        "4624741570807283814428707319137982913483625918909656057073314391592554674800556558040189767456641449201582"
        "0665916994696040385769960996006956179327586748338004860755465704705486223232459808249735830200807558896234"
        "6666145156130842715967918196794561008886211006529975975354318507015705108642578125"},
    {0x1.3499cf58eac56p-987, chars_format::fixed, 1038,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000921618937784037325138"
        "6225234344523900898114056892264368766389694116364433408434582133098995372021049984062191604412148079156247"
        "0058129921769437214706009973058260865173496321652883226793313437335515335934288330827410313014457604685990"
        "8571668564638099154710476905079045104467961179905381697182659091275421605654409939881825288538480681503005"
        "0912205675383269371309430717708417954717530276617121140004348164540143690585881527779717788936032409975347"
        "3030704075368695199951827482684013499971988993418856488566338075147620067171549130652258755105025348424465"
        "8157619807012998649176788353621728721596172866945364020965829131795883913896368903414188789632715887110086"
        "986492180657573226368342685188914874974230699578026104745731572620570659637451171875"},
    {0x1.51a27e8a8fd04p-986, chars_format::fixed, 1036,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000002016654222889489366330"
        "9521343065653027086245497896068869059180976583615938098889986991041485859172655850284923121278179049365606"
        "4318876082158442840914388695516071513871282541627904960007529256925655758366238004656093505662713945653752"
        "8211198364194749602836764902987565025944221130708673443828163387359505375370290009445274572443627613958541"
        "9606556712353250612586551744106137528572254128169189469681750106767803119244277794048375021047157915946259"
        "9857421379948439622868937356578266959909594120741362514869852677384097257555841840521523679675833897238817"
        "4626883880522031537078122191460297407274783067835677391633127317778686117811785197733857788768303829936298"
        "7414194915000779858380976854620285433129268926055743804681696929037570953369140625"},
    {0x1.28c16b4ed7098p-985, chars_format::fixed, 1034,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000003544974751590889385952"
        "0264700887688271107416558032715906653570211101157114219987495688096790234026558681710675314185695039044167"
        "3389046891140333791267175538211915142881836447148902272897131242054424760323762734875414119017816505979577"
        "6451057876420487228094750780831495237996530558044233292884300493086993773653449202457881809071533897240172"
        "9596065603472996108834056777416770233084403727965152368376850711830195137130645640590704660731909870705380"
        "6529570935342883620442701491795272567870361575635905003352499512824154974326187486698906026566290297547083"
        "5003190344156534010770165498653170496875412652458097421921303135343195297833828784423963016127545265701753"
        "06033284095638792306713346530524716480707592136667472004774026572704315185546875"},
    {0x1.519084374060bp-984, chars_format::fixed, 1036,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000008064939085743457919311"
        "5655390618626369629653008353154439327413620740314818119036634456720430925246670592130257684011506550587519"
        "0702262346443580413571712749788204695695123012277087263105239201891820479284533969818518645517731907503011"
        "0798057602091473932084908015034567525286047273421566565922229061651406247462013601709967883813692721418546"
        "1292825117230319532485842557112068939568153450865993280216546928857042166319106957693584960248973265389426"
        "0268826761621079492065154996852043006813295420056272714448441938250959284349518278972810987370152873447585"
        "1958983525486767921479203821534881357550897232367303129611065194955396175464225609057065347598042047704151"
        "9013852253561174979884533208594899267372506368456441805392387323081493377685546875"},
    {0x1.bb4c1e678fe69p-983, chars_format::fixed, 1035,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000021182119864764602130642"
        "0947830872065837349416562163106754912736319440133647537047417519506625089140293248385386753482217342594034"
        "5405343077013463323112228715747967338103643416804748291754537549066191215546707658855503073696569114420021"
        "5376163418936391259487269000595612031216319183887868586108914728266913044890210415928204921425043137414284"
        "7079932175793656516248460353248085399130697050117059833885306031409904703709059143662429130360743269466709"
        "1959787653602446546371828086868386418607590851520843575326635774784713441747515775290972240748548223967022"
        "7228091449147774440773030146542967075167643267588580207316320357062539090226915532990280045685258559475635"
        "362835015005020199131435664704208816162996076304381176669267006218433380126953125"},
    {0x1.8fc48720ae1b7p-982, chars_format::fixed, 1034,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000038204276533494359839532"
        "7786957950037434467474350925682292758702707539053966097537580947663100241695943403082531804530234533427497"
        "2055557698045277228910057583486130203365779977007424200345778333217990261591775052038674621644837883321860"
        "4479055745892037899325962644530650042011580751336469774152864887311520809054052032886266679457055618321561"
        "4239563950863023436570620060327664713533021804518289012696278260248731747094663669522603971081606399156333"
        "4699556229294842917259386087074187210475783580978873634790343706621345363738501914041367247728531590692172"
        "1291972465216250361492750030131190959054941877618571467150483782421339536125360230193230482848612855245297"
        "72302016446491866534790783641858391019539842314856059601879678666591644287109375"},
    {0x1.df9d17014fcc7p-981, chars_format::fixed, 1033,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000091669699368021086682830"
        "0309093813571285621232474662339098971852561732904368691968438376659413371715296794753554027780942902843142"
        "8614854947085524042160263437140534698285714236207807018531240854589582130352740175233562430379023280135911"
        "1934199081564050835388846129941632190939608375409401841582717669022462385638815428406251457874360114711958"
        "8910563403995608284494480455504769946667523216484187271326674880791332001238898632099770597084200640414102"
        "1470207555193573290672314600093406404336752969826544293661311868686214794585806812928077014517560803574745"
        "6710396985460931950294497232649787115171583267022416268260150828123549520339627356344091896805352339831926"
        "7275737964394466129772993407912666757701714015382776779006235301494598388671875"},
    {0x1.14f46f3c4a3e6p-980, chars_format::fixed, 1031,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000105870073708333769307164"
        "5886124072693146296874798954178832516189855441157660004353211757630771024341596578033719821846802609255108"
        "5643962556381937827988644235294122737922022064040736253715486237412871081011467456775144784917714373365323"
        "0160249007136943912958984242226946137765447165742074403848248923815843134358598433641122735237144977649112"
        "3135684782630561684391683828579425996992353709635774270637096026351859440339529808571821550153320544369606"
        "0298503739712745713124908816402368714174653481365366811568682760782876915863262163482116619227760185945641"
        "1707613300236561721775200418214623023298244641208887391216336535355835025703113643664182588390096646989344"
        "53704098273993991469348626790718931843515715485182226984761655330657958984375"},
    {0x1.4f1412250492ap-979, chars_format::fixed, 1030,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000256177341895859676868182"
        "9976825737256842310654327258445744819313471812859917700055329134698004320247395612121803671260214123922447"
        "4119309374557203193060398335988390438444710676054145004223437055549092341063651939952711254089605942575157"
        "6071960503677948754817700769498401177181766232959964193664903733784825820267664691803248684099758561191352"
        "7817469545238997407045234095644380673653509287505277908336999504527719309410219875178825293965486069247083"
        "2277413345817796973767311238020200683207741845002297395790058716153525483767396221899398704893320226729908"
        "4432475721397029529584462526599002034113933442034138852026499319988753574461847693397707919598076817475405"
        "8802045425915342354542418540247245180296875588510374655015766620635986328125"},
    {0x1.9017f415ef785p-978, chars_format::fixed, 1030,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000611766716334159737596090"
        "0171171739569686686959974202247177759940425621023390290215523752040825861534988212323450527213368448456470"
        "1777247058601053761862866188287904621671478557284507204014216207221772415281552042774346782581581192683400"
        "8651569603496067106454520729283294752579871329182936426348026704420032363778594943881025488296122744980767"
        "6379388096070674965149803890959401033610344996445005362652164402969795474430171420624878611838431720806079"
        "5409670502199104925704949359469014160326235763930160048467177873299739191152514183146561607454394603837639"
        "4614792823657772754457214549972293815320072055217604731689008630136271723456654164715192320970918259328542"
        "9056144712640551237160829125782371580577478908935518120415508747100830078125"},
    {0x1.96e1ac8ff079ep-977, chars_format::fixed, 1028,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000001244291850920601401202895"
        "3502157484899302248375526922745314229166692585546772990892217496229641056244180835561315195689137757789588"
        "5020022496772410413988317059045245377611213388418239106676765461468848383746280664092973815474299167222516"
        "8441354650138195822558318864938044614007032745608778442983632656067307717276665535817566683865265869024514"
        "3514862764213610885902701104197953459657922797754442670964483945940232205602535173374756171647220221181740"
        "9708258360725922875465550779760937086007766054677009929064967760576046514113812222363608434148993491188240"
        "3581096088174673455142188302497447440448899021951800042462326739293158886225459160084952851961541578755088"
        "21587667877847598940277661829097687051781662148641771636903285980224609375"},
    {0x1.fadb23cfc26e6p-976, chars_format::fixed, 1027,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000003100051235126117055734868"
        "6264751638282347697441603952716948646046693942464502542196818852403552824031750041494745884790683734926184"
        "6175883025166164806498599908783951915826113591552191892899938026717712946307353394825563800253428096559535"
        "3092919104693493427497172744505685162739090774795106876820569693546699239184707928567968354322443185678444"
        "4083274091500700420703555836987399712520363953870514465047148032607184325622329241423209045337661652529605"
        "7392478727384385760735974124403991028933509493200214488404622950198348128729879347251430733000443246176375"
        "0012676803885387452378858427867468188188241476144860361211975943760433595129660724041926192764915817357353"
        "3413935670423949606511027942182777417112760076634003780782222747802734375"},
    {0x1.c2d100e9fa8aap-975, chars_format::fixed, 1026,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000005514599643126013910099346"
        "7191842543303968665047751359175490329248140080201690655843472208689617281422163505946515376031144432861141"
        "9690134650231524119310940944686897401473972303914830917415065953443301454685388122841522413415404381988854"
        "9152070816439653378310887032225499836821436715596770866662350547108554679082936746467457577046471331226469"
        "7289274394842495745574537422516867037314585991641886069493735438794004631014086781490233046315499495508653"
        "2232557782440079216740709862709191364247832437561527741320374664494632591901127302658724842566511890764605"
        "6283387444873731418111750757745277659752247589518641113946873407135807482894539278142676044746795852491585"
        "953284333927743046282564834512270046662507638757233507931232452392578125"},
    {0x1.47cbd89edc28ap-974, chars_format::fixed, 1025,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000008019518080011995521858004"
        "3524324296264728715452014332332170246674538871845805219648492909707144892198471904040082534603052959979879"
        "3600046834482647444437487683767751220097572919791242799892524698422822978446221165723798256749590483990027"
        "9146786398360818656186570954245843716698894420854352456620438185242918109562666605362523505773440715614748"
        "6304856183344925087301696163775028804963431540984237380150218682479654930440154361420853333545363389746232"
        "6737963649687648265020685474228502202597648554842420403440696183134806821821458476785465845396455373942354"
        "4076630981269681312843563475213302475499714965733582391790622273205357040908868407873222029151501734155057"
        "85588461369367258646472150182028804099587659948156215250492095947265625"},
    {0x1.c4a8aba89bdd8p-973, chars_format::fixed, 1022,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000022148549407571021803058758"
        "0892378748180044045162290960266128758237081853875197114341184482311756965524739725514269341594904066527742"
        "4434707407854591706332448113851127805566965881571771436089615736431261505627619156849281750933181906556668"
        "4802998876220095291903915324011764241086179483872688853308191821462831037697260650618579771433274264469131"
        "4774842762584499878681779361342808953291656008895208453361683573332178323164956420441319644683365839431195"
        "2023107428052765343098369150862706140329683451956136293976532733407029002335352053483609729854816729883780"
        "2725991818678468465210144105201700849036212045721809359776072325345109326784638168220298677182818265744202"
        "36100747585318545294634398450106527178604665095917880535125732421875"},
    {0x1.ae1dec42dca09p-972, chars_format::fixed, 1024,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000042091145246438698296464197"
        "6788584620223206018410308358432061499907914886710591233068837766126994241087546476736165489660708158188897"
        "6532528261348147612138346921175538542711878986253712101692204514120740888858124855710541461898075840990354"
        "1460234877951688209248224254034261463148493079177659920629778053137602860800369125671659281747652562037736"
        "4696154878934954777146874097164792640219120647730346822277636460817321960525720307042509474279237735500174"
        "4081039719787285874992326572699690952633986222005019432682477986364030941523289532031147634770203769239297"
        "3034679777114534015392534198929701908358497367015250536401199805425015654760144385399977606296181636396097"
        "8393038157465241961259638119909054498890554896206595003604888916015625"},
    {0x1.54ff221954c16p-971, chars_format::fixed, 1022,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000066739709449862607565675687"
        "7829201194838756325023076671857801591621689938639801840509711072309067042884640156496699439994300838785152"
        "8664871312266920501114219371300473883094315059942700609960588228198801286350447114884254092561109053574594"
        "5360033210823732362283438537636905209068142302258607649060295923141308162131010242194197916325697362693742"
        "5960768196935871679150780952465291867950902919984043604391377263345732481961082670822286777585677288460873"
        "2483185534928741979770956013577147182563951486094138266102243971731116472336426028926215761392757848297473"
        "4826157117612672491687994740358669693712403332630888555168153976682265301974938845259831299379547919361155"
        "06649432796777077774136549374872640072453577886335551738739013671875"},
    {0x1.be2f99979a8cep-970, chars_format::fixed, 1021,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000174654636402337691006381973"
        "6077110430205085110398918660610208193165002648830459932732755875328272920006833298046786276680503784255684"
        "6006778704271227385435512730699905754647142222043791534216190031489176270929205737215277156234213897550939"
        "7213454717107882597757342120686914788114089935876483956717648137138281353448511598356787044275189190360158"
        "9626615453304416936900776008651698533435544636347626690765031072431532774639002545780750939311942703695306"
        "4651633504530963445390509584488895131989898049530998192521307275379277301083810182420653862263320234542268"
        "8648205063986358713344707038657667978506388499093939846046989651768187181149527056505010534577248975985391"
        "9318571093384770703357713843295595523841257090680301189422607421875"},
    {0x1.462457ae27e71p-969, chars_format::fixed, 1021,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000255329454260029047805071575"
        "3818166924852760785307324274455464703276896685649750398556670281450079476171301511416012248448222007463781"
        "6440716300864560198901287405644409298523192920264967278757403969724292477983682901039009490073938325388861"
        "4316831594822366040947933300462054184386729464257884520452002649710897967901356092952311755812378900392119"
        "9749409846260814033055309256968619621536147314096602667572767547368480537021868582121265835469099565600764"
        "2227738433848796318377451325226628190118679852419841970206898163786280296976945027930017893514340686171115"
        "4337993762616468431106982229175266879638765688225021717769969836929117214014785145496494060501032575121829"
        "6624302065265450254613545551241049480495348689146339893341064453125"},
    {0x1.c9bf289091a57p-968, chars_format::fixed, 1020,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000716719905100483776140191265"
        "4283331028999961614491290387680525327758435160264770312345835553652819216736444016623532872322399497645329"
        "8018484358256225950727041531158851305320828328874380156377840606874957230780019461255688271701567752333273"
        "6185122438898204140391778580621578304431368821964640382678296205551136066826473768970889610022361504710940"
        "9764110696035061612142836930506582657157327364164772577568894370334356710122547899533333122870576400085144"
        "5387986577865539325916074017436777373567504894953242171513494949770270836128523773225426738845273436941923"
        "2602320030129013140405207627454909161216317749927564665698270971158400157244573484733167635547219613675510"
        "582898110780193501917110197874105637083630426786839962005615234375"},
    {0x1.c9a6c21c0e44ap-967, chars_format::fixed, 1018,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000001433141335227930212814919107"
        "2605813876697528611345885441115000029609556842920386965482577284207290323742533219950959430783015194668198"
        "4866655822228339143835403194270253223913061678439860917065041842332387051370077950094428814869878862795791"
        "6496725038596154564027501474646179397442030182754135054292301436144243035179137127061028271541768460916962"
        "6900527234807117188403332704905395975649634750649953559577652559528484291031633467618609466234606109062833"
        "7052908713177247664619683224737543046454127747542696798955644966121171604862571317569558957857552588354280"
        "7316083301746126724381306477578494291843709874477007787068278367148644618010713187514488284609760326730217"
        "6234293033266604144621188254848931364904274232685565948486328125"},
    {0x1.080ca19dc76cfp-966, chars_format::fixed, 1018,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000001653747921414095749664443207"
        "3018089012144452120603766472454112579144784777132047524978251678680652305622500049925363586631576797699752"
        "3004602180573355978400757182575064036053958408210190339447230879379051417089690260064067487672099587992241"
        "4089510417178382171731253321930144431314913298710310772875402641130578414655191164330530463646436718242785"
        "1593250624197965599005919337369891600964947788560805510699332326217569801868088227035341727693943399255277"
        "8680098874211345639068458050074871457491113617241586311735177325328666991945594936160738917458264152063330"
        "4112836941762385362003194298015982774531160072879490045018610848272352089449297155999395672819601691676846"
        "7473936479509527842902093242027916630831896327435970306396484375"},
    {0x1.568db6b9c2a6bp-965, chars_format::fixed, 1017,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000004290843909020546729010417987"
        "1798651941226153898698783477673232932487248769134773470874791558624108005131697353608862902655753654574915"
        "5269194293346060062071094839619735992744602682720872020489985764651605227123683444931533858939585871115444"
        "6384822881445654088301480606833643769669528121156913759180085536698487352616174964008809803650350438860725"
        "2321301774363944935742492341884553608844792004824932319261176330222096044026500175605116486722498994442457"
        "5770385717357779091208619818711665610895151705642793452624142140189626570619779038580875302481307764977579"
        "7625712909337310437672688236559439684574369461412897368191004528045867884390464739907179528687280026756613"
        "807116577015152709246269269183216010787873528897762298583984375"},
    {0x1.8094bbafe93acp-964, chars_format::fixed, 1014,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000009634563122144925584252862709"
        "8837665212135824138580247641095033482922043986659116736534146977997184184550644460199475556134749771118880"
        "4648235220805765618575601316863143054761832211432259334276682908110694267973267936336452574790472113201409"
        "9792189719325293711235087718438176498772644269414827594417119678477271996103962446406885046148430430699696"
        "2247952090789771393359568041684499232396514214051736756405489381778675872598742815737011666738940745479418"
        "8886316922944939839391299995745043273460133146343884929041994919904676232308848762167658898729149951509500"
        "8487221366327604330469301849090855522740604347010078082126314423497545739632197917648583593472744787066092"
        "183286022494344519144504612739865478943102061748504638671875"},
    {0x1.a4d81255160e0p-963, chars_format::fixed, 1010,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000021086057222075156140699923441"
        "4564500843088972527279057134370861085961669874684090783975879714875336360665125559425961800525159988473481"
        "9389953871450325631938423353411492527102582769073390696443103356152047667934205046245456558650038735730800"
        "8719781038879945645342734732749178265832103241325253995241750493815151958293657369564370243965168645236220"
        "2454062268891390078907577990174502268833095111096637846568643857395612744263557657149281665440973055056669"
        "3721065896779939636234938236192516341296551508179883633406331741957525488070917823271593105149749384800080"
        "6618376890372039405238914424603586856296346669256598951615088896128955516717885738634805731156711106938387"
        "76867128142144224012266562340300879441201686859130859375"},
    {0x1.555b4760590b2p-962, chars_format::fixed, 1013,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000034206800637910766975986348248"
        "7568092455857226172452538849137654670829026558635397447930919129012919655902035289765511658279266066746655"
        "8236027503499479197580402361620786863744924589096061170472217063438961289426815347747096631346945775370008"
        "4502575974626831490993326694422860463385783401015534916420924789459645737632655303976057606048773717878928"
        "6028980473242284769127953331015775341858001266767203925650569921328324381543299424787438555730075039358292"
        "2931646787240480909013093699491596011502544473515796187072513489926739944685859607150588631254483057331394"
        "1407589732975206216451663662122824092386332909028127374630388995592459534494362129485634479377824374911061"
        "83531864268581560058202217788902999018318951129913330078125"},
    {0x1.4ac2efcbe3305p-961, chars_format::fixed, 1013,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000066290167589677367951375617422"
        "9292716806068642209468475059928574348081435492672562858635936768075345718116507990734126024664323017252510"
        "5601231572132227719729327193433661012858341100476443032943984664211713338292994338219373247383273584684158"
        "3610763427888729264228261155872596350770036849190036848236690453955577994035107919232269198025498868586627"
        "2949097261799666956920307209623381975737540495544653710372564881978390565989219877292992603247756361908752"
        "1925534187639963588382054509606194952749384570687464334561188609275095113289769257647430285377053075634126"
        "9447780751678632833796862583333928343033480199175862679264807795179484789189270636076092132672376871712774"
        "44430229764849742991883463361091344268061220645904541015625"},
    {0x1.5152151a900e2p-960, chars_format::fixed, 1011,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000135209468575757704669243360090"
        "4978812788038658784057375085512637014821192293633284354988083332910409714056212910610846709279699966459815"
        "0437523432714437780192406774076606804837119144288166832388898991383219610969528979291417497166809956493647"
        "5085288494044278548669054734387251268194713494859273686671251259149052477932550907316733642367666498707764"
        "4126779433703191479472341766481221651746023800800090309455088100077933460409533060257217016013325784579980"
        "7633941363732792862223948592127182664634081911897379649605382133585971706661879051381683577333948154154830"
        "3712439342710725481894223508701233451359165629882362810744996099608461578753790281688211841686919921141420"
        "718345664751217256871473892942958627827465534210205078125"},
    {0x1.7e58e6c112543p-959, chars_format::fixed, 1011,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000306515321253198280436114038864"
        "9718163177630153098638242256322057332264316825884745387709988626966778193900377967818621973079307255143430"
        "4355125421170227991116729669620848426239592992911979679122157206922094124611266846097111966736120531163975"
        "8215562046178316584558614023241339019551486284645236279138390006112994254377796838563179303464741707072344"
        "6154644578522256496639523318507897582380933808362832961397125905373505903881692268239311221184441430130140"
        "0353970351150576226049056471007070154205939564098937126326694182928324715844701286793731070551106321932604"
        "0478506394714115663318719578959298300145129737275568872010082272953473703897500046421729618175608545958200"
        "349764878121067677996247624605530290864408016204833984375"},
    {0x1.3c778445a2b30p-958, chars_format::fixed, 1006,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000507402297546796300155974976354"
        "1125170478284238884770689255999822246103901985835478854589953636416469537561590049706630652513764526444447"
        "2236786867983363196145687982136332550029676213935914005983113566403763609110378518267950840459370242977226"
        "9969685610809178987830705642758801741201614124206542938945991467305841033444750290456306956288188648520408"
        "1056812066585987639722063880607676286374127002491780885114417306881402349312394657949491179323334737191953"
        "8280721400311952883002233060077141079761762918609175743077624948793447281348172956072801799356361241858583"
        "3945965146499299438341126720124755301171679221957015338045823564364353547020467330563043595487862594075027"
        "3716264569061340505840007608640007674694061279296875"},
    {0x1.d5d886a6af07fp-957, chars_format::fixed, 1009,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000001506640153100876566020971562084"
        "7113430721240845311467067488393060399424689768179013689935270456617217772626244929423631519228493856034858"
        "9795751273940538757255549062206419695642046911817014605594134791735095417547349666106256911825953848335647"
        "1500150312765170021570234313983189886563782145873240440323828891290807194213814694507158939235901598275080"
        "9131377045618332285170839599383602029439803065564549875367002305011744027345479199876728897725328043145101"
        "4572515866251973827561103685944590487910895898225162299074096391327451735400570200908986735487971171181929"
        "8254603418980386599420783790582966667612569549001195037944795412981296229040797865364009022932618669635537"
        "9052802457638497724001780397884431295096874237060546875"},
    {0x1.b4d6ad2f813c3p-956, chars_format::fixed, 1008,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000002801593794149458289375221969937"
        "8451541676163091913910886367587801515223826775770979017901213581846339239008597274356448340618213879408241"
        "5708206777985372462737529604331783161052369852259640641682719407243347401272745693201162769531854684711698"
        "1997986538474037406413302814400876575334916367833693107072636011428947924771043183285915397963385764442595"
        "4502850284440493944167381091614718033977997952112454266036283567034492773027029721407239251594118127204450"
        "3439934946642157033684526504794793241794104430220950327217291773091671208313520057013551013607566881844423"
        "3387687590160584099397367567846354051160569747236486489617845200348490288202051349985773023756814947896164"
        "670199036189450481071361309659550897777080535888671875"},
    {0x1.a3accfb847f5dp-955, chars_format::fixed, 1007,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000005383036452986689707089265313361"
        "3309687768553145998845020770002508286663820178028904357041106164871662930240429232628188396390915409645247"
        "2893947755538934242330914543826959031146221568246692512569359075149804195162245528686132546025168087601990"
        "1469233112170819584404180268970996038988942682994555869177877222572726704409670637060636345549170735863881"
        "7637507737802603692179707323013726519499078873069293802377310441059050095455840943125657666622548189687664"
        "2690857726316749420932215444605654341122928806547906002555368770089678159201832195643718096762297912030990"
        "0059276854565582725176763468818525035142169991443317320021522630614922936712841305529989073666151493844968"
        "98688035417847308483629831243888475000858306884765625"},
    {0x1.490cc71c1b5a9p-954, chars_format::fixed, 1006,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000008441234238050257654608143045011"
        "3714547500629438411347771053360322063370388173904974678292331037009777086711209941481547644874475926368827"
        "7212497420153992338777818006934888909213572957511956634738036763365144586177532285838927084302911516660789"
        "5428831657856603626176699984273793880426192286194266443686243608836600001354453011013245420503311602188706"
        "2016086384595971121585437748216881228804338113019161359341335927611034275239403794071774633231535502365664"
        "7031482236645528004617260974202488109127266152579244998351781422253738236175424370155077300184429245205537"
        "0516538649507594510998476523084758454303188096588303409769684799427283670348952796189333712505075374786790"
        "8906204526854610836750225644209422171115875244140625"},
    {0x1.4fd2a30c2f2bep-953, chars_format::fixed, 1004,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000017229963037415353860036939274512"
        "6026077034739345703168137555632023714502853526675561807275891540870413620561283459465386257149814404426731"
        "0735092244866475405537978980001598032195060108955428328784896295737887239531749999981802001417396108156377"
        "9582829767646262355995956025950412141943783595608625038608668079091726460029975659200114921786030177059914"
        "7634700558856107451291371285917065599081112280820640917253408975640335333977713665527965071968852553983251"
        "7124741580735742733225434024967537004498810829066843540287458856623760334851322987488292975046799929539221"
        "3495872616271007027553507548507838903708274694818842286459908081847482476741930831685576757938867841781152"
        "21749321393784892819667220464907586574554443359375"},
    {0x1.e712b11ec1d63p-952, chars_format::fixed, 1004,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000049980227888927947361544276876048"
        "9455270526286941463611538933406026259074910585749895445770331696354343239202363631494369169360431693425214"
        "7634518684792624730079945537425876985997178452231243017087626532543106276358615929213885810712355953882567"
        "4057455540596743874765624052243747659098442761322506411824665706108552084084218918059037991974479006158869"
        "3056169849068456226653932205312729989102037696430382138353314730376082250724904487349755042619016279363453"
        "6282770945810749744395830459488135229127474448425736737475336134881159932765382595260797681368667692815244"
        "7950498623978211624297230724599890314306484488764858546210505231295418043612182084416991082185028657201667"
        "91044828773216135431312068249098956584930419921875"},
    {0x1.a951cb6dfa80dp-951, chars_format::fixed, 1003,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000087286979124915840031811171249768"
        "7467444368897106753274009448112897434374990551504083361434472076990675548257442958324490534088914416947203"
        "0345962929533820622952754572337555244829291746940819858048818312512407105788126951104999460919138178657731"
        "4473614959923071645694511151134251192939276656412454422655235774671039752807359164333796045189813934206387"
        "9562295690992026703839973859592630317510343598115293358217353215269579574482300932318121087160706915252100"
        "0289421128756125787103234636014020808990191470118697352773753581193966992555371084452440315677385870831672"
        "1036573336221194782970791861317168649003079683382766692806872535633233936121493231431619456165918433391451"
        "1633536505164077112794984714128077030181884765625"},
    {0x1.cfeea9a77e27bp-950, chars_format::fixed, 1002,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000190422710104977763320017088013306"
        "1562636160392816356868148687074254559912708970128427928098420716969202321713200302826873037284450151621445"
        "5924208987366001434939743136403660684329034900795682515039218239607769961070813600340587606383062269871871"
        "2357395107973013643630031179965109739646437772385890926147471081285806366515162850607095993734762727585189"
        "9282446151613688832986623643166576916545974660203523412854521672957349134716034187586798702358180168471635"
        "4436261775438116143970489630933836447388034254533478276594259415992602429267767218555714089756461068648676"
        "8873410595168253783490481271524725831561300847507090574073351369652666435690680061075434980258140771483701"
        "977439921548818091423527221195399761199951171875"},
    {0x1.61502417e8ce2p-949, chars_format::fixed, 1000,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000290037283829511630013363865236170"
        "6238128613374409059474358941441136834065355513724427153759145165568068731597325059613096888192036043781625"
        "2207225681919322577983708053281262885786041260892934350969948470571849596784985903495468733626073860399109"
        "5807972691548050674056472793774421388608166241433888395816776961563483444952082053324551414836304389344379"
        "6967648502707271130763132701946276020956850825940639071222081359496315692610547887294288506372101623606589"
        "8886987801334925916746303182643848978302993650829806171161826837630193206362337054919742109205228382754770"
        "8325200456325402876426988696140638836178773460972955648321583541337598316302171184287844342406097967000830"
        "5676166815434413592811324633657932281494140625"},
    {0x1.6f4a6043ee7bep-948, chars_format::fixed, 999,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000603023001148053233608671406136662"
        "9154844710765750815164166009510289390408928352130382822822659766062818235069111539868695121950322320668137"
        "8171510738766830004867709994331683259303295072702253338399620483078087368703367864741062551628623933830201"
        "0153777490849939613997091271883572026324551068699553809789367085830269349078915084559617633423193812990897"
        "0145201797688554174500309060673869117866459629299845875451222894126638524480070648366890280832688105349742"
        "6575560769846504235371891665287480776710841447042185189149010554457654596595786073462212798709949925503426"
        "6265556017366214401224164470380415863280759607522343102756186448326572436788800100967001687104564561953359"
        "727412837809623624707455746829509735107421875"},
    {0x1.82fd3aeac2fecp-947, chars_format::fixed, 997,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000001270729065641045197214871417914178"
        "1588967973845926807547334471277675980850408554878248054803892782582018822253418256902829942626257005944569"
        "4988348700318777825258518784535605857425130299671300426071383629977858895538733746821903149491024406625677"
        "0720046737203696728672760192370711138924283768772475940785693724826698986046600899389474145339650214620200"
        "5519277127551424134439683925893021558019255827189881118691971239229665920665706074589881220195814966137824"
        "9840066133255936674274226197607897248507836438905238727384458811013417251337908250088568385820779325091802"
        "1016981595825486761813591464957247173777907417675517257352395503235491976503703745032815963872051462389201"
        "6668749160857032620697282254695892333984375"},
    {0x1.fda8896e44ddfp-946, chars_format::fixed, 998,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000003347058306335633210849876675716650"
        "6385353764031783485196998561866179457340599432256217213352642082359348776006561937984312164867983255432833"
        "8726173157671099841073635018988556349126405324929433103638921411010000406997097554139706240329983669188387"
        "2720101591275772567836499474144709269745164033553143381865980948114813450956332339842537849932862573037820"
        "1514987590090742627365532394510810911008494010157265556059636318908537716658826575242739741476951917424048"
        "1162648267831006229274985704703073458419860862001834681264408952610279695812027204281110026433304299240596"
        "6114086480503347740480307977037393767702327170428860861334438521055997639875193840517369611866496580535518"
        "04025305127510137026547454297542572021484375"},
    {0x1.f63d0121b757bp-945, chars_format::fixed, 997,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000006596657853729203515742243316233994"
        "9684328657517781425278937040263737397772577187341772038360860221866728139740168744657011708467799022498428"
        "9048367008807112058030080344286777952675512614595714878804489254477073655363178820937302943891173739688722"
        "6525344476794228878774806817015940622309814103147301158180909849015378481312311580130769770792089183707264"
        "0679333216386798989999483042211053745064747961945094371289546480468588624655464858151737047145695739493473"
        "5507329277236644627330631947684311599090344589073145189553679017707785009474304333968113131703589680752374"
        "7130636300631758866165476656409393301104737836983161194297942630550081578225483538085400178223022866888026"
        "2464513375419983276515267789363861083984375"},
    {0x1.1abe55124f6a6p-944, chars_format::fixed, 995,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000007427398668320938600202918314649779"
        "2358537735412418076229677375034053108781538417130596628794716377703048792043944787439164083049732926376919"
        "7669372654570210896760100817222039133059067468132996774053651076190226967358944107425923006562795703829318"
        "5520235291906031948115381397829092825319154312472026340183818944682611111115614544147416970660937328158629"
        "9060755244822009110650534665364827404192153653867280756103054142218360222093458106173489557405135404872456"
        "5591943722679704655789621606831198408689956651820414839333271464401183877845096687949407630565934742072638"
        "8904357845227958574995156936912713306237255628189778269960699349488082411063864186430306510089287244696020"
        "99256260174797716899774968624114990234375"},
    {0x1.e1cc3addbf112p-943, chars_format::fixed, 994,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000025312725644714645962947927743805809"
        "8046188843976178214375723184585507431180848627052892059439660381190032909589290532205874362493462899587538"
        "1837943114843677690290757475966829773381513504462465935520985874170808757851469248740093376850022734253382"
        "3476404974675519672682903628385538916962659662633691571736344318617777302846800242763765681365778209538316"
        "4365461668044042733324278614600752670646079645747018634289655624083620110521953699389815696244858788510527"
        "4650750720507088292109266028314375468792514417090375144624505854846370613750986429422869415728090168020176"
        "7526275538160272166003731708917966386538917542104658631524656016777584689065144268206602137972929129612707"
        "0831634142678012722171843051910400390625"},
    {0x1.c37ea66e435a3p-942, chars_format::fixed, 994,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000047441324100905745554574287302084691"
        "2803820795971935816315591113366331582329509971297928949808058941930664947024126350169270196995072745313996"
        "4094982842291547313755490486786367335729006128614919710190720756388346060562319519438688203810434951289695"
        "4849502432807790285058942456389657214604934749586162446761321929113744909744685596656046149778452097128786"
        "8115519659684239948033351708868051182201085858324140277023786909650546821132637590793226042392427342459479"
        "2513951533482347196046726595658528758631712076151539390554904469478656627069451502833062779732643453355045"
        "9856203730373419301715640151438670751568269220698410650144241297015427718601896354602394403924717955739042"
        "5574947556697225081734359264373779296875"},
    {0x1.5de150d8571dap-941, chars_format::fixed, 992,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000073528110594538782482365773897168607"
        "9656276703283988537435722942874894629410400049236090868524904221483780423221265352794066364321977056316193"
        "2290871933457999804070473188593715855710063276080601930566799221618951389023450857711029880846747347949781"
        "2669476714657911404988980189023000184091924273752038001295416199133536687913336770565773056104716911264461"
        "1788011278170299217145724065948735254510907592500616061752976888536427415063374341194168250819599742158320"
        "9938081931051790754684746409238795346003455632343306647438655959229430469027013248365025737108296595578764"
        "7407936595401532068399171576742411085999112194422003270469263863796327947061737707383862021365045804873264"
        "43449802582108532078564167022705078125"},
    {0x1.2fe740d15c5e4p-940, chars_format::fixed, 990,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000127731959140294048399971213650198466"
        "7801236065235048806444537810208068087817829275181212790228225665073254762457032074167125945963486726250164"
        "5989542519919320622366927457459078161527979255825282039797351596484203705160087167691063167302504868459367"
        "0358363569459857499212684675938886509698800860291252986818533610029910805537195256577905625480446255138948"
        "0809263139877181540239827869316534678386403409720339026305076449997313311765579574003533288958339344621641"
        "2621528964884123281468415155495052660942536454564580301495844985838838783306155517883113766155698014616431"
        "5857620275225327679372535464703713121045423643509346575233415996862647404985643869421282773361209076680433"
        "671668879469507373869419097900390625"},
    {0x1.74c88e0ca098dp-939, chars_format::fixed, 991,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000313365146838093358236420140569051658"
        "1105746242498610056637907764625652226456555415141340665125388584830097774288102121532719018587676854488355"
        "8080957255704946859709991306677005528969850666401961583903847553471053557951376835124917962926402863407844"
        "0782650426136011666899880669292032641069797008147055331195674216356529194889190303458344714494976340157737"
        "3388034436986851036531041736832716725000154529591297240790424338568500905683261889088144262991753471099460"
        "7816878481325675283258182823175059279889191049771765351259820925621261521633325461482705778771219598075628"
        "2970173089471656319768645768979387137939224792870912024630374449872138538705829858684663810842954830785528"
        "3528766676681698299944400787353515625"},
    {0x1.130f11f4ae551p-938, chars_format::fixed, 990,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000462433994807609866517580488595918986"
        "7025753248155197523423615068565730024182113965787802278458523387479124049634922415502894962122620968309353"
        "5050836368468052738058620716115451967228395173777493981148346272808344417774287830298267236076066569792734"
        "5299505713900835962755400093518703015995713998485526808524102156727174234319548762303636435070446231952899"
        "4542283472195164243165427286927827946326324892850537364653645448662928503889332720476917768510116269567142"
        "5571429733166776144466203775852323954452079649806265803567176251405339625463526249899619311109025885887582"
        "8290937401954327799156713208214777486490812857965856234239104338246085766373351339663978363866896439428322"
        "285181138795451261103153228759765625"},
    {0x1.08835fa35800dp-937, chars_format::fixed, 989,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000889408777274034134780544224695515853"
        "6136060213214647927655374856057226385535490010817438841387381081057086944476526633185508976830686400273575"
        "1381507354730705652023270837347542895198593808692096538170536285629315523725974057943684291775593972874826"
        "3606487973520290702671781992419585307527883185118989695926077961368172495071415355856212507116014004141258"
        "8933795776394239933049382324414558667115560425786369347695780938584808156024325242043096442949805033001474"
        "1952395889951805410266142717798261498669781716279885903817870706702927436667659924741720411154519844673449"
        "5368313840004517004090879092343656929377043071000965025412724132842422519637004160953715876831044426578665"
        "17407683204510249197483062744140625"},
    {0x1.6431e220a8c23p-936, chars_format::fixed, 988,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000002395365208372751238892607141173665109"
        "4684359629139545046331701056101374156295569337074287726281108064839092019722035425712564337078891872125343"
        "0411000497833026470918438064748906303836803667779264399037996493294682779907053959099205417888156319550884"
        "2237166002254838778941432287913764333677699977715082668936870273420684163788956494132784941796958079886598"
        "5391354437385154150217050073066367310703953519083722746947699236233991091448525170238716635753128040232958"
        "0119848376247994125192476520054069021178244018175790204834170600687522006128029219949642817963680824424492"
        "5634931880191201392142822061160051761870987672004337971307673840421985840397795630413921011169278967728457"
        "6299598484183661639690399169921875"},
    {0x1.17acfc1134894p-935, chars_format::fixed, 985,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000003761567466326268181885589810634065238"
        "4824488135624420876733253077105060946198861732627493193519901047247753085151645061052614831077461787550378"
        "9522940191314377583805558176016959667319286171660282631959695917660262794816160089358584110296226747197056"
        "6960719972616815524052330290448761157948723719283892809603393480152922696382181832677174415906569718026635"
        "1038889725789977121282586495071803503310337622258942765229731736751373980228545367332367240256732267829774"
        "0121435959673931330218239056618465199032675986831449764985280751644590105107163390076822957129219367665806"
        "9223654709451072516761075679530496081880163478624608778936598616058103897515476300014760931806571259139460"
        "0394778535701334476470947265625"},
    {0x1.e09c9bcb32e3ap-934, chars_format::fixed, 985,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000012928212167160485647289050725920773987"
        "4861836069414361195057298546848250710618797414084049769873325428052026475209722120894427905829017312531660"
        "8241091852576254939741247469188715203775512048686032331388554335463507137482116585173531717089284209974439"
        "7570948154763130326339872466574662174240822879049800497992851730923604321033958606419596582626473030678859"
        "2310470685037034319253555665752608782580961488429909489306613884615945556331126875486164601415077624257882"
        "8743675690174930134321675660770445691242995363409492941734509374221242410848684155513238368365796187170024"
        "7355603717069267105273160141024636245841030542167997538884894269542306738988346319099212738837432340455180"
        "2241257973946630954742431640625"},
    {0x1.a1dbb96340c68p-933, chars_format::fixed, 982,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000022480352182123752808136544940388978663"
        "4144528684028071721643530480871593182406991088523084109355277990423722607479167570828666405584023758943395"
        "4496235477862650604747190007974927829366839200588582579987175828223675779905454921856840712616925561352311"
        "5547617808223210507047507148357936450312818091317344650050542591031620770295421779702653225582120691078585"
        "4698054868524203836021409630916609905079528396656843124885091925936276146801902962301794667900084167998719"
        "4819323902334663004063391308353045399311591450091720421895257829681349889384996716260685606079478830353867"
        "9715429772009000419656042999365911389032791895112255167192881093383147665222748531606285313667187297781424"
        "6041816659271717071533203125"},
    {0x1.2535112b05fa2p-932, chars_format::fixed, 983,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000031548509399420712639272059276400333316"
        "8825472939840263152474766394932559633481401213456905267591366748121685127366607186078984663434814626878761"
        "9467435913531988781855562027128524486327361877858088502218796529494172466935302619475876494375304284254242"
        "0848624400193571676128166369626251295790577666448960494078709554649747335787221346083512058193881301726918"
        "5088133887540329540019387686130807401092927971033628483700107282777002447037363112380936616653230090833282"
        "0911765805302593218419194473373446779984095803500262917305487147202453464907595976076416622159108849254870"
        "5940688817477117458589834121878781888972966233973065609238942277426176631314113665574377210311721175806098"
        "92684151418507099151611328125"},
    {0x1.1a21c468e4a6ap-931, chars_format::fixed, 982,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000060713639849830441431950666885186177075"
        "2265151539926629076264973010953983907324466041869432033823459140388847323282265478315251107842926851637284"
        "9444737215222562106656325116914278231437352250881778177828512586041058802465427960568227820236551669931647"
        "5797663852975205091841100466670249174658035281767126538276048546906760539717394672162140625498504576723310"
        "4233430770581482344127010001310021576891807049979818732256016778786725558225608403941078353606559612621001"
        "9437108179199837557454769415343201152373557052801749437569865055616521642323629981253371080878813132722433"
        "0521397445681333604743523119231158470360150086598845118086029335889054054948984672371006994246595001030186"
        "7223461158573627471923828125"},
    {0x1.fd135d461e64ap-930, chars_format::fixed, 981,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000219102021651833679610311447343290174632"
        "2697938270186945371351301396824908535678593228801202439354195354555298866455116158899738801666640075186148"
        "0211382559080287549242030557441693683989270686073119230933376584897099084395850837189027078871895526684485"
        "9388924973520421799665881564677217995557182337483349755159195630924015413291549658379384389715545475874182"
        "2546081513346145952348420009435809153123845362687245912248059666995383487273354828366695696929216032838347"
        "2255495913136209316417452869260914810433493047388543891888355256159483630086322246642386624637846863322420"
        "8467617370793215969921003844152689072025202975141367168786824130511190159598977575695967511849870934526052"
        "224100567400455474853515625"},
    {0x1.f7d9a435e9332p-929, chars_format::fixed, 980,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000433706034922139992466051098635625789226"
        "9790420502347908835422511841116263760317988870371022660947524084318977783088056734831661091131387005107336"
        "7080032178622864429629631048087660131822766002732317441095996295232310734747433463008938028163941940376604"
        "9209923654610719272401703006216476733737770057412870788266332106008639686989965213527408698164509196717565"
        "9794850779480003111895553824321087854495212577457398595402036090648629548430689644857400023575624192252226"
        "1811735236070993937319671767831428324962582529487566901130462056303559336906455268177393727945943885724685"
        "2906755824249947746316595754138291586086719495135961042977343346868076566523814309925662297331983019432755"
        "09984232485294342041015625"},
    {0x1.94c659bdb66cbp-928, chars_format::fixed, 980,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000696847157286931851289587852746449088974"
        "5995933947468338899191644265737622764483380773896231028946301101354121009652116589677772323678127928668665"
        "4271207663828960684445858789294767590557697945098533365090822545423512585568031129764104327698074634036050"
        "9781859315959933671560688119265086307580742652851690725868508539049375890529951116534350607480891045678054"
        "3266574359886133871760507672067140680759980765754218311821351038664767580912988223632453672861098702524281"
        "6226651671930502546972496938930139886801587107972624994517314961726258337370823753574631904982305230128135"
        "5599149532686969653008374807340759937762749905790290559785069252920339099874079061665087904062221291212608"
        "77582244575023651123046875"},
    {0x1.abe769fc688c7p-927, chars_format::fixed, 979,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000001473331115243778954022705309267832346033"
        "2933852257475188822441222074344436589917689823247953665290710696624690991611809635867231547228216053927389"
        "4339479994193169330520625936397519235918130249340730882903493307621089561285278036673153849935054504996697"
        "5086920227034460151662663011478742176698549702779007271900180889286549079717732243991835014506304637584929"
        "4907349943601734582058091677850466600549179567598052592528981026904494706085683657881489962319474536509309"
        "5429477087602427196556222424895294076578456413124521507596172456938825133112973006220848381319370353828574"
        "4927685484325243111761550184614450373063948573745792548306864820340006938921712751183995104148349852835053"
        "7526421248912811279296875"},
    {0x1.825701170d480p-926, chars_format::fixed, 971,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000002660440609494829928484002331288915189504"
        "5655703225518408579970423545100011582978514470567087920738321442927530728543237114459190980071924595778114"
        "1729612931668439653482875327754820963954270428962349149199726835698118459273524586492199972709272264358328"
        "5720404162313925726900614240612356134419032262428558843961823391328706420533704796826237834901399536182326"
        "8143063235754023395627339613127590917817943514492812352700718204492686590850424955549214973042837434213790"
        "0767838918385014099377896161172321732594458974432078343771471436203756019462135832472960533663250357058140"
        "0682087260645108688451326585554293824380869245358022373059672081904528410332819903308387843310356402071192"
        "86060333251953125"},
    {0x1.9cb40ebe2177ep-925, chars_format::fixed, 976,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000005683973436284207079660842335896376252194"
        "2847688739811715193332262874402507007578228137833409228851937575142988133388681897276244108465150313548284"
        "1878157912998491023471197153193567938330820279182603747487685157804449914335965648740881215808800101491734"
        "4439759287983216092513910053323400256593370050435002396967994998634783117425379138768137945449509233036530"
        "5712925878132005668316354328176029389998813412358306819750991589464158840440187540370845417980702155638277"
        "2917776316285266398822892936165695523171539159535919943189320603911105750651160880217314777880620536885634"
        "9281475078098721211793053402011838737841041885975679740409233160578292466907040308922351851128595967566070"
        "6125199794769287109375"},
    {0x1.ff8156df08505p-924, chars_format::fixed, 976,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000014089452631685326968433243074109517968005"
        "8969564052435377386295567255430891923404569767456183925094563844213295122043611679935471391755079980979501"
        "8719440525549860095877107153938102269771088019922306110582111291089485525691899073270714769067531770667572"
        "6019575953681928890031055092123983880559931602395425034948350672283245379563818248188577432178069785517522"
        "1447135604212500292255605581080737160756336541704916605654622573208077336936537681601495287937831361476225"
        "0320189168592153831708552861404319266303334058222258097550864258413403531304832809177251851959422421163575"
        "9045690707125067558519111608183423177759692836152771907530648000864265464886793313280689138311529973179858"
        "6435616016387939453125"},
    {0x1.9d0f772cf5efcp-923, chars_format::fixed, 973,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000022755564362864926940281773480518310790479"
        "8614676370506960981914851328415362342551959688942020547681275943405052471207178431622061755181896773453067"
        "7723524447242629222196714464872261421188963595703786682352290957981166316968715768476878377717323676558275"
        "9131106254964171713321790287640682417421292875693304779895386407223078981110638172143427694907604433837129"
        "0870631124853148741448273362510869730859167323400369922515612597339675515620741030786110317330091445693562"
        "5284855820286878817858969041925138420559706752255422532368290832023599170155833556378582588541054835832258"
        "9287812185295540933143319689919401128285303281244301083049743762773094540510748328820261887628362273972015"
        "8278942108154296875"},
    {0x1.5ae0a07bccfb6p-922, chars_format::fixed, 973,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000038219068582864352723967747931343616562165"
        "7209781173761641840447788828198561093401360596513533007600193800457963875686854151814858111036445511242704"
        "7709344441376665355487764145628079260448302287193681816195721958963465354214067102619271776398409728111334"
        "6747297605374296427402200943004967162985193289030024297703283006041946617762562693335543494641811348659320"
        "0998002484261631559385150974748579850886791518129421085948180303284306883294509926394689017938918992450263"
        "0828684452168306954205031632460329887918486232328363814288573154176463928935563277762910223655851384736110"
        "7142384002380822110267075736952889482918966077710436454866899431747659736574605283173505787530643829086329"
        "7879695892333984375"},
    {0x1.6fb881d919007p-921, chars_format::fixed, 973,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000081031176278644846070191626517872180531833"
        "1135326132318795500180952292783697914667643762630124008413474467884537069420798897444792340459678011732950"
        "4730189740041425982303724639847802831823323803632388446800551741044882685402671409590390401829607859501011"
        "8323094533029921605002661903680399808172575284741822476914983302354021964279286190987699675882237711813507"
        "5109536171233688494942452416618125742680387879907346830121637034403253494540299453377386417370013446614658"
        "5718226406710130532428411831937706120600181335992994193865678352422302987448586734996718282943690713535168"
        "1811535139582919792094206822722769688324053871886960073948088158553433739716296755044994126748747476085554"
        "8083782196044921875"},
    {0x1.9fca25adf211cp-920, chars_format::fixed, 970,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000183247342542790288693877843728514480478608"
        "2325832375061113482101690797286266586294867945954372905818531402941092342910125905372135803452206403364874"
        "4249562007607394347490512882057084425496728977149108482082998231691030369572059138763766664598935032230521"
        "7308929663141958352882771737400001547440233507938666437442632719015553489697543558934242681927575376884558"
        "4435883886178808128569655382229457502908034012259240062189848521009805863770517872740795257317589786558096"
        "1925245053824582404468293436544414244144371350546560694236426149333233363964997770950219573720159471661810"
        "8410253542270998588555667778049553659906796661021669572029079800552423015550776354970485826356707548256963"
        "4914398193359375"},
    {0x1.3567868a935e6p-919, chars_format::fixed, 970,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000272722205453175178688891579653376960252745"
        "0842088929858871118159521370404337824879190994854038061643561159339103362125367673189880817810703976647945"
        "6005594396858473757810534511171289815905416613152798741147221740178663478005676337635527073145403417312194"
        "8123562161113050777550986478978526638351015030754501556153103570961851853514223016295930188700358435622891"
        "2327582537870139843038204744666191730945069746273591847403191866223408504411485305382847908319671602904529"
        "6834147370872045913912150003826370272527369018138082705703206012595329748274965798141023735242043688601936"
        "9311322760748320147266706397833688866201892620311123569696025528473697359587650090179122841504977259319275"
        "6175994873046875"},
    {0x1.bf28dd0f45ec0p-918, chars_format::fixed, 964,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000788291051502821790843992383709116421149836"
        "9045702899188062518103364864188409315336136915242577447392215731577741539262476980101322752505084581018100"
        "1225151774240969062413079581855748401286232126223535726941159956859139325024899311289235621704445799561373"
        "4916857591820436578956704895859640879051290051584315035693850857881717419907691548467810618884097388311818"
        "9313794396946312462030987453218823755018816819599892055694230286747924272367378510090522287033623889106823"
        "2565002011363556756912554913016457825304880622105831205885823366792145339675906183530776971838811618905776"
        "9600273940040399470882928524666276933882336178786390647141652089006581729645900535885516546841245144605636"
        "5966796875"},
    {0x1.a393be0039498p-917, chars_format::fixed, 966,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000001479332526434951960922418908717277866062855"
        "0715159699314589946835960775139104114196387124361744349388346423526249997529063816286588004877609496510635"
        "4069497400210979615410318388465977151507798144171315330304323435988597563095458242572885229747942207781481"
        "3539875382686759895441332139770602381357809077363620286647587905672519662153366756951425520262031148039690"
        "8342237186203988319154990018200960799763004452095958354279543752826246109554840754022410900257769037244635"
        "9884979680520216781761547575060963446756203043820334004229099108480214648053579449883572170130099202247949"
        "4296931692114542127887432405933594739009899021351204586356951492886187572435401083037476155368494801223278"
        "045654296875"},
    {0x1.3a8c0984bac67p-916, chars_format::fixed, 968,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000002218041062043022551789865707997330466613698"
        "1289307679736753455928805959725081462934224670303724159485938268882871438022974238697141104193414482484553"
        "0951396830281289648621278119877048709460244734297439979032457124421091010172224292015433663000608699123566"
        "9508210185826348819618229937866676364296126489105865139605828360204845989995639472723758780395825659604068"
        "9177850038369317144434041219912680004534927123313725716843926392914184693322765428244423296707499699242123"
        "9352155928725744678815679120998085146002248164874856671200987562541287503365874233851326456361436674758684"
        "5781134774124232829708849899521351684572920654027513944639970411744444322331903593492619108928920468315482"
        "13958740234375"},
    {0x1.938106b73c776p-915, chars_format::fixed, 966,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000005690649743658697916832400938454858803658909"
        "5543759130627636379562863411660649404239561145787562444857179638324291687916940100137337435741474876016235"
        "0056495718058588423534096485487067553165909715657381402971404442246809475670690107408298781667462547191916"
        "2817470744562403850861742638326686838831329543166906530868544059489814971840999590469409567034147242064431"
        "6999405402196876112361507834250398148271011353848871090482305740770992731270378503731024908696903489732478"
        "7955384440730093355487897020162730857189426818122829178924268502347882813178373493124918620628860025715615"
        "2529666027885484652021194383320420661247802440895124858403164728133943685880850871239289290315355174243450"
        "164794921875"},
    {0x1.f4a40cb3650bbp-914, chars_format::fixed, 966,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000014121156100358157296664884403439661646302276"
        "3650784856871320010353040705077207668546950355581578583044505766940217400099355023661276743227694506565541"
        "1498903855245839961288253008194637438398510127910850318126637809078113983498722820987671412284313866751671"
        "6498672025438150812379965713453291240027473524507082740212010339249382671053582408053415675489886917683768"
        "2567321817374385812537835559417946028789607212568576973910770764877147702942096611971251748274003472604976"
        "6095385206250185385743288799780370985907194496369531038498334418749823932561430082471354799282769696040754"
        "8732438073482001097018337599177892638186130742755069952437588982806943523648328386865813399708713404834270"
        "477294921875"},
    {0x1.d90c9ff0ea8b9p-913, chars_format::fixed, 965,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000026685811370633676469151456124462933808944608"
        "6679562287777776698876674681021413432252249735738226278585206628706394471551392518714620362982432694174419"
        "5066837887234876955300930867092729468480811200274130651215744786557772150087296243176647496252440476244799"
        "6249762902390207940964665701907211440315524100628209894341216678829969777457299984096586701156978531800501"
        "2698958062884482095994760870515369048323272748656907984060140419242923626411226561350556759451418729720362"
        "3647085223188576757317263211392808734393069882455181660848545444617167500172223520590496019958399406193343"
        "1307294414013184518821775633960829937443323245504876620948805489343819559141038344485252764570759609341621"
        "39892578125"},
    {0x1.9dda5bbec739ap-912, chars_format::fixed, 963,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000046692815012344966698882844875437366789005901"
        "1889759344171317627022843286418622584881256584554850146178922587849067391433971807460553436148881053030070"
        "5802861083564184201184169691435145287114258821082648574406529482949951797469318976010031015211593519685235"
        "6143504992080056552460511205575879046219713889536617551984999570757281730469581796681608340143307523472370"
        "9158340884914908030521084546247013987864207024521100899305768953323642622737252465685844839888300778476275"
        "2504690325209332410674159217406970196845448542387095959055345603004485318890117726846497855781173320368657"
        "2008119029809783592472501674085799890593727350192541377257601235072778330693898940495500937686301767826080"
        "322265625"},
    {0x1.b3d55416fad60p-911, chars_format::fixed, 958,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000098345480986695514089618875926461208483325452"
        "0187790203799630446960504329333498437153616827417615849080912491003925803323420285422299200257544927820640"
        "3196974262922142565902846516873218036916144509441954617370831470053949450130019955123314130153815851209568"
        "8296822542786671627563023447619196019952069872082177562245203012490168186679900137224439591161763561631529"
        "3464515485572364258841282031378610280969479425754178210176017601378479729168995921054485337026942189492031"
        "3278249974575095799520464824210431965227917885444240882396069195834232249409883053072784499831730816048858"
        "9740516018599266395959212880525154717874306312317000128018615880641766641145906646670482587069272994995117"
        "1875"},
    {0x1.9c252fe78c1bbp-910, chars_format::fixed, 962,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000186000577347183717148252735186349783543584306"
        "5226252667540223733159853584429545480842165284796862395516622946505738661111515527860596046535739252667433"
        "9619943279155954767042619458245257620539041021467753483618439745555366084496635416052029194375312273988339"
        "5953459054698089295160136809941277375021138664370821656468798686147055957476482942394485517741175774489743"
        "1022543324456960570281971353204529907162058888376007918463781982884240607983616391110433956964751638884396"
        "6487172883723044175491157768319562372459142820052551651952238436737166908742319553970321228193470244524980"
        "1875002540042561304717037307821249843975582809304959019825510367065010295870020051722804055316373705863952"
        "63671875"},
    {0x1.37854269a312fp-909, chars_format::fixed, 961,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000281177567563084318100457074184575497197106100"
        "0084980110558541339231221112326541290736699617979395977326231025284075045635632891833639494133197161881204"
        "6224504398038089804797566696194054852793649425216579228222727097510217509956305478758508297871221479989962"
        "5873322057108782555733233200558807587860440057235205744430425661156658048746929392101714509199616555779854"
        "2355615838210352261328359536538279552301352677428931245555964648511872460375830460315773282037723059187498"
        "4672331036141828396945225593282927606498435385624529841926408136591221683870594888395821882623786633550811"
        "6641258134880120437857623554086012486429244012594048633043725631207559578078614137552904139738529920578002"
        "9296875"},
    {0x1.5b68fa4ac2b42p-908, chars_format::fixed, 959,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000627142702954425046034352511101324091475346679"
        "7573592625786027826229961270121367161220735064190560294766189444944164164163537272678618355342497912064256"
        "5704889212978977236562387447175181719200715273710035345801602255620534196942143774417246687690254364028350"
        "9152678828149245572170407760251902661012787036911831314203148098975334506109492493114566823642125222173406"
        "7473178795384718700740529819486819550341451155693941748487731802872607782124208196306724517738148599429059"
        "2771400812981009664297374096007549529645405830495946914994899100197867617957946223662087156345100226206663"
        "9104230829079096834618705866985638583219205247604259687488006991159779704436694203195656882598996162414550"
        "78125"},
    {0x1.1bee12d355aadp-907, chars_format::fixed, 959,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000001025097587133360141028521310018323277453847368"
        "5218055938897189096735340237340018400725666682494033072536608452334448790215856221307378430596060981382469"
        "4625419037109496021095951526904178029433537609825161518260979461178337955140116397414686445832946718544316"
        "2645279912920460025736906612085102498298245991228083818940277514836313880638017043345915398115813272728370"
        "1179492276737893371060445823347383802426142678436476115955450138058270748161861808671057012019317372254774"
        "7612927374090450924298878319085773548224441762980740444341131886157030691777931721396978119099548556496285"
        "1095177735122684967750904878926948300062887536858489633614618245137590016313744456510903546586632728576660"
        "15625"},
    {0x1.5dbb3bf725a55p-906, chars_format::fixed, 958,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000002525332508033293512228949556612784654893447598"
        "7700357144674961351479357467092094630453535541284919659245903800349407085632973490108353504676078653305638"
        "8680476864446948292312458125217671960943795156782787115386651848999561226033209730510837407818150760317463"
        "2534081548073471396342504983710412240194257585234633491428220431741047571003901582159610243573383026547491"
        "1659400368786801131458888124352482480324532223906317300645196650798384111356497633385763926314710642986472"
        "2263664851030405649181367011150329531668521843720200537028123097483060203056706819706736255855306948167124"
        "6793360301294886083514645802904351128554253419272228806760314434771714370286943562859960366040468215942382"
        "8125"},
    {0x1.deb564bfc9b39p-905, chars_format::fixed, 957,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000006913296125147657892922290453005227362836355244"
        "3315557555004747661057069612999210997894255772698684551025199124351522536488288269888962458462802724946749"
        "2666941103078711591669709456393002977814548674714031442490579187323502483842326834538282021757452558716419"
        "4948220489599485554712874650998509771058740523491301689686432317931766517872342221321618438402281239738438"
        "1918414301497856335169286849906525371490446315447355139287718496849222455179777434039582883600813461913264"
        "0683002736269625867150029972744613412338525800662983389755954407496066156925443484441684969664361113623048"
        "0746804569554606627570565749735444390099046341993234153112576404723484124748011936389957554638385772705078"
        "125"},
    {0x1.5179ff1b0d531p-904, chars_format::fixed, 956,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000009747372287629775385909424316703891833573247564"
        "8235279596858447770771804886894929506661512363400799235132329961109412782244052135199979147620902244163877"
        "9626597351701245970013572675145669042456116850923505846902122101954391035044684055589640864082184396140022"
        "0187736393637951646466301575756491015220368431665646131851050972773613550549775860949100748531330715019423"
        "1963853639010109636728185073120919295228223264260018917015441561102712444279374287475396552967106691035119"
        "1453495845396281368093624689695699465834057840582376163654013374792705789260527711530436179193315127652734"
        "8358808702693259272579380945576312699683565750443374991247958918786156723434999094024533405900001525878906"
        "25"},
    {0x1.5567a7e8b22acp-903, chars_format::fixed, 953,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000019721670909138485406708209875245988754855499584"
        "3593801435382496634863181333354250488013601769333154658301020938111316690961968819801684276456747470648078"
        "4460925731369740039309091313646494344106771917559643744611689449985149741847522870512655148231642390548825"
        "4596546181359984630593149398458548638623788384301779196054568577661945071167810995560010331333745976303201"
        "2643595551046517388510084614608233716254602267850305675356162650233030360899161133192808264578667329162878"
        "4708737722477047743341614476681740665615870417264687557758802755495463473945116677959704440051349739279053"
        "89687889706272452193245281982712102143805928570275023188204872089807073720635344216134399175643920898437"
        "5"},
    {0x1.82d26b4d40ec6p-902, chars_format::fixed, 953,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000044690483726796048912736648731122955257354188196"
        "0242319865883123307422572380214566349088266541272348399162694465100758770795918495191617148046111636565021"
        "9844543013087712957676283665264577527662267741361571586772049777232414728237847783800185819300150695494868"
        "2653999899843034181869139363871037782958467075585876988989744537743159905346990806740300898994948523687536"
        "7828209803100829565629765163934287231863692549726979176395237517451055069267609733839616408831778853430757"
        "8954035491246101013689948210955350821596365451655673397438311473563149126607326293087358055222847103895464"
        "44222168239476217622026150424150094836999566430914876899155427272120055803839022701140493154525756835937"
        "5"},
    {0x1.b9adb0b3a270ep-901, chars_format::fixed, 952,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000102056384451920745406860391496194921660362213036"
        "5562288058257422369971885119195604032070972015707144596472334283003344969574819842726371410401166526430641"
        "0929900200071491252672235000950484652288750093774229945977709420122440502247379632346325992236983886493821"
        "1391539205077023662214501398790628925066797744001656546577727861247458245657168760908913580691963130607977"
        "6803215097870129800335260946331259196166059113373568611705869136348407003151491682756842641906922895435050"
        "4391013909737089907168100664000924621669067051506853028575970448374045400888697082103359003015536916044411"
        "79068784764324781639073532912521042956144573308772953464440883496189282908517270698212087154388427734375"},
    {0x1.51754b041523bp-900, chars_format::fixed, 952,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000155949465914581444168158192054680861671598436644"
        "2620364478829976811035089889563564047368317717978748493547107618900970773911702439074983599285664500289449"
        "0099878123620323093655056835613818532634226074494779795904480899802150737568260925897170351407616991870097"
        "6802279957856393292653995941968958393707777122490398288305066037545153525183704267307195036904186159899450"
        "2394042224648739892050532127005297477317011060627275918383352054171181466701597646454049096032781767016048"
        "2974319858048441249248666379883400328177436639034736816575953623392316883651494465986730547978520346652340"
        "88747269980370542955955889926977401007116018807400721172485495540083189069946456584148108959197998046875"},
    {0x1.00a667d829ba4p-899, chars_format::fixed, 949,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000237211226291945636889926959610225919727009657699"
        "6496202397961351883127358688939107282331299624534155208390877862968305992335609703366546415633283533678270"
        "6119375033905584915207671447399368427797827278265677967865192480932785233809461823871812702241616934713059"
        "6071680179608635040182094153029361012433988509937012245563392134807731665037384537298367234779762339214326"
        "8249901056594934855686217622990248877923391269195571001807761624217336055192512549943990505216069472298347"
        "0390100134337335399195570019598788119671177825761130537287707783157679110738395099384763372686340200825394"
        "41903467893818834311806047336796227578822931941039658316800094184362279747801949270069599151611328125"},
    {0x1.2c4d42a513cc0p-898, chars_format::fixed, 944,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000555113591928415468862717082533166226808384500851"
        "4417554841019502743301366429368819546119006284763004333001348277225050221860684150032510350617852415448793"
        "2917435582912849238042093194887283396639502932028323910651284002746030998913494560860794895072024297806097"
        "1029142766066034974054612763882077645998211141669478955213198112932980574245986888148912541052644921915234"
        "5004917839581742185059741768986228887671664675393120074838168629509013042697933604905361403885064909007008"
        "1828290680696185622583742529430720402081186991071596341524139197492696468962732382079303814473378818485302"
        "511034413288084890890452684852818540143093357096495846052242040258306587929837405681610107421875"},
    {0x1.225c4c3c8232cp-897, chars_format::fixed, 947,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000001073473967444629802420724822979097421269020692973"
        "8748612035688298132431930940767808978781611808395357190463149503662940609545550797429425138405559672522900"
        "6339887006543979219474079905078476701423633851365003304096553358163726469933016105370060494017301219802989"
        "3482448464528100444472938931188041028209567758949481905183049001531134922860872368400958134235712133547181"
        "2569531901439452988004676219145306228626404952817818807907754264843610519108607195980800602836302109764033"
        "4464264306889872584610305498775551918545763871034864670939169778489835723700551452954573645827010966358712"
        "257418750698937467561024473055937316696854724845682348285079432681499156387872062623500823974609375"},
    {0x1.49f96e8fc3b39p-896, chars_format::fixed, 948,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000002439855426270266744439814801803809895247054421512"
        "4227046286789042553768286136848758427981512172714445409930115643233877845863399498871974798169753440335024"
        "2401988431098023618401338421499127747850118979962781370625158221841490672613693129416038541246919744044038"
        "0909570572089389208878233063263470015565582345570048109359863968364681509387377493594037525854040800897109"
        "1122482936133784909715421457345554809011396322005411855059916233822920918416811292732601739460526050660702"
        "4809166145756193292992255504344399533818727388472020637202984183709925973193244385159211841241130746105986"
        "2509222808177157336752523381613241275274954877922857555982462385291142936694086529314517974853515625"},
    {0x1.d02b819f5ea60p-895, chars_format::fixed, 942,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000006864215876463049547810788703539701409380640647873"
        "9147400934802190758122966145509273130663656083449116193388822368564057256191430774573151546980833069733638"
        "4232242413969293063536569077723416762396892707530258707424454546743892561221427588160133512763385429154354"
        "9312798476681105264979340881027849188655526015371664367066319612937083186121677093486292468421698574372787"
        "1460443148241127262602309896093569590960002026708618897030775910938683812388348909731662562903690820461225"
        "3030886781498471111475701705130013263603331962648371224484283181824576820244771587634819709611329231223350"
        "5987050190351763242747076189226988458164602331524196780765390002443382400088012218475341796875"},
    {0x1.9799ed1e92e60p-894, chars_format::fixed, 941,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000012055339469240307377403402594354358674407642465821"
        "4403161853873665328348183768707944967517035919903205770271070113114076479488114135898545635834909792131037"
        "9981065458509943305443712669457405347768334883742787788574210076011956356747276577674394094443595818534447"
        "4992491153419986760843944863078761839695019053264472317921674817757806138643290162179595339950043670422343"
        "4169274034194895415420453624725368318043357630277210489316956915292444618610846509129090912794604455025923"
        "5072047006302106680667373755369200337798835481918186611848963048722354732914235674141422188511695223505091"
        "651304612258808796215869856934551053015669443762235800432502941248458228074014186859130859375"},
    {0x1.01910e9dcf23fp-893, chars_format::fixed, 945,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000015235738192618518189936618594353198373490038933641"
        "5111790903062676051820241330533383850487198054690809001545957303087100560223792006622980536966737234211755"
        "4610115874265196595093653515066235057757408737321012747059302244480684314824553717385232770551514728255582"
        "4436594037789840136673492380360921795469449312993203310861757505321077871877040854320771623366194214101040"
        "9767355749589386637921051247047454063093657663296180147824771690982829988866222038776007404704345799976200"
        "3493823707191982605843870742955753084896546013143923808806247650486965191635898381488272370659215232130706"
        "3058388996553539467461706719877326145389249433603759474424588216123765960219316184520721435546875"},
    {0x1.55d13790babe3p-892, chars_format::fixed, 944,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000040438764974429647181083693278793666999589651788371"
        "2316059693838777295245607266108475249394878935376323626898846861862368755886367916636298143998039008428394"
        "6105355179120022459893093062023824545784393567834950735132918308903968711752955260187817332338525640497165"
        "7502319380964581908082064284459113668849235010808935239541206093029385768713858239491000151225959463531583"
        "5889637361803405730106505082375740159759460103926440144688165168171854738715370375794081116073467023962896"
        "8287348096121485573700124978582031136456289932225609673950336664355143451919771945115113191166252509180553"
        "149351063482548119983121858449386491438816394778188001261909345629419476608745753765106201171875"},
    {0x1.7188a97a16f94p-891, chars_format::fixed, 941,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000087435562511428746407917858121214372902879051776678"
        "9817379763220476136106242826852095074666987781422882240275455082159625173427591657526511616774859950448070"
        "5195051348020502345099156950992018891280747830850730319314819188183029263829944697648815507866941818927878"
        "0582425665436323279405306313375550995403554057816311786992808924770387346666342826175687898745708869277309"
        "8795098157293253829450151542285341405243742641265914881758531162780816922738713821526003173659290088391480"
        "4697424808639350956260920901169849738081795310697365452593665854547305770395594226542202736076609270724296"
        "938582309549515791111533078749081279345889490509807252804908017651541740633547306060791015625"},
    {0x1.3590ea1f17fdep-890, chars_format::fixed, 941,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000146493127491071126992490786122534662551391906108660"
        "4893020723479984156700388998530701157329530892948055206250467791745632187137591881800959448706575506783553"
        "3305293980845682189018765192358868026965459386012151443491814855009311650582277113439810642092690727961918"
        "3829769355597934005735327479576848296626166074032572190516990701799180866601670181423706918604194268437864"
        "7424132138357106197054181850987434271954643223838347525698626002419348990652336080238406606469810367043062"
        "4632830507827378702090628737328382855053277277737615450423826030613135622402351902807691843748918648949908"
        "080945278986968636934743829447731922043526141347861806163432873972851666621863842010498046875"},
    {0x1.a490bff22405bp-889, chars_format::fixed, 941,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000398040680032538019248823757194178125361186214721223"
        "8841684360793753033502180071560424510118766755474701399549993774340528518781782521015393593943194136695829"
        "2878516104741234323167088335311190521761676432545904666778288299887061291364677119632767625410961355927521"
        "8876947258959706568599369475887957963067391294889917939846287343966886396643018338025708549019241895307789"
        "6482673340235492057075596872283134858371284398948959714256144129887323486148624003771536424647219733725766"
        "8040945002790876177020317646106961815493905556587976914374131310785391757041479031876978729052577052233157"
        "724978255607703760411166929085715222687136653970780240940907646063351421616971492767333984375"},
    {0x1.c59bdc303397cp-888, chars_format::fixed, 938,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000858628666061551578620582213363458205748458803788786"
        "1653476646133471193396760860140523709430528521295122472188112244145499998342419246971681850985483625015372"
        "9001931401489917670794018753095678072632523527999732610094527055794991699011689812682020208999092432846374"
        "9206066143375830463217600681424042168640928466759510908488147805264249237670584162817806918290258013605944"
        "5292592764666886134366208157303804289513110088392566492734345663801695248299650254552073655270093165014095"
        "3745238481264868345866657053099401639847225793582187014757929215746065651862973105294722461164856108604685"
        "774535166379595213598040942354994072654807133241315619809341797008528374135494232177734375"},
    {0x1.b5cd6c8c1c28fp-887, chars_format::fixed, 939,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000001657418018730156027704299335942208423046539273378705"
        "1007866897996899438544490745152444688834530645625295640123271066862185300846827639112830109790029239800333"
        "6274182420225374479310694714219204498291060859779351667987674079151712854488592484033025216160648157535374"
        "0949876187647749371234129360568830223801641060064222372386736263114524128290896008457829750171471791610570"
        "6062353536412253151235023622382582131429436080455694095554769027101991142854931736085157727810031776394869"
        "3937529484290614370922528247233871396511557553970893932497479312360218072120491695818497939306244437975388"
        "8516263944185940942548772357521469280603746275395797560303634554657037369906902313232421875"},
    {0x1.dd323693a3332p-886, chars_format::fixed, 937,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000003613106834542996945113037331011560709929486413066981"
        "3892800930118616243487082666684796081077226753480935212068872259503118509581066207485830029333326409179897"
        "6751709329421719319329249471449113212585104216180364902090305245564247211421614493046873288168921343097379"
        "1424810940744070365363417199107528165592848991563388371423989125478551859503141188515560705433960301135780"
        "9855510923231449073199376203490368131774971870870529128925452259061106855564430654962589375807588265121141"
        "1533144826878180312068875356012841418042267850727474063115262479538676565684223521209736564184271951929196"
        "35507954677513543575460907844889158905506818431248305945047150089521892368793487548828125"},
    {0x1.86d3c9131605ep-885, chars_format::fixed, 936,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000005918324175176495510938976497671415587262060964341024"
        "3773660851543979583503245329654584813732786527982073834052163642085272541799726161544741798141501688273444"
        "8973389564189606166822481467349095902747600636497815870565594931401773022857017064655371943174559969975555"
        "9963097604629279063754642229864212114707279675331717816844007259459221802237099864315723446537096700850512"
        "4175029486015944278448019481201861981653551367410858983035952773046534667845276266870926697195576559022854"
        "0631576870240350592327118633813432163334893809956910105818693405865461650690072606842357847977527034422011"
        "2716254835138009906792965231941252390889503048020114928107204832485876977443695068359375"},
    {0x1.85911e81c4b3ep-884, chars_format::fixed, 935,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000011798475245572565258836463208928683635416019155375711"
        "6368488357751653846078375633343585731394837217385287091120028390252414848147343275955457018828059343282834"
        "0730621546381698761786831441274619355619496696270024173685557443459253842752241847183852027161270157839527"
        "2910201485060611138969490229431541336037591665706625690345523867216992200844339835298032472528560480231572"
        "0532675758147358190312305588395835973484510540261572242255926498453096842484137847010445108819535016652319"
        "3344995494299949536543046660278432397946662893934648233129548468640073030619432252064931487614833495014858"
        "781346346117845149269477579183027503827919826688563897931771862204186618328094482421875"},
    {0x1.fd3a7670dc2aep-883, chars_format::fixed, 934,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000030845119288706609241776127310550945770260699097294636"
        "0902325553169062823977589756568024449658175724356488309154179460646805809256909673683564407525994808351915"
        "6603246377068172169481286969315365287278018907572760857821998571184112154093996098113552610554410114972749"
        "6544350787571443902508172513593663572408346095883337524472602522735858303857046884402733676415512137932791"
        "9906700196084011500970718879296894750190780528244326958169030004334188899958031100736000503800060878357350"
        "7149148045707056223577605654336669406379845891253511117578209700869532329366449360905532226889918970109979"
        "92044067666407349229132534396534265265865464543393326124487430206499993801116943359375"},
    {0x1.55795032e6bd0p-882, chars_format::fixed, 930,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000041367697432326765352340817035182743358257354812683967"
        "5514706183070775290299430288530880767625546394325091548046642335686562972830560848535832043202751676119898"
        "4787279267283006731787236388821611791941976179801966223908838232485454712767866954880107986586331614093671"
        "0381685947902023492945274763039123761201070325649322867198926794092379193979001160520283118740890457050606"
        "5615283688529715886701601418737963348910052650002158795052277642750755249858943871277223658376131404786971"
        "0974725490393066509945142112627335689540105433975437451964937117339719316717342057260783566644006824506803"
        "9288577540523073152465291162006574964969847496565336086860042996704578399658203125"},
    {0x1.d4b623359ac05p-881, chars_format::fixed, 933,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000113563675624986191453102443856984735254272835648039024"
        "7148093097331978873723151459297710811496506381505534558309773790241440886806822023647805957728246263626555"
        "0762639865697663081700386660252071860545523437851473530877887418045599317762550258475151832404780769663129"
        "0499577845888123194920903598141112160404527827884306169772685471839601638500173215919930934478212486692401"
        "1933370531388442338358094661908139596342648995217761099977664396650272093960020341884435861220916521937924"
        "7000575593977410565239358757046872960846732199088342182083021803693622257171081219637059364936918824579947"
        "2649248541360921046913448446758900887079029619342041002028054208494722843170166015625"},
    {0x1.3fc14119b6b30p-880, chars_format::fixed, 928,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000154946245842527239759062495833753523032566543431810751"
        "7130127590869403722238026359250431068983678010402175817581233673382519031060069659513380216030715235291169"
        "4652169190757365849842534939286929512771800043392988501637567155216372107136851294950867489850497997102997"
        "3977585420440071472851517003121055829161592054739521109927826093026025885683246499701674274453089753056309"
        "7291977203548901120184100112729702315119501770992283784215283680031165586637831064539612758832139342286457"
        "9273358450301548738879972068346188727141606086652040192570849472622893156172198796091642797668561579545981"
        "04804131015062387788537884648628367603544198072285098533029668033123016357421875"},
    {0x1.387efea29f7d7p-879, chars_format::fixed, 931,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000302857553709510386816086836969056210337722783307285535"
        "5220692967731775893727875231391193715089712768013783170035525245663579807030327581339575641841515558865022"
        "3875058005326741563542885257754812854331178322417249486816148685850962107177043895514770489994015629591598"
        "0115867375133595828507638520983393372274509660267810031430617209341027949678360520548931055162245588815504"
        "1168642269270378241902705974557075324087799607548440887496138095190515484126289206547636858207838426948184"
        "7128789237077851670168107860012530261251377841489594288815216057423550542572170135730446067870746425778304"
        "11006902168840320052258179872988498243578485424887247745573404245078563690185546875"},
    {0x1.e65f23fe2db0dp-878, chars_format::fixed, 930,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000942740333348115037485284047572893847268067700326743274"
        "0281813334184073733241175012142621582185336547439135572303877902850839331914579032892703455962702636721963"
        "5439418242731552600088064997714165610578732713529973991554800638812125247404950314573296644157844600155364"
        "1354214491814492098227905347273644812896843414825439878882772310022109935207503865014021224756207477741113"
        "4643948266030983658278327971341011673659661946388286738125049216155470349506228879832318739988654166524681"
        "4447842162631883718367857800178745276287675211435150083921296137407835066159264367886538838166434182939838"
        "2732535579059561940117511215852170831865260158810571056164917536079883575439453125"},
    {0x1.be0d3381db145p-877, chars_format::fixed, 929,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000001729174836691516980553517336131169033606086325093753675"
        "4419109791788940622928061477911081864929176484648733039274002682060801271760199087832663704763871824868199"
        "3991531006456103430748094806588017738041317168594778702187869249690426620042779563163881086035431687965786"
        "6121076029993751741729645917063224939510035511898570999935992830067440500228934203315616921364477636261479"
        "4679384856915080325537702909530580016470514923381118473118916750055309888956981579069546748968265626703041"
        "6780025246929633596118386225452442180730702839693663881866994486265134523313887979133379249848275332413804"
        "760161035687737748418881478304219407823340282082114072181866504251956939697265625"},
    {0x1.15b4bb463138fp-876, chars_format::fixed, 928,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000002153124133599410258154542154390571855326120563459622520"
        "5065032112054906757350946064401973884364945201367158919349888958734251838952734069161919669821826840595044"
        "4924912994180329555785724990446715258463485821370710029791472089009777916920588380945749794008116972667632"
        "9974463181247441649888441390421006496972025799387444986939962249165560524017456595384490558469327633544094"
        "5576505682668112743945032654000227377822639620983203242462816986727896006612405764230193507933353399837465"
        "6641508551131984260262634639285697704413869791566604705834455516861576829347186001887771992780142196257079"
        "36771490825261708861973418770466995124900078106833234414807520806789398193359375"},
    {0x1.c9829623e255dp-875, chars_format::fixed, 927,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000007094381157920945667439354681068103447509227212713734976"
        "9143575260247208850042176344557556673219122391550803213462791453166083465372413326621666485198457943128035"
        "4615254876343265450440084636894948463058853750279245418059419061499942901115676887752226814880255198322013"
        "9436429766464461164984165663141029854488048705467562348360481087238365183897951270158302565235088387227882"
        "8061474056265146942266842117494952581371563236372454474548015943400930092469885047371085489250666827759464"
        "5356984354898943282803740889954727605047952229451319953662380073339087885534411135955772403038293485700573"
        "4748620310003839032941834111259667519124028078891797122196294367313385009765625"},
    {0x1.4e746257d7670p-874, chars_format::fixed, 922,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000010372442383613189969714086258459722252660210904892135354"
        "6664564824864365134133293000960441974952192749638978020863794678225957572854635073507252775535164961781534"
        "9103444803582326488982705952086013492929462684412975659811329213404719323722531070098963653390797863993492"
        "2375987608423830121986992743240549961595473294598640580924969673405756953920124756145504369343197985189208"
        "0485777689297288928968886924569014126842036461159664146976253775304747117052161568491733834101439034106718"
        "6712491252995801723554370577629804724486087744533699693661677914745564631876392042680021779683932888965662"
        "89594361861665631675773451618959540565523269606273970566689968109130859375"},
    {0x1.0cf4bc9e57f3bp-873, chars_format::fixed, 925,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000016682266784627316054126786634947099848892653011771160846"
        "9902247927774169651256336593638231661507087835116568115883612889554220377387265788086029467082903772667492"
        "2831297532849528031546928641619694366416535824542202025731166907532844165700456927285153916176469595705886"
        "7443145248950221393523045593432559418578880688659990319914265277282424260166051913216749835283576431746611"
        "5385064714278273070236040126348067956104322034201963154877669659580960959116015504309990919735860857543724"
        "9512248944124858612533720835526187821454158398162016695152261152695946643426485073285270438041876766580343"
        "02406565002561725539804953326260251143808854834560406743548810482025146484375"},
    {0x1.bca9d75009185p-872, chars_format::fixed, 924,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000055161395008185867433415357299266473202855702442652255015"
        "4174733465165230596318238791373343416884120642522016359703316218905950439100436732933226969082782786169311"
        "5454302291940749074772755050717921148324807872707178915637107070607758223870410283818480871009382801702917"
        "2180183032905303915282051609374836137447220943757556647797218095071645532979709602538130511390566521835079"
        "6699468382475616011900085039348409957586580232901106296333354593470671297966973754686923720279528690270848"
        "8048349448687817723031899550692941655042719473473767583033498736701881264169093594528605625061561557706388"
        "5750483471854174717985639223420961559096742377050759387202560901641845703125"},
    {0x1.cdbe1ccc95d90p-871, chars_format::fixed, 919,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000114560204642325076750571222775436851192164605571682527481"
        "5762124952088415596615808373168469160246822484321000751593912242355663941083913700201743951110967290075316"
        "3182380892806524301413018460615449738652419601721811101437128085997757100216577623134851669113404571254050"
        "6816944359776967289951251306531503289183469926273219080353866450389866014390516672435679791396724309215999"
        "6770248028065053108625679906847658543128458538824047203145322198383475617623515440685661963579197311084394"
        "9895152983258532048318532787996836228886776963364238874442152079723018206593200540364309223636337944497709"
        "68981950183436840696718769035296336955553897496429271996021270751953125"},
    {0x1.a08e347eebee8p-870, chars_format::fixed, 919,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000206698187369856312292114336091733007715218382597874181651"
        "2849212959334684319910588999155563054688552042487345002100121410104592008447301112604018951149526548034818"
        "8893504692719952301531071219054886735101514312883173414979910358326786593142237008198154964115878154288660"
        "4501583126242304688874484366513075164220664047059619137858056693870956007134838247289096005270760100292852"
        "8908244858324430310039391980073912226287873779846512676915660226793076428687633580029559705975990491787084"
        "7592802805226940431900752153915100946582833577516755521942664950845586036534018644192041578892577649154335"
        "24177885184490559892343474975885675437581312507973052561283111572265625"},
    {0x1.12459afe073cdp-869, chars_format::fixed, 921,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000272191846524068059931132000697245710331163957942600225109"
        "6560090007625639505670844147437379205645010682127734111790249585302708172431629584243318004556707822556023"
        "2756992231595695913707832396127112414291967814083664279483782121130660257086947726689908320576416698270875"
        "7414974681240812796649904138114661552244197783111750382074950405613552083946446489700175613754938664542100"
        "3994961660982636991816058707634629532208736580752557522215085254672270475091825412352898008934744774445658"
        "1029948456900349544307061602508792286538650452312185863032524915967344999462622725999810009215933241901668"
        "4057896016276584607758107174483620804839034690303378738462924957275390625"},
    {0x1.0001756acaa34p-868, chars_format::fixed, 918,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000508128354267473450755536119234776173989878203696489395513"
        "0680321274137157152649946485593063004909706459221011223798923824797171065383696947332357164386562648631284"
        "9073191520565355409187006336251727528271700865445935359221676212289295361664298049416211342128813651851814"
        "3256458335982392924007542973144202819143718331034743222068350975022076680647910977770307472932084310087384"
        "2723453005642196320580008440470383450260257320640044222252784994928836137114749728430244847021545183325639"
        "6123011598918717948962340265499338059700908690029345363869653635550764442527477510671124376200449421607418"
        "5189128697597492862393601530286713074957560820621438324451446533203125"},
    {0x1.a923f6cf5a94cp-867, chars_format::fixed, 917,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000001687665053057820762157022995279778564468211084460073038282"
        "8697983205295811627431458729119705328829243777096719665579994254117849067464302618370312175425353893782406"
        "2441208188206739880347984078224093935173556451996842851241854518414812710604641456646783939042209035234300"
        "7549697592858950809976923310636041815949880034513624879487987710466483762543019539356484131174578611392193"
        "2455203585099235154424807349383493024231486017916745364147754223484345302292969504582896292277375000907594"
        "6875267007574023695528840568813676232828754491306864681380564224560626125773652293287294741275525783255807"
        "419237011346512428936532889366117782259379964671097695827484130859375"},
    {0x1.1ec90c20f8a14p-866, chars_format::fixed, 916,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000002276883127404377217638244570721494113705000481985729668493"
        "1317704292669869186330235385392974936135583425559939139633685462503798116631815904395994711723284574730699"
        "6155023939888756843144321245127560309680255408819823953629550337527044667694952163634448328029714220479710"
        "5650413943143524391493206834878212096730282097671600157051213678678300464186484597886719361440158070086833"
        "4274804209917513296587055016135300878023975459549254745964452344219743352297906726945322169747046918521525"
        "4072576985178910173696058780136578510752082477360151040647381828489881163991894382690040854040207373360437"
        "75752403727901886111359007654197927905670439940877258777618408203125"},
    {0x1.8c40010a69bddp-865, chars_format::fixed, 917,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000006291918347254160060272175492842618664079171391920773579142"
        "9339647422629100785659522780692862200166897491701255556801910407106573720448533498719438330123476869662624"
        "0704934209115582338286117696015309238068919260879285835030642031622990931503918389292642312749696540879180"
        "3311714197177193889783060818926773096147698988342115117077934532689695873460272125731176376173747456244746"
        "0745166179129141239961621209497591323866150735669664874909372816156647940669783864971383067108306325702411"
        "6592611233964687353694158987479949427380270159845583896812091323905699762435381781071574840894205533141176"
        "329856093298409978372063276232106776575392359518446028232574462890625"},
    {0x1.1efdbfdcbcd2ap-864, chars_format::fixed, 915,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000009114070309202436715506704439522116445273667583315101326321"
        "1220841163780409432338993660009501481842296218708349541201452089361954411446146803975046420958720254804201"
        "6950090674691007785016340938454849306345780627414920934063304738214052872562345240855955895843954816456096"
        "6946219116473549606304395767765048257811327042187942500615765107049583838484502359610687054584021634782046"
        "2109279705594517393524899645116315147968384649516659855648207409482502910088356334794730960275068225436448"
        "2901382848664076403072603858551382288376096255467392095909044460388941503222527272887728801713303434009821"
        "1825380764598208977109714858111377822069698595441877841949462890625"},
    {0x1.906ddfd189240p-863, chars_format::fixed, 909,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000025433112499173347793194125621710163645079369331423202898876"
        "2740870132656644179963370891130188870966286895286909980735596949777809152245542352924571623599896408538766"
        "9306942286026266510837759661678996824110949218664528453283677257072323229605736418093485916168131207495359"
        "2695943801167827535017533352905257163768206378131651313649600349107789087387461150989691005378537949674398"
        "9865981922331313110583463218632304343712779751159601698778173244506374886663889558909304985006734120160002"
        "1436504006480952802391648772773853880784246678088998821393839777960585285786855049346501567034793016761392"
        "9746789657136764079177482233973250913550145924091339111328125"},
    {0x1.7ce18a4c43eb1p-862, chars_format::fixed, 914,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000048383034142174994104272069838127782959216294890444624860488"
        "1177404794594426120880857998471497917185926395692514342169545748844407930478209370082097698966466303161266"
        "6935882969164776948437199222172578500786635886274299181215882835731412951066974921021211756829121808175859"
        "8187914493364934874344008425996265567120018761509667718055608502897452028494895946834053067261106309416912"
        "4950837753490510108692200824269667675272188181979310566617032157898763990519492387274070392056149682430213"
        "6526869731362794131748160378334399587897499073925267530473811700835332428644282412990851223505003816036845"
        "036704538201885036357457504918588853115579695440828800201416015625"},
    {0x1.782df6ed4d7c1p-861, chars_format::fixed, 913,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000095571620410084553612231327876427113790261344273014651312134"
        "6531376923699321195592174941483374402823022241130263997567506024287148387776798461354301437476844010018790"
        "7766581818620751474689521354792419668637234994562671930616485340107247684107637321972451853389214118467182"
        "1123889970763705393577880634528933761517297484082915270789468943416839744708329469795749877089097746641157"
        "5537371988696981399871854364602534911494453108101743200834799840591710632180550687823669819744527982460287"
        "7755033025381947128790421438018640252322295334730678286714386718609825203493845270564103948780979172013971"
        "38322894657648983246446723616163154702007886953651905059814453125"},
    {0x1.c8f1f802391b1p-860, chars_format::fixed, 912,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000232181639911903853645089842504477068482867207024333342829157"
        "7919705134892889011156980930242366813130676885496716060042971897736006971123622013129470717465474989351231"
        "2968631191631271821301947346158547023662534217907009485542762701806105687506696983460743967825988419691645"
        "2391084552940222814224933545941684631041163455433387288322957692396586578847437356129153323542921648490609"
        "4517687214723033131816735076669297720633441014191257900017539357278220796859945952519805757175348077621113"
        "6458583264149293438298614129607825601449069190688909302232480320013781782200263494821089951192419964494001"
        "2660900365078741120123707875055885097026475705206394195556640625"},
    {0x1.b4262171cb3b7p-859, chars_format::fixed, 911,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000443229429011963768633603196809336946543089979211649221027454"
        "8405275696535832050413393762041703842835100613439369769339676083420741214153242100785872435174265771853500"
        "9392431015626411922583861369639865949698991042083535182323159478904786522820949927015786513521782914861765"
        "7450841270312046380823739644494904776851297637312513275110102336104808293107056795656130590649733974376541"
        "9970162656685419340316738036723361873504929779450561348524467585813726066495148491623149065684298295442331"
        "6406399105498871522953443938568758577931893225742867272462858385948084245565633604500203685160547735325636"
        "080376242437876526249034003779314616622286848723888397216796875"},
    {0x1.64a437deb4440p-858, chars_format::fixed, 904,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000724862454566518620234725743708768192604113707182498198187433"
        "3594377620530764610176592097380225029628645932726108934612739313174583226276319058355309446786731754362240"
        "3496838166730353957241402517547465384606062637177347754685284719257619888362283409076933859476395240285644"
        "6379192946724641476839922625769792445123702164439694807298008019021013530011385609259488019249176723990804"
        "8905028678287251757469304085099656023708399752447431206991973014885061270696168035586546178057383592410412"
        "4680138405043785030336699070613668598522547056960518100534311513009802409862859368668829561043226971944392"
        "26699982917385446656854952607318409718573093414306640625"},
    {0x1.68d1c7ddfd3c9p-857, chars_format::fixed, 909,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000001466708125736090512221954506706754473316374680549096643048844"
        "9206414100150968687775032402756052292826192310903305035134133781411481712341507954193064787326215057170476"
        "7679131224864582828071686888611188799409109024501138539451155008359084440376917174041581383111876783748850"
        "0000872271900044128369701757149831659567051913456988928102132132714135417775009699086311215171571037956724"
        "7962185037697773480199531512073678158854750890584017056925661719743417354466583312700152556120020313103113"
        "5463571741228836842304648117709300656826393728666743359277626137797043271568736571964759141129463848244377"
        "4640687500004641624813672695637478682328946888446807861328125"},
    {0x1.d75f7e137fe61p-856, chars_format::fixed, 908,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000003832202635359104194554961953235011507054258223190057221963033"
        "5353346952308164980213456390925558452250257609523249459132862945644945228012525507914866849886180070675458"
        "5208817826976126668888145120396190261611609172762119123793145872789603778805203802587968961121447916143996"
        "1002799972418744907169391423514023327463523140914150416518473055253385027500232035783985300855435692354488"
        "7943781694190440637960551088058658109244864183491834764218822863830891904140211787521427609138820308878984"
        "4277557265644615942295037352991745550805324976793851744763356416802504802538322517452316317317151165581065"
        "828711542919039951572701685478250510641373693943023681640625"},
    {0x1.ab03ba2215decp-855, chars_format::fixed, 905,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000006943148025853397197077622647678007083343944753441934095558987"
        "7460326824250672274858385074795336068109179111518174172764432638216994241523277261186746220234484198234243"
        "6831859881780104169648940151652988950108209827537054607555340313253858616237354565394861058283130194072330"
        "0705685976603592449533077414627581849293233497787771627293472929449345822969315648485548907151911780992120"
        "8470019603290425328615499359681908998029766237263426183580374474662876558240267887653911901083546355304644"
        "3911243526573460491703172114040390276817289845890578743620306966872375092911586288802873761067392220076866"
        "999516537127721226008159050024914904497563838958740234375"},
    {0x1.1a8446c1becebp-854, chars_format::fixed, 906,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000009187299399025639839353141660045728045005906832079651463105609"
        "0469764224373506303894785318601668954036095739737917845209608647602558431586717467239245039611550399241162"
        "3576333908756070286366449656119838691258523423430330414144163620953827604443743428744603063245041502634327"
        "4481569236323844213095362475894936453835494631591638117650406100306878685312472074114350800075997576491205"
        "8080348409246107484554164396410838347897285039581676105234110261940749964363668337453955227885141656326569"
        "2570816851024552511717992981218509470445404085105859243412968072025617790595413875401003822322765471302218"
        "3966981646315616387432623213271654094569385051727294921875"},
    {0x1.d6414a4bf4907p-853, chars_format::fixed, 905,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000030584908958671776337833997728212552743197169604966979110845813"
        "0402764519100128543072177565353659388779586721422062480805494048637982077473308559243951566395413290867225"
        "5471570809915647515699422981901707597238756567053418426117941253353267909236696526460445120208280487438673"
        "4624903615119560690379371506706635465707437346296769657742269429934163903699889943903922695607261208044403"
        "5045033212003702250424000664409060170693287784261706490929305618215679483092331173245544667709092235091659"
        "0045877443524782470582045759082447664181476862773133919940629127853848611379955271758919464669049389518829"
        "342226751666594490586259524889101157896220684051513671875"},
    {0x1.0035d29019008p-852, chars_format::fixed, 901,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000033327306790247037336907675034392568454272595369411738900867617"
        "4880079134735517335342013230631997238070193934483504697879606878598819097351469420895437630770473232697024"
        "3223355253188882278405525096756005242556469028619739611765019036536534035050301257528705215736828310189129"
        "1095134178466707426578612230796829810863957988927567766792373175362266064722463852642260216366005158732934"
        "5627129548295038999732084305256140469500499943939385349824496739105901495187144509403790073622444198594469"
        "7990572015406237569261690504356844448725607824856932216929044311840257291219286900776173012629452228655688"
        "47219920199827225548716569392126984894275665283203125"},
    {0x1.20220d0117b02p-851, chars_format::fixed, 902,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000074959510555108538799335754813356701754792355065646873389377940"
        "1769112399719866594903832403760079779042083118660847570367526920460011559675059654679049732952640292043242"
        "9984609818930077480670316564262828094663598944693614670185383532442466218699267405223828138978645448763130"
        "0095892741084197499086704407259670374813002062851633748523492548210781300670887434058964089123011544222688"
        "4232370871021353363060667674967440542821407338711019067174933523839551077258961555519024174473109573715905"
        "8912303663040423665505482395509092064060252160684959021066679582680454839013311819960942494580582546135693"
        "497151510794086759492671490079374052584171295166015625"},
    {0x1.3b95c8f65ccb4p-850, chars_format::fixed, 900,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000164202667269448256304548080880543307906880391844297662484492447"
        "4480251023441651216759373536510779461101387097822996439468312579313736912924505271471334743943687783285894"
        "6432038927944415292959612977509107916975101445198422476042659471640984443533378762951944072509128558502673"
        "5116818713884927428724040855519698349334284899334673425879735987102207151385983153910264694564775012186149"
        "1898836431598708185841590353804696289196689248002933137399349822865047328348427089299098885077622250958963"
        "6859120458893919968343051401887937419932084223079136151305736538298559071780881630642546065888267075810971"
        "8395204479519933205011739119072444736957550048828125"},
    {0x1.79a370e99377ap-849, chars_format::fixed, 900,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000392979515426787845600850473302891817153672436249994404115356263"
        "3585534912427028975058137822897912262984183657160412761749470512260593211414155724417537757763613607501931"
        "0696503361516265810152174500510905303383517595849911037900072190993370198713478468633737474167721686789141"
        "6881771826559067263512273201911508884068552843084392555304259015926831306644784841696265745674241479488370"
        "3454284745859365496546440420879817851523567449094063593575883610144277670625619799170002059668286123375913"
        "2217353134244980806810263516806334364273618992793185390706920126864155884828580549533789735266770585057487"
        "8205714560337746821261362129007466137409210205078125"},
    {0x1.9c56d66092450p-848, chars_format::fixed, 896,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000858179912462254527410920420918682439504774364380619835887143794"
        "0846768983603461477579537133361928488981466248817297542853053040287162959373058321187685047415890640017752"
        "4087721175565020604580279309823174920055603319599335823361360590330093225390855217522577816723076842883304"
        "2031463074232649497043267774177756998116200394900955210584580259543848489548147764788980523752020408735226"
        "3260159463187607331748523728837618007403262411653389035074149781685161401176489280819623071406746696594722"
        "6909941847494891129332497433398042956604786381467332571195428733847935092625307951380612214241116466115044"
        "845931920935999670518867787905037403106689453125"},
    {0x1.421d62e8a645dp-847, chars_format::fixed, 899,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000001340801150631603844087613354619321255286365581996464311523264841"
        "4608851460824412779274915182857333649885355057613535589004444814459107485028897497795071367868656328786520"
        "1430204637815836053277231611431919085691074217650426328138370468837893484263535010782662649184179675083299"
        "6448091584065997738570818997931555021995406746701544797903023003241856093261895712165245396792161290247215"
        "2407298980304430344846944714451589948955752543741374305143435234244962714228070337425103386522711053691324"
        "7629525335673340273427147625680436359716961143881171352463680319714642496079596901877242307398000614565457"
        "741579634388939812339458512724377214908599853515625"},
    {0x1.715254a64adb9p-846, chars_format::fixed, 898,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000003074598537137765830902878446380149229096451133149635983356099389"
        "5247133471183641249699681449552243237472526943183175593100589037207439488188256624549597810763535809834706"
        "0477106877104572904855819242902252133462944526794745733783938509454990154744011344594235513593896437941246"
        "6831551967266918677931538876399443000538108654970475785267065776206250602279624608904629574365051780485834"
        "9388973761791892305019059446288013874091013238298511526040244838541574337722601610235500443826320534848230"
        "4617941213627282753219081015230403317774960757323582469327131150941470106640207471971875407957254935630676"
        "84264279201544756148223314085043966770172119140625"},
    {0x1.f2cbd7490fd30p-845, chars_format::fixed, 893,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000008304947313449563756278337233530804082694798894791122748930560921"
        "7047398914763715260955078525106138710236649863613071683150200481577000742878690170022000140942294975068168"
        "6209887083042942769382184521970832898856698156442942703090795995625039035457501781039699343570115468839922"
        "2312002352067564686299288641194649680412519205583181163489027403101087284738784201514569777386084959733998"
        "2312872612038388001018205969465761016324883622189071362242178588791610258925279276057872913529097906000892"
        "2160938551159483058864969866471513981057877132554160010493232911031509454101705527925632329519805437285589"
        "837757837639031777143827639520168304443359375"},
    {0x1.b2aae429d3338p-844, chars_format::fixed, 893,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000014474411243713316867208977352315208912748300186833139035453984167"
        "5354753639148030452143451158399149830703468107963464265324484638353285518964551567088265107554403873137980"
        "9018957933593401684017433331167762285343818411044885533746274434524620506219125995305723357527314776166432"
        "0746690807416272077306969309532034772600245308586568934283524523440596892702417372491246648480892544416253"
        "1720822045192149514230329917332339732221913704414744084396980182542537483986194053369028249533947601013624"
        "0270103993777786054968382584849587240801028509885320895297831483040255143194596899156238644941664600889849"
        "492774963390928633089060895144939422607421875"},
    {0x1.2617611e9b255p-843, chars_format::fixed, 895,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000019586457971591684628123217698773108935833562264144584623143719864"
        "2769046938714077954561728750159436703931768778961167502825335230168197000394874158844610101174297566165868"
        "5779536007315301243905593298413366686476462468308974382408845446004492911085860270135950244988831730889623"
        "7513671350078634608114555514008370500287464166926141825676068445301167385514883698177546176927308109450223"
        "2268677049521764173824448926122463433864969518502089292929143453729778070058866366076873565593983608492151"
        "3778108439665755482693218533626126944347359338761906490029759018080945247530366860736467759639429490063485"
        "07646514678359750405434169806540012359619140625"},
    {0x1.5fdb1f3504dedp-842, chars_format::fixed, 894,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000046867153674920416790873337244849971076484220776787110409945879501"
        "5130431473931089518435134487283977625540227879888252572412233135500143521775531145980390850992942943675033"
        "0223072806424932106119128766805970197325482421531656498659115150512846925176018749355178878646041710082824"
        "0333323518242686928518304010351051540577111375092493159921425872818144761750136660331176266578771858537248"
        "8276856930054676752303283379947593630831921961798272782320798169726042997383300927368593567279231201682441"
        "7359990548829577090601763240558016590881726724432954799549383358558234672790149531275862362895256284006733"
        "5857459351888820719977957196533679962158203125"},
    {0x1.f6c7a277dca7dp-841, chars_format::fixed, 893,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000133940378498813347652150599928846785820592523114567781139740986215"
        "1397128824178273542061091712001697600489741012371831182295184552571827172752298276597827206935919744912385"
        "7583898395269720191122583914240751810857183878753080263591554001071057411515392078078462714706857877971986"
        "6139385729890801625236632339325143395897374604260863281941401282578084928262022203538186684082822846306721"
        "4889679313826047600506279372884213489373140373034023253715300471680741138472033401549031643231565079911419"
        "3247017713967342207709686373728474172788638089726541841654004537469523907692015816885749998277404037048816"
        "097012216008721452453755773603916168212890625"},
    {0x1.bb9f1504a1a57p-840, chars_format::fixed, 892,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000236361196159319544602501678692389110111543264914794309098727077939"
        "0484348136119955071672482176734551019886979338416843661814920768214468158394547246496896565295091270383161"
        "1241447972686233146646193882409497679773791432209923332782231322608377162394944996207001310887942606697919"
        "2546917085486793311364012688955744886482994983254348780963559905559411146744414418649144791101968594700661"
        "9810233218963054329841873754169720351780057245913342890720914510934494465099588466301358667734487117385222"
        "5823584447734369039655342049761605886022323077355992846419665985266463514158730746950357019311821978927275"
        "67777038100160780231817625463008880615234375"},
    {0x1.140d6862ed66dp-839, chars_format::fixed, 891,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000294161044569559372215437763981567066858876612230331361499781441954"
        "1448706988004808096826758429733606650625431153569494377252120909156008352007049354054676255691194440055586"
        "4905785390695936132032732128579822589302352293171772898936078165702938326413141740274218881721642376190515"
        "7676508150779736168275532777088051304040575758263582040463035592256867291609018569867190480778672969318048"
        "4357443084910488894820841696016046353183524828315637170466422689323272068186618987108680163778027664811007"
        "5313043248619216129989534126344633430143999664717144163669627884616897724847223975434155021793107861063194"
        "2006625738628144972608424723148345947265625"},
    {0x1.1556a20068f47p-838, chars_format::fixed, 890,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000591062884354364418329253214374392730665024773120333112469682377252"
        "7675163921479725896891521721045849840651915999551426802023426459381988765566611779796927133403617908751963"
        "5163782841485181509258153089152256288925517855260419870191548649163019649659947843445217810150977008851978"
        "7122819974311777224765773396437333629890333430241333239580022897061562662217223894230414898302276757435276"
        "0471327229523240260429752604361048901195445218743348681868283996003972638298232644555585672903656506864598"
        "1095535456295152200842278224707830617908242742977983822300734498570619115622471228714886455545532536860558"
        "157909562027043648413382470607757568359375"},
    {0x1.8a637844424c9p-837, chars_format::fixed, 889,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000001681039684855827351023579963752504954529483024994822221441109083553"
        "1380563125319563203943253866909216175104325704880448761140455703556626180185908048579022126094709857134231"
        "3927613866021217690405138818610985006226605666564755073601170473544615333948754380343036784129510016757948"
        "6103332587829562856169336508741156116699382157380027839469033864069983412553061048671602233218745036077020"
        "6194564289972002012617700416236636708103854388850007470083332807751966286065831315220704183198185446579202"
        "3538138098947494890681839362176868398994948552210918367322601204801678783889603281758643981656058000937999"
        "44427974679683757130987942218780517578125"},
    {0x1.6c58b883c43eap-836, chars_format::fixed, 887,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000003105977744955942926590067639918336253745327007984066848244101448876"
        "5656125936602920378930602673659646522508075048508831193127035440881908926520811716105080120700006784839696"
        "5880346198894113665199706590577342696924426261667259839007796752267515649057562033903373654401857533142623"
        "6187140125932174293413904931149686676806429833856465549385463707235723972546492552807531343959069361962686"
        "4606148281041428613600174497025784538263345957961162159163723866639150220568159037280157348845983734567189"
        "1293214092887485037314994884435306602798687276288545989827758369435248803257946775797031683187521866108295"
        "187647314605783321894705295562744140625"},
    {0x1.36a7fcc1cfc46p-835, chars_format::fixed, 886,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000005296557380144569072215861407688351112353233268592421471777475242604"
        "4438667279139986749437517515188177140269548537520221293766437965393848671855127178764030257644725829744125"
        "3734512519058771847953071990841730343795732793045214334729211875577158300987998323085546489474031132841511"
        "1572092561634509970907891424846710866942686459739822840866176056286334420348455397570476786496569807729858"
        "0010056954322574128346908080869265075775573926971696184685845668852822480375903592455411221140540262039171"
        "4747114614201404766504398808292555529737189414561317677517761229745780498074795405501136559553762545677832"
        "45175149886563303880393505096435546875"},
    {0x1.aa3b9d0ec1349p-834, chars_format::fixed, 886,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000014534181673457758400949055236695221048664713095250053797426519767853"
        "2370418359567919765802256363710982793213214068181046129672798657879984495167728061963953124586161238507439"
        "1567899856444888870552913909920877820552701336906544502774398188591604781018114504110735607946242802648806"
        "9547492632915209741224049382111279089343575631285032666899798293647051957896468777447945107059181546956408"
        "2406643364225160041453045884503886325221070737739693194936546919810702692652603043565212622312212995327472"
        "5326186385562319866802067425861437224035507833099242852893492970721014206630577538178233644114936440891808"
        "21143969524200656451284885406494140625"},
    {0x1.5f0344953ec57p-833, chars_format::fixed, 885,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000023938479247234097018550458511544817367739361536200950902814825089891"
        "6697102141063617998075450938596876943234520222814663334325501959922339511022417169200258138866716240572516"
        "4739032437804182998555917846877442215614673730495274627840445980495455053691946265275961590944942894884161"
        "1461861259188120954051414903760657912572990007375277218500031379100913127364874315175834774396942682472145"
        "1716012475547094198982983592160806543815234719036377453626738864303434918589623115748337487232265520789623"
        "8611312723960123566997756180723488687877637287889484740120718898355606155730862034130653610455249393190041"
        "4292357481826911680400371551513671875"},
    {0x1.783fc5ed947a7p-832, chars_format::fixed, 884,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000051319111420103700499236206263878034212106202950930977551857998220289"
        "3087476301157658778928854723620392753220523269264416102554328703892784714509871799045575377396811614393505"
        "2559887642015948609247281884462620205995816224373606402176926540883831558717591219455218087384224255737945"
        "0362641034548328645419826016816415049541718987656545856396071620261775045714406002201539977040442012225019"
        "1866657902531789248571633199703390242215773002375760167632603757343376191928042229339921704578692579360050"
        "5258815288522892074750831437217541465231243409180954321670387197333315664529506371145190073701706340823791"
        "574479173505096696317195892333984375"},
    {0x1.40710848cf107p-831, chars_format::fixed, 883,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000087414290750552295546310067304417538089998764617839404299068353704815"
        "3973431496755091359582283788293865850167188491498788205872086312288388767426146999394659547867198614986995"
        "4816609712059288233084778805421966138944275623574987168431568745304364621669241457008033758230714634333799"
        "1592083834801689901610784799867313772745020111854169849030780011055234667752217741062441145534653890585011"
        "1542451572988081998398568760735245436792821070637754721727631828680882026195550243758494821815186708842256"
        "7688814649449787897410550246752339391004334032122197024739335375916004769854676164688893706639316550852103"
        "48232749311137013137340545654296875"},
    {0x1.7d709da2908a6p-830, chars_format::fixed, 881,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000208108471524715562544013112320321887284472671173601757178916367556203"
        "4816765950484069543464753999344218966790668885556434954834640963848940274729780129572762106340724642693902"
        "9786182553238600216092848007235486599438797324606821503856913038248008966124526622808102991511627825050653"
        "1620131328768788774416189409345842116105132834135665161161595260229308676173768012552965491894777272036025"
        "9548131643864589751988643147070399821513779604354178902911542059198107738793838794825326292221503233637576"
        "1945435619458551867191958141096359616331249245416003787574812480465286687861085268674943439588960990282995"
        "311417835182510316371917724609375"},
    {0x1.3e0695064ed8cp-829, chars_format::fixed, 879,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000347021084000003477661750638308435237703537786182613813497780469128403"
        "3800891212333097988673493814013195364736504043808795941139087383925791711802331911838123827244326417953056"
        "2987277498363862206367235087609457123364999532402518556467052918877611333615959586607430637653297312728824"
        "7902939061241640291917731532433047898179063141000213102075810097903504213286609944131302895449794218020720"
        "0515744500844214749161058296204205458513208863139333891611154059887707939231034083780526190117163341860564"
        "3821485787007800553672720106766199578579046645128658813737482362534833983786485618496649899580083070693703"
        "4619841142557561397552490234375"},
    {0x1.5db5937ba8bdap-828, chars_format::fixed, 879,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000763186683615215970249210329411639121958430473608075726338558440631231"
        "3745307865574620244170078956471117970699169233373895272809046711033266481008823220114800551436505352505370"
        "1726138003728938116561908360251526317062627691311639965366997406572972581514278704760720055185381569864530"
        "6038608189906570895957396970022694630297199287577363770666847839714573712843375560213839416213729895094635"
        "2337338739362742305387139962103296257360220339421554482680435146681018012505959237765754657839926762185576"
        "0941857622196237041917083920770423819460543969188363546830630364948483303305050991006227235002260661511641"
        "6151067824102938175201416015625"},
    {0x1.6ac6715436880p-827, chars_format::fixed, 872,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000001583401933761789567352980256702295776633737919891851108550810304511052"
        "8907733717602402102884849998115672191187006109820501000606499411634194787087402593470868198920066841575310"
        "5577412001082854515786066821742485680145606254835768934161958790138488402376485406693577403584709083018706"
        "5881058547524256867923951849842211943227607911293126792083385341593121354167764813470369005376574416808641"
        "1452423513659991329474857843477918188270714321800366826427248381640323472424199547164205151630092903849126"
        "7945868500721886688596381791055070199667412232286926092094960561657785392136164166225682260746854268518291"
        "064538061618804931640625"},
    {0x1.3c3b00b563094p-826, chars_format::fixed, 876,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000002760497402953147075537995895520339372419594994205759124447381524691241"
        "3391595013067101010555177517397100426985139428091311014234980202789586468665938033192658135488171299928713"
        "4480758847780103851594645801982342979064180714871976769825179650409272513476073933353388956892321072235149"
        "0145615126375166980861819231195004556950502697414714017369780865967942852167342748113218698557693272953814"
        "8337201682004999096184931755553173054112814485123238132174498935401641579922957354412202193532663584112586"
        "9650200213049730204055454487099841334754419372624073886119824036392206103519085784231235178743518732247252"
        "9558581300079822540283203125"},
    {0x1.0a0ff03dc7b93p-825, chars_format::fixed, 877,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000004645119455324602227217342591024880784218971739856490542099890215958775"
        "4760551012912411892518528475138617823127607714941375176711195036461654593756557922664803433514884132688607"
        "8901110074148150025254392503526305529037021655810570930625531946792188492433413938849159577969097106271760"
        "8281675484211415461117818876639956161981328934681719894959830501408247531638575392360372050583551619962632"
        "4546859661234530477365388955308858864327508806609889314792645398167383551277259549976575383096677175116552"
        "8157351625613694857586869049470850208882843077237683524983690606425331086854496209355161543677267821372822"
        "70923606120049953460693359375"},
    {0x1.1c1859cd75eacp-824, chars_format::fixed, 874,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000009919902000696459127729350966514811417573806821829972221617168476186071"
        "5405043509729734134051835419456145780406172178277413161498636992137303800662181445156443401801518547889441"
        "8237919900549658925539440736238657233268937358693318097865972191480701130015141892197164286134518013372308"
        "8014278380959822191416998871835413481622998929188674249549886989606473985007047872466741235759782391044188"
        "7617574862626088827907557313143938169737105103111386182522107665148933770898445415333007078802205277104248"
        "4812220901567775296839230012789253525767435152435751596777091235983885421322055696388453631048842673578747"
        "05339781939983367919921875"},
    {0x1.6a30b52edc7dap-823, chars_format::fixed, 874,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000025293584256227206734436690448860438863560423322197287673071289227707969"
        "2204821068839754613660527696056655673032934775744927789366034483299943037941202054718946505243272833507365"
        "6294192008200028049831581799772717571671721074991839534481385737708488066272572252571245350667982202726521"
        "0178115522857672390870362759424441473374843557581613823597887118702404883540266812295744444400774717845528"
        "2919057421350105555224402231830887206967806285670112170221507665071279926429611065289317694700042420246011"
        "5896441210858370550884234428874411423922321243546304888443672800252136308686251480799838569149540212777083"
        "07025022804737091064453125"},
    {0x1.ed57ca0b1796fp-822, chars_format::fixed, 874,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000068905280466167352632776620072267895607425419562720887072786636113143019"
        "9870943435827924716622928660764729397730215669170795196785528888685159578923864553514694529384313751243344"
        "6001234126433512271726045295786596372096141206042297685159845546380806896152212520111951628197619447822423"
        "2356890637934720581112260679636734550174591142037230254783839132641626802370354491366421432128406243347719"
        "9095122086565542807986691910549101079454291551252805162525706181057897779052882188595582910816002410243781"
        "1130608445012373884007387134467228753085378611852319995467861412812368477963781865718674362816797973607663"
        "15250657498836517333984375"},
    {0x1.64e9ee7dcbf58p-821, chars_format::fixed, 870,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000099700406511611006380450058410122703902067520359419945795899511825630118"
        "5979588665807563367554229093351299347926878163027036020163695376425344287053227483975642933460875671431629"
        "5964916659136608035440694664907508699970961003572985859670160028279294993823700602311639161464638127681204"
        "3618961458485036245110046968814655838036376921871076322233996810721470996621854701276918380162974677430101"
        "5743591908967152567417961150919091220856185361682832504647890500198973106127845308319244621499182967427340"
        "3163862076315431601670227511616193753920134610833738402335980235514144062926662492342671367806516968812502"
        "4549663066864013671875"},
    {0x1.7342806f62711p-820, chars_format::fixed, 872,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000207415632006523025196785164169174906373195371036682529872752233681456273"
        "3196900633406750711502066586090349737651414619121929946067878998595023137607518164790410230208118160529480"
        "0804998156206074746766028222000936477101839893892279418571282614867927137837132859625536123440643270119148"
        "9441868242216727044385209820679912278477826246793595959500243660563151818027771380841832693640445456188727"
        "8313580962716953304739999657551660090606873802274979700164372578814557790179804100883390247924759915758121"
        "8354034260716438236027409958770086933482837896691685792186827022522786412573603601400469044480079361392199"
        "643887579441070556640625"},
    {0x1.a34800bb3cdccp-819, chars_format::fixed, 869,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000468488612389678255239194355235351386695688755917216939524974794469609688"
        "9275440032086587785713772492575863764663121769661013949840449013072081217002421796823094420634858798663255"
        "2959791163397391150480078590960800464210482358554447476008071375720055732864784273664972611655480106836126"
        "9837670010346006730604863637259213240596606427214002032758068677779471237557757686057729819749443611671579"
        "4435286740615955354035910308168210866360531162725448806722244300846882708100059764808580923393744064725832"
        "5851165337021124565517153553017134868475375552171532363258796791949094141543712314728307999356360369347385"
        "130822658538818359375"},
    {0x1.5d9ceac385ab3p-818, chars_format::fixed, 870,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000781287905611796892616054701198621930179850698389670255302610875879330551"
        "7195870978404841713188396988128923287974065721352393075122418551066596657853413338080275298916399348535473"
        "4716419110408496130853247928578492241422252260407857242364437935491592841104553623523092855818553312582819"
        "1829721220074489940780549879604172402236060303546333769974476684124086874201422786888039344734163906666723"
        "7163433456130097453860186207032859848044188224565027108655355814594743568647730686615345405439108736657707"
        "4550292968661472642896014039432295935975217238894856607067629281705112580687453385688400614439430569291289"
        "4301116466522216796875"},
    {0x1.0397aff005f16p-817, chars_format::fixed, 868,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000001160234474150790106260993366340033268803447790605933689662507526818550332"
        "1277861155577877309099200703570062871759815522881113374815935124759215572993917116224795133831483509297677"
        "1138161453964800725190495041903503011599886137368592773546799877499394285923288865121706060353889213509561"
        "5587837214035061210211423585850725498665816904041609397518302995764306023305238497902488967898868020342043"
        "6124343358353115842501466575805640352097289296560418368734678913228931200939437087788159961581465910047408"
        "2740931232740166655750873897827114152724275883362810669863886485081705058400004603553698490081558247766224"
        "66742992401123046875"},
    {0x1.260e422cd6d4ap-816, chars_format::fixed, 867,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000002628531409965365417628087574323361253955646116821732150719166651258384954"
        "3277500473619693088454262930856098098303948802604312284693797178542387164814895571426387662670835577249199"
        "4903748165606956838961840921237500709335045772958175552098917642465249285524387246225899102999109671601637"
        "1967122853936092377692113114869321697491090963580363241607614052143040540849433109843155710931555560972302"
        "8171644630679617395772994661804039589896223778792770293045849647466844098260212735564789473032006673525509"
        "8153627327592205560893738901018096050788253487773847190576048032007569109788886840915062004242486182192806"
        "1544895172119140625"},
    {0x1.95518b86155dap-815, chars_format::fixed, 866,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000007246195267114579930868294227361324279094210499485281620797358795463778440"
        "0200604552323859641436019959259805541627524381368324353088153031282671758700037764963692127107204873182521"
        "2743492857367125402295389748557776900998860749951689485541996761789107821514105364483876233240855209145929"
        "8218235738836401360617336568712397283800737931493553531144933215030036527214207242191050786592724667324735"
        "1952415023600273667576940226363301653096492037705698968488662811198909785131615586198786918782826768903042"
        "9662476215473756935600868637399013945524368611538824872280748159378906498225093109517847000944357205298729"
        "240894317626953125"},
    {0x1.a74e934210e34p-814, chars_format::fixed, 864,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000015135575793727129243415548881706639972764602138477489832613301661125525653"
        "2612911904572526460038796615464064557235535184255428202266594734780713103215069500727504595579802054769661"
        "2801995938419088226231544388528865167219048211633614353037959605771745618174998999740314969772733593311483"
        "2527948799345913493919240241391196084831250696806847449720365426721059694382001837632545128601846310630150"
        "4920946287872817633761992078128830310281174844229789408905630908727536976405794432973052507474674698762818"
        "0025979766467714496165151706491323570471217184103207185438466801337976788369859854760379747062870592344552"
        "2785186767578125"},
    {0x1.33f5e315efac6p-813, chars_format::fixed, 864,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000022022598987138437754955088140950822414079425891031517825754706103180380894"
        "0293348910079770489697857931874563628273401003849229027947643460709548320874194553229940197985486063866961"
        "4670798818301319562023515413554567537809101283096834013388339700196877232995665517358526772416380714017470"
        "1636546412036673472967391348409845462268627991297391371820917998165639554697550184147146843309056835791578"
        "1915959205034872994262578079066845040859907941076591375398817610400020832219000691738654346851177693702055"
        "9250785009302119656957292836180468192898176572067138287748962619724641134653735346365932556977895728778094"
        "0532684326171875"},
    {0x1.218a6c088e0b7p-812, chars_format::fixed, 864,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000041410759136055035697554355612523273349805779575443516024484433325588504826"
        "1735011062749061211793783227645942484379691318093841368847098623863226362751057949455437358357281291709007"
        "8198520957288184777281421438777970618618828499284120946242604063906544270123754851472649535798272106982211"
        "0373058304439515386219384052728954163702265368813309267001173474115003096471620752013064126070402182426851"
        "8292725366826052714592611208714273261395627080752743556294388041183383938489151395241871318175793857142069"
        "8036025142557591950993581068293892594140396122869258664699108811249834168694212207378901879906152316834777"
        "5936126708984375"},
    {0x1.666ace219c563p-811, chars_format::fixed, 863,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000102523259087347841878984078463121696629339644516172061356190578703615061771"
        "8363325006003067828838099295381539103507207744202525643700611524672299844933001035613433505064997893247944"
        "6718573249396209486279921427132204348932797990345068549826491701491034444775051745415504201857190579925928"
        "7265901681337746621347007671816715879281848289288553201291490150946851111594352688143654351462331802805120"
        "7569954102646295942779533234962168490646675608744310157317163502352340937966413998580071972072654694838719"
        "6241181227689049097325035710943740918313124555298228499379304666253435895481214111535361865890081389807164"
        "669036865234375"},
    {0x1.66ca7625d6faap-810, chars_format::fixed, 861,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000205260283483150922693264914914166716147172748441715521997713402871496297517"
        "1049035381782547160052232774227698485667471867245925706032627831596226796183758396050199760459851947025984"
        "9409329879045372962938698464806900368765191920874766137506415209946969599155078126723825585946353211592780"
        "6587691429534082605687544159260014136145889373788274085623000250963914920394540512835289286025901533921535"
        "5673194397338372708285535055693381899508696665501113683684770786168217064751366954802701707958201691744906"
        "2503148987762376061836645458296711633615697144291896185639468699244637946469630579438003792347444687038660"
        "0494384765625"},
    {0x1.56e3bc6c4d17bp-809, chars_format::fixed, 861,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000392326684132539341095763155233754108248276350060145324785663767954357616607"
        "1328111203385529055820908854409551186443084919373917067982109478797832735088299408640774255550297436654337"
        "9644802654288179252370784552939288880406467952263662138254115806400058113472923135087350620948486311284499"
        "7882375442919052776890269477778849002172473111965967140464422965683565799664797786827073947990240854919101"
        "8791857386839430814658014354114909166773527884807665163068492284062280504681162738206750305934487612711077"
        "9812803960550043866289394345654678389071255841372420349853289748419105595898023070011717550187313463538885"
        "1165771484375"},
    {0x1.4b39b2c87742ep-808, chars_format::fixed, 859,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000757961507355959685182389831074838390700031429559869743115819166802257914534"
        "8683370076416288747863020785670478229418594802605843659633218761991003725554393124746818759551343919858321"
        "9037956780023842622026723484236112396230465459969884409244325262106978179826169749752573222068433030816685"
        "3319074233042814560568218562357326702621223793698055245872947263256533504098315178943480044679282326507455"
        "3050656043056416296959360170882045939731413452970282373048701017908669290277725775612223691751332374494642"
        "2143099920831121603313971394256177189429143638913836328456803834641060537520226847441051631903974339365959"
        "16748046875"},
    {0x1.be40d1e238ed5p-807, chars_format::fixed, 859,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000002042372149921196110956852553467144364774045122558957777677661535082492418590"
        "2447511045534069936905640957606537200670668241598816941076161810442082354034465365585049545316189811674090"
        "9085283322163797816690426713928058838659146977561179355890960777956883768691351789892769651237357201604810"
        "2090271465196837631021566949809345877871341713514137474605812629688134747242268026711001133906623627505611"
        "0971927834750821976896185521894260300273463567943024440052209000198482863479912953156904928607571710364397"
        "2525011916090411511711638026757892492384201068375355062528660761690834686424636523760511863656574860215187"
        "07275390625"},
    {0x1.40ae59ac6132dp-806, chars_format::fixed, 858,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000002935329331483333385498510273320152179625003615741057817445818197494168142790"
        "1748305530776598182206753889861863637101626780047066935764018072155601016400421464552029813635340871920828"
        "6540502372077707795876864389123453098703947018487275042747888356091864668435050513072283786301499972787555"
        "5215685304086401604276801173120313979019406684421427336942605765312807547951367072021783814225922804651957"
        "3053627935149750677307039941356482814713297285599712220196545670395402241262550735056162451065557414323405"
        "2851884708200203074614546619619936183020853254555093160706089018728675015413448479151270475995261222124099"
        "7314453125"},
    {0x1.5c161d88eecbcp-805, chars_format::fixed, 855,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000006372363858570045164279555957051067914809499361391032495229017309283858883126"
        "7228266631303318254630028045739040718717806151057630003575437223382249922228296120345672094131497663649713"
        "8825053868512001918319562376117850312216681982942556631070811232763283968776586654217551364407764863206039"
        "5171310907363823836647106858223277741268017668931344738686611225086630704022117450770311448359851054010344"
        "7645068390784004440801839078883719477888542923897825206398740323615820485633543592686389160458875278305783"
        "2428086623507826775024249195807395571626534947115790181112136753703741303550556196455545432399958372116088"
        "8671875"},
    {0x1.ae3b20e6233fcp-804, chars_format::fixed, 854,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000015752344142353219450694189702451991296910433408430789019004125131863629296511"
        "4311542306595038907176200315901038316721233788818826571623317203349289987417121376686501945841032567911901"
        "2505526989607932653962459605347373167055651820451912046546618888153412645242490087251350087576649187699383"
        "0106389822694180825408845628327750244082466163980074438483304220415007922943039390750698179386470176966033"
        "7112702767082883519285744806346620427578497508169144643312340209721649688496292864219377630628268116030388"
        "7520665708430256415338137506661505153630440989474460324611066529306552773392890998138682334683835506439208"
        "984375"},
    {0x1.c895736ef62c5p-803, chars_format::fixed, 855,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000033434436478293493280593571271178008379632079500385975548283939163497852214879"
        "0448445176707594970914929266046301395881911376324184025424812370739165394698174516004668202850196235934904"
        "4500920058349166573528858544956797122849756889458856656030089637540017312018075458430375030356712402369619"
        "5171762939647965970281076927336877655770322576324057362054878847600831468525556287002358878533444200008041"
        "7182360569694778279347726566779815145097506338920779765572188303868670858298304546602128519970722727663497"
        "0189720245583840332320063960238821736133336803065883544325328102972112818275229884079635667148977518081665"
        "0390625"},
    {0x1.630761913b642p-802, chars_format::fixed, 853,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000051995664937001350863664258209506916125612045887421035495539968219921552001490"
        "4045126665970571265114347528813007435581863058379511824026420279450528771594711743194984119825629737962368"
        "9753316518168622232637649073298959845059152436168274836787886410245541432791484117122823236508634176085889"
        "5925134098498692005651547668872239050279254533707915364965481634484943025853564537256019007487191319787066"
        "4373018730201713610922019398386184775914931861779759491034394263205676462386582564671334894431929147821752"
        "4385991080034029146579204618992264661730418092258037341593617653687274884899416349526291014626622200012207"
        "03125"},
    {0x1.8907b557208b7p-801, chars_format::fixed, 853,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000115122266583557494838479816079037491869684562714706684229055149680486828625505"
        "8796458842284516181576719673471613817362866823301977849457479564381865329613399427500201855688873879142642"
        "7335191075994556321425506668463677430938992260094122782147467504278812098597434190907723040329777871259253"
        "3880266541524285722608449816430831021518435036130403690642361921851294669994972412565410678626010255736322"
        "9481670642614150662832046947746967360569276734749642475323944536173037037021708328999399961193013811652519"
        "1726635449611654545777445394508955230403436092920083704210609483654546500441817613591410918161273002624511"
        "71875"},
    {0x1.0954ea214daecp-800, chars_format::fixed, 850,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000155436367745616369749843612181110118157874961159881252517615127457992032391145"
        "7023153031158762892959294137625850420107270440168478704645026759363769681184230190786395976567038018780134"
        "8372271029157026219134768483368052056690439268533777009988060893597801037112972580440307515231250113286653"
        "1784589848540323576235046792761341567879445491740685965407708948988769245421066466376556710384056647230345"
        "5745447620744679132024829071450081674006838972988367188884108104737049840838885337987296921979337482709916"
        "3647280629935841825048177410947717584898643244153371511285382388809980791499754104734165593981742858886718"
        "75"},
    {0x1.5c2fe731927e6p-799, chars_format::fixed, 850,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000407949309945749494425253160754934363624554730926844389979349861354376544669413"
        "3273976895637787747339760713440649581560845325794100875391063273453728186643522471972773614713700301177847"
        "8961898320792492765145068771147703565746082901233584519734866693216924923323985431318931739634995484782340"
        "8099297662072926409251426679384195381957872607914527115566407673022695321287430486021579104796335660882445"
        "9478793671211948274702724136559074011196819859825079215570247071425975730487942082183311410950781004256077"
        "3185128340262169124703929283421156748056103332106440284086201736963792074952550592570332810282707214355468"
        "75"},
    {0x1.6ae6c51c6cf43p-798, chars_format::fixed, 850,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000850378345450284397265111739703870653764954518012213587455414660221110552794478"
        "1436847646569250153389780805284146206065382019591751710733514433667516784023869511295085720936858126749712"
        "2657568220147023957497250691091289435446773603751461789416055560870495170098169210699402960762896169760174"
        "4534558920220401921577220435163110087575526258994364542988920973463193672043139556104124355129532376738670"
        "9839198875183729692636944707657278930317739103339487124899124826072841078946429617996885861361489855103899"
        "1265610597067390263892574347297208384005668413929906135659085299150980463700477685051737353205680847167968"
        "75"},
    {0x1.ac4e86c315850p-797, chars_format::fixed, 845,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000002007282059547957321616912623139440883855192261998987478687165819964773269703476"
        "2028792666015861804714982292219159115495529137800501558783955553148061206323583534701281077232750185616658"
        "8209464579572448604508899906177218722368485516244242417571146377270527918098212641631803107437230286556012"
        "8825632323317889694497843360775408580857259092497863394524723040311278730203262601562060541513604453034882"
        "5415809501368263327044824152414594545569962369609544152106912922650934411810223780925102998679548866177843"
        "7540002054621660753197441908343343400344601261991557764803617049109707437537508667446672916412353515625"},
    {0x1.794bdcb1e5858p-796, chars_format::fixed, 845,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000003536438208901197998089710968716525488669684152098125444655612595655697829432108"
        "2019870841710940758511838532489417943905736435746115951713790347474465462971745337544820877439873033371186"
        "2007633962738258032417741380068532111539307826414036222432582407066643734419136993944321749222199366860571"
        "6208990694526263949725175127253153391301107011881575144862324406302148146062287775652420158281351048772455"
        "8551743402584791531847833324394767751212559672612147109528806384219695184783904856874579756560539783035465"
        "9437463682786127174530399653052185980142212749148863110471344671503768353204577579163014888763427734375"},
    {0x1.d14f7ef9a1bacp-795, chars_format::fixed, 845,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000008722809014595793534724831854774230258708710231328550144251403552622630667455584"
        "8729098848343284853736028606487383125492860996732221717787417179695557893446531314740287886503942082756517"
        "6878567927435477084189200595780684764659910944290667814669512958140664350424682323927138148558204675353147"
        "1862258384352222573375498842616906800204400210522386811845621446994346351424286732439555874291154078060218"
        "9115030142752959592996857877227304052880736262738027290210660571731655711256049169304129861923207797896858"
        "6186803325882819783307168556881297598817001041704706994464233425767840657272245152853429317474365234375"},
    {0x1.6eb9675837dcfp-794, chars_format::fixed, 846,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000013749379101340066083857337348176012879302998942040643891959413447462809923213710"
        "7923859209133670605866208605258647049621760492047179451844836572119347356991890024090747092362463756927276"
        "2847379370874635318426406858110822716901060321069319180330630095350071198454014017603381215347279543191075"
        "7698492719414722328945092304179731068530834521111061163476202640787726787899152301887532484498175670012280"
        "6053953717458149970358111047972034718728424120220308910285188823533296077514778262102253723563125528563041"
        "14332462945475323168054283191572629933059608724961728922265061757224113847541957511566579341888427734375"},
    {0x1.96e8a42e0e289p-793, chars_format::fixed, 845,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000030511988184972799383071211924634487175460180935326054116102185981586408321039421"
        "2669807093524175183158874045050170880613243376562389933452426086185695180699312804245142060569472810956533"
        "4572370334968164571962533878125149465944408270649637103835598442140509946028942888834087818054913127959283"
        "0979111230155766921910856068568283496852317230749669582281777159547977023790389787193331339347536950378181"
        "4634341296303969712079941349950377993759212633121226292844763708145719324648259205908825462198868419797842"
        "3767700179485155530528570647693354807915784314898721093603267857929939310679401387460529804229736328125"},
    {0x1.9df5b8438b263p-792, chars_format::fixed, 844,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000062081425746751335610146680295435101859461655681989036586327775217238749061303501"
        "7353323713829002805755157194020730148118435599036452088715313932099113134973129083783128920389682715075150"
        "5751447312031222220017832949424406905553795591369611573268431281518228057618249401975945890243492974663368"
        "9945528960237823817825539165337044719128567721394744671262149404471486748537392698331767276580429963086090"
        "2353138272962413113555038517755830887058852014800933522702452536975068231984788501210512796491195164930952"
        "739801311157528383120640408842401705946246458190149534645571431645816318223296548239886760711669921875"},
    {0x1.fb32cf0b36aecp-791, chars_format::fixed, 841,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000152128786415558027249508460865161450323003269986911909002923017356190314057552633"
        "8086781944551107256257294332875937033885350270044302018784621809744448807229376800166043171230470979247077"
        "7186115661830616632898880741734246107725420264835065954468139450169209357408246924208083777284462849880550"
        "4339775671742741877846696047649844165106895821713004468111309546238119818657398265896079248483073162796078"
        "4313379336537148325565729100673397232328082703744278459276106826127533120342240662852596857525177657403125"
        "501719700324721350369868638181213742553728087480359007130879811509061028118594549596309661865234375"},
    {0x1.a45aba26ad06dp-790, chars_format::fixed, 842,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000252161663518464109045988041265039199759602063414215566806731221394308396188930687"
        "7895352865071445289971934552461081251587394827416804758179858983102808612721778326780698686015680956862173"
        "7987604680316201070811263080236047160654596302778345901333565993595911750825409982925725699277443676955122"
        "3261805451237266910905932922787342896975680866822288201124281755325063402837770633220119310559118757519818"
        "7287184221450436040247100286697114970765495289023647586135740814347953444228162789526700205662670272193162"
        "2541693936500695871379949066388752655501946377532357382246670784997633063539979048073291778564453125"},
    {0x1.76eeea7b33d9bp-789, chars_format::fixed, 841,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000449828978835193123497002578520742852428393384058916236160752448670239424680177924"
        "5582632820621839309957978885381833266783882815436988386959011380163998921014626575641453243971748047954427"
        "0207626471757268578659669983092065941174603904921505077310135491395913225884586303728461812512986449627782"
        "6918043851977788258575236620616478336823085136602585312742180909430348411109930204770908499349190022788555"
        "7798282272888791052050805713091213003012308739061423106369221258417858013955079753813197763552984657907220"
        "444177753024394698564843952193959423860928797599218080852621903797938784919097088277339935302734375"},
    {0x1.2f72b0932e6c0p-788, chars_format::fixed, 834,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000728128014416453039664187325228606052344467815817011629518747024454216250146978732"
        "5772110024713328093333754746328221475697303727345561926510751935093640686385450454336346624796049720140323"
        "0462511871226478475386233042407011469985152131558951126999263252254878031683189821228867935507876544121147"
        "1113526006554815875416381462677921753000759728803205318158423248903343928149265950091280712114337761219505"
        "9168237794781205290847875237820453998789574995457953460635879854777311114798495215561348833515894505972328"
        "37336115964779975403775359793941134875836977710206014691163289853648166172206401824951171875"},
    {0x1.a51a411cbcd83p-787, chars_format::fixed, 839,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000002020883717144889583731818090325921472592220756822795901210867759968804953074302394"
        "1864936723736235817948008261140342779894654766198813974216962059622039149375372207140382159277201024253418"
        "6589497286966518076494362067842073632190771066191155689438185010834650626563031976791391939903019143196511"
        "0937831030511219504532874058646614651291777315833865631911866390659568658853764893684303164709342765736368"
        "3641219540298646042122056831742657703852094032730167092498886612777005716954892482974151250256729385145281"
        "8399420681877823748179849398737440333262050279769937353134545698907231781049631536006927490234375"},
    {0x1.b808810bff5aep-786, chars_format::fixed, 837,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000004223465066821442335027908171814301805291882884523327851200879145198730568559459114"
        "5976330970127359480860248854891726431558443351245555468482610003496561352434651925296169879290047618996071"
        "8557697298950778181410013964022802609558487181028968350823979446899678698771936631524277718499825579930692"
        "0272281717213927883238578820306538666423915251678987176917078960923994189243430557545188066401361332022631"
        "3501911783489649376683084871481472461594614907247440858246857575468466973071241319175342027247791966720048"
        "49726317886095361299522392188637733793856554789030127543270065615388375590555369853973388671875"},
    {0x1.a522225f95f46p-785, chars_format::fixed, 836,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000008084125743595664567854740546374794103525453249129066529147690275534203562099912191"
        "5876359426286744536442548879145579602755273295208707182241809884602210363950548931232190091262986853262347"
        "5135095009363265921031875187107902161141133274103377527040889370197718524615464087385253601309126961531718"
        "9935301688316595497628363205247404911760487729038729048937905227196481048751169063611695982960154326059498"
        "8729338797802211604439634988154451173709514406892911690109024301612727090904032911743576303129133173491689"
        "7008832721886597106496144499841505379496532267678712661840290110148998792283236980438232421875"},
    {0x1.b3dbd2256d4fap-784, chars_format::fixed, 835,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000016733590187416606942028788295822734147043087946233607968651016945006043063743409956"
        "9829226051651502624936952359551337435141043924366256262954714703084104196403532472922571050719624290744697"
        "8582396884194042035207547557916850717553492842057781744688693737608928952458431646709318550288396484391157"
        "7762794840043702122977622085741279270737213198962173572325958013463853117760877665013868039714619089151048"
        "3936959754580000980633446858750098421368476749851793586866701372231665192694279106769119933450898417201549"
        "643514656077765935283060136103656512062492185832101622422474207496634335257112979888916015625"},
    {0x1.6578a562dfd81p-783, chars_format::fixed, 835,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000027448244739455369599852949492552923507948333818208197008468158129083810159695483256"
        "3602691754150154664120314225695400387005807802038517353586335988207343902959393348397621769684884913575361"
        "7230521444125453235251012843207362623477900893247213636680781392280455803632115282785593332780520340251878"
        "2556286556328386905117998586350085644107340826449520555370615285390114023939058381308345313892978294651712"
        "1080110383876637670106173438419253507596733224476414075014265345891995296496120856593048414341827141680276"
        "415523884377632032961134065066676791255166649173319499965817414022239972837269306182861328125"},
    {0x1.c375b704d8354p-782, chars_format::fixed, 832,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000069330212812845955601973051705409859820189947914406991516234621867700438780635584678"
        "6422452402293772645156697338726349371873983367424350097381613788724747210201244748437625890393184241908098"
        "3548934581879151041193417684465460693231943222252870968475205589194276287015578056177004092191366508966567"
        "6503348144898858484909426122870870673228226689067501074893767746717599791972139895758896137999486120056433"
        "3509007908515664863917534010543666617786469916707237836024118874742072934775462928779342329475149180326686"
        "989774048800335725396492694612182396772755548224227706288758099617552943527698516845703125"},
    {0x1.41ed65ec296ccp-781, chars_format::fixed, 831,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000098876088484049352922774021202980270628015087562012427292778038682091273168220811432"
        "0336162897601090023104023704996008069111083741196140661388861826358577996302406407082910484532702903501127"
        "3046501315182391724708342834373731353510858807009428849017497972201623850366494027130268394546556252337263"
        "9220888897028444197595899063387263573871573732612758260782869758009494263629328008981472261588690396371322"
        "0175723695858462099026339510542868187895386861625212297072254733429651534552220213138019454443987615077904"
        "49963348399628134274149711127064592991748928608140845053497969274758361279964447021484375"},
    {0x1.2750c8cb09651p-780, chars_format::fixed, 832,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000181405208663755975928171401731983284561534710865154438919473014190674270163498146632"
        "5264328182775378221400043060725800937244923408999789410546799241994708361732797013064162048498558045662932"
        "3170804836375424666568971327738513769501374817304064961379303679402983078229591849296911571492481719626897"
        "0748424091370987864524876515161709281756916094605784025688182377979979672590895711517738600663244505115355"
        "6989518300004374198462856061146613925239488684555318551006250185081535696799617385213871147992274592745652"
        "135539672861870128479085175141572936063038323285280528640583952437737025320529937744140625"},
    {0x1.19ea333f13ef5p-779, chars_format::fixed, 831,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000346346941664058856997226659961568191908353051579393790822304311131985848144061421594"
        "8950670924303810991380480870918391562773396968168321180155700058682912089873920922417568865509996831765897"
        "5778618460070823329599291047486172481627379552579203424485131687705351828914558936751977084970788723665164"
        "6911633446061837481566262159959714724571419648768314999022617018062933732568358168026213901853555115664060"
        "9221578327596539256658584427377168271165435763538417856513893401175314602355933911012032764195989159737458"
        "24201798081334576050870430956021545159155021671205931799164545736857689917087554931640625"},
    {0x1.a38c43ff3364dp-778, chars_format::fixed, 830,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000001030872543605267300407826553584936284294146260376706800905581732833516551899440193317"
        "2454910493217867696432184596271668631487447065193359138589446927491863106418507505948623568420731561025482"
        "1040680581793107781394674696062574897434560726357391482064362738944257244665590825631465273733333620756675"
        "6390293322256348701247931456511785821238511159745172815626529220869590250040233626257266765566180638817589"
        "0193990786445710715532644427065621287497880140069704688156339008987222694650154503308016083770941603769316"
        "7240629952771552441667361465182176428352680002016594773550650643301196396350860595703125"},
    {0x1.0b0ad1b956d83p-777, chars_format::fixed, 829,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000001312300828090958506009473976947437846053886610704839212982469612660651627920597254767"
        "0492262550710764284363323435464168252607282504216121550058386417219638918387595741601006739821592204253433"
        "0073715044124724096640674063033718326013719516858787658082444313471097692400701790150424536692057033364955"
        "2524608892742277095894257969637967157676697955870966040512564362083751427239069866417018956638131113889721"
        "3106203693198480966230974668304648108481706583483004968448046454807759853953231524663460193768051528285130"
        "784630367073426811242164361861337955626193876000618043775602927780710160732269287109375"},
    {0x1.8a159b1e99b88p-776, chars_format::fixed, 825,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000003873224237815389731809748518635096030003118658465656286300637347620601152368226255781"
        "1183503862971612833114691641746125502072880341115574094325771751109269324097178608013529608749513409124237"
        "5838374168505261130380049259816672308978233967422627780162897268815289721857818949348917033129574756053525"
        "2056117984854618682523930513157192437314654228741856799035434401631043720518455898366052956161532089876252"
        "7140916102609030211008210383276559453108001243028592320154717229013144171564493874024049142539487772727966"
        "16343751153961765872340989930831780784230462810757700253816437907516956329345703125"},
    {0x1.d415deff614c1p-775, chars_format::fixed, 827,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000009201073964781300008541100556872710599879906689903744896530267513577688481665481962817"
        "3659937259171048554565929979214712659389623130600333190907794838391075515187831400099110511118637642668704"
        "7583016174605352766814853433181824629824581606810599704853693183609434375216004542753155148207986606803773"
        "2986220746545492963890123827116289570377787445870908948449086008729201361201082428590604112666257592229022"
        "3290517197672726442811029075924386055866495721558512948039413487672903898945678035746290351193063272360450"
        "4410411901707601194771524410246628913870770190286396683632119675166904926300048828125"},
    {0x1.310bd967f9a00p-774, chars_format::fixed, 817,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000011992483584063613937396382002898619029819538686188191051376468587418398044923819788257"
        "9818103124509702374293152236901426529753933885926217522939375787436168025095420854421089105328643012783084"
        "1934457751785326270193002021288587642607408488965662669916337673223002264510994634236841840933737724623832"
        "0165532369920286784015079222380268705401143575325058869567756026714067386945351235295748404808174268116051"
        "7935100483419861018435189240188373810482122213082644041469933620211270257379648322982766563842384538563467"
        "443736569589192277871478824920734897185869982649819576181471347808837890625"},
    {0x1.2a478a0b632c4p-773, chars_format::fixed, 823,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000023452909097606002102998388857387398320146582515932569159622941748507502071602816219003"
        "8577919142927662102871282920701702839101779318975472524788417303881315933266593759151136812057701602281728"
        "9081182864226530689812976721417530770069277611318604358776733743161458118453496278452601803441503553632201"
        "7474518992277328792793939383070761065446832297352683219271773789038387084150729566669981216349132935276369"
        "3592948219303919368730207897372104156558695370518639326240457297236641350456607151007096954463810541500796"
        "919853141331376838730027058339967416700395930195810478835483081638813018798828125"},
    {0x1.a10d1c936f397p-772, chars_format::fixed, 824,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000065583225953784304043954834614176088194295405940341601198073153875988601237261704379055"
        "9933365976788191707725308732928182976190209935831121926799822295206356039751458151538698202210999800319499"
        "3700690531190689213186495513705997548419470722568105046316621424908719955943222521965922140810646651477916"
        "2775429961972100244078354448201804009172919086425145196331932267229375638726444077959998629259488107236621"
        "9565719189998103239748735717531246698300106404621320272068687120569178549223991517121489275313276613889947"
        "0724688740209962027833578890959869765026578336541973612838773988187313079833984375"},
    {0x1.4135d56a1a3e2p-771, chars_format::fixed, 822,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000101023596160976000069440436962663043104025661238803813305258686783605864177002843137119"
        "9769739320783499649064124775574220382629810839018012388827720150663315264203463880475089652049354996245677"
        "5568139884585617152622423648803324813113672233655333301389354335118987941796574841244036595242772931025471"
        "1557318894251460590412627372888990853767951788969775191050007390534210978779180314377216632922844233387005"
        "6541814956903081509819768976437949905372395341814698585477427930455840480364970460096700113363793784472737"
        "60163550393934817516023051483276085451591674857496627737418748438358306884765625"},
    {0x1.9ceaa4e0f9a65p-770, chars_format::fixed, 822,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000259732139706213530448245451882005921834190423856397272920535626662496755449426919125170"
        "2550594714010912120186917916765895983048599631991780520962203620444536908024011856433780670158318226201921"
        "7821979193975723091497090396671169522898471518374242167613410216813397235783378578812866385423780918919398"
        "8670381485384142340434982976254742168664151852148712674513691555142017462243655904084873720815259807064786"
        "3885904017009536566406455700942818368886508589824748630609074368927306714824973309805714092994491615308634"
        "72389822545360807847278223954502168854992227853273334403638727962970733642578125"},
    {0x1.89f20e3a83371p-769, chars_format::fixed, 821,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000495598000652351534897964101941613909664883556175856665427073391369005587112187855573638"
        "5611230374810791309986802372782433508435375322008993365340619986890224801448685945509568718742271638818953"
        "1996365837452205190467129661523205108676185435857200245311949408728206729192333568705183528014348985462418"
        "4204571649235774764779579585400684427121320457497024811161711198841228389639769023837032481024520231244303"
        "4057065200979920481652492615232633927148499564024439563982325881645117144098140065448506502009259057265030"
        "3328769978657418311198129755525915792098434753398805696633644402027130126953125"},
    {0x1.bee6d84bb634dp-768, chars_format::fixed, 820,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000001124437726280314387806801642368801259603971889474876152269312370318163413010465064013526"
        "2083103846749672518801249249538170476428596608475348806502147009220854218318208403259597181016504446505711"
        "5424454465191892043335924275116028084271363278077405450543201961262487817246473430127316767816343112024240"
        "5621415824776126460894783892659511819740228947054511879748309739593626321546425115133674085633918088072495"
        "9346882809972866164269263377530400296198176892310064309601980174227287902248981317884777041785984059282988"
        "554452900238197385204296812693280688440211623202458213199861347675323486328125"},
    {0x1.deb403c7e96ebp-767, chars_format::fixed, 819,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000002408905012655528254140312114793714664032268881311095087349416525657742714176490020984771"
        "5481143046869400508714270672918718286848988872663121901055634647037723578276123125516128349187148157183017"
        "1798317313191456617430978322899298739530987421493808516778019770371345005838834155581044390605946827549797"
        "0709180486706718587131364030821635615599960443591760513678002044920579287319276929340598582253722901275914"
        "6679613240165097560521086933490729562560414901156584319689412299906187005948185278022005662480251971989026"
        "83943273650726489520827818495221097315484026779586201882921159267425537109375"},
    {0x1.3d89cf65433a8p-766, chars_format::fixed, 815,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000003195799319805462572521364574117316278693568485767752743809097950037064781039795892048082"
        "4463940923329563437363685177400336842377167211712128391896467408379088000492459813190319379094782060739161"
        "3617716363350605791562223296062732639286011595094094702957909856135709785441411699195097500768807034283392"
        "3998116760516870121574917697037459288010356755439583792967346200669790443814778669500303146321199566652812"
        "1763991142543575975589971847109339742740076626470903744949365521927945602356867632925861853636270287275936"
        "7963005063148812537726423102708329937460263181492337025701999664306640625"},
    {0x1.3cfba273e39aap-765, chars_format::fixed, 816,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000006380419758740376032665289805420080182832321478044221503202200762047835959781840169328401"
        "3081678136665027405649019757328785359072410017997799082473115643094090029365795499978289712081064470112832"
        "9076885474982261315200453456798024048485256634684909215190879937128725725538244545473521500098750392836164"
        "0304537884889342864314578127938577062827756669432571158155604168064975558083170912444617887509179562778598"
        "9583994623827758905875393700067186061579595903977837711660628927349432190801081573067233350735781687425858"
        "34885842794925337155136765021905438655114295443127048201858997344970703125"},
    {0x1.8fd3a095fbb3bp-764, chars_format::fixed, 816,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000016095894110621704153832201294055971532390391615911012418102173691565843809408450333609669"
        "5857168934173226321447397301047417148502624258582835574723816240415594393369665164751768647196218708742592"
        "1344236637602594225725582449224662605981402620585333275787021731573507809506478128418455212296523148679126"
        "2664266996524011655347686788983136076956554273893939557385379020373453645222044106667326598338033048058315"
        "5873811564176938159689442060769621685872330312916464823415664426762643483429352265211453025979662093409239"
        "73633448396800289534637228014489311600510035304978373460471630096435546875"},
    {0x1.f4db39b3ecc94p-763, chars_format::fixed, 813,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000040326128219471308776340774632801968730422798127085717909547582642722780609987155279615390"
        "2810669339478058442834132325348297619070203917114895484113342497422436622422171014950377706618395303383927"
        "1770105011467448775538953564225445443359521685452770061497047825649312653532071752631734104992995726313037"
        "7151447419596676213378577557632829154543778635778400664844147650126586480978710722699215601770032193691389"
        "8614935271862924100599178352375439954606326097129388309765290899844628674147158970800023347955167381151032"
        "69759047998205277790672589771116263168693194529623724520206451416015625"},
    {0x1.77036a5ea0238p-762, chars_format::fixed, 811,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000060387918131443855293985504488455915724451292685267014767829849073500412060744954585531063"
        "6730305293393951523888733562888957496230925242955930292779412423416985599139667873737076545274846108104562"
        "1877686951519498545128012141933364974487522376491162699773763210995107076549084989195346688616058796160233"
        "9276112267342077701687069702978155674956635793332657387620943979787993513510686776554055594710429194494938"
        "6627062503390682659995039549772250462149515137830868639868155808286646814645933763259664624485459438133730"
        "144593675207962419919759523671831669133780451375059783458709716796875"},
    {0x1.16a7ee18d63d3p-761, chars_format::fixed, 813,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000089743230112456742542899279796268272934437787928293448086298107077647616276508988954791659"
        "5804288044644798103641898249421376652724137290600459136448447242365922273624432734917290803189814744215370"
        "5702731837594015544794593860976939114279110402292024483236793330618757059821482848520627476373652688290899"
        "5679261595490429446328543904775889245889306222564992234900589838102861964399884580694207148624055586974244"
        "5831171652450554772427198667133558451445735864240418102343992211275762410613327206706574095487836196314795"
        "23191051204460867478785766697922665624531646244577132165431976318359375"},
    {0x1.23d8446ff655fp-760, chars_format::fixed, 812,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000187981573753279378361773655523115517222985669926891374954084011800644608102756695573682624"
        "8605047653570682229143154372846202159429019436045435644649504351411553584618810450861106936705352227437584"
        "2568731277301646484032327163404271841069493719674807837610894121338357522419245958738777012616141543339439"
        "0911032438610658571063920444331335527989881806927056022970182117493234989439704941944639774081102521389589"
        "1696714349771919521346467022907845451052601328720021485657518430282316906559267028608176010620252575967031"
        "4514760374378365126359435670864994616380272418609820306301116943359375"},
    {0x1.d9ab918404aeap-759, chars_format::fixed, 810,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000610196031199063948237033598934190410434889286687771273216097796022959577558462067715874396"
        "6749819160787012731884077873234225312484501399731681232773444628204378897443670340405165260057441307837979"
        "2088793432688089101518227058288754692925652690365461478939154568630158575729090638020647792935120263089288"
        "6217751852987400174491426935500887326192277485223523685571752784812643141185464689893528184889638149138065"
        "2507002409142303849126507863537916582989505083248647557799326948431744454808215738540980419242520356242812"
        "16732196095488604104431604353842022447906856541521847248077392578125"},
    {0x1.b79a4312f9cb4p-758, chars_format::fixed, 808,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000001132618262292722758502699840195345356438733152663299584143457256601227018413136017286203526"
        "9820314552997461241377632945337361515620918822560229961170393130765553757248043014053314277604328004618600"
        "5695400263226405409869565899275176363968066480730681427609625729113254172188553663835406121182992392333618"
        "4608179768249661565556415092990480854390048819071574318100620038390298081275462824285010964499785882149284"
        "1688957682488157080189277388885933187971360453197973651452791340741998288731311405618485841516869165310136"
        "725186574173985326892508292140337999853727524168789386749267578125"},
    {0x1.0546601b642e2p-757, chars_format::fixed, 808,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000001346328421019360593774572293772585724294970999933506003984042320478536784739030226719526355"
        "6416334323998196073782473607018630567269118364564600234366654623643949382152730430690017780065413052347695"
        "1053665910754980200664236958227015240115626992714777562773465232769283056463949854307181394577386702165003"
        "3486926053374860706444780130558337318531162313219201160491525146597775296876709847890267525250594795293765"
        "0369501082058516769660425361944455031347308706252788388788524194595110661637313910166749819315348258679689"
        "093276443200938289032121165933464368436034419573843479156494140625"},
    {0x1.e06b693958e4cp-756, chars_format::fixed, 806,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000004951126320251195764151239969982960264155762354973640825355682242559097539526642761111496204"
        "1653194091053383333687977528459131961733246268075570183108576832296256725838984844196198969342687811673558"
        "7887408259374359232928716945672901112317542495858052699618979405779261026253825753798270697448884031653575"
        "5315962922121208210453490746877239548906461407468987574429645050867059461785131584848399640120680171713028"
        "8469826373770474107040550642701421757615256057500503308103419946710300086061346893748306313536348753510183"
        "5560640066559693432397641632558560331744956783950328826904296875"},
    {0x1.9b121164ff8f2p-755, chars_format::fixed, 806,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000008472853590985601241020004190637241463229621527264800448442776684560847734470543149339523242"
        "3944742460409199077822362080714239493454257568353046797628519690492599331320691011073453588367065068265407"
        "7675051720555490715378575311290261124702213771995469493649223776846558440547642413498326835922954176759564"
        "2143658069865886831148635099517743665330779472058221776535386464582426973587043170795481595949964461599706"
        "3996698543462258749378243096021674191619062240164618779799121232700677981587852874117410446960008698216656"
        "0311473505952658790405830624425931318910443224012851715087890625"},
    {0x1.33c105a132a50p-754, chars_format::fixed, 802,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000012686651186489640418613729090000624883664125727826691528539824897946273278972673662123556913"
        "6796631789208189983431026863877108668219641584809556168837216776958126517591068005717065263272298248242603"
        "8981843949566612935545218642071817145322217521025560041269146239403948013671611970850556013445928964207740"
        "8705331572574235474192624851323842879640005145189256370467851069614167518680883900253222756097604564947196"
        "6663022054729635272862815877076419614503481104276280881883230397522547283862747567583163122464808826042178"
        "125167560452464976701592025420950449188239872455596923828125"},
    {0x1.461881a63a0b1p-753, chars_format::fixed, 805,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000026885518067927030135600540861707655056802159939373748083541390174722386534014508552498653876"
        "6100510099067445588072524415445950949218647103736177038525626564873722274278821070632004195312288860329438"
        "8630217951705260348488305643570712966829103828184920483901645182663652301170189091428704104767787904483000"
        "2873804362246721781438144108851865293957093901180296561836196437647790186463949972800429878337528313848596"
        "1700105907608224914495063158132615052678462862682436495900588406487060191263024372546385805536617848116566"
        "363084955103460608268235720874628214005497284233570098876953125"},
    {0x1.0c2407710943ep-752, chars_format::fixed, 803,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000044214640337505111554944922904823248343623564594516449176929291697505388608995390558125712875"
        "4791912335240586693816810894915724128757425416511778571176251130211532941252220691325000829704363646059477"
        "0323859200793544962681567393060012625739634735505971763236487302996987119743532149729213667588530593927826"
        "0408520599271061340719831810161934489555283359505257515360447477172801213945337256578391537827633397957645"
        "9174713878464261200380015132547253153164479656660812754868324751497403180618654707083628746868296897020739"
        "9435141959840122704954168408875148088554851710796356201171875"},
    {0x1.f4741e5e15139p-751, chars_format::fixed, 803,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000165042995966925546628984383155687426802630829910568830144805080182059616159400640616791914911"
        "6567972342502528633809026611619473914203575226695110014755603134810874402588512571826899337246445297246553"
        "2766264698823367621612810348534805900131492296223407951383730219237158057773598874706174618086063840044242"
        "0561922495131334668208131885746403391672324167111969390916603648953175737539471579501379373729326118697840"
        "8512639099218568828122064104941327084405161941916779504534198182319569569273053021476314273499174412667533"
        "2954466959597313317938127585904339866829104721546173095703125"},
    {0x1.5b320400f0d98p-750, chars_format::fixed, 799,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000229000914269899793583925306054617850167594820150049504339158929071332501528864478409489782356"
        "8726988932085980115553293515389936957901739981436559145450779378992877790037673882467134229994518733990751"
        "9685728790162322547086061292293262864310308479222563824048629828472193229030605222469084308480088212658865"
        "8596692441343569075544140943477600366367404323388750435354634978135442694689381148271780915054657167342124"
        "9634131103639734074609825126412085626048859210797049749415351752705234733937121147766631468394943062111239"
        "263831349277623049276453315314938663505017757415771484375"},
    {0x1.366f1ad138336p-749, chars_format::fixed, 800,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000409508166888628517157419817165105554911318069237530796256468732001010118418331055637139157129"
        "2008962787733866727329374672025191194795224807234077953539142049054179596385647635507320267095499467503726"
        "5536614676875184659859020383556149347567769289988908977699207829717670516082905572978102352864353337911640"
        "4234813862457090464963812948429443738058813073252100543366837119461025892649682279087776787817400792979497"
        "6185694127951447015973190588292187212001502539099993036783572947568341165095404737746532857085800120406782"
        "2030524909524755276801766257221970590762794017791748046875"},
    {0x1.b68e4ea5cf6b2p-748, chars_format::fixed, 799,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000001157039601914719995161474681192713940448938292324236773346444178863088807807473422509603809728"
        "6016984649018125775151464503555615646404060658691264580754160801113496274674184840568134100418868606634608"
        "4883838015448770939237227843610689471472516848889140225661395889556818593452328080378502548794576103368260"
        "2426807961772990456483059228090427602838082901289380518829759688894970117957680038164686817687234225862905"
        "9497492830636304470371179529986886830620720903236045776519393561035298250206099701234656483366474654869577"
        "789030389398873717443638753366030869074165821075439453125"},
    {0x1.5954dfa1e8cfbp-747, chars_format::fixed, 799,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000001822172616272087821939155910415839537495966914721324561350389674540202833806968589169321511824"
        "7249574470577577363283406905925589340504067750696872317929067358648190651662372963944126659917530731609662"
        "2687835586709261872886471392472717771987220460119402136444455870763923790489340610068961537086029343422713"
        "1712148405798938080241679861553713797750769999224740366201895083983660350633648559210159679452353048229015"
        "2376909489707030059187727235006050422294906448778167618793769252410314007579540051336232970229014522482537"
        "912632759093969035679716483855372644029557704925537109375"},
    {0x1.63b19116eb98bp-746, chars_format::fixed, 798,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000003753698138066099592031740920696553640319790791970843848324320727604625978078263679575067096049"
        "8823863331556436197349751507464907406536791259502997841818725518956116584948522260009384734395632938955897"
        "5557559433994542679752635962542248075114030101940045590270114197307140207018668586394636941569947697560965"
        "5342242607715417559482986858223945821096213086745651726628355163561208320263619248887956178202400601004652"
        "5100412652755517015868480555727850528566770216506559421430507788004742729225958245147053412401108749542667"
        "00298560860654499549138307656903634779155254364013671875"},
    {0x1.5ee917be76e59p-745, chars_format::fixed, 797,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000007406442429898379975840992196232696570280155414355170494470746700831178484225750302970256254251"
        "9306298330314198119432646936936219640005302425837793809866997855583039763458231724336941595820523128212963"
        "3947664312153197637819160236228380518879865419642095099154847013243834698228981792961692765381003688283386"
        "1429456852197071346598706932047301177361039950636204339426533855648927410852086145357918308040661420841561"
        "4734431946343515294217972587643229238349975638672734043378699267533306073702414230563790824741511327734312"
        "0253686591211890466457390402865712530910968780517578125"},
    {0x1.6a83518d3d07bp-744, chars_format::fixed, 796,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000015302655517853281865519088036641672349453364010152362760912937487442751067960308155681513204043"
        "0603531140119169719954301232130009138770629329047623431367136583488292739563960649306317491883315147232877"
        "8111853551638370183466073023350414179430653267818383940598863187341144619169938988058504946188990166111689"
        "0371411748419049310873563085132522363302203246396131818560894282203919762752828801213801660943168347443587"
        "7212217601824120899083102402432899611516052729144447370268452974713939382192826509551728150820699522893409"
        "931803161412415537068199000714230351150035858154296875"},
    {0x1.82e119223c726p-743, chars_format::fixed, 794,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000032662448520856141582359969116197647314758219008736296797176525214401520867340405444019626396002"
        "5977722528663186968836682916017000501882086507974134707585824404879354484989379169992763394149298116714053"
        "6497351170034620473951673976632347333736927399827635100863212403303690831363747883357719095736646178466990"
        "6108011089145100688546861344607708883052424869986261801888046350637846415147864801751679914776550653014890"
        "4271560421265143357707928115720602473152213992952494569908513824173282587811025445448262815293110163847537"
        "6877122978262757424516848914208821952342987060546875"},
    {0x1.9511005e0a3dfp-742, chars_format::fixed, 794,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000068395808072043960437946888615913144022818684597480409139416604854902806048015891947817642973494"
        "8862245893917947413915725902749084228620358340824715778220783690279558522472606442707272495233483210036215"
        "9581367871384747045125219246721474379386766703417334122219654531636577160208810229335271405672744950103125"
        "1275288724009435300708255534437191306099867781740609566530007646264293977991206060866325869748017718453607"
        "1352071608186568842594609317420574039197696219126111789580806886704377222403255162694449756479070580400807"
        "8262816775448607042875437400653026998043060302734375"},
    {0x1.576318beef5dap-741, chars_format::fixed, 792,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000115962406402571260225807637588083339565449145756968128771526860579794274238061701246310431437353"
        "5120241196943636624576522441056300581422419793065918182403765774576619664789514847825369394357789994302581"
        "5117473555950899664260875011783584215111954734503708050533070455197544779620469044887126348153871233465047"
        "7100302294427227534119601005347919656805274459431535703704462616052711014127602962719080546695797410866049"
        "4425525185133740063498266042385379033759626084965822995882878273767335675757022446493915011042685707220672"
        "96520471808840557770281520788557827472686767578125"},
    {0x1.3c835681df4d7p-740, chars_format::fixed, 792,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000213773982901020816425471059982375549303296669336586187605949616394455735106529551573912809724370"
        "8385367203985409989418142339845464744509848763411466950826902047362041530912923617136105382832462853751569"
        "7089148893646577214111150032465788510783774980534050003893219526729892343374479002155979221460557420738762"
        "4735739625793585216904245671834066893864881121276947393151048614791519049805690272638749341813777239919075"
        "3868947235717472056123782214877819185392685523254459125164136720192630371751914248325658632338692842967628"
        "95038863071250911929155336110852658748626708984375"},
    {0x1.7d9de55918ba2p-739, chars_format::fixed, 790,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000515490543463541900457280991786122842428640485925469736386057649097520844538168988144440300147547"
        "3674571741539395136810865812257820287579206899897896199476737985440766083717013405434910690087623353627747"
        "5925228251990646506347478814471636118300164663494927951118784242630813001137337588649111379217550198123914"
        "5721946995220188267870819637862289155305070449878798335295330840577067021393127348309703358916386726162320"
        "8224246017669461827484581446654402322156932534434165516639328956185987526456438566471000057408688430571702"
        "690182779582617200730965123511850833892822265625"},
    {0x1.2414b43111a27p-738, chars_format::fixed, 790,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000789089664296121387614420534108250108411475119368219551774587134574381988054662718380514246787658"
        "2864571993987161677266347483587329927262540886673595429084055068332713331503140972745759863099423617038793"
        "2906236360085565080066630242262384729105354678672708365776181553401219189809418801996089930748555171743979"
        "4176679794332576993871994576554201767938461199302784663624577250824925208461360727003710702208860452385157"
        "7109991383532739195818399287510119742881192916232957821791065350183530710515309186009093491021467737703715"
        "353433063517396561792338616214692592620849609375"},
    {0x1.c124cfe4c459ep-737, chars_format::fixed, 788,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000002426825986162955409696160720838616439633892458788625309865145355014039133937884499839346028899093"
        "0432820913585260554414526029717841800919562286700763605904040464751167458275925208215946333392494612263620"
        "9365307724097787315779589883257950377354121499303143400294712376443754680426129417822394964985828423328207"
        "2275776984886776696287230432917325151114270595302521151786942917476744573888577694630402552560755028212755"
        "5871896204672378684490694692722428760174653910908007906129323028077264260411026749718554739595906291020435"
        "9782805061396260271067149005830287933349609375"},
    {0x1.db6ca39d80d3bp-736, chars_format::fixed, 788,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000005137651801328117658139376700388169245253921618963845408251386167105634433055348889898285991546260"
        "4752562071319485845648335529584393765522975276335293274782126103564560674391804761359705291119305451450780"
        "9178873973886099210282662326328019523997863070563037719717129070997665663585612017830449229911133403178558"
        "4645526739662301140214643107323203614135985232805757613680820631336441887723303479232869452436887245731411"
        "8573580202763213328421570983840494818766787235351250893504765102314681700488732866881574538666002685874740"
        "9429610530917642563508707098662853240966796875"},
    {0x1.2c644921df46cp-735, chars_format::fixed, 785,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000006492339312327989397379812497506795768366182105530253107926877050242004909514098345522837065884883"
        "3305956119732868279822906352745414538319403704146625057972477571484405064073479760749702326642482665264654"
        "9956059872012243832470328232644071176450401483212656747111730955488807809611431008209463391066858018677590"
        "7732763117160367987693854415608264300757440194274055962362354462378832753180832240963470361183082402027763"
        "0688513162592170967972426511609470994955390113934168759848255995447624075105516859427388219868399379202902"
        "1073497485616599078639410436153411865234375"},
    {0x1.6bd13122dbaecp-734, chars_format::fixed, 784,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000015726294053843144363681777730802477936874597299084010995107628966567384953622503257042435468958025"
        "6817689514556296506682508635691790408230988645053782874328147548076915865073026467921875301752650598198704"
        "3218119453256217150144733715978427901629387459284666143864869306007500181496611203249610419580016413429528"
        "0449738030498260886817981140598424248086555342030238604672222152498165969915199735649857611225997848420675"
        "9362681976604047511921835077849991651550299984928801347440824803576874096605998398187416862946416525739844"
        "020914670608135565998964011669158935546875"},
    {0x1.287892a1444f4p-733, chars_format::fixed, 783,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000025630401696102993478539054633433987502198527063819861595789767934541667125215787275857810993033871"
        "2919776527357557274968367720569106246135522165132339121000037669478455657996670633099125384048964216917608"
        "1287153935906807676638979861995899482434722854021681551266558689523039027804336232103222151597704699482237"
        "9922391660359274271916002455343495552557398005709744430276564223663170930770139608062610354384149949188616"
        "1320538432032766932551477934507877337828248379260954800678355110576711200666093855448294052836140256287434"
        "17206667487562299356795847415924072265625"},
    {0x1.b57a6911074d3p-732, chars_format::fixed, 784,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000075641405712977867210175274043088388783420867275149767322122351434047338374177936253438028204899302"
        "3569628370488523999137071089542042803849243123833082314485877867503612078844280060492941395300769301050477"
        "4610838844771708168843517945782166786778563721827463933958843025588740107399532386823702651549747742355276"
        "1186941336160543862549988839807751895579998772653688325470326107232963792745930375230680670041063232822687"
        "2762673569564881628548880660380868326841031190637588018517873017028771871603303484157541767382497748122591"
        "012254201103814921225421130657196044921875"},
    {0x1.c6dd472003239p-731, chars_format::fixed, 783,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000157295073408453606911729619505523894725953819271770441580534862440013840931204724506555288279172526"
        "5682898642166114211738697187713054706955842546263361679145790725498681498242083863209695438953850313229173"
        "7688994472301051431573948834616830901954944542778316213234982976290202142350877351166882380050718600047179"
        "9043574906093596493205266413296990196692380167403690207319888906701332340595651002137507102441331544012289"
        "7708032052769928717028176619198122777638530567453488010312630109750759595045868284965451797591045295646909"
        "95446785137801271048374474048614501953125"},
    {0x1.d8d511e371cedp-730, chars_format::fixed, 782,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000327017007584163488901739444514020270037333941428279849661973291684897878910306288715646201611544729"
        "2044197663076116579400260859501397534190638166850065340773734328819697802740537774029895653491985746347320"
        "2697651435032552543576203865042344086094884512708854406959942766511470532038912545588547952336181295560197"
        "6898306401847016646603757148935068544244962351492995580088595361981923783923457114900478524857371577478488"
        "9148021506306074395678311790193411911037000933819133664075399287969675494501573233226822323294383922196327"
        "3911075731348319095559418201446533203125"},
    {0x1.124f0a5bff47fp-729, chars_format::fixed, 781,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000379431043001038469074651257189628076444525440676356092452525157808468573981563260749833451524921233"
        "4464478218854372958354678262211764339276307076838216900030749536116899596849844045447638112903920508284238"
        "1228428673664143676671917067921934141682782846048725912030100126490279750221605199758820182948609568808322"
        "9631353675845188054656847706142232783217611563395233259486184000162893100070693463774052738465987946829719"
        "1977645138114233180345854973418698873477770304796619722599145594351820432739557317057896075243604005751245"
        "356048428902795421890914440155029296875"},
    {0x1.04cfd796f792fp-728, chars_format::fixed, 780,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000721523642857880053793775247959791749645526607159006997040539299925472682339901892690001761779717461"
        "1834525068905315960874482005026718233604873519766104468453429474282071023466786318463963190522546001664489"
        "6094981865004659746758400146543653868622465826282386230479879668218102422146770900114185171676978938400617"
        "4907218638131173917391177799025997090172702992695088863786243857700360713804173414881425105352380025308263"
        "6167965641333253133573897348355761500720074760832267536970270004610593799613186191805297330974501389530204"
        "04297689083250588737428188323974609375"},
    {0x1.dad5c3f1c8083p-727, chars_format::fixed, 779,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000002627216902452713167932470255041063337972054455244298385747730999682583978564267211395222833881299723"
        "2757040379717462115307781844607562060287839351012152481824654882380169383340203054012554868633139986721486"
        "8694778426056050225253556169478909199723350490592251366959793551896116302879888102206434602990787939478090"
        "9043154651068824471780599187704730395683969622213941713653102524381518253785899380703435327698620776191834"
        "2522761430038425983329280479309262507031712731206614698754794756482645215365118609345332025802628587215353"
        "7948037183014093898236751556396484375"},
    {0x1.c10f6676ee08fp-726, chars_format::fixed, 778,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000004969214075705503968584204786780350700796506481339120394453393586005551377900200682597751273073739785"
        "6713792652110940037893610113477356898945426511160030786483638944556554320108083906843916705974904743791005"
        "1659606462509034100044121352105519179823508882610455594247772185146701964604725737248860216514495753356998"
        "3171669726672929674907814670698107960921254035124227163717402147831928058900846423923974580181719298414455"
        "7569294727203564152805713830598552930337880093573159627635611491620130885270829508146408233073011684842457"
        "125199643996893428266048431396484375"},
    {0x1.09d1c057f71b1p-725, chars_format::fixed, 777,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000005883012289142309938497422517314849471308186442110116208741734602315706040722695499665752771003657423"
        "0300777822884959744956830203671830219446124424666866141278247274657433844948622004807122385264774582644514"
        "7658614443065312831352488225116224202916968414513172723789935327375049417409831192742477495287436592133815"
        "8977154606575054283207340894242487559060583627578757790014252843179330158798802015612057290111323581268733"
        "1457996115464217508961009642396585239800211451843639845539784174057675246039415516356173045876598636308441"
        "03710160197806544601917266845703125"},
    {0x1.4d15da31c76d7p-724, chars_format::fixed, 776,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000014743436359705466669425597004321834607160275202191708101647359884779278816000005465530348819209779595"
        "1468193274657326555527683528423165521075539607371822078683349867541347863453219805292318913772267021247819"
        "7939920891478945700675670578997649636833850295033438465261262013370652846731723982875478958167012077393670"
        "2069690600361602022159246479474998393004303980486125738995295279594477648650045806279857474029772106803426"
        "5336038275194781950606208085012372213473554552613880716866570935356126307329100842696616070606264233683324"
        "6048399814753793179988861083984375"},
    {0x1.88eb0dbcf442ap-723, chars_format::fixed, 774,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000034783661139951836659834650869398120825446263038654374830389179725779207115608018307232395526906385987"
        "0880824300939458172670455150508058822235267367986041627005790042997377904752045570140208853566396039690367"
        "6479758706671069406990269746660238927428872711018746481991387760562749230806116297403149718889702098837849"
        "0220255913529791938285558143796317931984839907097658936340062828470837435597321113430649553015925929159557"
        "1639897200311940047402536426101840440670659097350647474752106036851970713051703441768301934192532745560022"
        "53348196973092854022979736328125"},
    {0x1.4855037984a9fp-722, chars_format::fixed, 774,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000058132163840225073067103367504949528996314796226487824120028997327955421486231049647242313211271414237"
        "8778496575931983419043299641654638440132125481074183643823625939890917321998087428065303811935078982220060"
        "2167033080320155151816220164993979839757227461089845910506971715485581225714522454629832571060428488951781"
        "2470097151684577794782847430343609839366343499101500085822887900487908381027204874540283621144246564638885"
        "4403929804648678499580352812183946211325003975603679026913411470755820684245890767411404683725822603590493"
        "99767172872088849544525146484375"},
    {0x1.9bdf4fb46cd50p-721, chars_format::fixed, 769,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000145846414348785044654977203624176621809552747269771057617162877814093719225517252963305984986600106270"
        "6204141099016861315269834193670278038706183720282384066743585253501474455941764360418820933239666347867983"
        "5374309483255470999056060106694347782347845835362429701209163392928524163109099636480828887360275436856538"
        "4486139527103010105897105377117220903254753483449847373854388714229265424632795812369169390595111068408116"
        "3142495388801854357102537942013401014877237805002520937425944193199261434930638999167445989980917975259444"
        "574476219713687896728515625"},
    {0x1.5226e4ee6e982p-720, chars_format::fixed, 771,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000239483186457223836985961329660028613562628677384316778039396973577792511481656889953521201606272226115"
        "7592996898267009926620304163787306892480776168521367052677861615450962220072159900888391196462355362792534"
        "7693490035517321444407074677040871397493857962020084513631697854991807791579688729150375515509900214495298"
        "9181255171836035604989077595260812132791624003169810582584626320410899186907744226562325725878972712953197"
        "8540648124353963735950993977735246748350980256848276494637588925843014358359478327888418878023960023604388"
        "42515577562153339385986328125"},
    {0x1.b6eda5fbd10c5p-719, chars_format::fixed, 771,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000621708419827233387307024027741745811040794443557706452277994411521409901799371808917832426374999543745"
        "9708730084646622502439860068442286678698825944301025310781759139073356879664328313985698688601620528992621"
        "0938458834733984789592348386885500116630027572299560688584147581500893126388510893377999861221311372707282"
        "0608328932913850315914325737268345190442541755485660417583283209091584744628348620323940367827433654444591"
        "3665648244575892101719754367791134694192123209751648906703932254444471579441803236519866181783791625470314"
        "55687829293310642242431640625"},
    {0x1.ab54a9970b491p-718, chars_format::fixed, 770,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0001210562607654399725553132950172692385758887701305328620754199410250938136945199172975265888535527454069"
        "0355502492846008444363980996763073434779142504236751156936639801445163726824422596431945380647995592024691"
        "7322472515736102472858231199791467081222143445286129853107163927468170979507191259905972660712892501272660"
        "9172179650580485452974212620040682347896625873062938122248292709475007817104483946048002761283617774953642"
        "0318648112730692004377228716327738603612872108154905649944074828637843845058514302590590430101086250047615"
        "0671602226793766021728515625"},
    {0x1.e52475ef13116p-717, chars_format::fixed, 768,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0002748668705590606257788154000143150149657512359067847652939126240469042698309526250008546726233302789172"
        "2830936961339530184488254755562255682970365586832112135699056236684571478652609112761687391649248291660802"
        "6871760284950640014740159858982599053352023940579474462685857732762463474346239252966327615023361931221281"
        "6854907296492568241531562622742838180023526445880051872910350605799361364333221427514268379258902152396232"
        "8572986542001771093889245315798783532919956243031568917427621001507696878876820335601470447414729214585804"
        "58420328795909881591796875"},
    {0x1.351edff72489dp-716, chars_format::fixed, 768,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0003502765745049966247175754573508900191873148564109798029057617854775749550924909326628455469636702627849"
        "2810014717383073851871364542031052664898987775267639214182817288866597944170052014552966290234588578538375"
        "3539137637046969043468588558754523047422259424976062063227104084769533852903073076257032877285374940878761"
        "3766827060471274377253799889306932143630282633642383689523347663031395573111905814969041986415140717123486"
        "1512847412275052242804501401809980382251293818175788830911809550523953036512303536800257532449198727420025"
        "53422935307025909423828125"},
    {0x1.9d894421705e4p-715, chars_format::fixed, 765,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0009371878794082113864014323852870494733158227237832610990196601812083859436006541366308855748222925121806"
        "7569237130033979703908326234701870798568231434116803704095289921826427587751663751247850433354120894538773"
        "0294878847952665795534233115487937191335435372821527508374752709460878565652044570927908258107993393568437"
        "5053797073237697636798612040482671968552883966503139627626344881245978523301163061207480035276886103419527"
        "1243460530832167912168889310832478542238080230255146955773958122072713426827081710062923927684330749343644"
        "12911236286163330078125"},
    {0x1.e5b92a8e62631p-714, chars_format::fixed, 766,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0022015678401956501509913015563202673349273994830102214878621064509890592629710942073381394734079571892066"
        "0717487730292989115288528305280638727413962106934831869139267022072217246445392935266135588703131037280675"
        "1279330987296821526480487767504365898637613452426541908791360526539551414732583564950686053667485060220450"
        "5899377266646047617280040514279127012951123130564005585555626870345590497806540537552635681909822254316423"
        "8476156766516279219677862865539783026980640293512478470347104263432506258267583226624305482721499771514572"
        "785235941410064697265625"},
    {0x1.5145b770bd17bp-713, chars_format::fixed, 765,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0030574111115052798755704223370355788580585808691529488807936764944992602196499942092750844854714155848637"
        "5976497130637186256919022738489601122933480405757980718915295656524814620284490229794811067698027804710242"
        "9130376602599274637302539181859471723845759904668345426627291624744410958365438947344354893144388403260841"
        "8791325650128517766244303228585118902873034286845844905346105029784310865178592908660838937112931288536138"
        "6306009764825661633654047990831795098362102506534239404342245751501345683352411639527096073876144544101407"
        "51861035823822021484375"},
    {0x1.285ec117f96cdp-712, chars_format::fixed, 764,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0053732563210682168420160693837490128172921363352811330680377129309428579320206596965611505276898569179318"
        "0647093390822649793019079985569694858841420483773418054150208979227588072543018999060176454825188719716750"
        "2661464925503548223182782469269863121025084723548092520888452073422375220993719096473946649034335302943612"
        "1613096677012827332884190800037895188734464273611331722229788010640188364868864193380798439305695257683444"
        "8302578304119397235029009490306081909908983761213174092123799691360182549197602745922903305642037707912095"
        "3567326068878173828125"},
    {0x1.1e8cb1b784211p-711, chars_format::fixed, 763,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0103904152428537288160412175725911584222222470068030213236664324514378750459993403762404929223250548826745"
        "5274086077064876093516276776164403713633366717813302543281377633640747297431399351298595125078328058694723"
        "1263392976230612840578533304141734065425472100835493726268324530250308200188467928130265502885613498267791"
        "3492772776218471166681639555783027339890029254934945555773986614114209400275887172144352324622676982476223"
        "6908887926431680967992576467915316169541976245690932214605308313278667239559618768710187730608396350362454"
        "541027545928955078125"},
    {0x1.614c26f94db72p-710, chars_format::fixed, 761,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0256214462290950831557021118293237115025941079151976511923976832932709758776894370939764211603943341408605"
        "1435086543068996317001994538498084889568900263520757669040740738052770788606744726394148829824347522901862"
        "8575044652520202084551164343562830387309657146164986667715469091859590029098553279708870192289773041968972"
        "9019447246584008116626378243936872732732951000293611420519701228387529778995846771832418528463608655479959"
        "6666878438609204060954081373473785578227275825919510032791528243220806060685957293316522553894287739240098"
        "7446308135986328125"},
    {0x1.cb0371a5199dcp-709, chars_format::fixed, 759,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0665761264036970766088826968561289863070801164942176929925487645707981749130488944459314043158227861100918"
        "2966493486879017684378501068111704106608360294651257179423138281250615695075077090854993617483899793184073"
        "7572721845366892918083935204513265098624706864674876252326384477185950873409277864722432308439377962972266"
        "9538428780965056667683747977112330295981666683354446638887307886481193845762170827268609786650431284012097"
        "1295474237981811083504503726588941354220904426249518102009195870956794005096163148113563856611563096521422"
        "26696014404296875"},
    {0x1.5c0c6be27bdbdp-708, chars_format::fixed, 760,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "1009631512902304645646792774788606240482994106554289402879987679823841931516363676304196711548653407815878"
        "0379274662627526750547647585362799781486959784193358918138494532134903128026449481063685188698857938834116"
        "6108008035795636147154980294554173887909631712236290273713530124748884968781299725631320910455173014794362"
        "7991788344775165642113484538015489634488837892217754894556857929193281905736745880779492409241135131603805"
        "4729059183891803150331228050777715164381028996281583312150401039433149428272191061757567798196078001637943"
        "089008331298828125"},
    {0x1.9b18dabf10f4fp-707, chars_format::fixed, 759,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "2385050068827948873606908831289659780771250115393856357311011604239164563273727553142587346786353833713096"
        "6789101042797565022493713355971935140100646122626554995637357166901585570403935901437484841248343592371289"
        "5425018681697218180777730838941739826991680525470154592625646310685921758514356927323761938897634452280393"
        "0420356789506446385314138879887562460700399879791522534084974388936628423572042785968578321886850655792667"
        "4158021419955445593384336788084225756068439195770951500391245958229237201130896626685706785053753264946863"
        "05522918701171875"},
    {0x1.a3e82b920dbbcp-706, chars_format::fixed, 756,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "4872323574333538300731694203713833393972787664039702754863758731172772544445786685972698198591014902707137"
        "0646834020728366930715533377952042405272544808690873835324162678305034764863415184756426036677847226141483"
        "3261356449196109510818245763145775913293657994758980747920630459771222224503264224646902589868229507753779"
        "7907476312181193636149953794577688763457731731398729105343322181898119349835402609162685622645375626461203"
        "9375453042703799131923481447004995888932681929161145303655014857543743212251038596227736832133814459666609"
        "76409912109375"},
    {0x1.e55d4e34997edp-705, chars_format::fixed, 757,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001"
        "1263700063301883961637593345853650848173698173906203553947316800214949500052155115279306618384733383355823"
        "9012593269879463412835243497329655831225472435522686519182378700969305497526912686191024754645697306870198"
        "7762145427468664520014456587758418342960524150909771188685359678729708491944850185052337045874514571952057"
        "4137475072159689914997940459086273680774009478900069713199343055246913368028437896195004050375544491283694"
        "1746714816416655581946140115510899932593584992390168732897366379179420338335127806106417125420193769969046"
        "115875244140625"},
    {0x1.82443127bdb92p-704, chars_format::fixed, 755,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001"
        "7927923533931952950586931510282749592790453715109808832297352620022802755310066252394361312560633056624429"
        "8444201320939750950080181045198894675756701860610234013571800216193558312750617204334599296344409701776745"
        "5629192373004068874618729305040214979501665418511156657769937991179760363455405882943393933388417275007027"
        "9238392034119581576347126335201240604873503387124270592794021386497103267133076944317349877812852252494116"
        "1179202904954465216073197261130107718452951168115991671745272658875064850016612522098924387137230951339006"
        "4239501953125"},
    {0x1.c3ddc4e626843p-703, chars_format::fixed, 755,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004"
        "1945272696274143506064751591019143690519608938330793458941131430315420967011543669286107587304069881291831"
        "6032656187170995340885670400984520535211128358722668170887203873605927186042732064909372141468474051452393"
        "3678415858455418832312297913362303042355926367090313440035220453662023511344211217569805253299537764581623"
        "9298412580286410353907497125866517188536279462904565662754642482258294680343001078696867682334679872718368"
        "0479454352306477125153503393953171166192097258701941353102439406321508295406082916789713976868370082229375"
        "8392333984375"},
    {0x1.85179680c1b94p-702, chars_format::fixed, 752,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000007"
        "2236307258538304887715568455167838293359876919019126748017947977725350522616163447033071439365285720056989"
        "1830461200043803436029630915487962565111962873028113557121533529866936632303307488823207702072296748481648"
        "3207014721774399563123795598496459219700635915793195213974388269457089126242058992162724467598411268911353"
        "5041058088826843891771253918599206993317190354583185164130892272323989170581794237052458129973574375453130"
        "8094598405624524073068109367799283444890475986358854047759977156130022709224630661495325512078125029802322"
        "3876953125"},
    {0x1.03abb48e8728dp-701, chars_format::fixed, 753,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000009"
        "6417543570694105910088319847436003732314160404928095487625173156883373210396589866754925983282318468734151"
        "4860626102306640936393564625714042933596543888017233328739922582864914111709598516057698962957292905855399"
        "0934567441164734848774927916780969315595016517054297439820165043351563820924614514119398727275481604029996"
        "0756386042271669947379377208367499428338782010383566943029832407667528711616577681695535866646659071647091"
        "4123908388130256787445397850940448407274826997829338472227774193835039834169289840737349095434183254837989"
        "80712890625"},
    {0x1.79d5b387ff6e1p-700, chars_format::fixed, 752,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000028"
        "0585349996703589966336796826175106571975204649309557050563077827633031484345239137032008779803454425820674"
        "4866910610784094684492403144435151475937744515111924390411464700497548572775572008259531098399240604224725"
        "3517988248553695734193115760399581199810397072263038625088021364839346582236886037622201642160557316228189"
        "0103555689859162509848338625648592047933217030304094512319642425587221267340543997848488412451689626096242"
        "1731401304347032543208984574360369687689530249039543537052391590404689227043061316990701925533358007669448"
        "8525390625"},
    {0x1.f9a36c542f98ap-699, chars_format::fixed, 750,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000075"
        "0988159427014312640429110041769881035201942013657029343734130067244322926974338613539238512172550847669836"
        "5998866305276024893441213037826183892778818826707997956017649120904325241743665960314219979480619321621023"
        "1177346799866346420303044037594349839926813988028994250545012004521866214882022642695520100672688043593341"
        "7381270902368080551319092204034520022717550201235816920625743921225883595721830904852424989083302494971511"
        "2537048990771644337852326770292330505646617071974147492442400818596083241288074994201906520174816250801086"
        "42578125"},
    {0x1.dcc43228552e1p-698, chars_format::fixed, 750,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000141"
        "6213380898374425888696012773925654197350739575085630499979667280211957369283336141916504406947291611976826"
        "2613417266819735171011252694363255137697340061477369007916565648469804681108757661755312573049783211164497"
        "8145679474573981972311296079824919626411465757802494339700719610313560013496068738320814076437003493972563"
        "3348163814481607333907526178386566404869283988033728143227953720373312739138525006452287158896685331400467"
        "7994616929497619525162625201512449265505741791014482315261649149642060813505950456203663634369149804115295"
        "41015625"},
    {0x1.d0b8e4fa0662dp-697, chars_format::fixed, 749,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000276"
        "0873558001601881053225136698606642770173156021946094638327654441239750277371604376302401333375838176249127"
        "6659190098605285263009484118213545876527089266147750636296374559822726010162486378474347864133504874870383"
        "4735859000210058479124286122333688116257698505115434325045276597993086123951126307272369830002097643093349"
        "5710899703696215964159459884254130282807854308585437044111403605197611649243454627518304997063068990328191"
        "1439523509412904776158227500132102989654165218342241668691467145045506745987262675612328166607767343521118"
        "1640625"},
    {0x1.b8f44bdf82c3bp-696, chars_format::fixed, 748,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000523"
        "9340425140704756747489929431788793795042333762247082503028355968048391910974058508728933672225668737570005"
        "6261215037225973259022020420098146267207044708247643902378832911166801581099385424260935460816884100119757"
        "2191136678325799358574956793126756634659899667264492014922184163522858477296368823993833665523722738620684"
        "9134284083186625764919636375233175292076301811863180189057807144486547703348615966037782155726693672292036"
        "5383065976756986827449157248366853644941097600101121135313051876576380221084416888288615155033767223358154"
        "296875"},
    {0x1.f859c249f388dp-695, chars_format::fixed, 747,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001198"
        "5208897227798591039255948760211295972666003794523598898895366020833219755267124170139715038638699952937432"
        "9645641469104729428750120637526367360593775039076317110708918658483802996513415675328247462305935532785334"
        "5693077234597796127995527491563794867569650848921446775522592734337766008213264400815397407021420615343117"
        "6922528484394185175495700629128401173269414579032286321428360062399315349631550183174906062438748159785851"
        "6867445804419504747204630742763446810820288164538437931161379214648832550182966372176451841369271278381347"
        "65625"},
    {0x1.76c3cf6d25fe8p-694, chars_format::fixed, 743,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001781"
        "1558999586523701977647593653910305007237069848717168449377479088923371990969176642927894674055304613438567"
        "2757693904280120418869003651550514604809425577325849506851929562524269723511223669099656493330621079242842"
        "8532458822479610900457972964267869820261321558949972877826760738857749922382498268945857045773232228967821"
        "7862435840327482891491017196268320347469034697494415172295492230087479206891090890393696595327575030145699"
        "4053947741352652623430920429779814837285839361266979135427518008642083779946574395580682903528213500976562"
        "5"},
    {0x1.b9755a541518dp-693, chars_format::fixed, 745,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004196"
        "2642963537321076602226972991351491104742192225758657473795663642271950965237649181687944784531856492724856"
        "5355071455733746569152196344022113027036138256316024271384693248884883018412271913955944148702408979980059"
        "8227265908537135628614882879304623430375054715224577326792297458415887012265235615755629258591793791972164"
        "2684984061588604707508785500264498166000046974354417486291970140109533598016391655783942366698854204024234"
        "1326597783970853680579332068366495230471063766360766930156215738360360456571385157076292671263217926025390"
        "625"},
    {0x1.f9c57cc980773p-692, chars_format::fixed, 744,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000009615"
        "1781021743031816511544979411331543689547428158611066559215048652158551199908498702146817365187884427510235"
        "0184914401779293504720175219084860292010793608864288357348223601530554819113162490280742714226103002168478"
        "7171977026814222128547887762200230029015250967853285838300682440492056232862759485418693647725985578269155"
        "0194921251369678834994115687793640049054121013242722791010216905285005198355969738557592934334727596160210"
        "6476021831384121674402994034324448547614929792406649935288203665277248499698714567784918472170829772949218"
        "75"},
    {0x1.e4a6ad7e5cfc6p-691, chars_format::fixed, 742,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000018427"
        "3217982706919314195292561843137165719736900892305012012130249686911694510640542037676336488393653370589959"
        "3926243894634290961656111329176900212958789868534462454579217822486077398734081760380838049395837069950654"
        "3978807720930663055229889895108185505411486872655218182893989627872308830406501574228862140716596878643792"
        "7548378335753538717584899573810158933553784812321272086670136727163721373068830685498179085517895127339316"
        "502913213462282092457461996729259367925729225844679795995907374116934418495361569512169808149337768554687"
        "5"},
    {0x1.7f07a911528afp-690, chars_format::fixed, 742,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000029126"
        "9982895385131124804481665511145926540207193470398340387598672609969994161817640184411539843887508097780175"
        "6292715018257904858834182291752430373823021727552972791080884692201603060704926189600310048340391737094843"
        "8966311208231185033304572841707248092160456783790763408486004595206503050586030453811311128662604284676407"
        "5936585430228638201812353595012412234223879718936063316892205505647505934328410726502253892713691474035512"
        "661765215882184128685885148232309762780083810333437476996260755753714866145287487597670406103134155273437"
        "5"},
    {0x1.2f7677b3b90c2p-689, chars_format::fixed, 740,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000046152"
        "8401072508039743461478764594687924995319060152189993535433087430486392734217870019442835051719190583198144"
        "2553656510713656782715994845953583576738777953421944638587676427093083206700091872060828263730375628385820"
        "2610054697985641847092867237293850732450712511768642331141903450743921108576381371538542093509778445466239"
        "1896052825203789490508562830204903362902983806769511223761396562871494245090115486737359776750854944284169"
        "31900349707338395187038758203101696045112352978425373877568505844026791606893311836756765842437744140625"},
    {0x1.c96e22e0f49e0p-688, chars_format::fixed, 735,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000139138"
        "6772566309644863656584159407279723917996714126567001591179665817923235637133008261506410949101418557178525"
        "4848693614484716795497282176097625998871970849765483775684436859404701647425834608609867577180263832815174"
        "5048857014012740612630489661352641380657382676143555519292913946041768889166100234254192155836433450264248"
        "7942058638252519054514988104354571006977764996434201232882858207017178083239851389686775235683257017738989"
        "819696745189651711690480619467448362029039063335112658375929128862225070406566374003887176513671875"},
    {0x1.22d28ade59d78p-687, chars_format::fixed, 736,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000176921"
        "6229598528527461332850010251663094336550047608731056718174696113525493748257680175022142829591808653632854"
        "6854876086315581591257086836506015699884337160251577236196765287883732610170710275347081986155736728834817"
        "1389238633597943605260590532313554987754629513514602287999027427816764146389748365110306868781667345159075"
        "0078006216779943448818722646594666610858803694648045696820707766968873627985895833280516684694909979158824"
        "7445999167063696700086089680623439003509639588506091337715385447548754882518551312386989593505859375"},
    {0x1.11c6046b7b121p-686, chars_format::fixed, 738,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000333099"
        "8408443947605288487079001788029608005563452878826501581531686943608952740413095239583871994525013198697303"
        "2072884208419659788802381838961697598322675897538299253098251482071796658315377880753111823559966218895976"
        "0234085615296503616542869646489633287956485382288755269890623114565331375644977306382168232365205848195478"
        "0527519640267849674880834409948792776098878986583370660790958130647909965835962545756566893462183435137577"
        "475484134256044426417195954897394597068043838268279111764305112919348772493322030641138553619384765625"},
    {0x1.198b1ed81b492p-685, chars_format::fixed, 736,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000685107"
        "0184689406742258247552337040437801141896330300976996683830234784171470648296226787368745596153712885999062"
        "0757466205693946622570166193885204514544362989255474993548388832557811929371181931092445652573418316369154"
        "7291239901087983503297008739251704634191295723900352242758748498461092182730567399414962801117339622637805"
        "2571475242760502901622646926155686083616098433267498422890941426625604718466269019951953415552834787603402"
        "2294815245715147598466779192478520189164084980440014264351823725096579664750606752932071685791015625"},
    {0x1.da6addabbbd1fp-684, chars_format::fixed, 736,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002308892"
        "1688496223736447698070618132190331861821537468965751360953523467964117030458093659711888679953431325679138"
        "3016641616913805533295082590105365577700220213661827891554176114291090426996418755045595031272391436505633"
        "7843282569335669119776810340847055881483383938852947141165661430884677477472557582460844244118662091717997"
        "1616485032181643293539463714565118379358749880808820996661168372725964919205188069147711554587345138910813"
        "3001777714280339866642455389931961554995216357284980538007966577307428224230534397065639495849609375"},
    {0x1.d56a8fd15797dp-683, chars_format::fixed, 735,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004569104"
        "8306445641604873487344582286150036188199466936663762245861254367951253078053084337328657486501850324463993"
        "3585428847066193727231878618202759175994292635769866898199587603013635816698477200737836786434113051057221"
        "8930930147956667737444440711664958909309074610966569304085097304218562735090854035050636703161868796892880"
        "1205899327226333183208398450978715639442169140673197444986361607235881156993779171410174755922663555574675"
        "719765400978001502127488303683860400844254815568243693565432528291836433709249831736087799072265625"},
    {0x1.f3aa6275d60fep-682, chars_format::fixed, 733,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000009727078"
        "3116371221191762939854842941752679733416007252745486261609859880583198730913356445623264907215190864856034"
        "9300936337143532788944063699216212541764989243921159202999554308982439677599213591449347542999436251484507"
        "5367400598016897410898113328837764425820423149230175473845973261109374719277837435612064676023199513247523"
        "3045514061072806455531384785125604686392921739119523946853964894459653941721178135905207621152684004902257"
        "3637782547046925665674774262349927107727157916980699199453741510268400816130451858043670654296875"},
    {0x1.0771405e2a869p-681, chars_format::fixed, 733,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010256959"
        "5461606064887268053153568553376580639755792494327251483572538700817220146427627585189751601766830964808276"
        "5100520184753913789297871952035445488088620858709522753885949304861830749926997065358822603151656880892231"
        "0311911551509347891000650194176893926784616843323525236120607465290160351740627831830419575892237962611722"
        "5434610903951368692523709576945339194613665397373662186644403123786205805517732846357614413846370081728352"
        "7981808733394394904977790897574079405672970002302133341216816564411828949232585728168487548828125"},
    {0x1.ee86c40e3a880p-680, chars_format::fixed, 725,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000038508135"
        "3673303142922963813598370635291867582327185276827025105817590405888719227773819147337110305420544116504406"
        "3198381694452180707110771386166181668775638237942600526891996199641936902921727029456397008323941915328700"
        "1381507450019492771172674531394468387904917636365192202428543052485720105094951785815459324529649949108075"
        "8552190140197561235432547384533244708479422634288198456340738382181879371165666648289093435544310798152408"
        "77180188791702678289624792713938430940614004939666348281690488875028677284717559814453125"},
    {0x1.585a84931d29bp-679, chars_format::fixed, 731,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000053628739"
        "3449776509413993969946640629094467941055963527219432817297286274505728731147698006956225575431890876170408"
        "1183778334542989247871394210213720706412612288628073749264151253516919514035102739759677470174957006029397"
        "1105518911499917452181725574726703070746493199644653852365211489160451206420107780390756479522390212432361"
        "9544844002276042785807115068477468180307113909637285338877284767145679505652290144854230292183753537507320"
        "81888124338330413581757188688331103832532131348029085481099453858178094378672540187835693359375"},
    {0x1.7a49530caf5a8p-678, chars_format::fixed, 727,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000117826704"
        "0698182932174834217027009303240135587983161895795494778452397329639679691686536974300676227793009505677020"
        "6268004366695289302094455927014979167727325035300577934263323507469848151660165476262236690000163522812199"
        "9818487048077260073912048682449024882889470093045872007457557688072661279040149182649600739751786706476858"
        "3773797722050584699688170936184216507537852151067693436150301794090308536030638452862988298951930409076787"
        "7812950822319769876550077524994542753523582646391944239727678223061957396566867828369140625"},
    {0x1.3b2a42806488cp-677, chars_format::fixed, 727,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000196331985"
        "4098648377579926138397987021624086250638291157791230954668880010436584357590182633139799315461668124712803"
        "4783577265187254152367638373603835684085721284008785144391510528355096890087564980113745935085538658214821"
        "4277448008315767986422179942596365826145629817854524429745151872434160383029615301814906845447565080285068"
        "4760039871190397496653333003622016920199196745166870414860204176816066138383274440078377346130079835809872"
        "3210470279803874144148526265154314849414816574238971946808618440627469681203365325927734375"},
    {0x1.c83826db2d099p-676, chars_format::fixed, 728,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000568403391"
        "3906094698176268428571086565481442596666460955736241020609519321090743659280674528094060498408491736387123"
        "9453858101075259619968299460644164129331162039955588226898372684026450148478891405910277662364390521228588"
        "7702971170286636762523478588329475238357643857562254782543377143330981224562879633930733936614162483272666"
        "8737257188160360666910506192611752260105743228060751385289440433302908709738748375198084447829892022351978"
        "76029202131802937817666288074953338254840490731769654664251589792911545373499393463134765625"},
    {0x1.ab36df94f8e93p-675, chars_format::fixed, 727,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001064532175"
        "8200814413322079175861714925420398312598654352133555760997816258375072365309746623458451602566928889295558"
        "7817123557658132010249725751416542814066399908321499983973004793509504161485004080347135156251003544265824"
        "9039229363606436055076672347113866815163628981036236168445495284717579960502642475861507919904976041523930"
        "1735078975625527410821978439898777022303097916766691649207535368545176326930298026323109512486224382840655"
        "7136280207205919064795260099278785611381060600944513383492306957123219035565853118896484375"},
    {0x1.50471d0714b77p-674, chars_format::fixed, 726,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001675873128"
        "7663245067929802646359253751876178073393718529381383029991245143140589642891986998226638001813841188457154"
        "0760722831242178043882468016912989619180020502706117428233351747395942121515884241840494596513741316837905"
        "6082846586489400073062815260306226775250614217297608945528700853686763895314550239200685720351426929003281"
        "9751222225759992649072668129215176147377509677947335109118716015043007331011463548126614761292320640235481"
        "244469082541147893929952413974668845082847184134976215030832236152491532266139984130859375"},
    {0x1.af855fc3c3b42p-673, chars_format::fixed, 724,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004301053857"
        "7728233744816436369978549136976645950673498532952391599320329530671325173016013614684923269901956026805218"
        "0793702299742913140983893922344975035501831505450412114109672135334397735251037816337885684958047399272301"
        "5478174654344760932744538761509098314194729572674808143340483916485684814524519684382188211579232287930164"
        "7036270532651278165887797562530738322949801980031349707060037709951853600603902434774229050505469076347146"
        "6516501229666796891561067299047712433489573159196839302609305377700366079807281494140625"},
    {0x1.ad47ff12ec668p-672, chars_format::fixed, 721,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000008557459533"
        "5115486808557631060044950010564116057553208117505835698979224270605230907269762845091732308470041266117508"
        "9528304438909809546901546014735177540676134332138472881953762100352137042313700018497337879496165918958028"
        "8095025616031282691409656494757870534052617087201115566268802280358798705227412553213249254918373148019358"
        "8714200446263056192475952356968184570908882976764095565692431171738149734334933275867032274731426465263327"
        "8520834947286422890756022706803482172043515997794660421504886471666395664215087890625"},
    {0x1.2cde48f104883p-671, chars_format::fixed, 723,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011995252022"
        "6992914307720900091625850495097564336893566868492558667583379960647579954874123322170419152753964502645220"
        "9815018851332492164470421724613555880809966057218791771626349729814754804973560650793674682363383237004497"
        "1478862191003379588517783537674469445171979807397050229507286000499451324619208184934162672567957907818111"
        "4399636409904600629831838939433010105053112940441364353780773903991851843595958763125312470409739561953852"
        "017096495437565634136727399479205502966257918494308309931284384219907224178314208984375"},
    {0x1.946b82be44de8p-670, chars_format::fixed, 719,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000032247460965"
        "1804600295377863954067981650497106921823374028264261472171109156258578967142316411532502936521798048216973"
        "8157545429617260751948724545161550164929347900143444386071167553835944697344697087864752815321198632661073"
        "6196192472752954130442089237547974876620142022818033285626625689427902211778409103868338300290375416632087"
        "5502896119062450104680129128035887883334678002414605802479763479077509165796055809909187564387126800148849"
        "99019899375412526120418451580793367541540907217356703995392308570444583892822265625"},
    {0x1.4e2c914eb1616p-669, chars_format::fixed, 720,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000053292453195"
        "3875908539985563008290215902251892089800145159268567401221559574851017261948902272744481687181065927924279"
        "0532067763545710634025583260109326608409177908765413576800665981400561292836008934034151241045070961228748"
        "8674782406889048222974675939075183083749350058926420756371324155844981444967496091500674139367439954339942"
        "0079590395243378093609139932034856238785018363295943683098880386632449051383959973682724787639613141872635"
        "547279188040318374333051363586680061786428168335572053138093906454741954803466796875"},
    {0x1.031a309da2912p-668, chars_format::fixed, 719,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000082640741741"
        "2055757048866712577769208988306963483048452588757830285597514371579074785748875864556108189585740117180728"
        "4355107415836864226327749292226321475119185672293258316840326519229032767352667901178435935016012515772658"
        "6340213926226357951008718726295609928330587708283588016053330527448486920594671005732915018619212965168501"
        "5318329907338056732349660338068617793043851447322041736375085808880727801220330300011248000844427980884934"
        "09434384997049557284279503347774175966576788721074109389519435353577136993408203125"},
    {0x1.a060575f96216p-667, chars_format::fixed, 718,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000265606661513"
        "4470260327011265797749984328048196385454700741542428284140883424514856308075170706221412771217465750892413"
        "7864572400279619393621332803019113819666352713459007233981402275694516349005956646243017830327712282448586"
        "2567538309483936648467687083454023101421747900088673106584510994727995497457418865781511761412333864356302"
        "8626906070446864245505579419695971925496500213147639499943211009347841516900893974938018917246441902822916"
        "9215643606811336644663330285421791733774070365381447800245950929820537567138671875"},
    {0x1.54ecbde19e11fp-666, chars_format::fixed, 718,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000434952149729"
        "3475053093372496822267881905412564744551512923227327739429847369248209024683312612536596673638823546885178"
        "3217815040969304503384094458178092268115210023143078678982713079920236767336151237300129605293701448857540"
        "9843644914093858712844401591080267607833338989064400429719805711283629488600778865792251541980345788332959"
        "1860677420929683457043719638929479106102316101892383059298162219248469505288001393428207449595659030610532"
        "1231640691595930251310123645268261612767922430489164753453223966062068939208984375"},
    {0x1.9b65bb5e316dbp-665, chars_format::fixed, 717,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001049722365714"
        "7530461540305772931267585053715061256250505487087888061029408785894563215220970697678764383480032593906591"
        "6205702309557577375277159458987036426427633182733447713021968370263145361858036928289137615212740149550433"
        "1960559979975536391905723334450553852881134362068216711904999364434749875519041157852477294908282245377846"
        "9194141465743679238160144163995956438907303935779751926152780243481780495784919204856732854249500399151396"
        "209309650004291796200412761177808216423411324935699440175085328519344329833984375"},
    {0x1.9d9f0bdc97dd1p-664, chars_format::fixed, 716,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002110793667228"
        "4170528945594825984539537267894560074842735445651564636232548380045553302817073544554452002495338117462053"
        "4078658991556593400119244710172233781404038272600835408871699423495545285788169382119890019819420166458488"
        "2960325446094595491519667713215219785422905110363553929458253876328347995783978350150958928634440423464512"
        "1978246820592353953489916252647358865343115582584946414230154135689901732367690272225496245117494074301275"
        "43500008710404569387590416050499587800361178668850925532751716673374176025390625"},
    {0x1.93eb2c4f59fa4p-663, chars_format::fixed, 713,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004122558338833"
        "3102048516138791115797958837443685538615330228158010372085611196534261347478949518515573803887042776683357"
        "7772299895100679885999472136933656647575247856639421484005247092295404547283959255810537283939153615280537"
        "7136989128030010671552377676024122283837285170688576898765577337301783627428040617023286366646630475684076"
        "6048041588267560017035084467460711609718511878343601909600068154087444256240183857041447304877667616320791"
        "66770683820072204968831426390708208735980111470098563586361706256866455078125"},
    {0x1.8700df2babc4fp-662, chars_format::fixed, 714,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000007981480278624"
        "7251835728077164402394423392733891469600650972933646922261786684070011768202491345213497635405836392947390"
        "0800406081157910353783243643114657359608848833361253991272841241506805336597404984340460111575666022057063"
        "4633816720601395545604136254404189400125104060973148928687734799098012124540258682432908196877083204176316"
        "9112950312043616184359878531487269768561814660148368024122515583353773744932580874663344179382612758572700"
        "658879417422882008015735820127939371092240516958327134489081799983978271484375"},
    {0x1.b201def031dfcp-661, chars_format::fixed, 711,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000017718621999986"
        "4749278205111055912018589125978374066197669227881315151030387724345170052438599645613022584219802754045709"
        "7953259328816059945423086088311184205880616177141549770021804808590354451776189294939184337822591600499156"
        "1326393998653795376111965350552796482851659510178079054575114841420625620468727215117224421601426553623832"
        "1843973232791164313798871412962471835220626769195827947235622110286129050558540240156290211298337387790447"
        "592797183168010955799288442025804339585715041494040633551776409149169921875"},
    {0x1.eea8eae3e8e15p-660, chars_format::fixed, 712,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000040389599243158"
        "3045713943332535252503895076311479780934520547693664806562418678725835547328313110433294021273363893780503"
        "4780928606430945625290707275674257055573884215037232738872408635230567690455648167913395447674811798960347"
        "6636196737113777359352989798512837038616023039381374775032016160259230267044393895005846414569114236964868"
        "9274980703156713685751795983584096488275612518695440933890975685190809613062696118817552579235707139519482"
        "7800525263513822042296462436685865367291814465033894521184265613555908203125"},
    {0x1.390918e84e1b9p-659, chars_format::fixed, 711,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000051119492579282"
        "8784499200892166815538511338797192605313732010342891943886281580483256028685184519802880654753328687915381"
        "9648906041551028274268562539865070406913488612853213504179833758904018370085949144695527290774041634025375"
        "8524866274063747781132401746798777790016957543570989997195287670003656195376339120010082958104111194123452"
        "3057045814769439813122209299794155552909628221725561202867365610428802774469140416562260181400463623856109"
        "377838127752113794699265665949440735904563126723587629385292530059814453125"},
    {0x1.349996396a2a7p-658, chars_format::fixed, 710,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100790299803776"
        "0352523794006745248987438542961217419593457359470612193547391686242939713156571235245311076881428119502761"
        "7910521317137030995375115802078871982691238309826759371170232609459580549810568192299972653249096884325031"
        "3221638661194719787077329566666878887174893856785966934635413242893764663291559650768477552318529073392585"
        "8486893893322471447037807948195595931183280571682149505994767510801571410366742140930448555537922888340438"
        "63450758146748423007478214340356358069694664436610764823853969573974609375"},
    {0x1.f935ab4c240e3p-657, chars_format::fixed, 709,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000330008036855068"
        "4468997281648174946382804357406648407085135196092613471039301686552051097935919700597874153854575989644816"
        "3001312075836919408774992875424396582242361864068964258493416789105073380194371666385477092586697492100694"
        "8707813186404234711808827184648116380332875382803236194612865656418592304556264448127467316824428949345174"
        "4559312297666397212071127248105910099473454119853995537371389125448670178169533053377812394755221610653250"
        "7338730815426432497099038104195443954491651084026671014726161956787109375"},
    {0x1.a6f53d0b3c96bp-656, chars_format::fixed, 708,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000552560816345404"
        "9291209987331594617821867970163640989621616633942511247613790383333508155046427218235057156316491736183253"
        "1565079731835808231681862371698864689080324447442721208730527087280035670998979685844651802800071539294476"
        "4290733974064232720563277639560254049527765853489875257055682697413713754457568012174731815681092948578849"
        "6812174881480413870766696992766235423337878308651477389960418550866492165533756096688199530990443024609879"
        "186497798459794215161380336108314093035431824318948201835155487060546875"},
    {0x1.fd60024c9f6cep-655, chars_format::fixed, 706,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001330915646612667"
        "6327720798888520711121310973719016756617814609392099367961465512997004022190634798593712344809012654336912"
        "3336008687248835603759825341297324826585552662290670252876445576563127635381521847011482567784244524538302"
        "4757386520155419520590180607348277590132836378469352051761008545687687211422030370707996919463285443656754"
        "3001424200212283006776315002739251470698678414022677441491080589922168267970859024072320361540091755329141"
        "7625497725089895008484400045455087191470511243096552789211273193359375"},
    {0x1.e59d51e4b3404p-654, chars_format::fixed, 704,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002537666484635187"
        "9796446894886180118923517375928916788468439012038559075591863943949905482322123331177881875117581804566750"
        "7501033007502798482889114822353165030685871064806380979997518713085247211620359113239321892013744736508277"
        "8750155424105285638558275846595641108095833746918637233220466393816326595449266228517373855397721233293129"
        "2826069615658590284856893342692154277412999385588950569011586612223617034264066429835291956640345600927392"
        "63995560422194101981991352402767692097995677613653242588043212890625"},
    {0x1.8f3d063ff6ff8p-653, chars_format::fixed, 702,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004172584563963082"
        "3234884227494718580270580351053715713703971375362827503015835943180643599018229301247410673453137023511444"
        "0276681218585911086934300107994205504714104860990795054228564285081786387946659435399143288603999513076571"
        "3915101684430478057187716062578581352152485071389375497738696764199545096908565956533808131306607814317908"
        "5025594301665865165419361839755147261933143617447462954222697482489653056327589852788118074865087443355257"
        "133659824688533856429351574790498347056200145743787288665771484375"},
    {0x1.8159ef44ecc50p-652, chars_format::fixed, 700,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000008054891565255361"
        "4245327177394068343716266241601526344429862653871128012696092458059218804885886107480434857599667923902644"
        "2252671328552262873096601408628711791229287582758527981933915133142134968110008715888249271436059630596140"
        "4470471333694306867890527358826950270156557243671697176671195161373933098056018737049190157906233805878505"
        "9859208293885656813869546314004329986095442735468526295545526700031871588905460237269435492004550566040373"
        "4502280634268682688319158924361573781425249762833118438720703125"},
    {0x1.72d55008d0c7cp-651, chars_format::fixed, 701,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000015502849382509784"
        "3440460370798397879919914389804519263414392212798173044323126828666473147181847563172722840418818164653948"
        "5739004681292286501559984214520409467410522025067113001633353673145348520816452122738504834936009445548134"
        "5858287796349425693893136700437728509978189680979782742705639939458396578936557826813559243399450305997531"
        "7336632094495939639412468591893668654875973774769313075947026064138787210391211167533235338079298709632988"
        "64021730228539197981164725337333010202200966887176036834716796875"},
    {0x1.9201b21128595p-650, chars_format::fixed, 702,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000033612132087463898"
        "0627641406841899354617686842148860032301143446825734706041256966895952741820674848370981567388239748345166"
        "3727282009910827224470704709509768673820498493219005964909450891961198171946450746546423822293731129894706"
        "3876944271555985439646295509571516123799953826967960151184500280021456011548758751801505762629218754188327"
        "3389152455349837490381121103198323908767726251799354114660609589566292021099683629126336132681375017182897"
        "009957109717175163086000551360132959644033689983189105987548828125"},
    {0x1.bf95124bfe3cep-649, chars_format::fixed, 700,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000074845511815508472"
        "3892730981516819500550200911616094734357271511038419504657925524225163693049480606331026030748543057238889"
        "1688588143450382218513326026803605897969424969769987065915072269864794505831569673103769471550616591376104"
        "2449960552908237115424423286884529903161183095179884684148801654944710608786162313126721614660037498120830"
        "2481577617962127682956761128429225789873821642662460485927840445817073256000215184821622111810604090217338"
        "1508385840983168502105714325889351812293170951306819915771484375"},
    {0x1.05319129bc0eep-648, chars_format::fixed, 699,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000087354525906889357"
        "4305134993198538601819826319241490003920850539716474513772902925780905472224882452658349705414899403485023"
        "3097163611935052314576367574441871757087775557264027195413961186352049851840434775056187475847559854756176"
        "9991964884741367086470668693809581118019784131401775478072440977727369632271191569356706813323315849604381"
        "7399119743256577785689328853675146190840651483635609176766549227988267805333064068837038323167938402444969"
        "732430229950789418789762474926163804411771707236766815185546875"},
    {0x1.45af476abc232p-647, chars_format::fixed, 698,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000217846293363428304"
        "3343840105255044439608213317204687613009897078192597109690692465986277592691408555959821894006630173944450"
        "6095505079093888034941798418116106205993729784916404753702422780710280257369318292232376849888355197691630"
        "0540442163418491631515694653811986348691337937295430285982645590934421669065895422886406865184893196951399"
        "3663120591434024270813103802297202805654045913798305355456148879564224219171817120132287862611600613532154"
        "24961010708322035390495374773678349811234511435031890869140625"},
    {0x1.08742c45210fdp-646, chars_format::fixed, 698,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000353779487507535463"
        "8913487667852550214946932963610024162769754777754049503207158866648586079495607698068514216489730410356517"
        "8852282691667659608840113035799925615101335443096451382460948062815012073693165291377269999829137971766737"
        "1885531914227220137110388078345964125965517531862537092344718621338433299695967540557698214234665287119367"
        "6499222460810388807942854755170323220878245060297745028548986169193879532454353341863058408893334590778864"
        "88131187709654153499168327545731926875305362045764923095703125"},
    {0x1.e06706f5cc1f8p-645, chars_format::fixed, 694,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000001285340064812500204"
        "7663650303839837768770868178827228680425989408577299035277697772519128024365042269006137521958339388319697"
        "5265503479494447072597343928704527629935234980629701495621199539547037556144229442345470079606428052792040"
        "6982515008146955967451695398724643112299643103663775673910972184612760788176258685407613564239509832076960"
        "3757825318678910573482963656312687065092042077801896417210663056529091563705356552511784874489831495682451"
        "5887701286388062303644996831053504138253629207611083984375"},
    {0x1.c3b440515c5ccp-644, chars_format::fixed, 694,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000002417112508347818585"
        "4577296568973058488028696120773687858171527751677783966413609421158848849895950071414992776742766462322480"
        "2204953078177500746806460413182965492695822167375307505348079714337003905535333983330970718150212643108119"
        "1942010252850595523287033985789669321526444757608927731550951889320987373819142026991025156753856607046775"
        "8974459713102558552732954856343026723690055888710021350990995482922051405478223152042970325171164381289806"
        "8027460606431856653120160416392536717467010021209716796875"},
    {0x1.ec1433b7cbaf0p-643, chars_format::fixed, 691,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000005266324045366900913"
        "6451576689712462018780864628757726838532298564973456520124312425159168990966344080685284372048038208798423"
        "4515131775332141605827039252921143204800571618187675999431430968489137764119560673111591675947868505036349"
        "5734853368006928166562436836138049592492697802548236478358520529617766739001729760991012386263493969655414"
        "8089055580137656188780075461507170901101717759741393603409206482184290891472920793565653525360904603890315"
        "4631796610265874469813951463947887532413005828857421875"},
    {0x1.8c19569a7d35cp-642, chars_format::fixed, 692,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000008478256274282182518"
        "7637774072036156880782589649318925320904558902615305403899383502544659296812445003369004692272970420908678"
        "7736189120322426639864121576693397330358676265593198834037152235715817069429196893999010101159401639577556"
        "4940509800763785671916185917507549352955056824078478279323005977928175814655943739879529153802192464682133"
        "2904342665749434907103144778825208546062155400334839930506320175047419033723187526321855645168117515248133"
        "77187526721215880820547994289881899021565914154052734375"},
    {0x1.173cac50c28d1p-641, chars_format::fixed, 693,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000011953794466200874950"
        "3089102238478026639921052296675200014471809570790044403441032909195396359467854674486635101108320842702261"
        "3298248493375000791593832932371433932593882735113346414977063157234473260032991012413221117379942112771102"
        "9828749938473236600379940134825736762734725227898037573008988801081557260969989479404890006031075166624593"
        "6091224381302042298327178250130131804494601858274360658601193326491878588046458827201053492998972995592881"
        "612034128274647988565693168538928148336708545684814453125"},
    {0x1.08135c62a0056p-640, chars_format::fixed, 691,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000022609509033348430712"
        "7953571409359772803095127336982870579907579119353490218219476852343306243082097399103467772270922940612799"
        "1080253983816615286662244932825455671700708034737857635423884374419500761222456632014380804220304282042074"
        "7378237753242365104911041411953627565913238812923726060254300475841047934769828299971163833702491013210688"
        "4368456208752682043195109425417207350414578454666981015229526221786807006629498234932288311629150104730890"
        "2301260328539765642741343754096305929124355316162109375"},
    {0x1.72e01124a3b3ap-639, chars_format::fixed, 690,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000063506864504234787217"
        "8929168588729103731776207466253764586680356459178885863289433494789731250844399343683952454007404739476733"
        "6749725328888569711409474803055530435807449641300011244092091474018423418952728173503582967907318694311580"
        "1574751104695176376459974319398945754927290668438086171312346739449765872904568371150068097358639249101610"
        "2674324978548862178535279004153515354065688557841667305151505498091184549204957731460112041598585348160002"
        "997507320447907741556292648965609259903430938720703125"},
    {0x1.e830eea3741c5p-638, chars_format::fixed, 690,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000167190923074967877248"
        "1055941962541542126534534498202745103521416813473754421206073199908259895165254281215308516227579576489577"
        "8735494523984297364116892188309417901215384208003196885624368929431305416422077941961631852052529884088373"
        "5259511842062191605411293040724181397647254696152715588357759798505784923294550394615297009173171305766832"
        "1239633893088513813960814378062459350506405709672403745380004055867672638841096510800085511376306229931840"
        "104611302550048634874002573269535787403583526611328125"},
    {0x1.a55edfaa629d8p-637, chars_format::fixed, 686,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000288613756649640442593"
        "5836871058312095311794871761541473264597878184472595985606367097373222668869800877529088552860298321376034"
        "7946479274851840572577603463445319811450034511292436661004993488187289413747157834399722720957051814536777"
        "1828193789342477235604363994624973813101513850874736399835055553921246983579323413022256111347411962631273"
        "5400699442241274001058362449373364010127032398605780375222148055134723634623868533413931267400188526019835"
        "69028279257018265724354932899586856365203857421875"},
    {0x1.e4fda41f3dc12p-636, chars_format::fixed, 687,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000664379586224470887670"
        "0882126955463017095346819946382451479929742057573428918996527161429215879870342327877002116707737471812527"
        "1022578143361434990908293415374062860783204142547245813244888835503055355847444914026775323520290486751277"
        "3040962885818846901220232893236930669611199419249964239317528893854558190936267026566141425051313849752100"
        "7225928542884374445025424006780454091529598201395448030060249965799465147365051550806948573291876921601661"
        "574797868976827164289034044486470520496368408203125"},
    {0x1.b6c6d5b913315p-635, chars_format::fixed, 687,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000001202143587794451254987"
        "4307758373463485567732529548696497108946777892373338498825233998851190169288250470729983756551049200325340"
        "9646038667103199192178730894714971640838750321839454360839834009539364164168776033623418700333871719470945"
        "5390020102928159467155523872584982511528028983638984992933752520154204626796100307564534943738721194689085"
        "7172860201104002606422391817193670983149333434914995143903809339065936913317470198921690228366842475023103"
        "730967012105212976535995039739646017551422119140625"},
    {0x1.3d5cdb61d5eabp-634, chars_format::fixed, 686,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000001738996455539959270302"
        "4922101071638710228058853010454955816287203412674019899135279944202376472905021337258625896237726018892889"
        "9086845828533503606946253121325963450366034526072666759964392438712742370869822534456387489474784033525648"
        "6925055706840475130878149016154785918583949575125805400818453276293215346026410674679840945211540500433754"
        "0444738954378827964445928741978867217483445923848187815353826331562166817109812355851913263269115033658801"
        "01742535317199678246424809913150966167449951171875"},
    {0x1.f66ce3d3a114ep-633, chars_format::fixed, 684,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000005506102911439653005578"
        "1180408544466257723099083034183419703118907194804421094663580781660676273528898210088043157496678446111711"
        "9754411304894464276186456426615997746028595767878242155456834626624868962582541328173269874309195561269455"
        "3222682503348082494541469600607497030280636718224508777918266791407040625019889179303603943253832051368754"
        "7095452177893522474675770324240828465783630281774188233607627719489884195763554935119805608804359250562788"
        "832806214445181325345402001403272151947021484375"},
    {0x1.172470deb171cp-632, chars_format::fixed, 682,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000006118268064240605714527"
        "4956363318000274544013834890966296936024088988282930612184978650264904063655374278708582004982437326041559"
        "0233856953389263574865715472704679815904138025683990166563353576868412611739320572220306167036383303769522"
        "5389013764717715215814805406610147515377607379775485559684197286852537353051075869007562299900213368314710"
        "6802833986208071593930453200187676542794020322742581458245280814157780849754554959666206298998924518407900"
        "0110764778863625679150572977960109710693359375"},
    {0x1.cc8acbb3ce387p-631, chars_format::fixed, 683,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000020188412709311976353396"
        "8847463117825496600276996261344169082492136032863543011831648858571334555566261701752986650828364633304418"
        "4467038786744951677948833071723791600087614960102937653691668792334319658741997691461247264270712989910977"
        "4676963858447867111579389970137833126738825790174333853081246016781765389898239014268504426857552292598582"
        "7575131219352802416195149318400300767284708891985212138097090862874407767109082004057353578117944082355823"
        "88012711863023440628239768557250499725341796875"},
    {0x1.9d46d3757a126p-630, chars_format::fixed, 681,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000036232946244639112367859"
        "9034222123633353467207374535237316730425316040231727778261368214560242254952821355279147249851468071176677"
        "1401620080053891581170323531895693937748727877484376357346761417436052398995962478079173907474651509305526"
        "4266635365095100713321919597667540136749723807220847445420758981591982639725443239909862127078321763680723"
        "7422939172478544940856503420152322393960593225744469796950069542703289361136545581165109048996725791055641"
        "976122492220468984669423662126064300537109375"},
    {0x1.5c67ae0e78895p-629, chars_format::fixed, 681,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000061090986836497964518361"
        "3034251803677236517703159998560778927294990338309622508444992574831348449932865299573396737151577326827495"
        "4172919206030684034095396504315336582435878961553782991955748926193970550206763007484081137435305555643552"
        "2138895914617137092399936383134815807917765598260378196445832081792336947146274797124038277978644551890909"
        "8850496398248618576556315078630943074008429474547571168137788454818734275718514862324305325582256049241387"
        "124183744194994005738408304750919342041015625"},
    {0x1.2f87783b2188dp-628, chars_format::fixed, 680,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000106444494521393955412029"
        "3562115247343756377243487613631475018606616016886866548552742932471940087312652947117762081892330009241880"
        "7938199458932982907434008164124277908316169896297883791818928979893497865768452217871938696060258968304822"
        "1276340627860312652496975952271428426254825821668512842041106458866495101696667393908452425062908044661195"
        "1749184112580887560614735875984935407829451159190376056173778082528014814837904155465756260167144994723578"
        "38456837431095891588483937084674835205078125"},
    {0x1.45f46f0331583p-627, chars_format::fixed, 679,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000228617862225339546463393"
        "3869150977954140226476306611561116275116133228638974195199741021195291306564050872265758690240115070370439"
        "8719380294227416997052161951256350653209352580842353263790206260382725737738392485788340428836466740504832"
        "7486120146547623228990845060225911954280445788970650881258700268953440414567426028989215999185465069229332"
        "6167135314722644650223345597852365197619401218926106143322634491976351864041964794405459684276785193309357"
        "9096245573367696124478243291378021240234375"},
    {0x1.6faea09dda3f7p-626, chars_format::fixed, 678,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000515769054862210954959362"
        "9126143515284893647092851878483329360823349342532024278852283016013650378000284570160481222106076337348452"
        "6437814702584827526423100153911962913962801720855275222978938897800051178817984260633179706125463586728357"
        "4036004545197262845773427069014263159092844402553818370891779652412651376958400520895665884571049344041722"
        "4854583096664283015562359037321257706712436261963397344208984603540615634271876312622767073101055486120613"
        "234601872676421407959423959255218505859375"},
    {0x1.fd11ba94c244fp-625, chars_format::fixed, 677,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000001428201918168743641580506"
        "1570582957797941162203963167425601499169707767566576137048543241444320531168598156511583688427686195847212"
        "9897937475431167531842729039094949094354884306009515806723673286503437496509105787378263832730335840309201"
        "4499545668583556513012056701640438893215817552078525004382652304169786365593370561594916572058052968769945"
        "9243337232320280125250787257153626075271940536628789995287096375595375273874864083007789293393194551628306"
        "78485175184277977677993476390838623046875"},
    {0x1.c90c420cf0b65p-624, chars_format::fixed, 676,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000002564510265800063807766265"
        "5089472362542882984305302201347516398173403533180585976534161315640938051666852184516249354632293221050056"
        "7375141201380918228455858352480628723115250797285514387548153230939412238584051887667836321420415401514120"
        "9497251639796833017773424919290240970816054977116200075111851757962310125684874866527111631793100174964969"
        "0210063583111446018923027887259222427377589680137555787871347433236980870707367622303054550973142518028192"
        "3215108719205090892501175403594970703125"},
    {0x1.d391952e49017p-623, chars_format::fixed, 675,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000005247085617955439691422075"
        "0697206729680930693393806189392472186972317553487714556786098233769482799791950847693693459834579021626839"
        "9728663746626185262113984143990716591357062201655858886386541140904956275446729344345153423037862697984444"
        "0459329023491130157174730485458049630374966675633574693062515331282157551074828734058892777864602540193250"
        "2132098401926185663426957522247203760063557453586246851349782431341310393754891747355941298035050636481939"
        "345667768748171511106193065643310546875"},
    {0x1.e503a112289d7p-622, chars_format::fixed, 674,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000010885720130033327524143787"
        "2765529244852077494742369477459509342651047244598374475232481184911356612413555554232574757514637326804013"
        "5876652521025979481372233742465255701574216453851850773665954943082477224263880753119476116577310064807731"
        "3173127810010776926951954126705625347302718942538734107223165386053846061743415904126374880046187387430900"
        "1371907275412415986910905389530960445916397265583237461437838296424402663589369706999567230223368430449756"
        "84957620387649512849748134613037109375"},
    {0x1.e034bb81e6223p-621, chars_format::fixed, 673,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000021555608982793881032727700"
        "4540968764480579568571570505024962616865742631615116082852242467220033430009273037170918392497696227267889"
        "2855734329337793196374074077906107741798474958876784395016707482885851968709296922631032851601097932395854"
        "2929769636255440339987971068117759495033682455054731633575352264020137520998691191325549281307961732743070"
        "1664065014159113051007049027294417385656848243327407379757324330354356057073833205658622215952604833557465"
        "5023805235032341443002223968505859375"},
    {0x1.7b3f7b7659658p-620, chars_format::fixed, 669,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000034047560211390398233126309"
        "5681521292291635730852337465299625151417698607026609316841829263617487716740419967495013736445763182743473"
        "5109538407361638706698218674138096028710135167744227329690414138172185751796380050875945116419344891273141"
        "2683260466660309502705263508594214867077018498322662919022245296769732774129634242022391711546658347775048"
        "9319804904665210544068620174295287490121780224036319569306523046197506575595216823978488395241784846001475"
        "983712225570343434810638427734375"},
    {0x1.c3de648e8e3c4p-619, chars_format::fixed, 669,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000081134394501696493643970170"
        "8958448590502242119848052707979349489721600419940655926461604975255618475404233150813807595154285254949233"
        "2794224255592679462840835674273478876350075563767085192465140862054717785123414363518932443771014783422046"
        "7755337811866996207513082672638554911611527398619286206143324159777057005675967664862641318690146376278630"
        "1641433145360549048637471436359609252939227081020258145036152809972693933016744703307415890333677450929616"
        "981056824442930519580841064453125"},
    {0x1.5c1fb09f4e5a6p-618, chars_format::fixed, 669,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000125013356525501566921482019"
        "0756397189716009459935755363577571000079431383938798649139658042184851112712146728342127592621185516412687"
        "9795171483134847347119197259993669087956672047493648606916988245162007574697567061860707121759570383676749"
        "1895912187880027559965868163003755005006934407345014860350754751682443596085778380356571835395956213185132"
        "9700175990805493922248400632256332804710138784602977702939272921306113799173519196290497784021327441761339"
        "827053234330378472805023193359375"},
    {0x1.96cb5454dbb84p-617, chars_format::fixed, 667,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000292164551451979908816970760"
        "2906968238386236762223990983897090126665641661907182378337682656506472450151745907015395922255032710247182"
        "6621854724862603904799242549379013755638688487646302105947642271040607916570764780353314256670601811103414"
        "2393048937580440691645308998693147226694463319568298046502370889995217710647026826901517825918460806798933"
        "3594250399158272041774723734295398882676620527578590726337454864712217649593312757082596259176638514576396"
        "2327691842801868915557861328125"},
    {0x1.17e326744eec7p-616, chars_format::fixed, 668,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000402036891910035001370326183"
        "5764714669495293870775410413117761488534112347254852152707553781669864371194117900991196066188913092094076"
        "9627436025320342933617917135113353168931505731050779793171834786790514287864729512953780153718893963453631"
        "5925232559264867798326985595199078779815424832599279718167822934433244010294826462930764848126385680015541"
        "5081163596886320108465071997702885841948775719040644829951801535215970389698672803213886459437536799454981"
        "91727892844937741756439208984375"},
    {0x1.8d0730dff1c35p-615, chars_format::fixed, 667,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000001140601491854304861112957904"
        "6078472017190434076827676333703184492562745517458722933909773128140863811860680440723519874767311358167542"
        "1832304460289731814158715726226721499893358385121455295036409753755696291856376809878491444622602781279561"
        "4298253285437604990024681376542185656441137513607157191982929093989227066316968345458523994262768230938095"
        "6856546873709262441718817170600788510391208708618239903357485935403444561300988952253751086750397508717824"
        "7349584125913679599761962890625"},
    {0x1.84e464adc9bbbp-614, chars_format::fixed, 666,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000002234456407425392988160245295"
        "2105121463033999896331509753060278603561383062671020092513964622839910827392979612072505380639591971850586"
        "7953302822071585340945473684155811269041734009391899894892884998655950936230307166985243115317803582559672"
        "5766172839564272885227331529420345731439115502642545507672856789487309544230679891279458896193196132458740"
        "3615865918507170866263260790615432342540019426259929855207218540356013049043725298895767697004814678063411"
        "292896489612758159637451171875"},
    {0x1.0f78207ab56b3p-613, chars_format::fixed, 665,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000003119559897062789212478702782"
        "8771258554467274331378106474180853903784890176470576278085246910031864176926682381009757593827972184358523"
        "4379937227458526717860732051290204395780473433869536107639158198822468448383115985094636099649840128948812"
        "5559457224226066168139585512180838489229070664388435003461492126740239264693377932479421857227522247537141"
        "5195959735820466509414273243741084753632448488495906132266682527804921511867261441349881244530437007789203"
        "10767716728150844573974609375"},
    {0x1.5529ded69b52ep-612, chars_format::fixed, 663,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000007840889282617378434989914048"
        "3375110468365507426372771215508168337980921036043285415746083661506063036302466033726799126430809923626284"
        "8998613132804398487495251763436683220632776620778652222684238885184627406388017322992084499241930369275029"
        "4188388326470646133479933189911245652940004567736087396799055775383956456338672302480006246520779594987653"
        "4463873259186889135949555497350644501301606934956057533627187656477601229539927078260013316828025420335279"
        "704886488616466522216796875"},
    {0x1.a04e5d2b8832dp-611, chars_format::fixed, 663,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000019135749100368870646470019839"
        "0262952327728712239665529938333681387879917544259402053032888172184347996533360676967652656209466863703861"
        "5650212192538996283931574068143975939412425055532002285154138267248351272320519185851595688434551396579504"
        "9048363748503832341974546972797132904308785650071473320174774026694645358673515775192868362553696596252586"
        "9243235045262356311507524517217651891403639732096190614798119668651216373161579595099193750774857480934088"
        "016510941088199615478515625"},
    {0x1.ebf813b0bce87p-610, chars_format::fixed, 662,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000045227279193825361739063351116"
        "5816088894220038747993788047324185155542688625056340145570989028740361933186216690467386983882756961652575"
        "2554075245242312500128389337302506248357336421615574134467730176141549296104524998635489828297481285095734"
        "4018034514803369509095471164975265590462906153614392945616567352114257599835958658796913640401549715379516"
        "2213343596961334963019303057799158031852299505468028659494469866878455865686526428769137627913798915813003"
        "98684106767177581787109375"},
    {0x1.c8dc05f944175p-609, chars_format::fixed, 661,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000083999229662967713528086187594"
        "1734181721582943453713679770682887344457568102457262391541221214178048116785539260638908340859917786703727"
        "9505483395285085546986591926783022944458139895520106489883316870842496789860725134086126172959651037933921"
        "2932675833731449835177604422499681212807486567909065953977706557577852435843117665011821890292937224415194"
        "4407190599525788891487127925011008301298436891926527553092511054346791910148049449840910399972537803137129"
        "2308904230594635009765625"},
    {0x1.b3209b1f6e28fp-608, chars_format::fixed, 660,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000160007032096671255227914624485"
        "5932247987306293322327633334915277238729554926380285362725895588754187504410829470800380833095408524162170"
        "6088096341188012914102423428466410628525126202526153749617372677963548106623913999568183279653957322862821"
        "8216958967402578450494409099521871624849947515643100378317721954170792449254983258149261584544709424748265"
        "7027764663098328744606276097725901287038160277123370277167439630181736840759407891672679545569391024173455"
        "662094056606292724609375"},
    {0x1.5eb78be3e1518p-607, chars_format::fixed, 656,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000257934513258245514911410956676"
        "7562491252934434271200538926296978958690829859567102593189280347819932250798685230108492816467372748857184"
        "0826250257687412060697694011629067923734034125963698115546615166584861817323240326079480806578051329196807"
        "2293604483722417509495763200324740129764135772142565726176616547381869902883598255059031376990796862892570"
        "1707243543973426496727951436282295386607338694004922738045019598655644155617781674736874175657419527851743"
        "62361431121826171875"},
    {0x1.8c46fec031da2p-606, chars_format::fixed, 657,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000582883665073076040413742690611"
        "5103909148140022514359612576808446722817107364758841777661151831975968413666955572913538522125935081938480"
        "1826429486676475866814876109309418283302171512609831798840104165292921800206023581849348651578578326708382"
        "5667938561003612904320383015971953887054691593216595738675834030671283768765741396909279577202197486279725"
        "4041005408861321458736807313694753554134760028963271223622555231690394620121743439748913939713048648627591"
        "319382190704345703125"},
    {0x1.86231c6dfd804p-605, chars_format::fixed, 655,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000001147704191955315150375531124228"
        "6463359086338700939173534433881149141551312845676541528433370751398526129520536020012344236954486162733765"
        "1189410728311021716825316418209072205209059768027017097741944446106051476144926058634185661890784220028337"
        "1765359783819221589931961870907795236477229042736793261103112697240517930987177209588268015525779946791717"
        "1661002569274579372573148249479204708825803923891308204782759202811211858909414701163803629313520104915369"
        "3020343780517578125"},
    {0x1.6f91c9cea3db8p-604, chars_format::fixed, 653,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000002162629407013831871202182833901"
        "4812165466875626132428688506066130661223800325245624218990344615529115525670749882601503297142177345848008"
        "0315944694557039046086653470574190248564560937128913048158665762605822060055463866322246382019655628800529"
        "3509078032902091923457112717105630806377089745970685933260769211709292606271388326560215405129133988014651"
        "9818852439242793594288516683321266294987653057491978352698407891148399388724798573721552763515774131519719"
        "95830535888671875"},
    {0x1.2c556f28eff41p-603, chars_format::fixed, 655,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000003534083085250713196588697362884"
        "4009684695670072958139623317371787746358871058121738979142765604242918427270683241572493184281442612016647"
        "8731717470396051187190782581219012149682498960891262131383887862540827723812764302327419934805449703626395"
        "9980391539791048593977360916969031572048106601825361653601806771067623066557405101165728100046261785882799"
        "6936464081367646380909919085410798272389504087757458521098222151497599140581734611116920818929543202102649"
        "9569416046142578125"},
    {0x1.e2ce238120917p-602, chars_format::fixed, 654,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000011362518681203582246140939809705"
        "9223323329750156082286044639648432325619883104525374377905680212909118662350839847885927093395163376953078"
        "0649407320374552076732425727447144486616834978424123328240435501922796366280503312783365917365174312756198"
        "8572368456666284554871791776494899439446052728289589990958105355180415493189818268179755941618181564000540"
        "7784338743308334629146202923761771009708242041718279364773719393293011060833410329727610754702027406892739"
        "236354827880859375"},
    {0x1.24196dd650362p-601, chars_format::fixed, 652,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000013748749674401770954459165335871"
        "0817668762928858869536383184052080983005439632688737953615326333515273092605183293467910096607640374531111"
        "1830830508814835515785355905748622176053926586912542510160402062117321762649513738716450171265643756029288"
        "0656933026350543942598594789753370522566816764442872597848560704959503464200147147833503265827822922002568"
        "3402460874936529235179643880011367428188255501497400935841710308348831778207986640399917988020206394139677"
        "2861480712890625"},
    {0x1.02bbba1fa294dp-600, chars_format::fixed, 652,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000024356505490995989137168281913610"
        "7318300195609360559665735558886820956116389467418480581762255051188661816646626267444282690413817201444989"
        "3795379843474624297167025933419508764610709545226859545525423267148372678245393625964579526328349325430932"
        "7948354175229582990655951038920732423389522537707078330518124609826977512391397642546757797290343067143148"
        "1636818520619080862711069451537886787670702841766022628816887598996680028595230877580535278070783533621579"
        "4086456298828125"},
    {0x1.7727a07c4162fp-599, chars_format::fixed, 651,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000070632264615999984553004824523934"
        "8283897468159126630872763421931645355509398841528836700413839674582977495411936486820912787231863213987513"
        "9732279777697874927785641034817652246495648429400839683868896349629374101573069328602934415866941417964147"
        "7778991331825910198740299059709639508701316549619217498679468403879124284804538594740895098332413481316117"
        "5020589785207957510152588199416767215272118503559179297817854115327571908552225891930742562863088096491992"
        "473602294921875"},
    {0x1.8f0824209bbd1p-598, chars_format::fixed, 650,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000150255416353796503238078049262513"
        "1313183655790989368653096202076874532796262768734136081147985410699406855342631734193395304686021307845963"
        "3625382833323965064677164571736947384885291112411592881140044396780914024598132155156214698736369926767688"
        "1706388447416844297101906935142001824747991763834646676407801031790115262730812163741809882810243615841753"
        "5712121276660471303203703997445462957681945192276164531001748843715848335096879964667415663370775291696190"
        "83404541015625"},
    {0x1.38fd6bcbd252ep-597, chars_format::fixed, 648,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000235712700143533653223369319506338"
        "3685611322315984499867376583641592003520123238822480733091626959027132489043347310332422282332634014516663"
        "2407251390978949674797437265536789249726404535232298423612295401912372253892958284036129629125122165807669"
        "8365258828418743091325273815121460476829034268030371060463325483826466509899620357858435828090556121781442"
        "1238282153146407800701708790804195215186079052909417057069881006589923510391969274646584153742878697812557"
        "220458984375"},
    {0x1.c012c11b55edep-596, chars_format::fixed, 647,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000674887905042332015324048210127833"
        "1502439998508787893391432699367881011894957365460991991605179947757459060525555878203957825322038920950910"
        "9252093330695496204972405029787172312068416266365540069370928438467957984442296261215105474404132053309569"
        "7944637666129056903335338002909782715289955453489346958075162849226922751023079456543002218531124432178119"
        "7259739015770754506414529023440291894714329082622622972215277366512912337768656523273591574252350255846977"
        "23388671875"},
    {0x1.1aba0d7a89944p-595, chars_format::fixed, 645,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000851686068755673214987276620373728"
        "1085952043392178312399545911742550474447761121572681949922758384553961681252395804477406167243534340829825"
        "1404715463428815375105825383201600093367466911186381913978815658791653915337152942484396358421701705185374"
        "3753314997692566402365290532001538051110759554425967289016047067802859859690076647062973391344549104412038"
        "4987346780876600067145267828322886717207767364116600071977157873861187455284682545908481188234873116016387"
        "939453125"},
    {0x1.fb338c7268b50p-594, chars_format::fixed, 642,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000003055786593521295839437608695717332"
        "4154082751196112498539965546191859384115363199888292606660746361125668283340484037571383831699018204666021"
        "7446344946472933812140353250354288117258476863349697332813418892391221042590921932812226156621483821181821"
        "1400416693170662727113985478183823335721980028025030361593055215041959837190521923332064259055002146620162"
        "6391931891093110222234205139677685160791537656843706503862113584384899329926543742885769461281597614288330"
        "078125"},
    {0x1.51b04971b0adbp-593, chars_format::fixed, 645,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000004069012575835781931389065310465960"
        "3597467313761268844991087784245249784829428847210475329294275518716491653412136379666423494524195163953742"
        "6384878238066930222719005716702736354770121804434103616468073547678393421386666695621433539998263784859566"
        "1597381697776886918409632666455919979846021303241798302378411367222817251826090015529123859996461440512599"
        "5189283239303437292544747420798857552235240907507102919238856499693549029737782429805292849778197705745697"
        "021484375"},
    {0x1.a8ca233514955p-592, chars_format::fixed, 644,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000010237088948578388358098853060992576"
        "5833678165699543519816739026811758277103573884918911845878259246763776340849697422669866470721371511852998"
        "3010847352458996891915187839673050932468688832702088095025858634405865838719400606468608999474499247944762"
        "7517060907115025623620591611579466797588648126715963228770596324739373609857690212696944678148132075078524"
        "6832813540266442635758464587874453243448908378478833771696540049938483523186971702045866550179198384284973"
        "14453125"},
    {0x1.402ec07779db3p-591, chars_format::fixed, 643,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000015432289335652199429529596192176095"
        "2280128995355532335903780230002439902106171681964904599691076173097759759271595161852061445606846570553485"
        "7516299229776852940266818037569697974320880151630866564103843751340348456654787834477195943853030778904275"
        "8121875202161315084633753288551916067532158081233435391266806375281507495586400182624672163254831082909010"
        "6252418296293784793912536957393210090528948166507516025010381931734137258421801774943560303654521703720092"
        "7734375"},
    {0x1.f0aeec50d31b6p-590, chars_format::fixed, 641,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000047878677416379371549125789239926548"
        "8275276151541240457915349794344887203244731185351753491754511165749554829196846477560962493984753090692845"
        "8091661656860381861855985455168049554864448079349729639474815768229922801413673914161293747159398543359951"
        "7399823133161165766628860143208254408020613956065686180510699469311110843403784158309126949658184006386667"
        "1697437406874245500460119275042566472879746420364608831114323224783157692541202266056643566116690635681152"
        "34375"},
    {0x1.57d294d3c2f9cp-589, chars_format::fixed, 639,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000066286789908919767154439712855163324"
        "1654856471257758794690825235525357844432318820659861994055782684096716141775524355094157699459438893136009"
        "8433133959264526500722798022081521365031163160858263301206457060475360690707532743601948118549864883622173"
        "0927205677352442792084202886242692144199012459097697320364733506063726855287774209801534211907607596434562"
        "4292711126381340661949671547560893038505110852732627277478242436357762368270840624973061494529247283935546"
        "875"},
    {0x1.ae73fe6587cecp-588, chars_format::fixed, 638,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000165977196475565345851259092100739880"
        "5366476149743750311604392451903207596846739213843409678237113377169104146929663595303028938437023429099489"
        "7722409322578884085024115852600249581149079328402999435544793620771795317010302025925238906642933916602274"
        "8325256470690871053379233058112221779997889814125759915031815714329956264384917577666782736704616810992236"
        "9402275556469164467258730128554765023143883909572262187349358310587896236931726434704614803194999694824218"
        "75"},
    {0x1.fb67296e3acc2p-587, chars_format::fixed, 638,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000391296163618354749958168301134273711"
        "3939478374800690677684646556483173479640008227989372534824608807782087337247737217276479692375180018718334"
        "8834990540475128812272007525804236832383235927143031196440133464921993395194253059660135062572626327844897"
        "5926556105706094110164009778376798762079990792706460418585939444700299490819050738035550792734349962122210"
        "0683141335108256011247632041082471238011026898148078121016447315999933764807394709350774064660072326660156"
        "25"},
    {0x1.3ed3dd4d0600ap-586, chars_format::fixed, 637,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000491743331852018458857016433048177192"
        "8528679311940238534399712174383421525328918259752617995061995340007505682153275698606542935712773259521689"
        "1258580806600352642597941600765812136735054533090439266281829629055509583633628759727182097412609852849993"
        "0542504397083636917202583019328014246584974422293036894918411259098493725705882814892400902400193980681435"
        "3754156336153177138490707869794905698617635343551805241354135114165840869659973577654454857110977172851562"
        "5"},
    {0x1.c7fc47e8e35d3p-585, chars_format::fixed, 637,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000001406577213166360162473160513277137603"
        "0687013595023265826246899604517310916218342653982498273578257694903797846863803354592312379775735833496353"
        "8697635759700073763508738768671726201090282961141287767540599357579432684254257072374457660506218693806043"
        "0296209980469258502851293064721411956550060490555280947897869268535238617974651676834143674410903250011972"
        "5007587257232992073560146104583620982534044853267658149002760617409663046473156100546475499868392944335937"
        "5"},
    {0x1.e55c37b92c6adp-584, chars_format::fixed, 636,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000002994378876442696674396459452237561435"
        "1628056540175421741903002166035225397433156307925002196026795564333321860800732260023990285767473609688728"
        "5429346165120286356617612333602815378437074971902704269699125569824971873496545479096037651978579992191150"
        "5099839114997820088040932021308668960743662393965366462481244219250884957219823927613294786002919454776580"
        "789553414262980289198712932020828133788777831646220852744768984882856033280518204264808446168899536132812"
        "5"},
    {0x1.d5f79f14558d4p-583, chars_format::fixed, 633,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000005798827328485946924597590924421122623"
        "5064534468838026322900953010973310895710460351625303496060697525894981754846799448233472580657311979468109"
        "8598188149502821244093362724432709697646779140442854709952519834481575355268547379497009069253572433783139"
        "9571800371346050428402437303389817593443709839557440032105433568682862475767560783606540728946436142711828"
        "5829539423788560868340267151754097473537655899023331355796062082375019741675714612938463687896728515625"},
    {0x1.02af8b4a8eee0p-582, chars_format::fixed, 629,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000006383737379183110916446442922687934008"
        "9313583401475598285331493581326429673206288607877477935245231280837188564787009132408304294846616842779757"
        "1451303935851646140779239476004716342445942378983444119379324329844134615146761568247550674011002948156021"
        "3541664875596554901104780563157049593014023988690619684414077863454296787671113498979822685277179794826213"
        "573655430103650891087095920565370724154418138047903578491219789281529983782093040645122528076171875"},
    {0x1.590863ea685f4p-581, chars_format::fixed, 631,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000017029147394060241225903488954267271489"
        "8923273869351644640696094496857025633242564905561571190377650128431667310922276302573508422178617217778935"
        "4428791256123022773256234821051426574415366415907465929726112804747693325030138100672596616353372172516265"
        "8362102045803504170975831620913372551777275351947103236723323352059524514418255814217675702145734323793974"
        "25142662578183158464648926695498204922699256894403776088999825921721509303097263909876346588134765625"},
    {0x1.88afc27ace629p-580, chars_format::fixed, 632,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000038762215209996964796089923759037167832"
        "2492427536823728543378726506019728082716395831747267001077774270084925501806670174866216009677450964270651"
        "2953664452990677612703625554026920117242807007251381456932695999254649548206525351444569181879737766662552"
        "6547211377515140335058410910399988637349337544609219968737913624189813877322683660487034814611363469602337"
        "211596081779924811843071508227249052874980749704115988758129120184126037429450661875307559967041015625"},
    {0x1.5c7176f603643p-579, chars_format::fixed, 631,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000068789882161917508509670824126173614140"
        "3044742680014921956399740581562886162916885542186221362873370531080893419613781966113824431849672860148904"
        "2181743880051639476019384315827153826089553979286803568580422895165618106610762680714571764269279291838992"
        "3888446076356769915331098530401145137086193594292363576582306654955320578191159151869528057193739314193893"
        "58263737195692350077525599803438550915864524706649698538771763034471717901396914385259151458740234375"},
    {0x1.790d4472e6dbap-578, chars_format::fixed, 629,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000148875621977114469089781218362547566565"
        "9352650958589949975668943679471235456361871557534887466361271920586088122046839151996105339750152693202655"
        "5928166613066923295230654743312995775558321121766534557827242501067824918202897819452663974735126709356625"
        "7944302826094822806715367278970623926796793796461752341109155299244693461361690545605128190643011578010301"
        "407239990086636328070328268988589415096579914050756027741641285278006989756249822676181793212890625"},
    {0x1.c378249bfd0e6p-577, chars_format::fixed, 628,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000356517430989046641453828113599111802600"
        "5886155410308918526898215231786380968751338156154874284571624448659133395194372223630162733565207651264967"
        "6874971877773732310584587588016131582809612550593957474653709571679682043186902660149986555651445502728962"
        "3656178984528924160938846316861374702652784376098268000158537825961986402424669458870213276942985979758358"
        "69968250249240285430911246574479070674348728464172280055825836608818235617945902049541473388671875"},
    {0x1.012a9572308e5p-576, chars_format::fixed, 628,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000406159542392037782859802171593570642607"
        "6332010062619958431831272318783138874262507295396479475668064131645251870497308939268400733922807386960744"
        "8150365771647312530141587581009118343558626950799148281046271256567808855867812108852064523161903474987315"
        "7054105128662997301341221712984156433636865913673633110339306470339794504858111659424780755591486576076810"
        "83750037261710068110348985087259076445035649476524760030822502887559721784782595932483673095703125"},
    {0x1.56195178ec146p-575, chars_format::fixed, 626,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000001080598113210514987988882819423685353906"
        "1686084662780914854471675383228243117452879571122473537783026978971842487447921180510513979245365186142858"
        "4866033364818684675278744191346541679918674777914698058883725209587091814926510645613748528670465332304494"
        "3850364593356260109867034399495400691418744678903519925194377801076238148673147847918302273719745123524009"
        "800896703181146322315911891127839376287699882533919755293883024904744161176495254039764404296875"},
    {0x1.9d2601c0463a5p-574, chars_format::fixed, 626,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000002610049033590998097955226555835549321970"
        "4695290513080366093465835681490016799462387973765729881171426828168241733259013399292146369447750338880713"
        "9807845292305705181442388256835168226672308962563672964438490805297338473214293819379816464259972063871319"
        "5222674660177386067424332816501896648413308447588486597263343965697557104623816147424749364511595700034881"
        "997429011261167023892458961713610470983980921921475027054626583122853844542987644672393798828125"},
    {0x1.b1a83e573f7bbp-573, chars_format::fixed, 625,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000005479224332391463097507240628161360683226"
        "1951011145665036504979668985390735600110157767758785050009028843723306919687268827826318060701922646056994"
        "2714717248153474281746765628088520324003473535650431537768304962822635243452634262699183389640515919045700"
        "9628685312050850428276694131688178962296877209863921698707625891704876707671839895342016796959143826538159"
        "53454390247156911968073950955361295931527445870673812509943356729991137399338185787200927734375"},
    {0x1.9db5b347aea9fp-572, chars_format::fixed, 624,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000010454380162673489713965397325213210055216"
        "3879873109105377162392415433498294286245370856908124601498581730215858895362945461402133653079036345203985"
        "4918359298172819545920254130654714979749139962053173554210376204625461005863476843387305393280877162550277"
        "9192249264078505504614027390103154345616586155077416235880715362347189767875031969711231284078903547104466"
        "2694250760821017274249137639457545000358487907089906875091056548399137682281434535980224609375"},
    {0x1.3df2e64e62b17p-571, chars_format::fixed, 623,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000016069032799845684304837025898602516055352"
        "5330476653608985142497079187555897053107670564140159176509442566372059407021909524012789333201080366212249"
        "3748426320418018292509093509152048893765563673233963855958593593632026744656404079205066647203536888565373"
        "1935242222344840271636673845201596436696040803930327212744844481901820454994441082559588679931543647630524"
        "022363479603462003303851739929994528409740117298461041517310121662376332096755504608154296875"},
    {0x1.3fb9aff5a09b6p-570, chars_format::fixed, 621,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000032317634556278561328898229389131235973792"
        "7027325626332809914034879157391321624327129064932660032953998693729842545240820838063867420776343008017269"
        "4982316283872060821192192709729960428978910791358989140379796397922628678340369132274813716042402578734967"
        "7645937718103957392662178718638371693425024544200467810601510491638476195268941251133713791394315017124881"
        "3573390689443103255850376521944591726785518526871530953226141491541056893765926361083984375"},
    {0x1.b756a80b08275p-569, chars_format::fixed, 621,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000088816113793007975094594031352311578123949"
        "4167371788281308547084154424200354650707776201773488980791415078417796406238021557467994937388956410627563"
        "3058851067540238835452851831762708928631353643605783934410829825276089987266954588114848541270166660775652"
        "8800628693815337078049941448123253158054173322985664435833612313446487476518149284318543738637159669254492"
        "3911644918628926358632918516033019990490714551064667381385930866599665023386478424072265625"},
    {0x1.f7329a0afd825p-568, chars_format::fixed, 620,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000203451601586999405058926242925751758038543"
        "0325922397277892203710499409471254020804516754654209654639932909255687413528517546868831113606722319891083"
        "4421890991160800376733815743794010033212895441229296565025729898623995081971623460966619095990658796181731"
        "3694284115030286757019609621539322656336515768811388337382669901901338040363856054157222072244507777981504"
        "304120309709632492257675099278284852081287060608823236140807466654223389923572540283203125"},
    {0x1.0dbb0dd4c3dc6p-567, chars_format::fixed, 618,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000218113647323195123792998885625982056518325"
        "8686257855657737347172216088763166848656291822782916834522669335644771523960050653729780457856095864396001"
        "6318089840545935342587500849741876484276147343096801587789314275371440736377430304898008107874617963510343"
        "9999677426826811398232961770959454258651768754652990020742431535295716456361590860289280665530000903065444"
        "7555995176531553920423514884711703468816347962870583199190832601743750274181365966796875"},
    {0x1.f37273553a82fp-566, chars_format::fixed, 618,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000807740689160805269118228642550843231522689"
        "3494792878282174487309771526555057555137543853187756139458112204099813878239197477337300089588511850598419"
        "9281366002798013382874237491147363150496319895513637211883391544592703564244368547173540341075008703545423"
        "2579156985417451125586335210551714277714476384788223766687476249466281275483109148501386123200716261782589"
        "2047399734741268643801542295545106323151370703548879159683338002650998532772064208984375"},
    {0x1.948f132293c63p-565, chars_format::fixed, 617,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000001308561772651954193974715412547935990591208"
        "3343808525334106458195989110396773558319983334774985646548651422400177890451390329808117639430576439949311"
        "2846351303350353239502484610555690434248628579595201736161689146633660758036332258835300772878381990178941"
        "5921638100352602461638880220153348552331791239223807821536185010298391358412451677556901252347148614418801"
        "397077483341880749380852062406494029384384863122503528387596816173754632472991943359375"},
    {0x1.1ce9174ee8dd1p-564, chars_format::fixed, 616,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000001843108717463578204325261813318515827856557"
        "1369229321208308841340213027211857844123697256040862519901567725132672639518364854371628903708159075430161"
        "9279792859862700397570904034465465726650754241810398171714853256199299280893008188067892300503088321533399"
        "6109506247186677474230868515683431825040191371852399000466202113797504943448957858043831546287649440338737"
        "91332956921068821243541667694116503967315307856156270105429939576424658298492431640625"},
    {0x1.3f6d7ec03ac34p-563, chars_format::fixed, 613,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000004132806492532132674382360331286768338716797"
        "9700016372758868184808065548286026722508349641027855711185659446215296171197420312336059674308408378140691"
        "5821893135130157239833260145924419520141522508884955957878888182040445979824348321458158281650270735374053"
        "0994471599110522744654340322094456670675212886409515158274968834842167073689925579942545240153929528929270"
        "90733811106253593050550399881101662656807983753370905333213158883154392242431640625"},
    {0x1.d271d5b8d56dap-562, chars_format::fixed, 613,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000012069870317233675409785921174121444821305867"
        "5474846470260318024818044719063243067120770137290554450844551433999115380573910887578371341979222946847987"
        "9497113395238860243862727327474188777003838509692351870032032910037612444082501641811469305197024541046308"
        "7468850125598650551237036205202564890249705306096007731217219252509953590142701977279265426554214972769816"
        "77618412990549099603329870806860179147990998205219881356242694891989231109619140625"},
    {0x1.e5620509d2608p-561, chars_format::fixed, 610,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000025119843525307733558434594260816051677090309"
        "6673967930353818644221741226839814296197259152147860503559509486239204789313430961464462590490736435598083"
        "0429272741382633782476612511642960529126968971864664787062889352642748759037672326378535772807239429456532"
        "1556549743253252690956906469133543099304872943427110064921659955315549232098416962449358057714977677229240"
        "84996969867141831806614270005060577891677076056708983742282725870609283447265625"},
    {0x1.daaeb48f4721dp-560, chars_format::fixed, 612,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000049132134419173275300225535204544729851911649"
        "9701658694834634408878394183403806656222921633064889962501065491350976425275433250304984863280428171634552"
        "3152413142666030324845516070701147579657337123241253961741033729226789364662827961018036133320427313617289"
        "1785884242393338467122165324196011644605546981105602878290791388448732419818004683184996584630381592680288"
        "4671039929380913953626088229113441405268743189527214099143748171627521514892578125"},
    {0x1.79db46c531467p-559, chars_format::fixed, 611,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000078220288221977700063059894664378227368411242"
        "8973370074423487710257342610625674603614327579116178628388196293795797162626830091814571929935183642335516"
        "2309676128765210431154313546423058071691765486209893249257758087062177758498404099890663358857738381451506"
        "1686613845960870319279798128399912226739252082389068103035402992951541364381739672960888215163802051676603"
        "836709312773313559283595797003584392382939671772845713348942808806896209716796875"},
    {0x1.5eec2ba1c3720p-558, chars_format::fixed, 605,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000145289329418459781239540418231613206704442090"
        "0267319919487593677463668500580057236620964242008498010268852222847716274413173625608497913079524966652894"
        "7671427209197606892230099984747934360035885007327209715222003029066694358608454854337162898211622403584386"
        "8866984479016961310735620585801978784207524847137505642202061656064633727425727606694981158953001902520523"
        "944612180221265729211093850118644184299387944747650180943310260772705078125"},
    {0x1.0484bafd678aap-557, chars_format::fixed, 608,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000215720283578313147392487697244659997412717666"
        "3329307988473347306938546712857725657427570524490693918411758290383869840942834731519701257950431770805882"
        "3864404057477616982597412257398875571344725493510145560232727974443858379411457797657961542960509206305284"
        "4086162862418762840265454214673776057813103379569211790266417476203434046175223271364747873717837864591397"
        "698825453685671334050757674102559717684013396166164966416545212268829345703125"},
    {0x1.6d5d28581864ep-556, chars_format::fixed, 607,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000605073421057126407536268421630976468093088607"
        "7631171957420171912817787234297774283318868481683511863311317874699026721620204024600543337355973772597888"
        "9305040941956754247376027523253570262801340275745355595446006673514357407252198901742843991249170290767431"
        "8122814866169759621243013671992945977824396159540497881209462457200089579779727868186796082007661967617098"
        "53673787110020335195594341069592956953993034829863972845487296581268310546875"},
    {0x1.bb2a34ea37314p-555, chars_format::fixed, 605,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000001467836785425614229866782781810141842564117115"
        "8235873201689619347389131481467218178604900546424188785128526833687830769657065064731962671428118010817789"
        "0970382493324330201954352563963102778896234442647145321597454493486497315822572316287467822249819702713710"
        "8636727761413525838697942842193364203301906166874401738418313264607291975181849925899367166430300780818499"
        "237580213954668397499666143064833180587047678500312031246721744537353515625"},
    {0x1.dda66275c3391p-554, chars_format::fixed, 606,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000003164114305557188872167581005098954210978546502"
        "8434827969598434513594568939907735780944113164818353072371269147227442593224405529594825365040984777210506"
        "0655087817291808653621495733409941136183312201214290111148995836702755905811341517724049697693918406924507"
        "6394699362838845068654932477476209593443045636001585391168764081377285606835175954030269312123313228447303"
        "7020618452899137221945934076678210757072040593129713670350611209869384765625"},
    {0x1.ae53c827abeabp-553, chars_format::fixed, 605,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000005701265996213117274833180113565775784954586945"
        "2984033576198099915159574664118824194511400497947243457984780546211633008401788598844966082310519962913898"
        "8659606033366015659128259656868559311576294716708666983658509115141782873460081585179330018295479063005707"
        "4667385636416663954055631149802259850642458557110755505661731896890448946906215984760424281458935169844427"
        "601586887049731567952734714418614424269460272398646338842809200286865234375"},
    {0x1.8a5ef719cc23ep-552, chars_format::fixed, 603,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000010449784962477287548783251955237842370155156614"
        "6826334864019810055385905950740758771320828326490262538063745178776147247109081094734941639330363553681011"
        "9857279726230392028225272993263843450452364994965665306519688594839664257358745546726073837195205368734856"
        "4431376644311167365028342993889282517965130211119142903435658352635759488131161489780485873740697437859266"
        "6380889595350983817353676260069987591361240220066974870860576629638671875"},
    {0x1.0a8013bce024dp-551, chars_format::fixed, 603,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000014123103050632778867079410198580307726871240292"
        "0541068368911575763700490733284467263367577298423282975392687130135769634683967418176373335886121724564479"
        "2935308284678692288452302095130502629247532688243010174532194011901728294090601781190078090265727142204298"
        "2885035401216418337155102635593604609313227230299263203367717097431398505056111687252861128855861691714189"
        "0148843251509297646865474549029463580129828415010706521570682525634765625"},
    {0x1.1c9bc398428f5p-550, chars_format::fixed, 602,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000030165478216464074512212005380921449232249896009"
        "4163883459095580088459226807666799899004068886051685278007729156847515877911950031988284153897746333486898"
        "7892725688447857051334631277050156343590570961616329006279805162991598947429131105988549014486141475892089"
        "8701496103210003098975054883301223628041392497177162320712243561484642920486418632362138024921480131995555"
        "150640263619194765536340598175053806517809107390348799526691436767578125"},
    {0x1.472b04c33821dp-549, chars_format::fixed, 601,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000069352686559745381219629204415882645570340784420"
        "1477779975327755062633188410020385461517789302134229495247497247338585103033841186687904998992673315180478"
        "3858442726799986942283792161596904014111697431290378325347243997549961343698246262935026970483997121083598"
        "4184914714199474992401083147022495609722179436331494389233053529333671768056532410769536588940137956502217"
        "61642321234625202601757092330837795035591852865763939917087554931640625"},
    {0x1.6e2aadc8fb08ep-548, chars_format::fixed, 599,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000155239156316592182116540333593965011324407646818"
        "7647449775113663912215536497101280437021070373800926524185812157593426933845162811402898680887532550709538"
        "4891797508949596239872819667141887560524686500709790591081991942003207362655327474605546483156944635859249"
        "8502858815166465171581423787646222997581034545137598706485618677189505645342906676871638686321474504594718"
        "576852307282958385446604353090360728373298115911893546581268310546875"},
    {0x1.79e0dd8d6d77bp-547, chars_format::fixed, 599,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000320408812244064701040701054214471993636519817131"
        "2525761333852332777473674992913214447027108853467029297079393326669734878211189665807441927037194255251288"
        "9142688224429225908407606753219328561169740837005707621340208175194042940491350748828157642100258170107083"
        "6816124348416114553627244483558069374027744185791657330319365608472005069461657785305916005515453484742887"
        "071767583594111673410114045877639110670997979468666017055511474609375"},
    {0x1.50a1c6dcbee64p-546, chars_format::fixed, 596,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000570870659966143924670412531546301456252428176612"
        "9317526566419635735485884884360975976452513951624675081915468001138573658489054987719004117903299183075801"
        "0015316949595415271383035047804624141278665302354234911541467226904208366718548527193707891153132877667861"
        "0959513757920177232706230558186187214188747454115777586354089985248298015199422913523614410508503850329164"
        "774950244578449512806322431457406452182112843729555606842041015625"},
    {0x1.862c46595aae8p-545, chars_format::fixed, 594,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000001323334251342744653322084617698008418035230749593"
        "5298772563684034576138699777035986613426588992064096929624484557341399021891306890138310006079144322877642"
        "3588462888697503055590150915018973328299846328628471661195139331560301984598886596494720450062213461808818"
        "7057959743436057427473338804629924458598854986541360321208371750313296783051904664329929192280551912742166"
        "2183480103792153741442023939800520793141913600265979766845703125"},
    {0x1.abecaaaada1d4p-544, chars_format::fixed, 594,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000002902749268222376924546350129536870000547304408419"
        "4294943260531463212751655391460399814755446587701909041474935743278603124140607256272782257250664990133408"
        "6394861768322314208033554135758133295052719658033386416436682014057697341886413139751469199998298583256946"
        "2960667909084778059718781902132556507382819564321302015716342432672818757887538730611849655100266544024163"
        "8148086882173459801728850060431597057686303742229938507080078125"},
    {0x1.27363043a03aep-543, chars_format::fixed, 594,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000004005031318533224698037948079353027579083803421613"
        "0234269239697945665097491937671792280674809190792923657176885219547827599332963797684275644497957812839330"
        "5680093053021087734539543173563658797050864465135277447744160645301874769121775328077711944859058858832844"
        "3857685929471452269672993927502101792232928640358924482952399125411408370114513241114066551875913522347461"
        "6940250607472942846200812672119440094320452772080898284912109375"},
    {0x1.f9396910dcb42p-542, chars_format::fixed, 593,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000013708394080755749882353739878794548975711060319922"
        "5761168978964230580787408600882502079402930131673822163419006732222086034323894484084689341216849641479224"
        "1401627062978614652823668513515864069749045983218624638447467632641139961223891013812536479652440735884693"
        "4445629405245581645497453881801461068937202950179316586907829620444413074029684670336457955213142348285380"
        "185813403038234527882462121528561738159623928368091583251953125"},
    {0x1.d5c5aea5e5776p-541, chars_format::fixed, 592,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000025492926252346403699480399559723131522475692333126"
        "7460072719370615428030457759180738161742455950687444493756897045095772044904146125927159052272308828398501"
        "3090683402584474590747411753259623088047495266413310750814215616392500626374978271647156167704249652658943"
        "6756364949351894653290522151409795949089798076303340476697056289062895628727450248207182214063557902486967"
        "78190797774755330172384570897037292525055818259716033935546875"},
    {0x1.9eff9de8438cdp-540, chars_format::fixed, 592,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000045041091507036545799166835714074572890973281642718"
        "2547919202745911940414921214477351259743032122538652926379956781548301884168031234796205554552277059391393"
        "4114109918845576727243974090120817486463281438934208839893697531955943794618870985059845862267848439181439"
        "5890905312457495177615640024453646281524267570153715010163957628881209237239059125078916075999874661387134"
        "91403049278798069563096995171491698783938772976398468017578125"},
    {0x1.35efd2c76fbddp-539, chars_format::fixed, 591,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000067276831657939996199173247920738175748428147489414"
        "9670172557085143017225481483937143753539584747010422076106789338814555349198970333778333109059056976956517"
        "8468682396913065019601456861151524540447139051235005146110075237349741554326342899856503196071852473843842"
        "3888187671059749294753076297686432134824368751110720079131704627264173704339529068829140553825452116336982"
        "8914796349684474354758967340472963769570924341678619384765625"},
    {0x1.153e8699c8ec9p-538, chars_format::fixed, 590,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000120360754529645884962285693011227211565254648719269"
        "4016112906712314702358657372751839480616423140272619842377498371831965557992003712160248349385264474301325"
        "0056769792049242915691962716052948755237637718544157452941495767999843022796779761615077665689978467244059"
        "5860019122080279468390366742471611706350941138875187955869402879785637126810009475756822478368269373066464"
        "319957145522036108011010302476506694802083075046539306640625"},
    {0x1.a972fefbd352ap-537, chars_format::fixed, 588,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000369402710534561582048185239355022103377558944781592"
        "0779198213839248547783496951157132900760976663741917103927591266103600942054508846822468097371651143350901"
        "5198608338177706532176361531603848383494661224829652850527651574870904966453516740795142615423797810465807"
        "7731510550983774719902367320683814449326157174002983539537562964475094257758523723219897183010715085316739"
        "7617245016220384641603136088860992458648979663848876953125"},
    {0x1.cedcd588064fdp-536, chars_format::fixed, 588,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000803774974860294637969073109978872317499863220404922"
        "0756055772972337080621452348052409076747787566156520495176942482851069896339546803762048412705026259166502"
        "7486298472552658367018275042648961810362216027896296996928598020037020128457966742687104325202626773898711"
        "3207732222251418060560080709569006698444788751837482010514354193160667222252519053271487323081042165107372"
        "3466706819347602115677364764678713981993496417999267578125"},
    {0x1.cb43f5da906adp-535, chars_format::fixed, 587,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000001595056784657276524450792782037782490131785891352987"
        "5732063943109841715337321381611732771703577489536903502349379623809480404693423608671412800065485553106741"
        "2929636750704890697323743904633485510251869076888268108427930628581128120688710084461419207542654861230266"
        "3962004264088177849786782954944307405424456628148596509424848746973173412819090106279014176224088018810004"
        "195291563276423198181053209054880426265299320220947265625"},
    {0x1.cf8a16d1be8a0p-534, chars_format::fixed, 581,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000003219800877667736571548308823559094107806812950548488"
        "6301991581386389243298290941875520546912655676996881281044191722994297934220491177440366409713402077606702"
        "3160848590990575248460251418985831836138485385022657308697336224460692690107383121212263289541467941078820"
        "5226590464932818260131222656038901409342927690461162453656396066174341396517780764483920907682608083655719"
        "332828054092543457187503008753992617130279541015625"},
    {0x1.27815078c4b63p-533, chars_format::fixed, 585,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000004105228890331063404396083298757193163623440016095403"
        "2470064104477855048188571156057943012804319643271386198925796987207651018098028511887410186972706597660923"
        "3032449496732356088241557456578015929237728817932232804838830923233730375003077861250971190850195180983116"
        "2651603726739987027097299398843085135417047599817866157427274429479981920466787981923596316500143569645232"
        "8267353628992418490550875276312581263482570648193359375"},
    {0x1.94cb793c06293p-532, chars_format::fixed, 584,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000011247015311011619164388570519415046282988509125973527"
        "9741747925135879974063240368816106090328125806109183239424576993216500730132779180552061858976096213910756"
        "5169335636657600903698036216667845111433042832408822485088788757268226486530324074227172828587904589966139"
        "2132961695282914996319701701516959289417601935843292332629190240565533263563800574591121957879184091543084"
        "291008630540113777396271643738145940005779266357421875"},
    {0x1.fb79dd59284acp-531, chars_format::fixed, 581,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000028199919854660424181406498611767457424061948125885429"
        "8589457459624428488191761977266831369694370285708881082830040755467647076905556002995811053078143823884675"
        "8896109390273446042898942695810587542321106407847548563781536173906753112551553439539348939569353136479925"
        "5109224555942208221914631377657614608003080288344558084468684208204756019731248859110647696119656846453414"
        "657236217176483616952964439406059682369232177734375"},
    {0x1.359571ef938a9p-530, chars_format::fixed, 582,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000034406501648078402345831943940992850675010433136247541"
        "5930071265790144615646215078259890694210463772583533525266279480436005810313967603484552689107264291271767"
        "5433640137590195247305594909345493430182306596860622742466309500895727273464880490026271211635573150397503"
        "4068955683366372451262012623421741695264813612942626052113327810277405224673196646184808761848734931180046"
        "0637664395881218926120936885126866400241851806640625"},
    {0x1.dc1506c0bf6c7p-529, chars_format::fixed, 581,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000105821572946972887139631951583717672743241885198572171"
        "9894409815551521845785988952708204139474399757199419807826171073148844804259022309689991737891607182112194"
        "5979339326603987813586870046488838854148329058044112342763646435291832724065290367027641733458317007850703"
        "6227763823253865069688627280158633158487170573480001793016274242856198979073331588237555754089321977604226"
        "135305401194919294738383541698567569255828857421875"},
    {0x1.2d2b9e28a6a75p-528, chars_format::fixed, 580,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000133885820362663555419594043166998407951143751006488074"
        "9848744223254793754076756021225316433435338344953459467439586443326022949940340826249786569726969039054779"
        "4793059510184526291833644482138769608879468669219530401670454824660198838977884545919715262148141572387912"
        "5291720960621786477795942103209681646791640984403841728360044748549321065798091796033919932698877339989298"
        "37348564227117453384607870248146355152130126953125"},
    {0x1.bfbb91d629252p-527, chars_format::fixed, 578,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000398080705242629831129046568653465048781329393724194653"
        "7121059952335568026223584507165458748882980852882625532115425965736450282940426179796892610308950680396742"
        "6332324837775355474993402685474785068585575143910608448625832793399476870172835928566422215307639841470332"
        "2902267129206965453658202931263208038257035872804879326080897160088621835645648574210621835117584474315503"
        "701422926108310917925336980260908603668212890625"},
    {0x1.81261e2a2b58ep-526, chars_format::fixed, 577,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000684874465910971999415688793387732609580222326033081294"
        "0457739536694375108714137109529192455096668704841616167692947763953483210206385981567278734246565968431993"
        "8183340812160818214400762654358676796607955323226506004918322556165822460350746720183779242737752869118957"
        "9027008696770868127293174180933176997045400686847998011261282926397903945921075498310840676601252395453897"
        "47952523762375420801618020050227642059326171875"},
    {0x1.baa3429377a6bp-525, chars_format::fixed, 577,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000001574203035965531613531401963179047212712636441947777682"
        "9501394414493294958623139441874916754684678732509715899103307031538056852240548597509311090249113490142322"
        "5555834565328486328064118867427922601658085650759434786670525355266137025296167620889331874321795773492411"
        "6551774986936407789322905691142636861514631034901222501011932334071723335375457508301179350693496861344894"
        "53548900017576528398421942256391048431396484375"},
    {0x1.9a907771fab1bp-524, chars_format::fixed, 576,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000002920273408839778291474897610532750298406986436059978405"
        "6489683368011606263857076661142188306671405159781423167025684355540878432015185377709571340516596426353921"
        "1094938101679106092335341904570196983657111607404300383900189431218591302014329016001873226224978019359870"
        "8143728594996072940408519441822653019593776771607108453686713523625247173557248276784137846560483311143573"
        "2133191744974709536109003238379955291748046875"},
    {0x1.5ce3039935233p-523, chars_format::fixed, 575,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000004963143223862366347754616755273112400332892151447482041"
        "3997492211106129001776874436254409714844492300472015911147713885952803916385399442599912699660968322717022"
        "4030873388958268153423145767609226993844753478328382425919527742749268688537772422007652894684296984825672"
        "6439179741579269576223391510486187927658224539225843413775535462042906286635028827134767522968000184340037"
        "184670124670304858227609656751155853271484375"},
    {0x1.b45bcf37c8d61p-522, chars_format::fixed, 574,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000012414975541479182662530661958882288430785834775491841525"
        "3894118748241599950978857565442251287584105466456217648773130036540949365023441814765140175590447946206316"
        "7531499050878989147302143653326933627474979299646140492013260693375349748541774845381848399320823459041716"
        "5541348380294934742447851982030456871109854039981844119330919559540729918368795223177756028547610845159297"
        "97124356159798708176822401583194732666015625"},
    {0x1.3a2690b025ac3p-521, chars_format::fixed, 573,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000017875996042719942144684408823686534589648628475912376125"
        "6318213568371444623000687661626760426533702444927738923771107674341441242397371908288063262833805963550278"
        "7956111402941722283492907323121687029277413650633235640923880607318621527226861884183570539435102743690701"
        "3314867540678538581960362738163081922890280303887423854113981016970820232986294242405150883265433026828668"
        "1747402777631350545561872422695159912109375"},
    {0x1.8664d335d8f63p-520, chars_format::fixed, 572,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000044428868657860281376359178678068678828865965144798881231"
        "1780351669706026871334809700611563785295240028095237462616854285876469189545810325410817406934099121471189"
        "6003414161154259995400488663448950669618859741408789048876099387012441921979951172011268855276022497405913"
        "7997863813366711158424098630563612795406981048797523362754888079179316205818081708016426963313589920827914"
        "418743898039565465296618640422821044921875"},
    {0x1.a79164aa2fc1ep-519, chars_format::fixed, 570,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000096408509408080923610447309847908498668818477504064378536"
        "8126046069111380321858738774064160921961840933778408732022497546793318629212174366316259374071673186690940"
        "6711053939940359969795275491022481221271149533659942125679052983397494126651483669742329979687385596140269"
        "7100058134964859823768146238469490719243711491531401474372331681962078614051224232515313810932919951488580"
        "9507713787525062798522412776947021484375"},
    {0x1.2bc49fa39fb10p-518, chars_format::fixed, 566,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000136460714021292662180226084553088930347285447209235874305"
        "0097046497676302502943967554055381119547423766323595238344830105193157914693303425932522789155936224316178"
        "1452204208249015869028037829384948462735328602671552251757935853544416424933670392478048782405148215951059"
        "2269777986550481097183357926597278222367341442905293644749971602789648179855297617277419064627585012540456"
        "066432170700863935053348541259765625"},
    {0x1.b2a37c764c384p-517, chars_format::fixed, 567,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000395713245503972984559522939670973848253589531980309801595"
        "0534188984562819667599991383679897046883718782032484782941289259792401942239688076409151132765326564642870"
        "8472951357989644113139437303359323754832806498105951592223176268280456075964368410490158554250010230905107"
        "8746998385744637761949259271884011045468465761364898764508683415032121416408732260562728101474458408410433"
        "9627430135806207545101642608642578125"},
    {0x1.843ae1ac69ebfp-516, chars_format::fixed, 568,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000706921793665826155315676758975746710917614373613382411496"
        "5675689539617763325368327288361109999039924650044375982589927640589509207269786839389297132819676334187486"
        "3544762997531184610834048012793361393520758210628314182754643230419003777061857847364488424594195080455566"
        "6513239904728601575232464779031902301528454048548719795433516554941581280795361619320195627602011230602649"
        "38313679294878966175019741058349609375"},
    {0x1.4a7c9b0be349ep-515, chars_format::fixed, 566,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000001203556015715791981306274537208997391543320419551874216638"
        "7275134267274407820877716584250745353852034461563951029094754042084741201555023726427557083012962283356634"
        "1709883458286591764701770519397372432417712594848271227230992948309669507331728913676066375394901053891640"
        "6220492776005908179269094318962119052575144800112517791981236689550651499999859263780522026324949400565011"
        "981001362073584459722042083740234375"},
    {0x1.3e27452f4c3ebp-514, chars_format::fixed, 566,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000002317281696978396955189123377794352625041693253976329352039"
        "4005777040356077947428725088477967218198192385517917373937974791820052970469293272851624318294051301876826"
        "5036831234199951980780926608738288565060565046999262198272380951707877579093196401801900300021175486558998"
        "2252409368493331309771709369251704091173604782777233093007760038948922133043358862285948249785523761316852"
        "198177684840629808604717254638671875"},
    {0x1.b9268d67486d1p-513, chars_format::fixed, 565,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000006426272367902623461308935859215149511432256735493847572944"
        "6594062899894550316581573372400318968212811428919647031987628214981951519891993799577542570576179867467306"
        "6995193119893788442638742100166477114130792519595077614068438062406479166634128583854848649455609465219571"
        "7677079876446559347047552594588771871315680949382327170742119174223144139530631969227670113296190705989840"
        "98552364230272360146045684814453125"},
    {0x1.4df9e0d56e886p-512, chars_format::fixed, 563,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000009730107236224658299273161726811071102935306401307335045399"
        "8818620182181804740211694728963191497913793567991103103401793959160433570181997275766527095269264290194861"
        "9176904535218754880890639319149166591492630199955163315292873841498671690347850563431920298048447377091620"
        "2240532708166933819170785587530689982280013134565017333638307204694287737428192204358891274416205018071845"
        "955773824243806302547454833984375"},
    {0x1.7d69eb7260760p-511, chars_format::fixed, 558,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000022224325771347583865914578960158321557360842317854318621134"
        "6933657091487310462801228024943490675385197500413130917810364898093092551411950073674123927781422093946252"
        "6035650972628600739491381574581367202204644760249595881705742112157886504025211275233525917071227188614551"
        "7728911956442632901477596469360488985449110999125357379110588028167602049750754315903730751451811142871406"
        "4459200017154216766357421875"},
    {0x1.d15b6e4b731adp-510, chars_format::fixed, 562,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000054231128112241111883705509773089298055689258334481416666694"
        "0174033207766899747265282984093161657059795934272651133535944542041523246725633760821160380141790144506211"
        "1965585664801026021319908168374983068757897232076504585427720559612691028995704712640626772361153715821779"
        "0735080586652707161869926318559935407300572770977984474498071181984210951873668231747188277414766302553239"
        "54088453319855034351348876953125"},
    {0x1.3a5731ca0edd8p-509, chars_format::fixed, 558,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000073264353948817245453789075948016247651899446607642030711491"
        "9203261126919959600463538126003325368138423524291656290504702564770688838031055615174036884610469534126066"
        "9362997067361859795514395001616930733018553465712808422288445892090588535812980025454718642561058682378505"
        "0860899147793591675552556686780722696531199100788563791496346567000379603690015154850041767791574143231514"
        "4265885464847087860107421875"},
    {0x1.fe9875d1d94dfp-508, chars_format::fixed, 560,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000238012223201496246879702388385518212926837569584949756349144"
        "3680874708929671511664616792769509157042290729263692909282981377264356193089750664771164517780782827902498"
        "7730817899324249394130376711933650486643615936943145835807410346338302475022269747351964638109864012374765"
        "9229998350272682641624844749509035541297454920646488679466589507176571074090805100721695650319541248673971"
        "267635351978242397308349609375"},
    {0x1.486c8e4f5125dp-507, chars_format::fixed, 559,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000306187305366919855455790001692229950383732938369228904891255"
        "0400714620860933013738543809187681149271085941945609868091120166774953177037142854141018233583426970618639"
        "2939814864968179422182060843007728238711650063405243333717250217191754533091109488165101681229885852831307"
        "7185392005897595766108075485367715975680043787973172841690740579375060116374477022474485558367965354342743"
        "46698657609522342681884765625"},
    {0x1.bfab9b8aca208p-506, chars_format::fixed, 555,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000834719486723590818702524747938529309291954959390302831770399"
        "2255055112618365344675577328587436635959675428325027569332624168460969629190495609275974259069718081705553"
        "2910901204994378753476346741584959612706674491351373357062458128517513444577097106506660870893763676299618"
        "5139036806500809351936561053766612404049255191129847261548373937625810791913226462499137987133268623551884"
        "9571235477924346923828125"},
    {0x1.6e3eb2a2ebf2cp-505, chars_format::fixed, 555,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000001365789677138183637030918241816104834105768971249395580662444"
        "8243905928334545004278697729898364093587345786886531313089263086235888667409191551419479933199488611573870"
        "7464006492635762748605607064664260305266934879067831693088594717643565903100646927733796631602757838404734"
        "6694343336071347790439049988766926425966011418156599676583954839754938558167040734411064231007548741558821"
        "3480077683925628662109375"},
    {0x1.6acfd1805e7f2p-504, chars_format::fixed, 555,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000002705973954758640410373402095847976082689065120074185227455097"
        "3101395207195449636437564463046700627498648696257340323748682242724040444170987478411495446279260789908561"
        "6545057563405007609306607813789573026667536278047163536372799388111798081815841850537278717264629993896372"
        "6825437220330053205315677811360493235151514227614745297867971496265385307299528776493150340060056535662624"
        "8103566467761993408203125"},
    {0x1.fbfdc9be7c4d7p-503, chars_format::fixed, 555,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000007577545297109582983474072004813788365907822173003775895897750"
        "0243027089042030315562065576850353242510972298890882064041460099136324646511365952487433336851808048530280"
        "7469768102470893345904366988820833134850152267923359413168388663558680740356029634812659629893539455871490"
        "1539292174038185034695148230653865497794789982703501268412769655160379904851593576191402367586702482071814"
        "3018893897533416748046875"},
    {0x1.8b6638a74b1b2p-502, chars_format::fixed, 553,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000011796090875694487081840030359311463862270589279053705811580876"
        "1074837278249626667753117288906269017536468931733577855602836561907239918066053974196590031535933155795041"
        "6152631968840646565017772126604856329170037235553003815414569897105068661910842231236269130833379581876621"
        "3815606161209960395800117570967320430008706254767535186723326596270184551813838881741515821066634828184760"
        "40847599506378173828125"},
    {0x1.d46dbd2abc6b4p-501, chars_format::fixed, 551,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000027949604896251110474468435743440309945288120594039878056554427"
        "9921954016171784487658911555785873548242453272163051998044291731736689754999480979232786217446696064729498"
        "5068805236473413153126372484300849165127366092938786364110450759620750625707230523155311741574527176683116"
        "1173715817548051899046835891129345654406713027853111244031216018263685608830589461614758717278306221487582"
        "661211490631103515625"},
    {0x1.12792046e3030p-500, chars_format::fixed, 548,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000032753828239853733863446369582437710222695184799823949849189206"
        "1668447150314806302769849056650294108796333252127316348030245611596414872858686019667951434279227319113223"
        "5015307772538931409118755707298893828528817337051954380499856181898096431741496302183450840154663766232702"
        "2577849630928970432781679531426439396792112263446829491223785021441382997151012842866613095083039297605864"
        "703655242919921875"},
    {0x1.91f97f1e1b12cp-499, chars_format::fixed, 549,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000095938032050821536271229835447916874887997484567576901965829125"
        "6969378528924568632998836097558357236535442102841682756532772118758908073143284830054239179665994380300567"
        "9051664978882490798724246262234220764114202399847393492562247437513415173947998719357558940259847465774991"
        "0798871766481335786204703144142446357441296310764517415801702007499677278970537754650832473757304796890821"
        "3078975677490234375"},
    {0x1.4b9aea9518c4ep-498, chars_format::fixed, 549,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000158286344757288308148434405235066837656882541831304777114304342"
        "9024084047758469948167528176544682776912653363035930280156111373619638917108231837788659400421477874750498"
        "3740266631275601031515835959834139181852754824887752435828740018624766928424809502762608863433657124684755"
        "6501019103039194246314666325291562322641451797420234321729919875813660410590105384869702431771543160721193"
        "9990520477294921875"},
    {0x1.1106179212948p-497, chars_format::fixed, 546,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000260646976887816664639348267585205737473835194484928666807299508"
        "8430752460212614384745198842486859348406019417166829789576139383055137489322674490773682689374422958338204"
        "9638312333250627743062586688725091585459251117578008013458312697961852084035149641000001215986901914712978"
        "9917303218067379788735552246485106897748980726714235495824747867132452073278602120570690559020476939622312"
        "7841949462890625"},
    {0x1.f48d4b7371b3cp-496, chars_format::fixed, 546,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000955721437835636792125693963867145622443146689409402710835290532"
        "5520381149247389439448399516323693527385696516282605302217517721173690808036558667030681767685356861437907"
        "6473589746382005556442084671513745675453372836262113019323894209341343567227178727748481796550962938455025"
        "1638480990808959430571446202539785042577248358196458841392453774487726949584049437186328290749770530965179"
        "2049407958984375"},
    {0x1.38223e0cf2f9ap-495, chars_format::fixed, 546,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000001191935964515715076215188574587129816946998875964752027561753067"
        "9373213681293098328176454498212756348418279118150555601665201685096769753982448168633584412176407702216617"
        "4838198246329265529449867422827831499533947719005264748430392712434016735879361540756907724219470212796155"
        "0080648296820459406354990529597216843845630549601021605362388735114697726445991566440740783150431525427848"
        "1006622314453125"},
    {0x1.3e9fe67fedbf6p-494, chars_format::fixed, 545,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000002433444775335062147896490836112506004327807866246654749986213128"
        "3708984042278535636275983077789926684370094792417844456574830999066006984496233880787287573261319640680410"
        "8645775952673011694052762137127630272887337941179487208165929511288223378667951186140773886313469032626525"
        "7013513191916123647888187047926526116330566078186068092790478450763659348438420169935536563343703164719045"
        "162200927734375"},
    {0x1.bf4f6338b1c00p-493, chars_format::fixed, 535,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000006832519569622275826230015210842443752857043009150473087306324619"
        "6160570278444533395376186268614032140532264488840480451914504837343385590483951170204490217840827799011257"
        "3516429336486994559408882196722920797431871205120280497991740451360692438534245102123154809896103271026750"
        "4632110823167822434654856228970383578198439787772359444028780395594775340373239203017874388024210929870605"
        "46875"},
    {0x1.1cdba81ed92b1p-492, chars_format::fixed, 544,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000008702231667009879595972740876282748210436150590379187728392187690"
        "3868602415596437465814520086552230400500984567250911796258452201525241617115394462392204802181167071519763"
        "2594303566335424562084952924302166284271162099211654864097202163709480482507076519884526116836205258215614"
        "8171394464612237005333734915500968164199971876218771464695624584636893210631012132716399776199978077784180"
        "64117431640625"},
    {0x1.e8bded2bf3efbp-491, chars_format::fixed, 543,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000029861508065908777159451976047342515240826688859949110638489858234"
        "0608409889733594243845536658198709654134476256943272501564888338028997374032133260948786678076350777407867"
        "9419497302854951107405362150099364518243510024657283742270237945843651504136068975350045379052042474267029"
        "6953273560932560846458100107183547166975426819254291611518094470727641954967048615321445481640694197267293"
        "9300537109375"},
    {0x1.8a43b5f93a8bcp-490, chars_format::fixed, 540,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000048178117758993382415252081853649016760029538206499370204986995420"
        "2500823235034405160203664726038623565286822407474487671722791487229578768266569205598375311931512631402861"
        "5794355146398741091383881484821645516016589991338662690181015071509492664273040280948122893995104403874967"
        "5770756688447619742657221113011558466576481022161112679423282758608611546415761983652714661729987710714340"
        "2099609375"},
    {0x1.7c6fb9421797ap-489, chars_format::fixed, 540,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000092976724414783708703425137615132523255799443671421598073694843277"
        "9850250477352389588739384698331012106689787849419886842856325526502716934419983558360032835835080894125849"
        "8928464653140915818346980791538763289936484730102094049772932148827792590711460754459836901369343119647606"
        "8605511929612365598618832617157268611528914345651254227519998483149903806006114637128234789997804909944534"
        "3017578125"},
    {0x1.fc4d97b6db260p-488, chars_format::fixed, 535,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000248453377974546054124096218478105162449105381129043001342851481517"
        "1967045024721937503911256327954787145007082612013536717790258656047688413221689961965839099976161689726876"
        "4336167475114409706302346559379795259653938717192120443284889978102477887234003586072984895060037225507355"
        "0116131407179797214274900984778979338365843557719019090662749781175727345483572605644440045580267906188964"
        "84375"},
    {0x1.27312209461f8p-487, chars_format::fixed, 536,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000288573615274172078525608166258096043109731380500375273550035474006"
        "6984700266197561310311413010903161879487471238509926986670990336855614873626750099685160011141832719989610"
        "0382007209935530694287868902684985822736702244425962649705422453347112460171425263410261221471206514481370"
        "8911163929066039321855007218207870451196293377558772035164374411778261640681986222034538513980805873870849"
        "609375"},
    {0x1.77547904a2effp-486, chars_format::fixed, 538,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000733829874253472696504662411664356921355995256043058139423378569315"
        "3425794095362433154716834833762320281163276751347969286341704922201208270815214318925357902195642894168771"
        "0346544040836292450671326704582503179785484653536739475002131596213572274974548972149055531629256889984443"
        "9482830827645593200019724173455093084667664261357601024773204125019706233964966735072721348842605948448181"
        "15234375"},
    {0x1.a21026147064fp-485, chars_format::fixed, 537,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000001634759818935282177045054054488787491046274899356237491510492363212"
        "1430427394154917169330583508545076873765892171099360310717869665020910581306139857330984180339339395585883"
        "9364145480190924253344292068014980758090871827549648002131375187771943927587887540239307592878494318358078"
        "5470118572485534281639981340542519549125892000830440747781608078598419419441567512762958358507603406906127"
        "9296875"},
    {0x1.e33ffe116dfffp-484, chars_format::fixed, 536,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000003779322643470511364635598031540684384273016181923210691513792826029"
        "8076813313813372642658016571660158177452338055855888546398090024181726654816502494516076011656336364216393"
        "7498191689679806757915110601496243241433049926608882895493979098170115259616136077677344537414294150339871"
        "5913393644403242726936741616261493580695326300741215037921072531691842576184736657296525663696229457855224"
        "609375"},
    {0x1.0d97cbfb3bcadp-483, chars_format::fixed, 535,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000004216777346143084109616894481874471130717304789167765447632830415650"
        "6561188571555447146574496467644980277018903207961907119388732661400545320850614276758509932232760700377715"
        "1774727915336623087705415153818142529084209963045604465362761727503323166241185255705030684089166869622162"
        "2591255126538876387262079254791476225386081573853957834303876636927949431155049353492358932271599769592285"
        "15625"},
    {0x1.fc7c669e372e1p-482, chars_format::fixed, 534,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000015906736035433478795666492032411048437699973656947142198913549771963"
        "0496307849953288877553271285177991680664449513987454305753588712869415089089334399246465373968206186757087"
        "2068837637964263788973684320121055067169326875666687873260448935727563546153270143949896632947326143345688"
        "6465150337567684375926650730030214310392272041024179539494508318355717874093002706104016397148370742797851"
        "5625"},
    {0x1.ca4a36bac00c0p-481, chars_format::fixed, 527,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000028672951771554432303752342207397704874686379593615168937776854662187"
        "8773405301900708068746337504994945322408818988088425644366771375033162476683944430496046660877697340757485"
        "6334919438201582885201415341555187435812767248875572624752948053776526726589546868961296725647676685932179"
        "5103185844509815639410574880178487307497168016508884042466468421161973623156882240436971187591552734375"},
    {0x1.12bf051e55395p-480, chars_format::fixed, 532,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000034379041633188433781391796667234074028435987426722232347622158962219"
        "7482682623389863983269985536637307332869261263118140094455518050615101152124817967901873027097068416097734"
        "3415198183537556724484060097889722304549743586116310371815207363078165968507947562208219568651368309624970"
        "8885236845139518626737016243174816375240155021122412920468850604975921680939165980817051604390144348144531"
        "25"},
    {0x1.7af60d7aa5967p-479, chars_format::fixed, 531,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000094838962310135761344092396167333415391569688763220398309454881231605"
        "3065147462448233077188938996167179801399057332623091728034184656426130519076454149994764188014351734458633"
        "3922580025523771508531272951951346764916390419819472756495777678716502600107256209456679635005594684631820"
        "2967669406868083831280060434746012560989781549406031651292419456644039454928929444577079266309738159179687"
        "5"},
    {0x1.b73357a425a97p-478, chars_format::fixed, 530,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000219829002164969519126362375173216597026707988157805326928281888340879"
        "0275588501934261303304156782175666496020163657838417950808986735463441471582316162574387379909783845369041"
        "3411293450978479405679605510279646240013270535759912260815315741921876740827520857597762872416630687383883"
        "512728005919619715651456869894288878525081921353210190074545184093363081601069097814615815877914428710937"
        "5"},
    {0x1.cba92c6e719eep-477, chars_format::fixed, 528,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000460139592854495622187848497964174062689248092750502409651176185387012"
        "4874208178789429842802485022063149539488430909194789376169291280004440926372510294058843562505380308641033"
        "2132906020576639441970365151635139919563397044809863566255987603107796661536180276223793295979901765098721"
        "85236937051592948849485535253991494778196501116690165993113720808993516442342297523282468318939208984375"},
    {0x1.8be4634ff76b9p-476, chars_format::fixed, 528,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000792608961783648857125868633389541908859107692040025788732606098253761"
        "5712397245267211703428369834900072721788119149529402481752215477108783887788832919655403424858374016379470"
        "5700539445581365307871355509910660167405264567879220059764200181085239747180724882163715232070198364457815"
        "99000049045968896364821326508004681718328980102387774532495348135674451128807049826718866825103759765625"},
    {0x1.195bb1128d351p-475, chars_format::fixed, 527,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000001126604874345762001813244975010961690201250155263230102874630022277230"
        "0762831245282635755871042079935221433039730425210520222756093843627061944194023238493891343960989637060980"
        "1593025643499862217542244084349248920736567803910409665339573573343421659688270916752098164150324786867805"
        "8348447755344979159303793136769657451566731575139884695914882679901314332937545259483158588409423828125"},
    {0x1.d9582810d5991p-474, chars_format::fixed, 526,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000003790698976276097701053929642020471319796132317855612556647360005645344"
        "8874348023486668990302113409067507642551266637528786672055653201849801299141775094686807981628168542009262"
        "7374913565047968810228895304309081082777648385365220836309196120447500956558312752535188664481796184515969"
        "998860513529444159982414204294876763676852096147815252970649825547955202864613966085016727447509765625"},
    {0x1.91dc30400a639p-473, chars_format::fixed, 525,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000006436458682719876730635812539634180995079699347021814214234357488008389"
        "1301701589050045580411828601056066543857861354184855535527508444334817882353822387608534700556827601216675"
        "4572940813489866481451272426938454005768836732009907411180509574411567449720530764934999343126892919453749"
        "22480428836021405851435879947613325905648050990408162049774727642148519635156844742596149444580078125"},
    {0x1.bb4959cd66718p-472, chars_format::fixed, 521,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000014199943377251187537949675350005079423187700022228758326221521640526029"
        "5213467409536957833999369366008722874407753705401513284671140970518928691753252515077837559669042688180179"
        "2231378697370136951216370863303679060473230296854766707360327968674338036515155027602470266905967351968056"
        "3684598499481186364055881959576442428067625960673098033625050273798251510015688836574554443359375"},
    {0x1.cab1b98b3b707p-471, chars_format::fixed, 523,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000029387007315399001337843467140701947490646533646383646741168981933069251"
        "2610752660214561865506794335949789967239321904345156747275229367729995831822884324397633531132361947458460"
        "6775207725364931442752465779602158622313197512447305365216189939904546876264703794084991693455204003412709"
        "032881758809299262428136448855311663929317040733753824545242128163380357364076189696788787841796875"},
    {0x1.513f97a6beae4p-470, chars_format::fixed, 520,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000043212757508195659485508065379853979844500716301246743150152785223009553"
        "8800362411846402873351540132643570960952043271132202966879024207483585271608519582168701354278018371563475"
        "0974720782095418660543965503018408535752782166921273364856333578679926605858330352242829232861196385760569"
        "862934221186030844482600416992243969322617877399178251164590935928799808607436716556549072265625"},
    {0x1.23ddda4aa4f46p-469, chars_format::fixed, 520,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000074795674901009501599687387979276428028217065964050376989668893383691257"
        "8238068670425158420787444745170314071895485469191115831640711419412290132762704670408024637792177786766340"
        "0480684683540310689622466015351601862349167111369075434108876998189806009451657247710719467572422765836922"
        "739389375015650257781352180780599630217854761888887876568332568893993084202520549297332763671875"},
    {0x1.37ee070b3fb77p-468, chars_format::fixed, 520,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000159874398570857491285439794684213474047983693396198429097585380915449061"
        "2351322400471462100460431734115547648302777044697168576967906980123863581995817786040434280493702688948752"
        "3834664605233743964551011893531130458715673817464152701502724936963357236274397010976223316921535529322903"
        "727447764051111283609075028782985288180585511628949125194354419221554053365252912044525146484375"},
    {0x1.7a3e814f7c455p-467, chars_format::fixed, 519,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000387725434793987459124953106745422453922512891032594874223625841852210055"
        "5592761377749317723583554852811781183024322409339926242048687874638428832985662512640504057974261144387545"
        "2520600259624947493551908767796439000133134722428633454335681641891495508639495264472445987261653436831132"
        "64168124346368742549505223090492057351838011423203673479209729890726521261967718601226806640625"},
    {0x1.b008ef4139a7dp-466, chars_format::fixed, 518,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000885729045808417896147542327116863969597592909959232598601584432090028129"
        "2962707482488999909479826983551325409988454772747503340056640501172935512844263846793138597095532215877953"
        "1368015782256417636468472367451669020006934158710715958539951912279109347589481317524549275125040003675828"
        "0058854629233171655759043026055131449871016536323016683784903335663329926319420337677001953125"},
    {0x1.6a3ceca142f25p-465, chars_format::fixed, 517,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000001485272161434473543729254163996306044326314110204365635337295518954951766"
        "6043979043032187958942357980893037084025284854740162292307556763858224145538295607452834423766627270010115"
        "3478685493953250306368486765749182433290574627326818284042141799183800323706078347302422984042893438179040"
        "719498788628840946618341162630245765429564945800410859233497973264093161560595035552978515625"},
    {0x1.879c5a128f335p-464, chars_format::fixed, 516,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000003211416622121784517432744711599239237466896440232926880096371200383034052"
        "1992537289583647041045528110284263530349951539139983468640852619166251243800157789356404381418108529823424"
        "6800586801045226636006748241313130752278657165236190851192753909236005321071256981677969599796784446204027"
        "87489118438774242735211460419025885846797137206727786040705296954911318607628345489501953125"},
    {0x1.a13b758752749p-463, chars_format::fixed, 515,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000006843053332100657829831562220682788863437556445749629660036369035098061976"
        "2819624331006890836920053795052268837040249511327940332807288732945808765620126034268676784571417399659098"
        "4304971343366016453921898634106206767439674588591040686882768194535915436770345312159774317472950368938005"
        "7241534775569646829196396378247871130136170076470499001874969735581544227898120880126953125"},
    {0x1.dd22c5548b2a9p-462, chars_format::fixed, 514,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000015651071039519719751268946730433209491685269599788420485953219030692473518"
        "4499016495553665668181218038463735680904417760697692262477792647738252648295215490091671889157286396107620"
        "5611420801384114282311152216549099455747381869282054756781298103540835711990016306871443323392685777042535"
        "287304513633281869348053796759051449311207979673589429925328886383795179426670074462890625"},
    {0x1.3a466b3b9a35dp-461, chars_format::fixed, 513,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000020617783292012132110048484524577034708763801812806846889421937147593782421"
        "0465446945123766444293508342185314226530713713824082127126656554247991288683437918042715199973601623635055"
        "6160745124128835050848570030661233050190132621333636152617574413419624138051138995646737549047491952163495"
        "32298011658742230483021286380716757918646594494906099104269969757297076284885406494140625"},
    {0x1.af63dcdd336f2p-460, chars_format::fixed, 511,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000056602054122048727921826190049712048498669146495554482077926052213769892391"
        "9721551078235387314088747298990346792194827829660599641240756981656489830070688868731818918413640802502222"
        "9254301347470836880704748790302969738046971386503460831112186107202194534175784137625129392628895158265668"
        "499896268624088807818901523078678889008399162559304063080389823880977928638458251953125"},
    {0x1.6ec02ea745f7cp-459, chars_format::fixed, 509,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000096241634559974588550470031663368349943378831463927445452058900881064926118"
        "1838480910523453866866848763445326161315986809133600636497090313419475443507804928279463021903686529521982"
        "7272372772827707409899810195006865574824665465743137968830206089146401495465235722508613312222305895849308"
        "3469442454413174103437740243099393609930015773545886048623287933878600597381591796875"},
    {0x1.9e78dd35e6f36p-458, chars_format::fixed, 509,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000217529092852511916976481136990537026377274895205410423605823337212791259481"
        "5669040846309042458464692354951809429921316594686439401476288544343704270602632852441755153220776502469226"
        "8832405245030293038442707283947578424923868378811923323228240750150943772355656344948644194454640554859114"
        "8840750526187231093226911532892021280816813831593403705255695967935025691986083984375"},
    {0x1.9a585f80bab85p-457, chars_format::fixed, 509,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000430726291201881032495123987757462219920856107166247088923744679917792617427"
        "7643926410960953639064656723442675253498019349377302472925616083800091852427968055195874797685078064633187"
        "4989411246175209989797637667922658597168331331423091617844456796847969232221344683029181274309997674362166"
        "0195737945380030785131722532615733040986549275130901293096030713059008121490478515625"},
    {0x1.a6e65ba502986p-456, chars_format::fixed, 507,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000887808969808456945123556994501356671674746084949835164788589684096594825746"
        "9219694116915470475749402676706508810042696649702920684395152260781900249028920025575568097493087047790032"
        "6755104819257649560814650013648850587868487950664334763601685103216924104124624449367240660195513725717769"
        "22263017000926269477966339109356079124769044186304967070100246928632259368896484375"},
    {0x1.2041239e921cap-455, chars_format::fixed, 506,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000001210286050585642744186350691141643855764814083642151305657706237367114407218"
        "0353513990930639340259058767237325709935670423513996244569968030077273275469517682229246899606678958937324"
        "2949311404414022027874115262780878530831274706477078046795901829349348680866369719046454352952713560173235"
        "3052334628323918972488583866538415926878032025104658941927482374012470245361328125"},
    {0x1.e2c2206571f8bp-454, chars_format::fixed, 506,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000004053888118960487475899480010322448211042441998490692220671702559606035648313"
        "7003469609681462381640957524317291188926254129669373003981744282470621799220617474087959579096390065480430"
        "4187742835595325686164988374589032221302465329000777188362131116839661003606492152115484285822834483953377"
        "3793548383142400170080167454900059158143070525692763794722850434482097625732421875"},
    {0x1.264bf10d7be2cp-453, chars_format::fixed, 503,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000004942621032233825263557206107090696840588821687003463265295180364700394447203"
        "9593835210475205592373220399127701880188471829971253475219339114010891882483976765506775180065695722698146"
        "6137842744520790572580634924148345992801094950146746195022190939969168798551415894884143192300883495947928"
        "5883564251332461521178735704628190938091092387907110605738125741481781005859375"},
    {0x1.cad3f14cb1924p-452, chars_format::fixed, 502,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000015411744957634478558732875158007911309742643791263152383028800246394250010301"
        "8411395434201182074077539207603218589797015836084381494407933290832598692742653536345116174588473355663138"
        "3997587521092166170726429621207135842117636071464132112769695338048041137489524235515090494741996883492492"
        "346460319710822961304962419452460110382008284801713671186007559299468994140625"},
    {0x1.4a043fb92141ep-451, chars_format::fixed, 502,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000022170106143596450609014218157804357964381470241171242549541903911649755928696"
        "3958402834891063160891464277435062966705933777580211869707929056934148231613404163981973357636235389342669"
        "6992729841209988489542923697872554428392780018075983672770091316945354715295754269008522521640290584844958"
        "554224663146563346799785217835259873951636588884639422758482396602630615234375"},
    {0x1.d91f605f33ee8p-450, chars_format::fixed, 499,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000063567575408975392743526724403263859606835265005008746398722782311228825240165"
        "0881046975492633161486563132346426578332847489634158927173716225287463270003583594203279044269022582967257"
        "9378987237901012851778677095976655741399044978428732881345094886140578723570628664975737909788927071910708"
        "005133352031145300938446489913435412388853507081876159645617008209228515625"},
    {0x1.653fd37ce380bp-449, chars_format::fixed, 501,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000095998267065455804136465170482547947366999684488969626917464974228247748059445"
        "4353279537485213672367703674531451560088375242660031278793518034857995227061963548088366069731985696736508"
        "4056280597444764311055010744517632659439131361488912251913663824732302366424969441750856521571686454336063"
        "94738931683648071281473554847572435787250721972441169782541692256927490234375"},
    {0x1.ea583b86883d5p-448, chars_format::fixed, 500,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000263525973150510919647132574948439570965792684539809398810026647756100088322533"
        "6060430789537878181702157577221312628897975753811027144814431329871394977027865977566960377530986920136721"
        "4595368780107386756631929499283165347789957070133359903826764691144708669140059711646621994591237328370942"
        "2329039006745983085457871703159650651759893236203424748964607715606689453125"},
    {0x1.9caa8f7dd9b8cp-447, chars_format::fixed, 497,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000443558520762325337039670177223898989458218572250586819779652406990802628870846"
        "6038623458578660938980539765362319287575812445115443604920161686867563637962378827974689216987973560102413"
        "1474113689214566704920362001387218474022856262900682427132163357445837625284898368022340470806780040356729"
        "3462593645569098752698552088290749606525054105077288113534450531005859375"},
    {0x1.0b26a7ab62a03p-446, chars_format::fixed, 498,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000574299933661418178408124797535427463828147490944204908273475129475790203620596"
        "8808235289577557214185221175809093488648720304508481719567216493518482059798351863125739938915060624160992"
        "9851660342416199442616527003779071061538402153295760816763318979764870166666613065845559449530246032453946"
        "67724116557668613623517681616016498924448541174569982104003429412841796875"},
    {0x1.694c9672ecb8dp-445, chars_format::fixed, 497,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000001553384362442932381943852794272995188882668422481808532165805295925774530855435"
        "8873724455989172691764656869529304703414054431429231326438943379765976288158973018332636251844090175709048"
        "7907181989255445273967251973559354426957069146438147193651593982875827959976241429283746749471915763082811"
        "2902620254122175049117795947993016236754471037784242071211338043212890625"},
    {0x1.15ca8f95f7163p-444, chars_format::fixed, 496,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000002388694047247810181551600230458601070525036995026327852093758673520557592030059"
        "7436987445133566199723253520905622088961177203403340626842562063948166533848716253990095161542222823363970"
        "2916913751658371808451818416175046591027822450168326666188029786423462650604766287956000936915758528714778"
        "113866919214746715859310646312523018774953698084573261439800262451171875"},
    {0x1.1c2c03dc16238p-443, chars_format::fixed, 492,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000004887121523587298843517079003723681337537860440567719421724171809032686656050087"
        "4834949274333014957336071556902275886701520752615198889555348290123499906363037088484546285431449365571681"
        "3545090738801982175971799897942112736051213679070597132029303741692199615736542790245350502761093230347414"
        "67856411410222751404009550700580088999913641600869596004486083984375"},
    {0x1.5e495a5a5b735p-442, chars_format::fixed, 494,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000012048289504187995891459061440516981076638732120771659218926621650385434481812842"
        "5565764606566243510288219058966625819337939917796520503670154154436651304901717368743143186394807699935909"
        "1565846790156423584109474593413689541976548679931460273314635130483027907981785192792081387152832558721199"
        "6535640679843097377442714718438765419961100633372552692890167236328125"},
    {0x1.810f44c622e44p-441, chars_format::fixed, 491,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000026488657681982224362975086519642031326070653599531695491298942136575989842374130"
        "9139575742203039336304529094287691741966627719771032423495762254409444179311243835772567386195458292994705"
        "1941156429898501392004941590588928963306893800268427406521691881809325113789150170542748396344959084162370"
        "3067350646766787719232319649187434862369627808220684528350830078125"},
    {0x1.97653902c35a8p-440, chars_format::fixed, 489,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000056050315915746605269229572281796709012860726683120704776540492198506714810181021"
        "0084408541082557658500853846529071987618814344910087704317888361861949507041571302535319807153374858734455"
        "6128663875426184058714691467962651372264615689058812238015769309640382466140672015426133338338772381569455"
        "41347798517839166586329037456071233691545785404741764068603515625"},
    {0x1.d0b06982197c4p-439, chars_format::fixed, 489,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000127865809675379673931701562672267103831270744526777044682020813167535931494462780"
        "5427237946283937896764463663208001660671769439390470311614391098056422657748039715753857555614071040843776"
        "4507966200006170913308468885696110133708193641014112495709199548680022709001658719762139244141769534384518"
        "96858275740510024279521401890935550227368366904556751251220703125"},
    {0x1.7ad59dce3307dp-438, chars_format::fixed, 490,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000208483354839111909423235805144553034826803434467093250087031592844497279565573718"
        "5683441726487182520478495393187135418421662424496630273340712102924084001207643461912854939156647313501556"
        "2202086754238881125112444185947826421095576363157279834423466108065623720077332405340673896657422758721836"
        "818312138692551879632090978955449855902770650573074817657470703125"},
    {0x1.22c47def048eap-437, chars_format::fixed, 488,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000320035283620302166788218219483718258378975585793664302031648857316898480203335377"
        "1713512488147392270162099228886927309075062423572422140898385972403389861024642832762715603470566441983723"
        "4475149669897348220989832360687594706199654822519956050144301526089683893154042597972946227286045644119670"
        "7008701319424714322741006011785458440499496646225452423095703125"},
    {0x1.d3be4f543da5fp-436, chars_format::fixed, 488,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000001029649923330716605140999056670660455822138004389178960245612518154204429685221195"
        "3765862019485098933960139442073435740250248629227594233385323846119340430984906337219845291452863937061186"
        "3498197972678354451284120449607345881475872406589424192521997712826297511857481300936242063273315044261497"
        "0604109796889529120935379002954590532681322656571865081787109375"},
    {0x1.fd62fa30b36b6p-435, chars_format::fixed, 486,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000002242639476728350057234478757977212780535898171050351393197817899654441013735267957"
        "5618851857302903865882730175199229103565496011292631095934557746078943220095026182662358550654902950589598"
        "6246328713415363125428407082180577115652387196835621603031124215033164972079051555401962570523619692898706"
        "28723535172405437079605483585709180260892026126384735107421875"},
    {0x1.170603dbe87b6p-434, chars_format::fixed, 485,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000002456872917149054692341910801588400297342034487935015689191135733263452080870321491"
        "8225650257080313080960162114039088967256680674409730194548950760744934117469497887462044942346223608032266"
        "0186527317970438773249144337156681937599876222913792675789099487731403308452906025020919034465325049445396"
        "9941105882736470645243131993851193328737281262874603271484375"},
    {0x1.77ea54b4399ecp-433, chars_format::fixed, 483,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000006620060796036903650416836422120773948577387722861356017297500910103852844569875419"
        "3218898779976326154511917336384287231664184196234936420385925179861320722403213741347947394903037876071287"
        "8146559509391806548214262613367163669769028100225550634362833144734261671154897581990416404798059344914705"
        "82775056018609376694283863429291159263812005519866943359375"},
    {0x1.93170d7796999p-432, chars_format::fixed, 484,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000014197241995605936318075317043001757935035457049201291955866575822547697829794624951"
        "9829155102541855874230559487389305607751617582700679057839905945613876060209570099889526685608968859022154"
        "5451651730609188595965784720429445370267692111528854939925241769500649591614777352662374519950927507309951"
        "396734409084237509869608206969360253424383699893951416015625"},
    {0x1.ff784c52bc952p-431, chars_format::fixed, 482,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000036028982430553334107374243676082305559955741670713515214432745189797018506318167441"
        "5119379044974650651610682213475903496748485769939459318413756361660218138899061663084963748999691972507933"
        "9977690290364910317130272509703637802374239144100499997431894236097897299940723946702573929557957332859418"
        "3181208512046210003243462693944820784963667392730712890625"},
    {0x1.5af297257d112p-430, chars_format::fixed, 481,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000048879393706963279061651865580809295809985896396271068785213668870613554247017676426"
        "4613568775870143246099332229707765029557354523950224816865264246462861886095699349276602653803989153158999"
        "0908585685941164363224037664050403023168762797067327883280705896601134110886320862615955338992676555453042"
        "929182604106022776158102516319559072144329547882080078125"},
    {0x1.03b2ee82074fbp-429, chars_format::fixed, 481,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000073174892255233898487807636785800529379525766260573968879990028870309082137226413786"
        "9707037754094766826168104680726241144403907247560017629565271829849434655181507428399984635472560338317561"
        "9782063705755948849457107129514927443108698035930496633435099731335354533972538276537731498433942868404311"
        "764137596868821065976273843034505262039601802825927734375"},
    {0x1.9fc2b88614a46p-428, chars_format::fixed, 479,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000234296202969220701654372625286792351494656622948588264432171250377493874471367898894"
        "0931408330268277100146802227564773380100494885443853694357578831151249749287345522900632025209052981850164"
        "7499267085097794392124402283114679695089634514614855499431411479366570952080402733612319102179125471664328"
        "3610837890005261507919698260593577288091182708740234375"},
    {0x1.1c19bcdca8429p-427, chars_format::fixed, 479,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000320201927875855240909079382047038971716012010839560229188802197580556167054647521707"
        "7921304566834229785392762185141415572109308314583465318465889928031182893624995025779228264326882685649894"
        "9504835132555500714162867590326120408214815993087768995979099704250953168843084388646762806659085377812944"
        "4374817060285816350262422247396898455917835235595703125"},
    {0x1.1d050f4eefbe3p-426, chars_format::fixed, 478,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000642475926363441603398664936416724231204931381677133186106010273187261145870100386339"
        "5620250675766811689611775362603277134352101533500749088440368668869832279571287827648056854835525875034992"
        "8305180701119184697114085791427306956508170513907885443381888417559679379113930618425048181904818918700099"
        "808584671394300069646732254113885574042797088623046875"},
    {0x1.11c71a2da956ap-425, chars_format::fixed, 476,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000001234269555172185411645268386384549988070188881757831646700056505708103168154961790590"
        "7560256885144592305226724008378153404624922096368343873627455317325142880923526847640917510564998264021442"
        "7984817459457410804145489729393111255042550742282202499332584178463194121184706289536253860130263980592733"
        "7145199863994993183524684354779310524463653564453125"},
    {0x1.ee81e63a1dbb5p-424, chars_format::fixed, 476,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000004458766043103084573814044495093892580021077829793518393203048730169238491691343231457"
        "9352529747020633396157671898279222655973091011667538712186773461994050081775765669981786041268824373912943"
        "6110739866715672133838542989425811131717350350468471316563500366111765468871232128786825100591863013070937"
        "9141148930754401380482931926962919533252716064453125"},
    {0x1.dc836471938d0p-423, chars_format::fixed, 471,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000008593040354013082701418503357485015504543760058542599736986671841666660902782732890282"
        "2137151134768600284621627912476256256232688597033168567478982725596464412740769155465004605025643046038672"
        "1430959519718823793955100880298043069592935232947251450817141949376117018162735245056092245100792007580709"
        "68485004270664973091697902418673038482666015625"},
    {0x1.55264a312e91bp-422, chars_format::fixed, 474,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000012304010474281754010997831364457453532363710534547555388355590377279653877735542614715"
        "8905193786947316223006782910963684928592070655580364056608821698264700123403236140552502228229389995505527"
        "2978080028616364247692131602981552825675357276743670326242029680867553906299343023194677184192076335608358"
        "70383215299994628111335259745828807353973388671875"},
    {0x1.652956524c153p-421, chars_format::fixed, 473,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000025763001930484683121866989543781242187607596461670705046008890509721150477966409285424"
        "0376142853819533477654997259597310460635607291805673065230273042570734235752898997793752366928544966510763"
        "3481209314028693375060230754644492619570048227210977560174685317157897957914242825662416808322569345838414"
        "9419639584654984076905748224817216396331787109375"},
    {0x1.0a2b6e525e678p-420, chars_format::fixed, 469,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000038399042293533291316095939321676303114799213077840440281919805704609059805275974287633"
        "2269808372499317365910044710145437381439295690008968031009068382843451057480056121258710576890301225315461"
        "8254069768331287570250854349786862226002299989130792880255411596025381026026745679225130052848864003625387"
        "812494718087208411816391162574291229248046875"},
    {0x1.80f3cf53f1e56p-419, chars_format::fixed, 470,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000111070534839140068297759822869409928825994888725953915393037234143302615526527305271397"
        "9071222660231423121274199566584365256903829077551651105898776924580345151091413341216886755831641521800220"
        "7239203834667792099786184987630604893166703784352411398622705699416184457581957405287101320388426024640415"
        "3365910871809063564796815626323223114013671875"},
    {0x1.c6389b5e53ad6p-418, chars_format::fixed, 469,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000262113368468090987732763146851193877686932341901067358564771909222467220653398653985193"
        "5456434459325162191582489835119660787344562300976799889128731641073139816977369344984867083299081514779085"
        "7329074161341060155608291304076285368309466167310219059822685021348364465654950636532913662418976454294622"
        "705464001821695774196996353566646575927734375"},
    {0x1.55b26db32be1ep-417, chars_format::fixed, 468,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000394360121134651044381759906739909380763523592866008869031497969028205506321153473563752"
        "3773562778065540267581844648852745541005978291930958793464356548638452126281850878581468028895762232111744"
        "6430729844203449939481104294338132959898181198769369429030216917445607336044844216188170744727707132695580"
        "92405053795204139532870613038539886474609375"},
    {0x1.e8a41e7181c02p-416, chars_format::fixed, 467,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000001127903182848672536828516281251793616978886016663493588859071153715021957468803662903289"
        "5212853463959440650365015465446648472216894301859689032829271238873991097893686964801536213424044711065189"
        "0664773510091035844518841538911365037381575702547919562424686775048201468448557500757249194695989044218674"
        "1528474147600036303629167377948760986328125"},
    {0x1.2667eea0c2e95p-415, chars_format::fixed, 467,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000001359122081875357896787748575354095721984684980673453454465121726789177000238439800164336"
        "3339942878637947316632830235804125241752997751017057571712609513429978861869634906214183307341450424559118"
        "7769088276321436054830545903438616748892094562844289647452615121206669018005906050956197704112274885164589"
        "4198336694813633584999479353427886962890625"},
    {0x1.ff118baa5e05bp-414, chars_format::fixed, 466,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000004718684877818967099406960594087621978278121691471108630994279892449301312885179077894676"
        "2990913058749981445405514710520814818552477939279502321175673267779420034282569987143013690995925309155297"
        "3875772042184950963851513969229000287211204414046599085288555867645375655323789795402580250648241404228910"
        "682305819790371970157139003276824951171875"},
    {0x1.fa00c13d0ddaap-413, chars_format::fixed, 464,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000009343828809651030070820635917985414790988850969247035368764192788867773143527423055878928"
        "6142542238872497991929164230405696925429022528853431359200549928734206507270504063714712419433330650525747"
        "8080943345820147523351879021893663491763825688527705625954046148312625239616444121811917130857641105884815"
        "0414934963237101328559219837188720703125"},
    {0x1.665b3a489008ep-412, chars_format::fixed, 463,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000013234786366979427240557035972871836642676524574733744100764337150714243649312395488035954"
        "5924438766721601552453328962421458549925648630711638265850295574292128380162020867890736183395718452916357"
        "8218872766927116060686026545609252412900499832587222722510252054321150497353766705080322145596004049998388"
        "463205145626488956622779369354248046875"},
    {0x1.cf3a6f79862cbp-411, chars_format::fixed, 463,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000034215813214105460697767882447548971368626256994487285819832925973102312220381249502362412"
        "5245826541377146311911755533093525433960566479878897896249684215009582527023317672508250867310488454244976"
        "0765465690238836297191957544621034981392176942003185295012273726522451681136015314107273762726204980959797"
        "408157641029902151785790920257568359375"},
    {0x1.f2a92a57319d6p-410, chars_format::fixed, 461,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000073665992405027932576502815813307644287807305675409422460506005018551902720267819605398541"
        "4238097696478280499866977319501776335044121496578337140066670655016184682180563483630646645866140852592448"
        "5546243819526362906038236009913051704692368907667120951434121614917932393108410626345799351846363141934487"
        "2508503385688527487218379974365234375"},
    {0x1.b4782f812a1a6p-409, chars_format::fixed, 460,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000128957226518911376304253303844382994740951550947702589965823067780944065331143233135517504"
        "7106886920241856765143066843221303761924148291538730101056538730732209809426369364550317168661576089405951"
        "6893342761311739812790458294828430025197514372868087428946951588938321376335125139248920989602892567087166"
        "764139283259282819926738739013671875"},
    {0x1.ee7af34b365e0p-408, chars_format::fixed, 455,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000292193651505918198698068782865963925588668114184031580780326550462727555065603598806674662"
        "9414856022915856947811511918774856265928387089565685999666896423079799518838921387503210415926729079378110"
        "9619607895393891478809206008447840421478719878021387067971213191534286370952639136576340754016239270596244"
        "6370904217474162578582763671875"},
    {0x1.14a9643bbe260p-407, chars_format::fixed, 454,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000326964662826875856166187350955931048656275212106681739462240684404497034874533411736674237"
        "5107112336478396840853548949246738861004173600213341731028216731013784067505813407159442286256745421705987"
        "9564336730252832758378650879985629367606550261680557818114147674750090027748379705550036504187010055755280"
        "291123199276626110076904296875"},
    {0x1.0ec395f04cef9p-406, chars_format::fixed, 458,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000639989320628421915713048856864376033446721595892847469872724593420864829856958870455047760"
        "2085248378390653621725063220797924719036318117380292385885371003940702879343314781859369351981914555340875"
        "3441609544511913279421353519249173156705147582989555546199916313639688302881558151527596389698696131148603"
        "0723472140380181372165679931640625"},
    {0x1.3d46e281947e6p-405, chars_format::fixed, 456,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000001499858317076989514525823966719727736795325325581008976677481214221154744543010314739392652"
        "0164148452565746821726438033859810485538866367711221425645336660624407212028615122093665600343639667915418"
        "1835015100676359058434896646680760060697115596642457489420363978275413709130349419500915238953912475561303"
        "09703803504817187786102294921875"},
    {0x1.5d50c95200fb7p-404, chars_format::fixed, 456,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000003302628563203096102743078152669510483465282476374993410534221659202776793852752821674602115"
        "4719645500132460661679437210805460928561156428685590521298685838304710818522176277171870516104981653254178"
        "5396613413881621221776174822715281962709879298154402362185091314805242630602420016442167195524831288522271"
        "67726596235297620296478271484375"},
    {0x1.31ebbf8025802p-403, chars_format::fixed, 454,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000005784701017386635665813571475178213245891547339196541041928139521776381395355953596859883517"
        "3728934249636260139151445995784828228796861442045536931617772159167928718170270039634525523947964910286046"
        "8456508414192128576560298176214002601568625115508870317479941454686582403880708905196368773576377775302859"
        "163275570608675479888916015625"},
    {0x1.45f7b06a1b161p-402, chars_format::fixed, 454,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000012327531669436545124898364942880066252999983643906149889220149845403378792647983133165166313"
        "0285406069850700818436949056057893055823679249585303051312488233045352968305435308456249734196737179082525"
        "7509795944446677228676476284721228550824045540658730028149589335013698528738527418574216139323697360996590"
        "077775181271135807037353515625"},
    {0x1.df4f5a7e05b4cp-401, chars_format::fixed, 451,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000036253358049975739948158532959144013335613046749062970323972515958518272146127656397527061651"
        "2330158936928670103303942817509059905956200910147442693283287995230815845232814920748801039202484840625264"
        "2689605477018394461232562723775452393614394463284378370218080769149758857505694173512387676848456319333990"
        "904851816594600677490234375"},
    {0x1.ae574f97a96fap-400, chars_format::fixed, 451,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000065099035263477567697676239505583198082407067935910598028302046053953016881173914627929885947"
        "7791434725258529119807135344605329826410498881079099916276669949098538219094433024528915815827831019768695"
        "6168782270401104253286553344639621446432482400791768130297624278687916140708336692433937814041000624598609"
        "647364355623722076416015625"},
    {0x1.5682e2e154108p-399, chars_format::fixed, 448,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000103625499379046964959091862600471117889956186476373368177844043699374677721759333633372126623"
        "5620753673521880301015481835316604546695585074510813748318166403893500981160445255328996646350393286993364"
        "7619899718109816110545702133214480028551930183171747963222880153709154561490814417130793857746429154076395"
        "207084715366363525390625"},
    {0x1.d4e64d894ea04p-398, chars_format::fixed, 448,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000283727637445888553581956642123262479865258843174699347626803180913185298443069068327981185769"
        "7978956361760878807872477381784762503118981775000906459859365606515765003795155337649895275836332041129618"
        "2841990724847239933972813842498527812062965816261318735671086279933601076560689263142953954466296551117920"
        "898832380771636962890625"},
    {0x1.8405785281eebp-397, chars_format::fixed, 449,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000469577627967097371555452723750881902711650410221457193320352809371226065978207672890408810626"
        "6317865597179068001632585327384778399268861774060494784439725118241785784274686728434865765110588561031220"
        "0051832556009496694325923769020452784034068367991583215029459659802806642615378078583902084902623741413663"
        "0832217633724212646484375"},
    {0x1.7eb41af181b1fp-396, chars_format::fixed, 448,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000926284137359904239760725747278318480851718538094388095984951772776103581377881621517687046107"
        "3820739358671762399252297245381355188827437788019215124457909177576002204640438529929676809008996321079667"
        "2437668826852763435171642577713087958205149690123341255227614958196411999620035033920092092107889669705400"
        "592647492885589599609375"},
    {0x1.812947dca7db4p-395, chars_format::fixed, 445,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000001864465441767581948787876829126288776423259173812970804019699886455097908896727904513649076247"
        "6499773291512962081243971521160974817694996939384559925965931828721807767099510212703533750486073791155737"
        "2641561128410518344272982297646952019398857018895104864314375050246045339758763594224279247502096268362947"
        "739660739898681640625"},
    {0x1.9e33a8306e02cp-394, chars_format::fixed, 444,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000004010086210363826026032740370210610951607084380080466649977013897450280879472138920077347559834"
        "3085572822186905057565200084999978361609439732179814096524045340334030955205854963234999783849578354807610"
        "3129101125761463915188021001142699068384893953126046023314764012090470686426444166900948107290503230615286"
        "15653514862060546875"},
    {0x1.fc59e1a319ca7p-393, chars_format::fixed, 445,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000009843181783316012260131321277312294289340991085154620935488572812710829568897687517917454774898"
        "3566433413213202579862251653915055051534624458376958526131197186020467753223506752832174473323470653788040"
        "3917023842260757480666094320718236505488857267067091810391923600161329878145656933799249876937409453603322"
        "617709636688232421875"},
    {0x1.ea48053546540p-392, chars_format::fixed, 438,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000018986595125046416834783391206475835197011693029669966155263156671691418830838428529139208448680"
        "1761628631187695816852367151953603093414023513472452231891026909148753713286042719755834756149864024108431"
        "7352618090220909719089204136527578336674363112487531886729182570991963930462755397177154748078464763239026"
        "06964111328125"},
    {0x1.c4f7cfd35c403p-391, chars_format::fixed, 443,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000035083205445088968495677101873388169021587210288068562220603066512276293052810916395438868133171"
        "2988608732115906573028050475979768658205494632257575125878903299547717299838346765905333055749041027617447"
        "6658366227091941304109695520879458424636283604303800109503244258137414372793865533547291724048022842907812"
        "4463558197021484375"},
    {0x1.3f1b2c8eb7534p-390, chars_format::fixed, 440,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000049430715648584051844621127511504766932271831089032969572932369896232697013659331467295126281359"
        "7280193667150223703961334976370441319425264759617856817683619261680544917442005575369381757511402108712309"
        "8810853003250818301375453449086706715170921583482977020013786182723813883417931808877954225067696825135499"
        "2389678955078125"},
    {0x1.d06093b0815cfp-389, chars_format::fixed, 441,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000143867487806894634411720089270450072936305130349694969058045926550182615349006253769384373773928"
        "6573986672966155584474563588101073051265372588214952195923105424109066866902340001776788856342178576245158"
        "4783343017610136929540867731038936461298859821917731158626523192232145847810922912810016605078544671414420"
        "00865936279296875"},
    {0x1.5f088215f30e9p-388, chars_format::fixed, 440,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000217505354802260436510639680305528377013354190487961208732896657467379828645778691824236741661289"
        "0229435519025675788633274348734782164672190715378378245031133601909436517434190942448107290434316890946990"
        "6749542660244958783700832470282660653384794973337579621259557692831744036915874677268201153879090270493179"
        "5597076416015625"},
    {0x1.1ee7b2b7ec4dfp-387, chars_format::fixed, 439,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000355541202374641346026941197599213814105300914392385231945924023425570572466280160634143786390438"
        "2973685418873700535065775639722966823229525581142851589902504581542460165636219125927902840526377377151983"
        "7017726394054052113160694923207086389507835789415091172180367926100267413479119431307662324570628697983920"
        "574188232421875"},
    {0x1.e5212858a9ac0p-386, chars_format::fixed, 432,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000001202373545031365142117153878587117672681703606088163112794349727952117452707283033519505201026174"
        "0485366509703588584741742271044985659498541447419517312938892191148190125806622886098622237138943960841251"
        "2086611891344066242908281352486220003806306620784871586188979194136328089090315351938897947547957301139831"
        "54296875"},
    {0x1.e5a64b660de0fp-385, chars_format::fixed, 437,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000002407325014922304367752994225709352155168529396617220909980347611275176660681396749855751548512680"
        "3686976280250984695970972311192849181782997143031420579120058075178903814521177139449414732736685869846710"
        "4394248895403905847739963053197183129346301971948844195756005547239325696110955749018600613453600089997053"
        "1463623046875"},
    {0x1.a4a35c112380cp-384, chars_format::fixed, 434,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000004170137078921815569275422874696231611004697578299747178989974247794441351318576020742053361837789"
        "2337282650336960911124358651887698501080398986078585524941636181345282023250767388273145296009832430066275"
        "3351543989060579853452118286049679797374297229051509580387032947578194216464025911861313034023623913526535"
        "0341796875"},
    {0x1.fd84aa058b587p-383, chars_format::fixed, 435,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000010102559419519475794201171450381673041089322627018053899889380695208263228396234959442210305668054"
        "0315800262617175361107992065273974530599080955152985761274225519088885807436325575834309377713847614939429"
        "3333575213736221842600597238671029059811607467346072347130676068618442925385256248027587844262598082423210"
        "14404296875"},
    {0x1.8cdbd7659dbbep-382, chars_format::fixed, 433,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000015737569358633547811206080917170425167450411520103815909249604594369345874856545245212805027522831"
        "4828697279497837821986319825226191691030482601360852618520169586052322172410999244763978900894391063989290"
        "7274429293647733654219928166653100454479140789463860010824500467182821754168198236101261500152759253978729"
        "248046875"},
    {0x1.c3fab70ff77d5p-381, chars_format::fixed, 433,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000035846791147293954395277110210507684652698239680639314917967800036918115365251759384633992808617776"
        "6654702878948196800507852844357586424000876576667554483947866806149903563073606011829317396890873012538987"
        "7873734579886342475181978767165737092606523456123743582322344239764951045502938686837524073780514299869537"
        "353515625"},
    {0x1.92f9eb50ba810p-380, chars_format::fixed, 428,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000063920642274634331751536794408261143575334629993511050648872666338672571665986021735206183246506631"
        "6310275076674090520833858863401291192443279548090882698094889561395443424178066943634531052696735508613482"
        "0770832743853266338258506304086673064382356156732325879211387133444020186567868790916691068559885025024414"
        "0625"},
    {0x1.e5d12025f41a4p-379, chars_format::fixed, 429,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000154121878455871486470826794435419049309566271972237357143080649393136783708643797138575864124667438"
        "3737872144770457576229734354276582112144510562904694677226056840964234255885720568245232592703476094357023"
        "0741024501879890512991571333881927803034219492641067380717285096610293451679929432884819107130169868469238"
        "28125"},
    {0x1.70cc20b16cbc5p-378, chars_format::fixed, 430,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000233996571150694532427993724274548584419164096370267414377840680924380456729680389935073467054210096"
        "0754662232709991265315584539304483378699489630430398374405591067045972532565084161218473970667549929864999"
        "6392129046637675265839770011966526475548357054437982946807154687712923708808876455123026971705257892608642"
        "578125"},
    {0x1.f8f54258baa23p-377, chars_format::fixed, 429,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000640777072494531477345712948701814594979738366565675282681480642255757344672522661067334015294856645"
        "9128687255374758152631994199565927896597954231389004959433485579373270670316843744515124954660676742400161"
        "6573352786425661214416075033874283969924056495357668700583762395704820122310785279751144116744399070739746"
        "09375"},
    {0x1.b425d7b5baa7ep-376, chars_format::fixed, 427,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000001106917806539146411804119783585998685398182337099121427964465106805819523657678186433645989968505869"
        "9818985838907695245733491850809542760700002379068511372422761458974690077805955121015028589977154994267680"
        "9335780216735649319371255941752281553265395319094745377493328576212587577298762653299490921199321746826171"
        "875"},
    {0x1.35f98a9945d86p-375, chars_format::fixed, 426,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000001573395880167279095191183196645054033328690151042218769824508106193613244008211017299551381155218880"
        "6194750848300838014147761414381772834738961847109691353849345494773983988350461308271434235528286832057230"
        "0743114950473751978786711409956425483511937171834026083192810641043710151443235645274398848414421081542968"
        "75"},
    {0x1.22b6deb90a23ap-374, chars_format::fixed, 425,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000002951264303968298727160713040288227598425097892422298086633590377567996746115235964290839233947857299"
        "5711210671115813710187104734196413453864402244822331613591780511111572198567644093094822621155112946806780"
        "1597918458036879627149037484905674326085936247598906544838680851648021752353656665945891290903091430664062"
        "5"},
    {0x1.af8b9b949bd33p-373, chars_format::fixed, 425,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000008761895839903947528941149515793299411928594010639363029617300553600151529405497910367604494761067749"
        "0024580643376208998689305233206456297827193680314349424392820092411434289699250489116523598050954081394617"
        "0682297386793535999528105468209541146150882484707425121697199914185677505074067994428332895040512084960937"
        "5"},
    {0x1.6717d5464b378p-372, chars_format::fixed, 421,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000014581718353001727202767958474568085509641315254096668946517258054929653338668760014668801958991413536"
        "5885832166422613380830543504451930921550793798367298723049105942703198978517102345816708317809381648497621"
        "7917490144653395402570757209661432587925807640507185377121211582174264975719779613427817821502685546875"},
    {0x1.e82648ff239bbp-371, chars_format::fixed, 423,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000039644645414828138173162257943342753791936726404197770155908477143700013008038105686863030846404367750"
        "0604244814244967592799688033858650321919135290377962541541757670567069855566579894393167253937584463430211"
        "19484783841081544723213616709921430880585974508806378200231489063870560229929651541169732809066772460937"
        "5"},
    {0x1.e51cfb8657ce3p-370, chars_format::fixed, 422,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000078796103616943104296862864926637808976384305685460046349264971296098085718108590424082442044168977749"
        "4808702928472617532638674178490816260470459625717085681235305001720392192877266453685066566192314061292465"
        "69266701975452020742004266052294229064688879217955185466426624822655622182310253265313804149627685546875"},
    {0x1.b14f77ac7c51dp-369, chars_format::fixed, 421,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000140763730306989132795428946966494953633354394967346965100654775368454144611191354294993416273482074426"
        "5292749359478573706183304487111250587990863045610478788209575619784704283920909471718395936147460221139005"
        "7681912459797630302957798856517266927440740025132710425346247752609318837357932352460920810699462890625"},
    {0x1.e710d0676d8ecp-368, chars_format::fixed, 418,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000316452957894299284366479758405498013015153300365442114668302774362027017236047806669916218231558679126"
        "5939819803384480542154343286832485112721100067084904332871322417428918598692735545635831596174287807117276"
        "1923133899979676544387692632814983780063270773577183589647492112373328154717455618083477020263671875"},
    {0x1.681e2130ddae1p-367, chars_format::fixed, 419,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000467946374062146005526850091841119946310467880706732949118469529585892942611358452448420003810529184217"
        "9716636868566303654241614314944289616568687170600929848244691370240879435848048353721799426016783752234675"
        "71832515625537071561402276458569226060997833551855877904268772582430102602302213199436664581298828125"},
    {0x1.a823fd627c74ep-366, chars_format::fixed, 417,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0001102278795072777171761094324315510351910541596223438913463998337507598358574538862112825212925183136037"
        "4758720007850149491660100407483775788429494864937877683258886730185228974149721931720492869658905773658805"
        "522025872507231167222528685303920977870186585482457331214116436068906068612704984843730926513671875"},
    {0x1.4154d3aa34c6ap-365, chars_format::fixed, 416,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0001670185551585790858474780313244848775648310183299379723297530880407191909597279001615432270490567092703"
        "8588049413218561015314058502253510201835880192993883164036125066854166498016829336021274172481028822007979"
        "73906720466201397769120663869839685513950245652908075809535415334750041438383050262928009033203125"},
    {0x1.3a9ba6e00a75bp-364, chars_format::fixed, 416,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0003270479232134613926939519818831086498076277245978021966733788050641828861931365879518963315790184411820"
        "2961795989982173691003362958138454636644978113023886891879423315621501731645725021544326049449904953011856"
        "85272846413113018197664085143742641569449064726380745830695839782009670670959167182445526123046875"},
    {0x1.a63e2539171bcp-363, chars_format::fixed, 413,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0008778772927538465046420583968658156712478310784640448770263366803250453713800969065649510220902821736113"
        "5521839038855897343021929048284359152954843460038384673539560484604234173029320737290621489135529752758096"
        "35160087896703692795742861281764048566296912514108556450931342141075219842605292797088623046875"},
    {0x1.5945227d7951cp-362, chars_format::fixed, 412,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0014356894911231067898171923164012923523397719956349474652622401817264054835179242430812570726867562039556"
        "9609395820536576981686866835269785818676298857562755446418526260219235762960808818683579213832173570812722"
        "6471309299601555074913893102541253974308888834531656129855914372228653519414365291595458984375"},
    {0x1.82217c782aac0p-361, chars_format::fixed, 407,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0032111903570682555570830432285106056350808268235667287036759585960084214919407425089581154098784074762322"
        "1984762123193423025747805649805390981226048331145080309572679467705818692956022292826723774128752395133008"
        "99684678865465498234764125959913015552026947590190386616626483373693190515041351318359375"},
    {0x1.098f6dbee458dp-360, chars_format::fixed, 412,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0044169724909246743271783375837700448384399037383754852175667172815642110900066699080460389447141005868057"
        "7300512595879015513339295564000425906636050874382230874106442651414859196934264601320288039760451686440122"
        "3779211715551095402858460824838483699891256643499837415689501796123295207507908344268798828125"},
    {0x1.fc1a3e0355565p-359, chars_format::fixed, 411,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0169021881002942186349352476374852702816515493199417965353300827904162495133687276898844209515941302157090"
        "0401849903068670189531301308560376699856638876652995737610028352402636866451563731365247130745763937745851"
        "966064973879549502996367695229140698130020298981164052209980042107417830266058444976806640625"},
    {0x1.9d22abb8a3e58p-358, chars_format::fixed, 407,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0274861575182721631984627503572349625218405647917496546304489442051213309343047354877283852370984774869609"
        "6258479741644981792047469220622160496576122467419063847819950632784885804621987847476285866255227176855010"
        "64683276474702628786475061222493509474216607179307414465796455260715447366237640380859375"},
    {0x1.8fe6b364f92bap-357, chars_format::fixed, 408,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0532113482015039559183269947122156749830157940875473713147339471075371407926785436578250639785856358666207"
        "0841973139561826683859629713951889226218072364000034484580100026527733693817077658207262024951913070084247"
        "964985873179224173871150940905947186618917750283892786899997418004204519093036651611328125"},
    {0x1.3924fbdf3f4afp-356, chars_format::fixed, 408,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0833347856239357821162981086852666866433705748816360348008711535610941446633825141501665403919747446868711"
        "8064179878306685784138623550444206406489413805095796762933268020587437640839695511544931028011676745684700"
        "454921274138664102521131689349566080338539705656651646048516113296500407159328460693359375"},
    {0x1.59bba3abc92e5p-355, chars_format::fixed, 407,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "1840146356658305700046720506362478153418514919580729143953237144381157088225992502276364147381509037196968"
        "9088473135358898469208008830766155305349854160835782765484505720924511068004105209529393758874605705530766"
        "85104080099519938253964156154017020428131091156799536978638798245810903608798980712890625"},
    {0x1.f91ab28f6d8d2p-354, chars_format::fixed, 405,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "5376784423862267048130427466387650660078457949027335623159161680415466312113697113185133707159343207900672"
        "3080140691741812174355508525869297029994236481283212404596534967023190163547269801449291075872521732140340"
        "644845226572809529157488064473891307432846836840412141356182473828084766864776611328125"},
    {0x1.29815f4575ee9p-353, chars_format::fixed, 405,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "6333829374806563141955671468236487467386767628504964445167342592478413863059249829267913771551270371906653"
        "9909954743680825350924903792374425889482639248091034065790800825635803681559457761114287896040451046117396"
        "942666747803151643950824239942570360031580162414599488585054132272489368915557861328125"},
    {0x1.9b5549ca69f66p-352, chars_format::fixed, 403,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001"
        "7514400642486577219423056529958168455121436480387689214857689064489248433753353045222356747974792138413681"
        "2907705310492578831489120381580810440200883241625934295912642633798054015146534242980319769381134505869389"
        "4271570763602292963970708357409197599381992481448744314320720150135457515716552734375"},
    {0x1.124b975a88735p-351, chars_format::fixed, 403,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002"
        "3358765579576565334772675826735107157872544630083091706192581114916616667385249065695562210242645649633370"
        "6045442624764341660639114681090349749985529232191675913872702599912722915102318783709303584090894615368605"
        "3705913497996218739612629046751784994643955963022907695858521037735044956207275390625"},
    {0x1.1562e3a0ec3f5p-350, chars_format::fixed, 402,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004"
        "7243986610495878878673984778734765597249236867292989667607298760616960219054966616029202455795780518195146"
        "5005795973444987034101304350852038218864051288571350765414212230181767935792865589673805453295871045943135"
        "218617322658165475074435295648383851079801960815007788596631144173443317413330078125"},
    {0x1.7499ec4ac4fbap-349, chars_format::fixed, 400,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000012"
        "6921696719929717948595293074176270655868821592065115228502723093035575508756728752819417052641105625324043"
        "9621573862942745585133754372795203723658421886786527780857438475385595423831038622147456316483532086718444"
        "5964579981005077479106468489233703280283545311579729286677320487797260284423828125"},
    {0x1.2027f877e5c8cp-348, chars_format::fixed, 398,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000019"
        "6313160128987602230140589069120674893779125406478798262830941469469129607520870479724158468275870268316408"
        "5298367163590557291258677012723236633153179231523169035127063055277636210843393104609703858162693765072077"
        "32386773493842387889323502724040878468329818229420880015823058784008026123046875"},
    {0x1.3ebd90e3fdeb4p-347, chars_format::fixed, 397,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000043"
        "4298948725607294181933974340441952979288925912414026887685176387402855942127825498213786975990109531847250"
        "0014791485568942997169292799689712529737613650880834560117225488561289885361985023302255032167618356367847"
        "0959217821493701938086947191985055989095487749551693923422135412693023681640625"},
    {0x1.4363389eb80c6p-346, chars_format::fixed, 397,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000088"
        "1261657539118292960739409946303123725780871006988101793185755149006004001323026927378891990623904794199498"
        "3370136608303805922691119433796411506570515804574414630126734908108636442398157037410986760749781932649286"
        "2699285514009118677994236229754579522131796576189799452549777925014495849609375"},
    {0x1.36a0109bf8851p-345, chars_format::fixed, 397,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000169"
        "2966213667821148807895558802568924925294638856811351781262146839883981321073090026355949504140594721412330"
        "2342459896152434186640950048227971643360361238208070759951623991031798070100881289698339939026486985759943"
        "6031413554009831686140961859092949411305373264013951484230346977710723876953125"},
    {0x1.852936e8160a8p-344, chars_format::fixed, 393,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000424"
        "2001623031538089445969926359007458012110794838156005148358262320454521346511317229281281681846424778075499"
        "4591411301341557818660225142325571011067858617072978287595726603489974360133507991534889217365667026874405"
        "553342866483389551396854187976397966564068298112033517099916934967041015625"},
    {0x1.149ec7bfca2e1p-343, chars_format::fixed, 395,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000603"
        "0529809392781297437123670700685046655048483789943399879178843944794509056750476172827344642815850382802738"
        "1568077204681688731224261312765461811069975259273018052620262934972760395850186422694979262707180445833295"
        "30560909162178292548227844095570554690255438146095912088640034198760986328125"},
    {0x1.5b2dc6b83f4d5p-342, chars_format::fixed, 394,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001513"
        "7520077480203129736786547797218619270753778448891209064918076463125636944869989096240366834149603449714962"
        "2117214819752421125106211299219496197133556427938606464103348868389804966690375917611422685068708804532832"
        "1041443260516963902382193582509786917988936494339213822968304157257080078125"},
    {0x1.da0f73386d67dp-341, chars_format::fixed, 393,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004133"
        "9493171608475510736380563699750629156862226280416325731522075378368999604060724669971773099651206101216101"
        "7546178458942728313191490202170666992385689982184609191280290273663347725787965403909863535334056723463899"
        "330281266936838654482799695804640972840449109071414568461477756500244140625"},
    {0x1.638d3b1ba2bd5p-340, chars_format::fixed, 392,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000006201"
        "0359315134640090731319437049206220696431274480364487068426341395584546604605252648624919716507113178716477"
        "0913020638743635294940380183735409118973050619962086116661476750520741067204022527272515483696214789128062"
        "67420333330775690907300282423840649681512360302804154343903064727783203125"},
    {0x1.906c98f786defp-339, chars_format::fixed, 391,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000013967"
        "2797288113210155563802057639497080261101418469784665765265619430610942383225098573170486801015161092094059"
        "4801693043132822511751377565218354726435621618748890676388642623241585694961988686328873397278768541909462"
        "0032800056105071229529844130628872533872453232106636278331279754638671875"},
    {0x1.758b9ef75765dp-338, chars_format::fixed, 390,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000026059"
        "4284576091544869113024441675656851873115337841133722143365708084172564125190249561915251837705554401742351"
        "8212053862650430595916363766356788828785993044882368496423582980924400652007259360486185742061497737426327"
        "712363547867434874089592920722198432503802223436650820076465606689453125"},
    {0x1.7b53efecb0cb7p-337, chars_format::fixed, 389,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000052925"
        "6571861074866966622564362184991758705054614745692426662338541604746258507799065981582672715208499392294202"
        "3922151415788257853173565728994460950103536934704595200626972777255978544513779471271516694092626768178059"
        "63710919477975920904905105901332162954275872834841720759868621826171875"},
    {0x1.c70cdb03862e1p-336, chars_format::fixed, 388,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000126981"
        "6065184715251113419810988125845614275995682808177058849759881139428319192849635487192859941624854592126248"
        "3131621666812225084740060541828173882845409244340666437092454026306133640042784394113986314671002430586612"
        "3781960021918923744815065946835164201189627419807948172092437744140625"},
    {0x1.c8620f3a56118p-335, chars_format::fixed, 384,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000254707"
        "0634124934890222190262256837195757396815299333529111418249146905687757756780613328879250236219137738411041"
        "9810650980668147894567226414738193796911230347051073523053009279230651798707186324331033065240245566418482"
        "483161473301224825995891891394773409729168633930385112762451171875"},
    {0x1.6de527d45ec04p-334, chars_format::fixed, 384,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000408411"
        "6507906642250331195895235501255489010558232931652737851087150126965735140861940171547943101025911017273318"
        "8861368164992739794129569170184038097703308470945993002999406224190943740318423365285121879965284119243738"
        "253055377647337106095646631909179546937593840993940830230712890625"},
    {0x1.32f4268de3560p-333, chars_format::fixed, 380,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000685242"
        "6249982067291046594641114025792733808444130159885465849871908890575691854893072294419504006246523212127411"
        "9409952619928433358684826230009248507051618413394733219630867274509517957698525727310017899287975621138616"
        "11774779207012072627762389043226676221820525825023651123046875"},
    {0x1.9504d4e40f114p-332, chars_format::fixed, 382,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001808326"
        "0374699234761065257773418498730106022787616035325598600451327358187952165471790323439179847122950235854632"
        "2993371696334394192802862629454251406168400743329730917576310927470940241674403303605819271810565651329510"
        "1069735058671395240667729986672185304996673949062824249267578125"},
    {0x1.cb9bf91a5cf2ep-331, chars_format::fixed, 382,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004104121"
        "8769683543865527782587708994321977282570253751835355176353868356467589133067113662048462713562786916368979"
        "7540950303302913366392376656159255697944455891223668807057168630685792060203335559517088803685034984665409"
        "7283173859379552553760216182521247674230835400521755218505859375"},
    {0x1.534d1a72353b2p-330, chars_format::fixed, 381,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000006059640"
        "2508961119571296495219413977960985088664161517023286865497038758610911606257218864532266059908463494356686"
        "6588930258825411622537414066336047894439146752568610278062157672883821538692535856116708042779936221736077"
        "402161935015293480030935946434311745179002173244953155517578125"},
    {0x1.8a81f0ebdd183p-329, chars_format::fixed, 381,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000014091162"
        "2646550940969184229022091314518130712359406867042679799339056299623708606466087017396017291953984260348123"
        "9618162645140267896879864401078309489936080873580641530655526126026020234997201175781845924483971174376577"
        "529462311334822327015502130276303205391741357743740081787109375"},
    {0x1.2d8d843b6d359p-328, chars_format::fixed, 380,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000021541940"
        "4380193248651670288841782970808904532288686034378850074779233789912213307605694984649811926449815799086766"
        "3560088611417226829754262697058722921390553425595293622934754705135445794701795670505815085804830927660005"
        "31858470043399035620014514424980234252871014177799224853515625"},
    {0x1.5ae523c56234fp-327, chars_format::fixed, 379,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000049562087"
        "3989840287980026752059150291459341625517462870764782641410663349026046170213552612704183825027030799012887"
        "6185253023706365698846472532373612522455538362393161006908387382989139874630325656459405074424384497139546"
        "5018007039720702891320847083278522404725663363933563232421875"},
    {0x1.2e2fba4d55710p-326, chars_format::fixed, 374,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000086348821"
        "6823528866804486133456991077779977792835930131332092742833348662272985748573158444338915496975298063967453"
        "8071785979208342202737614219262452227901906240725418988393360968895849158615336311017872002140977317552544"
        "63696422798459940983750726672951714135706424713134765625"},
    {0x1.a8866b54f8da1p-325, chars_format::fixed, 377,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000242613404"
        "1499034978590055564514475383648601798436032509268632646894181389474970094831927936969903035456201621280676"
        "2871422250085874451502425072522491337759461940696977760033858204402517273797078661623029789913858154155280"
        "11949603900100570948172862273395367083139717578887939453125"},
    {0x1.f1a5726eaf292p-324, chars_format::fixed, 375,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000568803420"
        "3287511080114010781167425724268104097312920112035604606624252520666836277601326754766687008186470986973015"
        "1105993388888142740897880023820002419173095842184519157214057327786285037297808619594870323944323955228780"
        "749141742495715752536700193786600721068680286407470703125"},
    {0x1.449fb8851eff0p-323, chars_format::fixed, 371,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000742082070"
        "4814869536088751675067158544895470994812275183936089793018924239658144174988893916502142322850833635958296"
        "3439347313321543227117769751347811379872515444979296564830945130871029257222410374399398236040744961050708"
        "14565044206960464645561614815960638225078582763671875"},
    {0x1.46c05ddbb1318p-322, chars_format::fixed, 371,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001493891068"
        "1786228098433397618427083905000278780570950467448198038274216732657666002119768524178303625459142811351426"
        "9539148166937605854031616806544458143119642972251690661738492452061452603871892869715803063032290167203688"
        "95964772527028274762272985753952525556087493896484375"},
    {0x1.6b11a7ad03ce8p-321, chars_format::fixed, 370,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003319865991"
        "2779944591755497965186522112578908724555826481398937929092451620495530950235419850252258210723507610335779"
        "9725303807187723552061327603203139944318751411700583753118403087341835633246108094769809451825572845842984"
        "1924240692903336213959164524567313492298126220703125"},
    {0x1.35af01f0d426cp-320, chars_format::fixed, 370,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005663431628"
        "6537580410549627430526563174209683489552393365657133589081290878698891065102827260170613964063421798849062"
        "3562854632880516016770172038156097146354316708909596705851523980277831473118340477805634968266611038773673"
        "9752007997066030053900931306998245418071746826171875"},
    {0x1.dcbfadb8b3393p-319, chars_format::fixed, 371,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000017437369721"
        "8196113063704015243208747067965875508016343943741287829742157754862319334742044342122418129546722253205431"
        "8242253107903784262257495811123117467793836357329565702945521480598781283000370307663622328454156102695163"
        "94232537279639083660498499739333055913448333740234375"},
    {0x1.e33f175f87825p-318, chars_format::fixed, 370,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000035350054379"
        "8210402817892842659760097539150560271582896635734724603643181350804565324201879704146663916020005749792748"
        "1963655369280316553093601016308703840044416860234797599714687238147587264455072639781883052945016623706665"
        "2626089735718395434815874978085048496723175048828125"},
    {0x1.754e6b5cce5f8p-317, chars_format::fixed, 366,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000054615606193"
        "4441318621092045441032660308681227358557603718106692853823448693845175292429534277882694528221586447733355"
        "5245129408920113772627882583255398024993020964149434865318046789416202263713530106328387058785716076215004"
        "574612686683021678391014575026929378509521484375"},
    {0x1.8467156a708c0p-316, chars_format::fixed, 362,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000113648474919"
        "6438175580907332565880653966873506395118992763683101773589005179813700866154835962817624948656756383550758"
        "0954231657277026079560947234101704808680915410879153776375826243910611440268005043071854993760549846641059"
        "96887417671104003602522425353527069091796875"},
    {0x1.895d0eb98e49ap-315, chars_format::fixed, 366,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000230200078065"
        "6893202458516089685679401590576324453158175134547155022646273232545522244477459002923119279321035265858094"
        "3454895481930310174158828988727175916938505066846090096475282769653718973005391423611253029949878718850332"
        "174066138091195199422145378775894641876220703125"},
    {0x1.40a747961380fp-314, chars_format::fixed, 366,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000375298902424"
        "0666642780953754135567335978452472991859961173893630396968364346350643567404509708653300043590368338057512"
        "5143713587196206996924176535060370203741533267488207717423868283366861735055394526781231134347450183664810"
        "112785757689746191090307547710835933685302734375"},
    {0x1.3b6a90b6dd82fp-313, chars_format::fixed, 365,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000738338448129"
        "3360100162604071222320854504989415917243667423373175657818383210258806923533986241556370859195332901443406"
        "1400015193119257876364506245948504929991412023543177395961251163226947557872491055376075316272590357735037"
        "89072506886537183845575782470405101776123046875"},
    {0x1.29a514459ca70p-312, chars_format::fixed, 360,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001393476812215"
        "9904445853290075552856512674507704664699177572841136493178162330742824621681098250948372789843472975025145"
        "6654416423830571259374225337974011611156252922037258169533613173818100385793804677394622735141766994054388"
        "605073224738362114294432103633880615234375"},
    {0x1.0b74c8584ad3ap-311, chars_format::fixed, 362,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002504286566562"
        "7230013905293764731537341817933131283917087004920122084647344228898478210371710543160857493563223693900113"
        "6948844407029210584627234019763143896970351150846985824258803274296439361886009001435481001665108126089397"
        "16590594759537680147332139313220977783203125"},
    {0x1.1e03e68fcf7f4p-310, chars_format::fixed, 360,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005356123085643"
        "1216215705891197384170210658872854832333041087321234180910038318181672802850047733820007628560418217168597"
        "2328799651035840891788773709992554797907500387843891228116979454940850233766623349333385640802273842934100"
        "485380088940701170940883457660675048828125"},
    {0x1.713e883d649b0p-309, chars_format::fixed, 357,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000013829457207184"
        "7350006467947786140534609402102460119338483840183504329951410756480852036970002082214938069496871105807765"
        "0616342008059436475519226330199242170564636294910908465637413172208311802193088597551634614855151721147207"
        "000139900401336490176618099212646484375"},
    {0x1.86281c91677fcp-308, chars_format::fixed, 358,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000029225397297013"
        "2914853402915046037003365995797951158161424678070205702834545391776697284890614697909470154629997814087950"
        "8687731981104368938317412794557509506094479412204017138158281353548291029466911248434233716220045938072921"
        "0268068385403239517472684383392333984375"},
    {0x1.45504d79391d3p-307, chars_format::fixed, 359,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000048736427954876"
        "5161115885562973232237353661326521702392018462879200677062285966561894022674262468399524132160049764777409"
        "2578759747996729059226009083377666503000929669306147768883189338553343486811660273955905839667699971359598"
        "67351484575692666112445294857025146484375"},
    {0x1.8b65fbaa5facdp-306, chars_format::fixed, 358,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000118472141176650"
        "3795834920011168926296215936641177727034485569727245391385495932888180052660104404787609525395088845106890"
        "9045054476068079407828299173083787534280114697185660289803879204360881162923549764539705654978955780374117"
        "5956435682792289298959076404571533203125"},
    {0x1.15b31d81ca8eap-305, chars_format::fixed, 356,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000166412796674715"
        "9828107765209825994552167129554936207837810987076903930581624018675917720336651340542435363305307619807439"
        "2079428468517747070184564672200772228970478128098200293765227442139878292915729397733401783923305939554351"
        "80664181871179607696831226348876953125"},
    {0x1.eac3901bbf6abp-304, chars_format::fixed, 356,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000588185044246909"
        "8516920553670028118760656704237860263120333531016471621746637456908577353248513356817228666441363174804107"
        "9603736093364172756069029939969846461903462814768648203770730263090238795720931192885832356103167878986701"
        "10035226343825343064963817596435546875"},
    {0x1.54d51a8657184p-303, chars_format::fixed, 353,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000816981584111072"
        "6190959340594713716396752204762409775690590311177074675593649619210154923484788418377974524231704747460727"
        "8211532496775158564303013511601060759320541814855924433742431495891719034839407284806072370552380195254937"
        "86687775354948826134204864501953125"},
    {0x1.4254ea10b5973p-302, chars_format::fixed, 354,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001545269946488938"
        "3084423290711151957352280795463335067223992351392751481442851664811520430139228875639213995744337299656369"
        "8494777793436879534495292022436992037556775109404800293598056714392374950920150650171867569806873131225966"
        "044866027004900388419628143310546875"},
    {0x1.7da943773f203p-301, chars_format::fixed, 353,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003659395376290149"
        "0298980465769951165569165929629731813929605504263224870936440470834287500461898098845461917630071247520018"
        "3741800575688110181618613341186483104049336857735772610014290974319446787969336623844116806490099061063836"
        "49415647596470080316066741943359375"},
    {0x1.ae4f00acf5c6cp-300, chars_format::fixed, 350,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000008251660766595778"
        "2806495449548266610202563683706678154753337492221892598865851270347456671454474309415340154294710835376571"
        "0923663409929467862648030890496688726139045114262386812243844497274555150209350984257558006307623973962783"
        "73662426020018756389617919921875"},
    {0x1.8295f42a5103dp-299, chars_format::fixed, 351,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000014826450102010817"
        "7112109309230404161604761515251859062798560549580412410778763908075718248823384450717892513774699575501451"
        "9989666396774597050923947581614694394142733801357605731634397122864408194429046946612815415837368683560359"
        "983175658271647989749908447265625"},
    {0x1.abb6488a3abe1p-298, chars_format::fixed, 350,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000032807475032115240"
        "0621002334783930940202513541814817469150751240127675013509155922040907645472112074412341589250311944676967"
        "7606167840548043568275485063335952880492463696904911366558949107704185370883887697884167403882199956499654"
        "54731500358320772647857666015625"},
    {0x1.48abffc61d5a3p-297, chars_format::fixed, 349,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000050421279276628866"
        "7714049175213434496558184101026994112477668656706985117641549717061039336615015558509431246691132567436980"
        "1198150556902001329039711316763352353546309989047586031244556241720884452961200633910465023228199971105922"
        "8275189525447785854339599609375"},
    {0x1.68d80a54d6153p-296, chars_format::fixed, 348,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000110713529313139876"
        "7717026386576564905999076270512666752625153773141953869126009209387761702504512599387595189572820355949180"
        "3353030449422757775201774891500460993748209972927568896749778497989235797960843501525091752096634223345716"
        "918629477731883525848388671875"},
    {0x1.2c6b77467b856p-295, chars_format::fixed, 346,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000184348602722992243"
        "9864671014820259607164916371907450371006190330032051780043274915710483106829066898772124682889055778430799"
        "3280265606013315339776365873870562188509836621092146310161464010844116362509684895752013953067888207826285"
        "9067763201892375946044921875"},
    {0x1.6ef654b64f428p-294, chars_format::fixed, 343,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000450362971454614901"
        "5565847390136487163744421281719924533654409304717063588099858576407642256409055860666625519380863533430018"
        "4634028151020515833502204384460487026824375085037728001029155097609575124669889142655211742433118971007388"
        "6089958250522613525390625"},
    {0x1.451173235af75p-293, chars_format::fixed, 345,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000797894997669661890"
        "5743204193329440817482113311923432159532259024136125855019496049078781186160682797898753405806699852897325"
        "4481039137378992025466005103154103836916888873664956672360806241970118298900602228377874924371282450152875"
        "753701664507389068603515625"},
    {0x1.ffacd596082c9p-292, chars_format::fixed, 344,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000002511861056992210656"
        "4460984688389187692141330531682768924103863645054219481499842629645126936078591972527872511472222243531230"
        "9709437730552329335737166622168597422045113087432814378216341861796310595179875161588614823973686362990065"
        "39047695696353912353515625"},
    {0x1.063332099741ep-291, chars_format::fixed, 342,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000002574328439038412112"
        "1339828370307253704732203904243798931630246226927879139516091842410667400769648561814006096715185494529174"
        "2251165941694548044712489711348582758259760078958923842987028079231637018004530552653017459741047190391327"
        "603720128536224365234375"},
    {0x1.96f4c617754aap-290, chars_format::fixed, 341,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000007991143060138612044"
        "0060711986378002682633187804808109392328090664875747637758557400825900344026788010313343272911369936246104"
        "3666923313670271869280829318221799503990742364295320472425956004990574429576668221347291246048349933062127"
        "09285318851470947265625"},
    {0x1.935ccb527a6a7p-289, chars_format::fixed, 341,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000015841152817579089701"
        "8882464641018008950488543008157320474270002138555112131994111586969178359200601940403856832944195530241996"
        "7746287933439864720708976721912575416846145830426694475875093628131081178417251003920666538316019966714520"
        "70586383342742919921875"},
    {0x1.3b5e38a2262e5p-288, chars_format::fixed, 340,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000024770739864851201045"
        "2155211305654889101839291994373257256314216727223966524139888430219634166161400854032988566619651757547235"
        "9891526537618251014430666239671769242560566212549308763232701265169301373333992197678810748273647845962841"
        "5293991565704345703125"},
    {0x1.484a5328dfd67p-287, chars_format::fixed, 339,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000051571453461558414690"
        "9754111958434101816659023703664033867818207164808688726169703472872850000784856430335588701703489523571282"
        "0537383690075538450161438034853869422976361266642382017218067571284158409883746152359111636354072061294573"
        "359191417694091796875"},
    {0x1.34089c222a3bfp-286, chars_format::fixed, 338,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000096778617084384446515"
        "8565944891863915602747909697915764205500509556759598575651716164143069092577852590346952362288345318732779"
        "8568136059930544298735015241262011909133987707450757096283166295478439265991543602940180845983775270724436"
        "26821041107177734375"},
    {0x1.e6fcdd939cf07p-285, chars_format::fixed, 337,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000306005556558652005349"
        "7677219724879439959145670618963086526570704041880822755231488655743456205128555382903007168865333581857182"
        "6190105221989372774229983686836022431888358343760367433825245716062350333706110021552565525482236807874869"
        "5552349090576171875"},
    {0x1.44926d40c76ebp-284, chars_format::fixed, 336,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000407898671083931571877"
        "5294875626470385926419123333105307604270807518529328891798583990444803845522897437277247965812453288478962"
        "3464577842685924105438447903371304802399611547626347695335896454048526363549443947247030717306870428728871"
        "047496795654296875"},
    {0x1.4e29f7527bdc8p-283, chars_format::fixed, 332,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000839906286351287938781"
        "1399937801734945834565528522981195141320594189544565521220835566976062331631101494419248955870560600137698"
        "5537432417245983422897581939844353607370673169909597826206179621656852140508748086333845606077375123277306"
        "55670166015625"},
    {0x1.8c68f2953a6ccp-282, chars_format::fixed, 332,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000001992717826656166044464"
        "2125584749374937520778851582251840153437757893208705737778210140182563707851211680549600008809348350013647"
        "0476092352988612163262395625243307278830900372908744130530715872596772314013667190546463814371236367151141"
        "16668701171875"},
    {0x1.daa11a32d930ap-281, chars_format::fixed, 332,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000004771839231117577849683"
        "4201787015006522460756370577250546037300400638004617260362478357013608710612128385322177994718163923316958"
        "7356613212047538343034581376134935211933499518225742900654242594724446526025006878879430871620570542290806"
        "77032470703125"},
    {0x1.c877431c64f8bp-280, chars_format::fixed, 332,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000009178454461057711008754"
        "8536112667514918507241599449782305683393170457359980388202548163671022362647074555117211601907492906738459"
        "5406042749373380753064107605729164133086776553397098585026443014794176607191273850605561790416686562821269"
        "03533935546875"},
    {0x1.5319d83c3ef66p-279, chars_format::fixed, 330,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000013637044518063170854462"
        "0760090905084613073552309882071588338221196190603646879437448326867262360431709154963514036585997359479452"
        "1598491713884892203310936117346635245864362504730914824313006233451354019185590427110099653873476199805736"
        "541748046875"},
    {0x1.df184ae5a1660p-278, chars_format::fixed, 325,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000038533883620323423714136"
        "8128893415340996478918164189505690827044688227151816733024219543787370498849648155949225657910076871879456"
        "4929080860556792381458881802490168760412120163853230487833062749073711941022457594385741685982793569564819"
        "3359375"},
    {0x1.76fe5bdd1cd6ep-277, chars_format::fixed, 328,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000060321909257448322486188"
        "7996966232951770214205402364690073024853288708207880615382738524861521119471824996020430389313128435058945"
        "5757683977891608532509454031524834955525796191785318935471432086135671333301105923041518508398439735174179"
        "0771484375"},
    {0x1.e827f6053cb84p-276, chars_format::fixed, 326,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000157050726605353931219748"
        "9455185685886539197056637023936726196188936490075003356583213294480785568242997342311657438088381991935594"
        "9272491412335198004143965428959297991382269299217708245206148360399598046602265277726928616175428032875061"
        "03515625"},
    {0x1.57fe4f2319e0ep-275, chars_format::fixed, 326,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000221340726418391480146163"
        "5015569718274627178765751299225249596505238353182116010182283950977351771990336765898850911669779695349426"
        "2104386349156169447242147956660447400279680075978087677811790841695191575308476750194586202269420027732849"
        "12109375"},
    {0x1.47d634f051b6dp-274, chars_format::fixed, 326,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000421889631569647900919768"
        "5512987966320685875867604111458001744027098589253025634454275850202149904374614351329867678610640459460381"
        "9499146960639827531342972339284079258492104097977877930835987641028139759694082222551969607593491673469543"
        "45703125"},
    {0x1.ab161f2c4f9a8p-273, chars_format::fixed, 322,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000001099225953719482307807849"
        "2322005134697759069190880982299089476477421890699462556853397689401906770390979778607694151546843280207413"
        "0342767290219697959626185832487110501790388370592167474364612702816563355456835893164679873734712600708007"
        "8125"},
    {0x1.e291ca105dbf4p-272, chars_format::fixed, 322,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000002484054238126029593102682"
        "4878265850213738163806945569103735598853085085998454192004270399375665114378419793933909342691597838382392"
        "0259991198886269275880452442035925336260690735668115500978992897615927476495656378574494738131761550903320"
        "3125"},
    {0x1.05497b2f09b2cp-271, chars_format::fixed, 321,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000002689980129196104964925989"
        "7509032221460182990193199573687789715730498841548008680282752621494050089364971956146360501570711407609350"
        "9216799977300670476900145388353293690677054565291249211441112205284685587880488810696988366544246673583984"
        "375"},
    {0x1.5c2e8d0a58e74p-270, chars_format::fixed, 320,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000007169144283915296680065178"
        "9754421125674555953045807849165758253326495394357218725180436693959779826838539023524181158608569041319117"
        "0438571390570469553243783321439188124683995544413425828554208859124188824019086041516857221722602844238281"
        "25"},
    {0x1.150c7af401be8p-269, chars_format::fixed, 318,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000011408995211686882396999673"
        "2771619429059117696310083593483087029745251732070619014374528062846747967900668779068752395048930939229325"
        "944194026364434225582687841188243409709254873786228664105033274878825411136062939476687461137771606445312"
        "5"},
    {0x1.bb30e9d725359p-268, chars_format::fixed, 320,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000036501624740693435787870241"
        "0891277836731376220732051140141704161506159605875161481334726669028801083941369022414280357161153404157898"
        "7268880778049879810047432484556757312227489027693957016145786181405066828098426867654779925942420959472656"
        "25"},
    {0x1.8e26580dfb59fp-267, chars_format::fixed, 319,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000065583965679406291322543386"
        "3772474907706697339230956823918714576491226620528055668423504368694790695666244799577994068697065802161796"
        "3379673539191502533261642388234987613056971297550790007411141205578147816979139861359726637601852416992187"
        "5"},
    {0x1.2ebd25a1e5a0ap-266, chars_format::fixed, 317,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000099735404360143309836615940"
        "6069412823786123163324796730068189863724310472848274992506525874894482730745214907159098256425409638672402"
        "82046493845413738188365824559847017543136304439349637525185634460284100910598681366536766290664672851562"
        "5"},
    {0x1.430c70559fa8ap-265, chars_format::fixed, 316,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000212852635715402355756963326"
        "5933551639296725987663497454190032844976248188264555042422152048670432612287432453899640173462327851640422"
        "07656441873771873947372771748143644161220111890357661173789620596974447863658497226424515247344970703125"},
    {0x1.b37b4c8d42152p-264, chars_format::fixed, 315,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000573866702023013827963720278"
        "8807056492920169217697166963059087608965977706055865270454378473854683004629500446032807258003040576004522"
        "0527069108799560747635923877620361175609046577365973669951977782777152725657288101501762866973876953125"},
    {0x1.e7df267017ba9p-263, chars_format::fixed, 315,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000001285809956063130133848197064"
        "8325266446537589188919690394573293863678630154936269933032378796467868286022293131359614581138374615252074"
        "6396771825426169624107483758544143530277325048406906936058276443024528390424165991134941577911376953125"},
    {0x1.24edec18cb7ebp-262, chars_format::fixed, 314,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000001544059773715194646097232293"
        "1613150367282007839535034780293980553235893087580481701735620945314590019229682990302900204048714059771297"
        "947553595019588135744666474064112354893256519803109838895912968304013901388316298834979534149169921875"},
    {0x1.e259e5060f8b2p-261, chars_format::fixed, 312,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000005085041310658148984326449739"
        "1468834239896808424048302785732446399420840399817211944222782861236400064717650029209129207984481028747992"
        "2800960523182642683648046932685960291959579642015772043086609122131136473399237729609012603759765625"},
    {0x1.74c84ba4bd4a4p-260, chars_format::fixed, 310,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000007859891790258630143706359270"
        "0391486067845391377030263724566219385264035315415509521990392844610347274677649318753401309311030578426734"
        "94543202277888281984892070647330058705596424879530849578503082231151211090036667883396148681640625"},
    {0x1.63e925b45db68p-259, chars_format::fixed, 308,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000015008325529570412331623540869"
        "2318222467298748568848667528071014844189585617221497166920080296757455946666133503364128985836668117456388"
        "387335023474589528561716496306845300111545482800773821004114427779541074414737522602081298828125"},
    {0x1.8cfb3f3c5fcb0p-258, chars_format::fixed, 306,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000033480454826799275168273424149"
        "4260245160394205926976743394714852099777996214181704439045307244233459338117526732740417275913568885136319"
        "9856905782006938943098182212607365397150427389013379979310069956000006641261279582977294921875"},
    {0x1.f7c87448db5fbp-257, chars_format::fixed, 309,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000084975685812240518705712137865"
        "3504086691655000597238726212421654829545650974876771798110445932287518001991785436537587101247795788092235"
        "2800183139082748948605372626813875208770216535992080681381766193993598790257237851619720458984375"},
    {0x1.e5fc8e5d48f9bp-256, chars_format::fixed, 308,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000163947724143070226309182119377"
        "5372634243918692270000593799703073872677907151010451429759058340761011227242016051539416659017291756167864"
        "060665103292217176205515232500969434144333778734538005321386133772421089815907180309295654296875"},
    {0x1.ae03e4daf2ee0p-255, chars_format::fixed, 302,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000290131550137518304336272643681"
        "2116563756484400756322030273213923838050864039865987841562611675023491725703543580213144915476445763872235"
        "651387576298414489076718483357143723725388691019565212680930699207237921655178070068359375"},
    {0x1.1b8ab942a6426p-254, chars_format::fixed, 305,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000382611804506936019106599873748"
        "2255120049858934710011108712738518689170735705966447549912007319027170983581023332628356967493174797628748"
        "129494411563405321852741198026896593856497615654551312791564754434148198924958705902099609375"},
    {0x1.0c1e462c5c1cep-253, chars_format::fixed, 304,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000723598272195478800371822609801"
        "7140780701095782183686293577823391688605110135925206639698894546021871641529980582179296597763425758540148"
        "88159205157469067456314240460661266281712378036264886327355583262033178471028804779052734375"},
    {0x1.e7b34d78e6948p-252, chars_format::fixed, 301,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000002632414291507956679404458522820"
        "8590792665767389780345214640856391021186677025555855415331925777643406404267481582715967520197234875894526"
        "97486195004740894571365225366838907355346627759025424087013789176126010715961456298828125"},
    {0x1.19f7b9144e56ep-251, chars_format::fixed, 302,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000003043900383151561567633605648528"
        "5756533835399224529189344052214824595214456119324049792258875343600293464605060356052949960559839643219948"
        "250099914213156123317711143870226847667680860980675416893603824064484797418117523193359375"},
    {0x1.9243a3c6aa988p-250, chars_format::fixed, 299,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000008685053970949931955559499782793"
        "3889454841898663613334205733556673628208790371074675294281427261965075820622127188272720686006316883426755"
        "728765572095930620716564177375514361089642420728218485947991212015040218830108642578125"},
    {0x1.1fcc03dda0a29p-249, chars_format::fixed, 301,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000012427314157729456479934367418834"
        "4921139801832679256254035832815095396832575738969536252302952905818679335139867126855919765889486660234790"
        "77125532193887343148261321890083229131103071296755857577664983182330615818500518798828125"},
    {0x1.89816794283e0p-248, chars_format::fixed, 295,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000033983797108077041005965221970144"
        "9270111386975593968697829250705890339709488341324515374071635287665805623289119716016152060124454015265884"
        "05167456823811417909534098707575372193159628231295954492452437989413738250732421875"},
    {0x1.c60043d326280p-247, chars_format::fixed, 292,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000078416589235876873864289188382541"
        "2680982061972990493938935625523315898525486989136226372381121432223993609915480134465272471761419124295424"
        "63342526076594337886490692674241112102191675337081733232480473816394805908203125"},
    {0x1.80c28d4967c46p-246, chars_format::fixed, 297,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000132914077601964831657415119941949"
        "1075305257086908475749508503265285908288591400306702686081517049600710538824206879805638335832128758336392"
        "1988770555946670003883812600453791642239414171056122171421520761214196681976318359375"},
    {0x1.a40c7ce612bbdp-245, chars_format::fixed, 297,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000290208965790319384537361173621222"
        "8667135296506323548714539974492591207840732828200977273593613094846558098038147780280954865082646231469077"
        "7478454224088947478463265810300725797569510767959233277224484481848776340484619140625"},
    {0x1.efaf47443919ap-244, chars_format::fixed, 295,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000684930633110214442852626226308539"
        "0101973923359825322543536163696365620422741413585533131004115616382717641362970861808789762143903765257144"
        "24271780749287936058534182261326294307462493604621300846702069975435733795166015625"},
    {0x1.7500215776f19p-243, chars_format::fixed, 295,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000001030814484713535377118614529817109"
        "7410301970246782425463944124259742140545264889430363986396035589042598392965577684427324087311806164099196"
        "31827705932480302973969722163129709559888265435478871268060174770653247833251953125"},
    {0x1.4a99b1bcecb64p-242, chars_format::fixed, 292,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000001827277123300592913288498842730137"
        "8153940847425631690632810979503758848344768354506461635004842080033192263390140106182493404532628159952008"
        "14086913857733087461577506816919375825548910174944694517762400209903717041015625"},
    {0x1.be72480668102p-241, chars_format::fixed, 292,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000004935150669641910324006166926550225"
        "6149959617111583303561219685377261392905223787116563640644769825543047758998821713721504680236906163507862"
        "29899863402284617929661166109163084243262320516265617698081769049167633056640625"},
    {0x1.e7a659213dfb5p-240, chars_format::fixed, 292,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000010781250168794165933748349260234324"
        "3910264638792899470531141938294828417591353189172688117587481618090046432679611225514535349967383908198802"
        "53376364061559733784810868039410940784524062241445108156767673790454864501953125"},
    {0x1.8490c51f45e0cp-239, chars_format::fixed, 289,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000017181272168700195560600399255994575"
        "0191688722510099967403223288619485158101752998401507139707482255573997867396379335700002769043874836031870"
        "99842401715999979637460652213279215481944728338703498593531548976898193359375"},
    {0x1.e2624233f3ae1p-238, chars_format::fixed, 290,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000042659307529076216561467963956055319"
        "3168972469683442364205790310634427253557408187714105647198337090919889430309795900282398265726189862458374"
        "678051097719482165551080831781337690013222729845665526227094233036041259765625"},
    {0x1.d34363be146f9p-237, chars_format::fixed, 289,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000082644256896671227468821316614503358"
        "3318272051367540732059260881575848379677685269313105225560795453156201999752392611005149405019628407058574"
        "51612605924084149511941781828994646637298604474608509917743504047393798828125"},
    {0x1.cc0d98a80a987p-236, chars_format::fixed, 288,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000162738020657325978961138173872602763"
        "4103097410045766684562920176381305594300538915293361058918473228314436959590541926080602810091502080422698"
        "0534376836276932498708203738289521621263045147998127504251897335052490234375"},
    {0x1.0361a6687dab5p-235, chars_format::fixed, 287,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000183505869443814376581462090395957966"
        "2255884361050661407760281655192030983533924668060541241759050983674635009073179904153453991581773532228622"
        "490354517767036426047187834187574863309411199452370055951178073883056640625"},
    {0x1.334f6d8947b79p-234, chars_format::fixed, 286,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000434828615428421369337573376270471592"
        "5110958338493111881172797715333830872916712442244649032535828057602138531289335929051088851434758295916723"
        "76873605604435264983395219417897960278995839189519756473600864410400390625"},
    {0x1.305f84a10441bp-233, chars_format::fixed, 285,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000861345397615590038055480615315880221"
        "8112390354251248505662201630614528343138187122485072779443239827237358105127242669202292238202206019105358"
        "3587616875316948729880599795022920461828874749699025414884090423583984375"},
    {0x1.c9b7f3905ce9bp-232, chars_format::fixed, 284,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000002590595243725045563505923729301582289"
        "7473731806321263112212662836451190738319086758301231709882273911943529327018044446621067865400351938481216"
        "559748291967404307769910111881699055214056670592981390655040740966796875"},
    {0x1.2cf7988d814d0p-231, chars_format::fixed, 279,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000003406827648187512110628833531572523878"
        "7330858093186688658099540644480044178549555509113134844354121258224253452591702106989621843660299350553233"
        "0186491208047744444804166320805993706244407803751528263092041015625"},
    {0x1.2439294be562ap-230, chars_format::fixed, 281,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000006615700752136380539591751222162850767"
        "4702476236714185773792545977038289879884140448995517698614722807482564316269955719701793397075413905783271"
        "318826294501086750761564164204087123977160445065237581729888916015625"},
    {0x1.7d0e7e36e5257p-229, chars_format::fixed, 281,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000017253632008143088480986275464805616259"
        "4664610475574084555791727712966221709255677969584776451459889348610943280541592636736407336659321916801029"
        "023411688490517352222660438058887688583808994735591113567352294921875"},
    {0x1.7644d51f65057p-228, chars_format::fixed, 280,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000033892588392445132904880849439603103583"
        "2408658546980420925396178891103575355839740945128488973410602319117156688472064894916865501422840027142738"
        "59791254064651550505603955741606991836079032509587705135345458984375"},
    {0x1.10bed5717b54ap-227, chars_format::fixed, 278,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000049397904291451873909412488950158690757"
        "6592934125894735294262798645025293238520392188366703254950604394513860826816969882247207957292424991122060"
        "599367981196290341226848470690402592708778684027493000030517578125"},
    {0x1.97ed031bcbbe9p-226, chars_format::fixed, 278,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000147761815700754991357783998881795972964"
        "6543270693691090869363980717301850413872502132999352585749189714053058229777886958874081655166914945387334"
        "176236365795347469506899364122265438936665304936468601226806640625"},
    {0x1.e87bc17774e5fp-225, chars_format::fixed, 277,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000353883927539305215694586030569756054270"
        "8905701070644453775189948397167810358540904406875368957330644952008736200486300421607355606413910639782040"
        "63233997161090636218434661575127364585569011978805065155029296875"},
    {0x1.4ccad3c275ebbp-224, chars_format::fixed, 276,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000482185633857731122231087086928544800265"
        "0682677831896983412031939032716293413681877374959247433165167106011799750781588278683806073709165512240232"
        "8021117440941168240798979371941612726004677824676036834716796875"},
    {0x1.5a61517ffd9c3p-223, chars_format::fixed, 275,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000001003746392394803539895237768695472569570"
        "8749868243331851405077722286769296317670730594311068901851751621982905208845752049158036704193593034774538"
        "757502752294448392761903876557738612973480485379695892333984375"},
    {0x1.3760a2aa6c254p-222, chars_format::fixed, 272,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000001804630112067757783115652327375138155300"
        "4340805312555968258097633741380875846144919225810181030729661426063465509289312072911372495984143831747178"
        "764135517056767525796712181573866473627276718616485595703125"},
    {0x1.b29dcf95ce2bfp-221, chars_format::fixed, 273,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000005037756265273765674074043183480696509275"
        "4376110615663711189065303770401719757724363364437831625604535900905066591416234093068063139894383117810259"
        "7624583278594631650763868702114223196986131370067596435546875"},
    {0x1.3aa4a3e7fe35ep-220, chars_format::fixed, 271,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000007294226364184892470979197433331855239292"
        "2497189413454562471159916381061755863392570840931492118884350692330286429326633451588825073607891188996001"
        "06765970543491284065751312226666414062492549419403076171875"},
    {0x1.74467fb9beca1p-219, chars_format::fixed, 271,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000017260576914043516299667521604544099503136"
        "8942254606077291025462183934993722035708739731939013562031045416518587029197566747180584119441988307413207"
        "24457610150486788942736371410546780680306255817413330078125"},
    {0x1.04460adf3c909p-218, chars_format::fixed, 270,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000024135211264249107986888028696130084430233"
        "1199680608168326292370848100433544597095878127513056419537958634482951063686329453571446508833729813534139"
        "9152847190355737107270162056238405057229101657867431640625"},
    {0x1.4821325395af2p-217, chars_format::fixed, 268,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000060855030282997452019447514867331630657468"
        "0441276457329900935114328316525912406566934993043883319480057195762916477340190285864330691976263848355178"
        "46818553661819052591486212122617871500551700592041015625"},
    {0x1.6de490a48e2fep-216, chars_format::fixed, 267,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000135717194322092089616822917590790896522078"
        "5435880214450563946466856687031728868606265057037973678986955770686522077269479766474371452555454769467211"
        "5452339483210146553471275865376810543239116668701171875"},
    {0x1.9fae33750204dp-215, chars_format::fixed, 267,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000308368913191465426546216764354534279279853"
        "4647154007947826510094192557921891772574536300851979266772693650957852102558457910312241351543397130800984"
        "9425461816976347384500201087575987912714481353759765625"},
    {0x1.b89a1b615d668p-214, chars_format::fixed, 263,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000653713430119731508528988387670142850540091"
        "7024591492023198371494072408095221057296211181997410062702880812047091371176364709303433877377005013842865"
        "407407861123856296359235784620977938175201416015625"},
    {0x1.1205bf14b82bdp-213, chars_format::fixed, 265,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000813124596414924820811665415896048177068741"
        "7100698018506635581043211888340131866927322782838488132064383032775727008428556203643464133360106426989235"
        "32080491406205668969420230496325530111789703369140625"},
    {0x1.38bb74b2cee28p-212, chars_format::fixed, 261,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000001855981412950647386642180401236753360880458"
        "3471137464959335795734206066943305396434753643633830322823523500521445327350900664130943592099717852707904"
        "0475538697363422357966555864550173282623291015625"},
    {0x1.22a0215ce7d73p-211, chars_format::fixed, 263,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000003449567762615895867421439569691922423317964"
        "9058963110430872447723008494208841922384319206038046498414808280237161710744628525006862200491884428522247"
        "284967078805040241462620542733930051326751708984375"},
    {0x1.43e2f21e78901p-210, chars_format::fixed, 262,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000007688715671540768259102383228674540661496075"
        "0239691936325646278514953457227545274838167326206011205999045631110875216847571251783396084883096029016216"
        "49250645841588980289316168637014925479888916015625"},
    {0x1.a6c0fc50fb8dcp-209, chars_format::fixed, 259,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000020071439114262729837504870375731843208174931"
        "7651105701733226243785084204963498325479454120948366065657945373829686641016997655205206115182939135129158"
        "51364397379352766392912599258124828338623046875"},
    {0x1.a43598a7e7224p-208, chars_format::fixed, 258,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000039901264509201541515385647530544570777756931"
        "3296573829059392550415956380207781632010739005800912630326089506298277570548782926339548312289799185348914"
        "9519963741230554887806647457182407379150390625"},
    {0x1.4514380584fc6p-207, chars_format::fixed, 258,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000061736189512288787578528448418416349991749663"
        "7008478097846944616435197214273765845275167574578053467647504429563767628821091658473943936912688697004783"
        "0556322654427248153297114185988903045654296875"},
    {0x1.8641944ca7d95p-206, chars_format::fixed, 258,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000148228155683115713877743471137365531850617628"
        "0396008351620169786052842426640120340461814180392122940758722185770249302574978259743400263529336200340532"
        "5086520527566591454160516150295734405517578125"},
    {0x1.f6b995ecb51e2p-205, chars_format::fixed, 256,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000381892700996864536569443303868808512429901994"
        "5683149348065774492948647242485944631484315360661317694039053771102086264734603829885669675948835648501752"
        "12447569439433436855324544012546539306640625"},
    {0x1.3d552fcd337bcp-204, chars_format::fixed, 254,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000482120756263090964607335737046910295129184548"
        "6120439614808929664049267548576069034362769170219282267696881563389639383199305786840112696187596685076424"
        "095350855481001417501829564571380615234375"},
    {0x1.c5d7efd89b777p-203, chars_format::fixed, 255,
        "0."
        "0000000000000000000000000000000000000000000000000000000000001379040554740910859757234864203023303050665354"
        "8234544771446962869832057530013194054847840729805753756239288541495194785127271088725606233437937799342256"
        "7498515984851792381959967315196990966796875"},
    {0x1.bc2f329491015p-202, chars_format::fixed, 254,
        "0."
        "0000000000000000000000000000000000000000000000000000000000002699380950167714677876947991018326219983910950"
        "7301803802721972810548917211929893732348630965943238348446579057907037793339112719528261592247795018823419"
        "872788793583140432019717991352081298828125"},
    {0x1.ae773e40a5fc9p-201, chars_format::fixed, 253,
        "0."
        "0000000000000000000000000000000000000000000000000000000000005232021895448789678535575502851476012484574302"
        "9055888558216867850774043141361941613159031705933056320069790158341755812463991375826293315611774685844727"
        "67532123071987371076829731464385986328125"},
    {0x1.54177621d4f18p-200, chars_format::fixed, 249,
        "0."
        "0000000000000000000000000000000000000000000000000000000000008267169964142633934082062830213120039431487952"
        "9639688939193883369957348095154029848956018262827562450461879976754364993213606617872940726273138631243625"
        "4737434637718251906335353851318359375"},
    {0x1.8c7e3d8c73527p-199, chars_format::fixed, 251,
        "0."
        "0000000000000000000000000000000000000000000000000000000000019276428005917081988903274894497209583789235200"
        "8736221021965477733596774273299177586972339462480949958331639251543454284154774391128234192554058215314342"
        "905610800471549737267196178436279296875"},
    {0x1.1d175cef3afb0p-198, chars_format::fixed, 246,
        "0."
        "0000000000000000000000000000000000000000000000000000000000027720738716829783366211423523072899760981646584"
        "1798403055382188185776045220614211365026873497010110050222931977960513176092910948280156008449368314899841"
        "0814556336845271289348602294921875"},
    {0x1.4475513c62602p-197, chars_format::fixed, 248,
        "0."
        "0000000000000000000000000000000000000000000000000000000000063097149258933373555396693520858956722428887774"
        "2666815195215779362169959776323405818268309517939822174869970049426645388404390460596730442919006912917689"
        "877673410592251457273960113525390625"},
    {0x1.777b0397564a0p-196, chars_format::fixed, 243,
        "0."
        "0000000000000000000000000000000000000000000000000000000000146038814660673950191544065066486223357997282171"
        "4612054612001568583664870140519624031185135549832404652969469358986901884625568803226634472197751485333938"
        "6036168434657156467437744140625"},
    {0x1.335f347ccd407p-195, chars_format::fixed, 247,
        "0."
        "0000000000000000000000000000000000000000000000000000000000239097499545739290984863047127264436692140662444"
        "5438467965433410567473131868231146307731875389309386961521625874106489904594563874974763679662177013815482"
        "77339561536791734397411346435546875"},
    {0x1.cb7fe420097c3p-194, chars_format::fixed, 246,
        "0."
        "0000000000000000000000000000000000000000000000000000000000714868218325357134525827040142183776038625814343"
        "3588039819011645350355951153434841376093702012543245568444756399561844181411081205798629839157163744917111"
        "7140167552861385047435760498046875"},
    {0x1.2b9e54a754171p-193, chars_format::fixed, 245,
        "0."
        "0000000000000000000000000000000000000000000000000000000000932265186832387152243995656617496115470062423700"
        "6152888732071619516530868484515410144259845793808601500140904741554326054101316920396718331088344207391305"
        "218379784491844475269317626953125"},
    {0x1.61db13efbac84p-192, chars_format::fixed, 242,
        "0."
        "0000000000000000000000000000000000000000000000000000000002202049881264494876203363514211712493655815987895"
        "0024605332256666966723974999759217940229530756811212534736376207515633057521771033537451227692950672665261"
        "890870169736444950103759765625"},
    {0x1.b0d988ed3cddap-191, chars_format::fixed, 242,
        "0."
        "0000000000000000000000000000000000000000000000000000000005387261159597293155417509914577162667716775311060"
        "3582724995579755815059161748788482588937205208507054423401377376127275846562117768446237202968791824009286"
        "983709898777306079864501953125"},
    {0x1.5aae85fd3e364p-190, chars_format::fixed, 240,
        "0."
        "0000000000000000000000000000000000000000000000000000000008629622859499132515722973187885994477755447192547"
        "3343599866427363221069537701112240904539206861116322405729087727198931900656419761165562244079746401226316"
        "2658200599253177642822265625"},
    {0x1.b03e8e5e29e8cp-189, chars_format::fixed, 239,
        "0."
        "0000000000000000000000000000000000000000000000000000000021518906041456636649540146948591549576372380444424"
        "9806914387191511810096575548231772543665497700146147060328618439467737562606935278910241424697724621495353"
        "858335874974727630615234375"},
    {0x1.4f61610cf1a2cp-188, chars_format::fixed, 238,
        "0."
        "0000000000000000000000000000000000000000000000000000000033393236367487654889340514543993395885414094092298"
        "2647103907686288821916852642730160784453816121776183567171427971774624803882873084071041978534988281523965"
        "27002565562725067138671875"},
    {0x1.b36be913bc32ap-187, chars_format::fixed, 238,
        "0."
        "0000000000000000000000000000000000000000000000000000000086708313720945146475351007645513441880275082684907"
        "5036476620742153179051707527589540504339856257246438315205913784201820885543490247311817055789195940462832"
        "36821182072162628173828125"},
    {0x1.c8e61b78565d0p-186, chars_format::fixed, 234,
        "0."
        "0000000000000000000000000000000000000000000000000000000181970468187666026036866320957540966616516157535403"
        "7670515951369392444985334737195772712668533324273065544210687349993721714328431898158745100291255880620155"
        "9491455554962158203125"},
    {0x1.1775e38a634cbp-185, chars_format::fixed, 237,
        "0."
        "0000000000000000000000000000000000000000000000000000000222603133599254049013833282557299702059565194251283"
        "4837273165699301928837755016406181832991233228391945078627297246441972446178838518272174226003690122865918"
        "9655445516109466552734375"},
    {0x1.0e15175ca8a3cp-184, chars_format::fixed, 234,
        "0."
        "0000000000000000000000000000000000000000000000000000000430266067224100317333026770786621181243110051580536"
        "0378229754216557961393586643157147601449694081038343461913842993636241248227654731942689453338957150663190"
        "9869611263275146484375"},
    {0x1.4acfbe5469d34p-183, chars_format::fixed, 233,
        "0."
        "0000000000000000000000000000000000000000000000000000001054026242991815396584666677626491662818305460576857"
        "5074287470826265255183716784817538128179345311968289342157486633140791923370468402402534702222425266882055"
        "439054965972900390625"},
    {0x1.e17bb356e6d2cp-182, chars_format::fixed, 232,
        "0."
        "0000000000000000000000000000000000000000000000000000003068187998538622571875295539133090432734111360224460"
        "6377562999866621196092449560501454295722110444234867058605656421172248387681425499341411611275987070257542"
        "65487194061279296875"},
    {0x1.ae1fe199896b9p-181, chars_format::fixed, 233,
        "0."
        "0000000000000000000000000000000000000000000000000000005481823354294242845386199567614086443191578992113084"
        "0684049211074743678696081616378159770391924796871267297084151393359730921440980329112542535074936722594429"
        "738819599151611328125"},
    {0x1.a3e5b17d50316p-180, chars_format::fixed, 231,
        "0."
        "0000000000000000000000000000000000000000000000000000010702958332703832567616253901818145919920308310633570"
        "4121497645444567287179585019441154244655821808282401414871886524700799667471447695812208911192442428728099"
        "9124050140380859375"},
    {0x1.96b34187d54c0p-179, chars_format::fixed, 225,
        "0."
        "0000000000000000000000000000000000000000000000000000020733146515683786499609111229893863241245076553478564"
        "3256160374417458563911593835483522987970775186543541176655017724809603589812469909281489321983826812356710"
        "4339599609375"},
    {0x1.675af8398ba55p-178, chars_format::fixed, 230,
        "0."
        "0000000000000000000000000000000000000000000000000000036639110494840281694548174991298603448018526659230862"
        "4903332492471277075145167617389269028158335738355115730033554552298718973314046770846375000729722160031087"
        "696552276611328125"},
    {0x1.5dd2845405124p-177, chars_format::fixed, 227,
        "0."
        "0000000000000000000000000000000000000000000000000000071334288244990372312224907648096701095619611996252745"
        "4605787694136174698730202040655249068207108069901102955125093074988767111613914735646080345077280071564018"
        "726348876953125"},
    {0x1.1b379a2950eacp-176, chars_format::fixed, 226,
        "0."
        "0000000000000000000000000000000000000000000000000000115504902181527296463191518415016846094042323931950073"
        "0532801623775477633840056979868607605928852867639627638892484111121180817837198959163735878519219113513827"
        "32391357421875"},
    {0x1.050c080bc80d1p-175, chars_format::fixed, 227,
        "0."
        "0000000000000000000000000000000000000000000000000000212926392615345824042139084085022347428420568623696687"
        "8571050023330370630111578447788906881832960215258137376334762627097723751361355200295566447721284930594265"
        "460968017578125"},
    {0x1.b43a3871c2fbap-174, chars_format::fixed, 225,
        "0."
        "0000000000000000000000000000000000000000000000000000711629189352214430515176212350698193579561352328746960"
        "4676817937986941504449910144619335479111297659419541055742263599973449439645232367235294645979593042284250"
        "2593994140625"},
    {0x1.df22454bc74f6p-173, chars_format::fixed, 224,
        "0."
        "0000000000000000000000000000000000000000000000000001563247190926505061106805161595161751997831247953427151"
        "4571791116510630486516616104887110827559419704430548593022161692046697459355757142684950622424366883933544"
        "158935546875"},
    {0x1.b833d723fe25ap-172, chars_format::fixed, 223,
        "0."
        "0000000000000000000000000000000000000000000000000002872455350090359802857254638300178114911027128272264256"
        "7137230852108467397456216094989216899040621575989169047949594509459845436067162993687418293120572343468666"
        "07666015625"},
    {0x1.f684b3c7cc0acp-171, chars_format::fixed, 221,
        "0."
        "0000000000000000000000000000000000000000000000000006558170706952156987785687072431960377973028128216125661"
        "3335172096317790203054916032047180861903076571475476949770983954945174541038832582984241525991819798946380"
        "615234375"},
    {0x1.a5b141082f7b4p-170, chars_format::fixed, 220,
        "0."
        "0000000000000000000000000000000000000000000000000011006685169756962680050220555041590876254318428865998856"
        "9045688269339538913108647404952659594031915621633770697462006094925393963682158648964559688465669751167297"
        "36328125"},
    {0x1.4fff666a560aep-169, chars_format::fixed, 220,
        "0."
        "0000000000000000000000000000000000000000000000000017539896072768474874561864155705114932844071436878901874"
        "9326317838467055752161232305239966778050582704264694405684999526265046209880238414768882648786529898643493"
        "65234375"},
    {0x1.668bb57ef8bccp-168, chars_format::fixed, 218,
        "0."
        "0000000000000000000000000000000000000000000000000037433921715043594589736460314331405184962182591207676516"
        "7720492215331841300392792216243120028749941240758768607887085263453345700124241801631796988658607006072998"
        "046875"},
    {0x1.dcd176deeeae3p-167, chars_format::fixed, 219,
        "0."
        "0000000000000000000000000000000000000000000000000099564289980093796889603154154145876739448114195979055992"
        "6902590224573129717127057611396323672607934389143663775516448533334441014369664557648320624139159917831420"
        "8984375"},
    {0x1.16a3865422377p-166, chars_format::fixed, 218,
        "0."
        "0000000000000000000000000000000000000000000000000116364979243225221897297052242786229930882923236248731594"
        "8934888434929983564865325849049549620057568156330193520858451476789898436370318535182377672754228115081787"
        "109375"},
    {0x1.bce21dad63749p-165, chars_format::fixed, 217,
        "0."
        "0000000000000000000000000000000000000000000000000371583841159493506147378208719048169250779569408692309413"
        "1488511150289090977603018132195717243449127154792316806924856786230023167338920586644235299900174140930175"
        "78125"},
    {0x1.89eeefab48d10p-164, chars_format::fixed, 212,
        "0."
        "0000000000000000000000000000000000000000000000000658056963417738275682010734279149903138108824337865274527"
        "340177751085537685676458714128712234144985979360132419013818037920732217926911289396230131387710571289062"
        "5"},
    {0x1.8fee5ccadb200p-163, chars_format::fixed, 206,
        "0."
        "0000000000000000000000000000000000000000000000001336152174543859284066395565563171654946943165053851747677"
        "4582035584703495979290821050139073573949863898319932246070741721499786081039928831160068511962890625"},
    {0x1.07380dad14bcap-162, chars_format::fixed, 213,
        "0."
        "0000000000000000000000000000000000000000000000001758805859472406906837815134000656238238908993747747715595"
        "3047822519153788093489690886862546961352922261512761607203161331406532363885730774200055748224258422851562"
        "5"},
    {0x1.0b59bf6c21943p-161, chars_format::fixed, 213,
        "0."
        "0000000000000000000000000000000000000000000000003572825938796783575781050231474822856033670219138548239089"
        "9073723989786692440757890127298326923356779924206406360535208681285940235383691288006957620382308959960937"
        "5"},
    {0x1.fa531504c2a95p-160, chars_format::fixed, 212,
        "0."
        "0000000000000000000000000000000000000000000000013532863609445874625424619828095184220811044476992203391714"
        "726909818173064528541715965734117428727450051983079860150084854520519117571097922336775809526443481445312"
        "5"},
    {0x1.bcfee137bb727p-159, chars_format::fixed, 211,
        "0."
        "0000000000000000000000000000000000000000000000023787372002095833385126791878777862375484338276605231718277"
        "36041320661206356555332021716335377659697411693080297350262510957391581811748437758069485425949096679687"
        "5"},
    {0x1.151cd5ef2d805p-158, chars_format::fixed, 210,
        "0."
        "0000000000000000000000000000000000000000000000029626275330019588245631947287909396699745270360057415499881"
        "99852573984360531392757263428340980072068222394117076967551033424286277551118473638780415058135986328125"},
    {0x1.a50d5e23e121ep-157, chars_format::fixed, 208,
        "0."
        "0000000000000000000000000000000000000000000000090029880689123645099794460485807721339684096115950637844009"
        "362876227390039831564636627226957537724402162583602570082390824379725557946585468016564846038818359375"},
    {0x1.82802e4264badp-156, chars_format::fixed, 208,
        "0."
        "0000000000000000000000000000000000000000000000165284071528441447855006149734552733369999127774633850562991"
        "043359152029597089960035135672906948051353768689247248694610022134998672527217422612011432647705078125"},
    {0x1.2177668084382p-155, chars_format::fixed, 206,
        "0."
        "0000000000000000000000000000000000000000000000247576191853698082030212400035215933812096632723082049868033"
        "5024058131760117241155512244849406066711402810901342339011156623573839397067786194384098052978515625"},
    {0x1.03b3d0af74440p-154, chars_format::fixed, 200,
        "0."
        "0000000000000000000000000000000000000000000000444238987494900843994339695995098261443293305913325679391461"
        "0695787073745872826201675765786764986150790936867056336867509713783874758519232273101806640625"},
    {0x1.d2d07d1f0f329p-153, chars_format::fixed, 205,
        "0."
        "0000000000000000000000000000000000000000000001597036901212250959318477514463560465972110052858020348453661"
        "114995453788426982996437834015229782577081540055113898402168459700334324224968440830707550048828125"},
    {0x1.8fa32bc4d85bap-152, chars_format::fixed, 203,
        "0."
        "0000000000000000000000000000000000000000000002734429961643154352243242191279271813443642705760566549994309"
        "1928202467144496467783172463158734772458732489503583523195173743403074695379473268985748291015625"},
    {0x1.67c2abce8df9dp-151, chars_format::fixed, 203,
        "0."
        "0000000000000000000000000000000000000000000004923161560346420724200792187601358851860129025104491687662924"
        "1339050523954671848627932540076411043836705992149190718766560426189471399993635714054107666015625"},
    {0x1.73f3b6e413e35p-150, chars_format::fixed, 202,
        "0."
        "0000000000000000000000000000000000000000000010179995696026282273811276434771842619116554426387226609081999"
        "306437938716096066552645975664851424917170160429284839383179406269164246623404324054718017578125"},
    {0x1.7a95dc8122d45p-149, chars_format::fixed, 201,
        "0."
        "0000000000000000000000000000000000000000000020723091166540273850593168126191139912345243921985305222697460"
        "10003905501097895079213267551039998263371339743302659321122494162636940018273890018463134765625"},
    {0x1.af1bf9e405f36p-148, chars_format::fixed, 199,
        "0."
        "0000000000000000000000000000000000000000000047196310508913904671194894358782925911776121787765422306796132"
        "134761227959946314353602058140317633579755078227792840228627113674519932828843593597412109375"},
    {0x1.93bd4a776ff22p-147, chars_format::fixed, 198,
        "0."
        "0000000000000000000000000000000000000000000088399910274584726229868620813946972911876446658509805639346664"
        "85756635438910965113045452799651249339083210906594691158577603573576197959482669830322265625"},
    {0x1.998a4f77b7f72p-146, chars_format::fixed, 197,
        "0."
        "0000000000000000000000000000000000000000000179340049546542910245662039900875920568313167261753249545366657"
        "7716116620213166546467180442427628942420448257652650092541790627365116961300373077392578125"},
    {0x1.e2ee6bf0a5651p-145, chars_format::fixed, 197,
        "0."
        "0000000000000000000000000000000000000000000422956835910564709068003370286188447416571417665682213678355812"
        "2724658730842920633563034498958928767526273091660778125078223865784821100533008575439453125"},
    {0x1.80940300d356fp-144, chars_format::fixed, 196,
        "0."
        "0000000000000000000000000000000000000000000673636000238404179995423930417754312868629249686475854751089088"
        "646535533046155257103169810022443463128717088829987280629296719780541025102138519287109375"},
    {0x1.fb7e121e4f09ep-143, chars_format::fixed, 194,
        "0."
        "0000000000000000000000000000000000000000001777871026025537082306811881574403454523919617504481056645248505"
        "9711823829134148938595203744881815979364219466006546976899471701472066342830657958984375"},
    {0x1.db7f5ce10385bp-142, chars_format::fixed, 194,
        "0."
        "0000000000000000000000000000000000000000003331569659565884604746958559230960176066631235771463790780530480"
        "1690666734362639697081633088940864280810672903680724754593711622874252498149871826171875"},
    {0x1.1d9d22c7f3534p-141, chars_format::fixed, 191,
        "0."
        "0000000000000000000000000000000000000000004002301960990423046030612937546885334555687306024269519143435585"
        "0628634523560076237997206470162408844618039983898061251466060639359056949615478515625"},
    {0x1.8e16e3aa24c6fp-140, chars_format::fixed, 192,
        "0."
        "0000000000000000000000000000000000000000011156841616796604932136274348484852039247641538297458130288766038"
        "21663049539205116152069822829205002114654420551642655112800639471970498561859130859375"},
    {0x1.87e3f754c260dp-139, chars_format::fixed, 191,
        "0."
        "0000000000000000000000000000000000000000021966221825446393623879986362588124795901767213242488227182002426"
        "8029734385173578034649495511564138867989536864355759604450213373638689517974853515625"},
    {0x1.fa5d32abaa11cp-138, chars_format::fixed, 188,
        "0."
        "0000000000000000000000000000000000000000056765373748004688332440652788786161538895277758131917477071063157"
        "0041698358399840694619345434124738111031881204748827940420596860349178314208984375"},
    {0x1.f67503a2182bbp-137, chars_format::fixed, 189,
        "0."
        "0000000000000000000000000000000000000000112654775034390728341437781791380233004082818991798448486035784404"
        "71818264924572994395463590144925447532309702169950327288461267016828060150146484375"},
    {0x1.db3ed18fbe233p-136, chars_format::fixed, 188,
        "0."
        "0000000000000000000000000000000000000000213107401086292667418252766407681523457020559571672401249223380999"
        "0673310546131572074009228115100114521007594603485557627209345810115337371826171875"},
    {0x1.8335b0765d557p-135, chars_format::fixed, 187,
        "0."
        "0000000000000000000000000000000000000000347261690499442998794533299394815869917005220736341744107621709115"
        "031987909302410044329883903658013740638026145557404333885642699897289276123046875"},
    {0x1.4dbf09123267bp-134, chars_format::fixed, 186,
        "0."
        "0000000000000000000000000000000000000000598627945734676624400745950605001550286642741362338546015756676686"
        "11139098768423815169512058364388094422285646611925358229200355708599090576171875"},
    {0x1.5e56a8ce3c277p-133, chars_format::fixed, 185,
        "0."
        "0000000000000000000000000000000000000001256777780832933001321775313711471627602105802559709007658682419783"
        "6408715656044366011499934739896008786645686949867695147986523807048797607421875"},
    {0x1.bb079ee8f4d5cp-132, chars_format::fixed, 182,
        "0."
        "0000000000000000000000000000000000000003178582703527919012178411933954290292754725568671302600893705451044"
        "7409625558295054802900095791530292975435312285981126478873193264007568359375"},
    {0x1.4f6e275cf1a76p-131, chars_format::fixed, 182,
        "0."
        "0000000000000000000000000000000000000004813188583918946434263028581023898575269952764660409858008830460951"
        "8450064927286820639649469111945897896454038544789000297896564006805419921875"},
    {0x1.6e0c8ad2bb37cp-130, chars_format::fixed, 180,
        "0."
        "0000000000000000000000000000000000000010505090911062820335561411705941054623172870846458893207124770055231"
        "06106921870430888257930709698217096315087104585472843609750270843505859375"},
    {0x1.98e433996597fp-129, chars_format::fixed, 181,
        "0."
        "0000000000000000000000000000000000000023469216079446797138739112899579158124687027232331769891232554936238"
        "609927331878316423045145059373263289603794845561424153856933116912841796875"},
    {0x1.42726d8c4369ap-128, chars_format::fixed, 179,
        "0."
        "0000000000000000000000000000000000000037015098458206448453351979822608106339451489448555898068736741171041"
        "6296973229555473403516808856791343862457921431996510364115238189697265625"},
    {0x1.486454058df80p-127, chars_format::fixed, 172,
        "0."
        "0000000000000000000000000000000000000075395084299958847860449433646301178540543942807329687696496446852570"
        "945235346855720548050138439533096601508077583275735378265380859375"},
    {0x1.6661274c7f05cp-126, chars_format::fixed, 176,
        "0."
        "0000000000000000000000000000000000000164559798686967835340820637511334291365290360151649186607120062118549"
        "9801342584795897515286799950816332138714415123104117810726165771484375"},
    {0x1.3aa7b44b0a502p-125, chars_format::fixed, 176,
        "0."
        "0000000000000000000000000000000000000288965067500368064755779719228352553128154522967464982357315991850883"
        "1495951943822141976963118457401302752174387933337129652500152587890625"},
    {0x1.9fd27c3ae95f7p-124, chars_format::fixed, 176,
        "0."
        "0000000000000000000000000000000000000763744775889794385912297229514875268210416129934720340408669789113025"
        "0718208990904335632548776530668932505108159602968953549861907958984375"},
    {0x1.da78946cc5490p-123, chars_format::fixed, 171,
        "0."
        "0000000000000000000000000000000000001742931242211031071897797941374877596373704426709900579991877856290126"
        "82535510419761596095857177080024058568596956320106983184814453125"},
    {0x1.f203ac3519f18p-122, chars_format::fixed, 171,
        "0."
        "0000000000000000000000000000000000003658831567832270827231401967202780229509371162725867762209862489371751"
        "20390237932813757635425698511166814341777353547513484954833984375"},
    {0x1.b49aae7f5cad1p-121, chars_format::fixed, 173,
        "0."
        "0000000000000000000000000000000000006415322502181043530205537799813093430916940457471116691767428439442996"
        "9174601750224385013791146732675674257961873081512749195098876953125"},
    {0x1.b661988bbdc4bp-120, chars_format::fixed, 172,
        "0."
        "0000000000000000000000000000000000012882866599344565053618788391492597985347367160360079978812335056300495"
        "851823386955130707091986101697766997631333651952445507049560546875"},
    {0x1.7dc73059f4d49p-119, chars_format::fixed, 171,
        "0."
        "0000000000000000000000000000000000022438898905531304113205534342267833215945294680111818683410060358815191"
        "18026928138778739246707479015885411399722215719521045684814453125"},
    {0x1.cdb2f9141b525p-118, chars_format::fixed, 170,
        "0."
        "0000000000000000000000000000000000054272469927212228398680026288174857747043423993740677691930900376873032"
        "7611528112020569043533364805842467148977448232471942901611328125"},
    {0x1.ca41b4813a41ep-117, chars_format::fixed, 168,
        "0."
        "0000000000000000000000000000000000107735623137020512175428706905408399153184701951301970808448378468396141"
        "71734258592932298947107694342406603027484379708766937255859375"},
    {0x1.81c487a032056p-116, chars_format::fixed, 167,
        "0."
        "0000000000000000000000000000000000181387098238701349633394397706124283186756008245784673448133756160446651"
        "5628515662370009802438486357090141609660349786281585693359375"},
    {0x1.72bcb5fff535bp-115, chars_format::fixed, 167,
        "0."
        "0000000000000000000000000000000000348639542344064625506917491450303109916165134325757439080190348152792923"
        "6375536125880844075773656864924987530685029923915863037109375"},
    {0x1.8bd7918860dbbp-114, chars_format::fixed, 166,
        "0."
        "0000000000000000000000000000000000744496176838064849353841502839459311866175404207553605255924112979795595"
        "940397470964010914577790867241446903790347278118133544921875"},
    {0x1.a7f69dcd72222p-113, chars_format::fixed, 164,
        "0."
        "0000000000000000000000000000000001594772855822436299560799941989765492435642647914623707098531525626084115"
        "4700059297961143613131529406246045255102217197418212890625"},
    {0x1.eb4294b46da96p-112, chars_format::fixed, 163,
        "0."
        "0000000000000000000000000000000003695830084176479639455260307651214753449914783842584804612247384526132591"
        "666639170979876370670691443365285522304475307464599609375"},
    {0x1.45d8b318ecb26p-111, chars_format::fixed, 162,
        "0."
        "0000000000000000000000000000000004902792957147278927838444756869768149019724566978348662299374512320242730"
        "15219082824038381029918554077084991149604320526123046875"},
    {0x1.c95d0b441f711p-110, chars_format::fixed, 162,
        "0."
        "0000000000000000000000000000000013763280779744355993441768388857348578041188915187008104911491475416457823"
        "92109190078754478447908837779323221184313297271728515625"},
    {0x1.98333d0f2d03dp-109, chars_format::fixed, 161,
        "0."
        "0000000000000000000000000000000024567652907408954862171758719761037178820726837148989034299592147290607067"
        "1721993027764897876696892353720613755285739898681640625"},
    {0x1.dfd8b02992707p-108, chars_format::fixed, 160,
        "0."
        "0000000000000000000000000000000057759413981215069525017042272423165722552378432976327150239566602665492393"
        "820853640382627369742607470470829866826534271240234375"},
    {0x1.18e3e3b1a223ep-107, chars_format::fixed, 158,
        "0."
        "0000000000000000000000000000000067621854242881406431627770947480800315291558269137007328403548746185753195"
        "7636272663091092649523261570720933377742767333984375"},
    {0x1.9658328cb8114p-106, chars_format::fixed, 156,
        "0."
        "0000000000000000000000000000000195647770340322473312661063510516605879488523000599581212031452510120291855"
        "30780310726950421695846671354956924915313720703125"},
    {0x1.86c79844889d0p-105, chars_format::fixed, 153,
        "0."
        "0000000000000000000000000000000376307131331019530087401714271214955872839103262439387399877169913343616427"
        "64145573780698583732373663224279880523681640625"},
    {0x1.27dcf92066d8bp-104, chars_format::fixed, 156,
        "0."
        "0000000000000000000000000000000569811750812064009223916550837978633848152611356004127465923597968062004899"
        "91016465245177169407497785869054496288299560546875"},
    {0x1.b6c8ffb6a90c2p-103, chars_format::fixed, 154,
        "0."
        "0000000000000000000000000000001690138926311054318110236564865289427460630148700245225157423719757617540829"
        "938381809205427686038092360831797122955322265625"},
    {0x1.39b18e81b6f59p-102, chars_format::fixed, 154,
        "0."
        "0000000000000000000000000000002416607441957108957588975134712019154730585846911599307374205389291528134853"
        "336896338549255602856646873988211154937744140625"},
    {0x1.58ad465068c9ap-101, chars_format::fixed, 152,
        "0."
        "0000000000000000000000000000005310587796480732071029250198485358165789962237100555630757110785330978219665"
        "2680426318671180752062355168163776397705078125"},
    {0x1.9d0ed395b4c84p-100, chars_format::fixed, 150,
        "0."
        "0000000000000000000000000000012728329747902230165316181540568536882833839113574207013715404328367409245034"
        "93056774150460341843427158892154693603515625"},
    {0x1.bf9c0e64057fbp-99, chars_format::fixed, 151,
        "0."
        "0000000000000000000000000000027586071091388190196112205187915629121694961798162398502469066619619835167200"
        "191071434911549431490129791200160980224609375"},
    {0x1.f3a0cebf107f8p-98, chars_format::fixed, 147,
        "0."
        "0000000000000000000000000000061583924748384136682512359017261255450407522093971748312640088161632302368340"
        "62736317463304658303968608379364013671875"},
    {0x1.8d2ccae7cd365p-97, chars_format::fixed, 149,
        "0."
        "0000000000000000000000000000097911189758325206052557743537635646483728105421101526676208264656982528338082"
        "7420087744172860766411758959293365478515625"},
    {0x1.aa0b3a331c5bcp-96, chars_format::fixed, 146,
        "0."
        "0000000000000000000000000000210055839089996359805238145952856304376486447936260805095946149908033949297355"
        "5637345128843662678264081478118896484375"},
    {0x1.4b814b3a1cb61p-95, chars_format::fixed, 147,
        "0."
        "0000000000000000000000000000326889221350947712147955071785659465984814261422850057606214077799506126533303"
        "84305139233447334845550358295440673828125"},
    {0x1.f4068960578d7p-94, chars_format::fixed, 146,
        "0."
        "0000000000000000000000000000986126487863665154148549616437903991301673772882391672259813800118265245760098"
        "4197139126763431704603135585784912109375"},
    {0x1.f62c0cec38831p-93, chars_format::fixed, 145,
        "0."
        "0000000000000000000000000001980719577204124484138355016308944910386872689797885690626746042250712996212087"
        "813052704632355016656219959259033203125"},
    {0x1.37c69791af80ep-92, chars_format::fixed, 143,
        "0."
        "0000000000000000000000000002459477005766036849575665181886406238795564556816120551364851906728956835567617"
        "7002777649249765090644359588623046875"},
    {0x1.c42f82f902ae4p-91, chars_format::fixed, 141,
        "0."
        "0000000000000000000000000007134230712364223304595809522516715699200827642532178972744923986331716221978571"
        "64593415291165001690387725830078125"},
    {0x1.ab5c60a4631b5p-90, chars_format::fixed, 142,
        "0."
        "0000000000000000000000000013485130668183937590444128052855465890028802588861696634054925499593654875281345"
        "528748033757437951862812042236328125"},
    {0x1.163adde1f573ep-89, chars_format::fixed, 140,
        "0."
        "0000000000000000000000000017558778301243823121155271808116835370371045792990942242404584251962271126273895"
        "6605744533590041100978851318359375"},
    {0x1.6cc1d8ecb558ap-88, chars_format::fixed, 139,
        "0."
        "0000000000000000000000000046038833248427952809663776964936140725404629123882134521116254371057353346474716"
        "460079434909857809543609619140625"},
    {0x1.0cdf536fb5eefp-87, chars_format::fixed, 139,
        "0."
        "0000000000000000000000000067872927594290552636925886720441058685794883580176619836663438543506473958621949"
        "549296914483420550823211669921875"},
    {0x1.cf43fecae092dp-86, chars_format::fixed, 138,
        "0."
        "0000000000000000000000000233889360486653108513167454683035633013248291265766368439722253260950506417725769"
        "38137717661447823047637939453125"},
    {0x1.f45a241c9839ap-85, chars_format::fixed, 136,
        "0."
        "0000000000000000000000000505226523137597644108357193858899678905200966342862579397127901378286747580137472"
        "368733142502605915069580078125"},
    {0x1.0e0770a686d83p-84, chars_format::fixed, 136,
        "0."
        "0000000000000000000000000545319349263515916601773982019382980686780428085905231623418418248727505825979022"
        "802130202762782573699951171875"},
    {0x1.0248f281384bap-83, chars_format::fixed, 134,
        "0."
        "0000000000000000000000001043204606574315648767810454522756782910973292669829335211958993700088332845510308"
        "2887944765388965606689453125"},
    {0x1.ac4e19937ae27p-82, chars_format::fixed, 134,
        "0."
        "0000000000000000000000003459820865051478989748670632484660497868302074004577838972792560732951588908790085"
        "9522051177918910980224609375"},
    {0x1.3087a7746f421p-81, chars_format::fixed, 133,
        "0."
        "0000000000000000000000004919945865610923037667176669438364925899595305968700003623719473337845553562175382"
        "467103190720081329345703125"},
    {0x1.70783708f772ap-80, chars_format::fixed, 131,
        "0."
        "0000000000000000000000011905894569192662776098050199813402280754741687796493203055674863031360155574134296"
        "3301576673984527587890625"},
    {0x1.e065c19de1dc4p-79, chars_format::fixed, 129,
        "0."
        "0000000000000000000000031044959876029036877825464923078462041822306405426805057268534225947687055224832874"
        "95560944080352783203125"},
    {0x1.c685d70ae0fe0p-78, chars_format::fixed, 125,
        "0."
        "0000000000000000000000058745696639777179642268254943931146596782812693870464352651882683487016834078531246"
        "6323375701904296875"},
    {0x1.a0780c9dec656p-77, chars_format::fixed, 128,
        "0."
        "0000000000000000000000107654698431785435045489713914256723242131891407125053545692616296242105633496066730"
        "0038039684295654296875"},
    {0x1.3cb9bbf0aea75p-76, chars_format::fixed, 128,
        "0."
        "0000000000000000000000163743258090422544821847978493162537292356197934025069916273112825139124382189947937"
        "1495544910430908203125"},
    {0x1.f0a2b8fd92f2fp-75, chars_format::fixed, 127,
        "0."
        "0000000000000000000000513509211207940396346808840622328108640224488399038307803406533218193441570065260748"
        "378932476043701171875"},
    {0x1.bb04bcebdd6ffp-74, chars_format::fixed, 126,
        "0."
        "0000000000000000000000916140801451767788622065769604257008319492079233873702331702798193346914956691762199"
        "62537288665771484375"},
    {0x1.0b62fe692a947p-73, chars_format::fixed, 125,
        "0."
        "0000000000000000000001105885448728602157660372530490316353991836641389306121489508310390403877931930765043"
        "9441204071044921875"},
    {0x1.272fe8508d433p-72, chars_format::fixed, 124,
        "0."
        "0000000000000000000002441730781169199364855750861362078623225251480968477216777312403805932916611709515564"
        "143657684326171875"},
    {0x1.a4da532053764p-71, chars_format::fixed, 121,
        "0."
        "0000000000000000000006962426049274538699439196410633694865008161302307608512174481874001941150709171779453"
        "754425048828125"},
    {0x1.93f477225bbbep-70, chars_format::fixed, 121,
        "0."
        "0000000000000000000013365747882614801032463352914308130925659506904834814518322032295127854695238056592643"
        "260955810546875"},
    {0x1.dac01e869bf58p-69, chars_format::fixed, 118,
        "0."
        "0000000000000000000031416350487962486701379607843901811256471115918449956111273280168205701556871645152568"
        "817138671875"},
    {0x1.d259d75a5b1c3p-68, chars_format::fixed, 120,
        "0."
        "0000000000000000000061721033295351600892557306527903367291189660591862000039607358270465908844926161691546"
        "44012451171875"},
    {0x1.21e65c14b2260p-67, chars_format::fixed, 114,
        "0."
        "0000000000000000000076735849386577397352904483936223962191097616545595134704416118154313153354451060295104"
        "98046875"},
    {0x1.247adaeef533dp-66, chars_format::fixed, 118,
        "0."
        "0000000000000000000154837571490893774333213229345009640160216876301445875570468591053696627568569965660572"
        "052001953125"},
    {0x1.8590b3c7299d1p-65, chars_format::fixed, 117,
        "0."
        "0000000000000000000412468245113335524762074241204890152586197732119167202362655655356604711414547637104988"
        "09814453125"},
    {0x1.c16c9cb03d8aap-64, chars_format::fixed, 115,
        "0."
        "0000000000000000000951692901231032540579231072092779398477634354654546553799188135513986708247102797031402"
        "587890625"},
    {0x1.afab9cd6fe545p-63, chars_format::fixed, 115,
        "0."
        "0000000000000000001828195094563646962244514682444059838175275831433078317124485412392687067040242254734039"
        "306640625"},
    {0x1.f3fa50d429d7dp-62, chars_format::fixed, 114,
        "0."
        "0000000000000000004234976659797314303742107007588948382176629454667150841487566204079939780058339238166809"
        "08203125"},
    {0x1.28c638f71d180p-61, chars_format::fixed, 106,
        "0."
        "000000000000000000502755231383003604812020402739857044083133282962733145993183825339656323194503784179687"
        "5"},
    {0x1.9f197cec56a5bp-60, chars_format::fixed, 112,
        "0."
        "0000000000000000014064120230650801115977574752674439808505632504024500210870751715219739708118140697479248"
        "046875"},
    {0x1.23514676b2275p-59, chars_format::fixed, 111,
        "0."
        "0000000000000000019740440391270056901548099504899902549377128678416990284483212292343523586168885231018066"
        "40625"},
    {0x1.742a3899f4ebfp-58, chars_format::fixed, 110,
        "0."
        "0000000000000000050437752684379660394102518960175013841542044125962947903607513921997451689094305038452148"
        "4375"},
    {0x1.a24fa5ce867fbp-57, chars_format::fixed, 109,
        "0."
        "0000000000000000113383457288879493881896180602251467830667152418533914770559789531034766696393489837646484"
        "375"},
    {0x1.cd8bd478c4055p-56, chars_format::fixed, 108,
        "0."
        "0000000000000000250204702232128672419987362874135136401925963981667314084411657404416473582386970520019531"
        "25"},
    {0x1.5586beb808bb7p-55, chars_format::fixed, 107,
        "0."
        "0000000000000000370283608071470711740923263273835399293643331770486265552833060610282700508832931518554687"
        "5"},
    {0x1.1782f85ff73e4p-54, chars_format::fixed, 104,
        "0."
        "00000000000000006060941731133067066111993215447123683291462078494282739171694629476405680179595947265625"},
    {0x1.5241f4d37d585p-53, chars_format::fixed, 105,
        "0."
        "00000000000000014669586812661773367631643496494282542762537977724252025168993895931635051965713500976562"
        "5"},
    {0x1.a9145af5d709dp-52, chars_format::fixed, 104,
        "0."
        "00000000000000036869770513056370258874447534099887412925645774515459596187838542391546070575714111328125"},
    {0x1.14e3531aa8734p-51, chars_format::fixed, 101,
        "0.00000000000000048032409094989299117442762699440752432309049459180361196786179789341986179351806640625"},
    {0x1.8d306ae29c760p-50, chars_format::fixed, 97,
        "0.0000000000000013780266196844444434001720951926995236184146642610670596695854328572750091552734375"},
    {0x1.34141b1c6e739p-49, chars_format::fixed, 101,
        "0.00000000000000213772429398483853817359285620068290943482478168313765110042368178255856037139892578125"},
    {0x1.bfaa985695d46p-48, chars_format::fixed, 99,
        "0.000000000000006212619127432842815535315316465814989023408974888607048114863573573529720306396484375"},
    {0x1.a1bbef9dd867ep-47, chars_format::fixed, 98,
        "0.00000000000001159445109391313455470569692597092094861802556715613121696151210926473140716552734375"},
    {0x1.d4c0489e284adp-46, chars_format::fixed, 98,
        "0.00000000000002602091364932322080817661116014788518557084191773487447107982006855309009552001953125"},
    {0x1.5256e07f25dcdp-45, chars_format::fixed, 97,
        "0.0000000000000375632150992183886471662319623894115764293523407335584352040314115583896636962890625"},
    {0x1.71a8a2ed2b45fp-44, chars_format::fixed, 96,
        "0.000000000000082080728005574479728778617018482662413977023196931526172193116508424282073974609375"},
    {0x1.b0e4af6682317p-43, chars_format::fixed, 95,
        "0.00000000000019224324416725509019750615142710900007101508524254285248389351181685924530029296875"},
    {0x1.7b8de5bf78fd4p-42, chars_format::fixed, 92,
        "0.00000000000033711192675176746235914191322624765202904673078165842525777406990528106689453125"},
    {0x1.ae59a0cb674f4p-41, chars_format::fixed, 91,
        "0.0000000000007644553608444342585595182827876899211462513594739220934570766985416412353515625"},
    {0x1.5dd5fa7afbee1p-40, chars_format::fixed, 92,
        "0.00000000000124286662127449181887050977687219485896298609706178694978007115423679351806640625"},
    {0x1.384536c7c656fp-39, chars_format::fixed, 91,
        "0.0000000000022188144095886259914737759791032178121987505914347593716229312121868133544921875"},
    {0x1.a1194c27935c7p-38, chars_format::fixed, 90,
        "0.000000000005927330708414900645292509942453463927213019868389665134600363671779632568359375"},
    {0x1.a02b0d1c1f1a8p-37, chars_format::fixed, 86,
        "0.00000000001182821076754492303774112659466477733005707051461286027915775775909423828125"},
    {0x1.651f948c8f895p-36, chars_format::fixed, 88,
        "0.0000000000203001127618364981565507635049392808242185726186335159582085907459259033203125"},
    {0x1.0658d9ac47254p-35, chars_format::fixed, 85,
        "0.0000000000298254089359250336024448739896349803990549531818032846786081790924072265625"},
    {0x1.463f50c6fb1bfp-34, chars_format::fixed, 86,
        "0.00000000007418005368738489917011425132798547142642942020529517321847379207611083984375"},
    {0x1.fff128a1f6814p-33, chars_format::fixed, 83,
        "0.00000000023280428024704824536772626046771984820171752517126151360571384429931640625"},
    {0x1.514274eb0bbe6p-32, chars_format::fixed, 83,
        "0.00000000030673581616552569753443045750033145446789006882681860588490962982177734375"},
    {0x1.c66e7acce03a0p-31, chars_format::fixed, 78,
        "0.000000000826606194612068018706590240458897955733164053526706993579864501953125"},
    {0x1.3f09f0d9f8a0fp-30, chars_format::fixed, 82,
        "0.0000000011606565070959597058008216612762751596132915210546343587338924407958984375"},
    {0x1.364bffd2bc2acp-29, chars_format::fixed, 79,
        "0.0000000022577068906830200447981735699908012460213058147928677499294281005859375"},
    {0x1.21d26e23a4c2cp-28, chars_format::fixed, 78,
        "0.000000004217465074781223546467325241464407792335578051279298961162567138671875"},
    {0x1.ff8816230e3aep-27, chars_format::fixed, 78,
        "0.000000014887528604095426785363609988553645901987465549609623849391937255859375"},
    {0x1.81d69783dda8fp-26, chars_format::fixed, 78,
        "0.000000022458741990672780846062688334639767528955189845873974263668060302734375"},
    {0x1.4c5ef6a88833bp-25, chars_format::fixed, 77,
        "0.00000003869307125073411435703155092889760080510086481808684766292572021484375"},
    {0x1.a7cdc3dfbe9a7p-24, chars_format::fixed, 76,
        "0.0000000986745045636969746077316024100711810973507454036734998226165771484375"},
    {0x1.1241321139c78p-23, chars_format::fixed, 72,
        "0.000000127709782783028146746994412052966794135500094853341579437255859375"},
    {0x1.a5b4169e66c20p-22, chars_format::fixed, 69,
        "0.000000392741961530240641102713905485899203995359130203723907470703125"},
    {0x1.79889fa31ee9cp-21, chars_format::fixed, 71,
        "0.00000070321128865744089630400275037214186113487812690436840057373046875"},
    {0x1.6659647864b09p-20, chars_format::fixed, 72,
        "0.000001334954758379262946808873659121363886015387834049761295318603515625"},
    {0x1.d26dfc62429ebp-19, chars_format::fixed, 71,
        "0.00000347517156840570335023048696709846439034663490019738674163818359375"},
    {0x1.793d2e00a8300p-18, chars_format::fixed, 62,
        "0.00000562129889716887591599725482183202984742820262908935546875"},
    {0x1.39585d365fddfp-17, chars_format::fixed, 69,
        "0.000009338413843761515393811049878802776902375626377761363983154296875"},
    {0x1.db9dd5363f2bbp-16, chars_format::fixed, 68,
        "0.00002834895459445888963169284113785550971442717127501964569091796875"},
    {0x1.996aa70581c70p-15, chars_format::fixed, 63,
        "0.000048806263333083725435013189297706048819236457347869873046875"},
    {0x1.24d414212635cp-14, chars_format::fixed, 64,
        "0.0000698157387141301578013796724775374968885444104671478271484375"},
    {0x1.49743faae0bcep-13, chars_format::fixed, 64,
        "0.0001570959551281101199658729594688111319555900990962982177734375"},
    {0x1.fd541909e34d0p-12, chars_format::fixed, 60, "0.000485733515795794441871624513851202209480106830596923828125"},
    {0x1.fc05fd5826c21p-11, chars_format::fixed, 63,
        "0.000968977731662493927018708905762878202949650585651397705078125"},
    {0x1.b8d7be1e07ac5p-10, chars_format::fixed, 62,
        "0.00168168161281527614621389421500907701556570827960968017578125"},
    {0x1.58ae5b82bc128p-9, chars_format::fixed, 58, "0.0026297079760909843060279200699369539506733417510986328125"},
    {0x1.da353b89e30a0p-8, chars_format::fixed, 55, "0.0072358389242134502072900659186416305601596832275390625"},
    {0x1.523aa52ed6443p-7, chars_format::fixed, 59, "0.01032193246435231769042584204498780309222638607025146484375"},
    {0x1.b12c63dc720bbp-6, chars_format::fixed, 58, "0.0264388060766413794666629399898738483898341655731201171875"},
    {0x1.8284dd65c8bc7p-5, chars_format::fixed, 57, "0.047182495515037774225231004265879164449870586395263671875"},
    {0x1.e78254ba42944p-4, chars_format::fixed, 54, "0.119020777670958699534509150907979346811771392822265625"},
    {0x1.a2ea8656520bap-3, chars_format::fixed, 54, "0.204548882970135015302304282158729620277881622314453125"},
    {0x1.c9baa87f5bfbbp-2, chars_format::fixed, 54, "0.447001106999774300287953110455418936908245086669921875"},
    {0x1.71b66707cac81p-1, chars_format::fixed, 53, "0.72209474535101503267497946580988354980945587158203125"},
    {0x1.61447ddf5fb3ep+0, chars_format::fixed, 51, "1.379951350245121499682454668800346553325653076171875"},
    {0x1.b56d58bd7ad8fp+1, chars_format::fixed, 51, "3.417399494666546910792703783954493701457977294921875"},
    {0x1.5201909da2346p+2, chars_format::fixed, 49, "5.2813455142393816998946931562386453151702880859375"},
    {0x1.b29512bde933ep+3, chars_format::fixed, 48, "13.580697413368053361182319349609315395355224609375"},
    {0x1.28ba36cdc60a7p+4, chars_format::fixed, 48, "18.545462421229469640593379153870046138763427734375"},
    {0x1.4a0f954ec75bap+5, chars_format::fixed, 46, "41.2576090006436544399548438377678394317626953125"},
    {0x1.df376fa0e3183p+6, chars_format::fixed, 46, "119.8041367663009140187568846158683300018310546875"},
    {0x1.d777fba5be5b1p+7, chars_format::fixed, 45, "235.734341792570859297484275884926319122314453125"},
    {0x1.c36ecdbaad102p+8, chars_format::fixed, 43, "451.4328266785161076768417842686176300048828125"},
    {0x1.92271b9835605p+9, chars_format::fixed, 43, "804.3055296192766263629891909658908843994140625"},
    {0x1.3825bbeddf401p+10, chars_format::fixed, 42, "1248.589595287339989226893521845340728759765625"},
    {0x1.bb88c3b81cd97p+11, chars_format::fixed, 41, "3548.27389150271073958720080554485321044921875"},
    {0x1.0d8d78fa727c1p+12, chars_format::fixed, 40, "4312.8420357200675425701774656772613525390625"},
    {0x1.f22ae1035f4c6p+13, chars_format::fixed, 38, "15941.35986971332386019639670848846435546875"},
    {0x1.86358ae5236dep+14, chars_format::fixed, 37, "24973.3856397186100366525352001190185546875"},
    {0x1.60fac84cf570cp+15, chars_format::fixed, 35, "45181.39121214867918752133846282958984375"},
    {0x1.27022f6d4c231p+16, chars_format::fixed, 36, "75522.185261496124439872801303863525390625"},
    {0x1.4e3d42df12170p+17, chars_format::fixed, 31, "171130.5224325763992965221405029296875"},
    {0x1.198a850ca77d0p+18, chars_format::fixed, 30, "288298.078897354193031787872314453125"},
    {0x1.b9ed4a147a3d3p+19, chars_format::fixed, 33, "905066.314999694353900849819183349609375"},
    {0x1.f24810bc3163fp+20, chars_format::fixed, 32, "2040961.04594553983770310878753662109375"},
    {0x1.48f2de574af19p+21, chars_format::fixed, 31, "2694747.7926234123297035694122314453125"},
    {0x1.7b69f67382652p+22, chars_format::fixed, 29, "6216317.61280210502445697784423828125"},
    {0x1.80957cacc5b6dp+23, chars_format::fixed, 29, "12602046.33744593895971775054931640625"},
    {0x1.581bf08ec083bp+24, chars_format::fixed, 28, "22551536.5576250366866588592529296875"},
    {0x1.10483fa5a32e9p+25, chars_format::fixed, 27, "35688575.294042415916919708251953125"},
    {0x1.0ed9715f279f7p+26, chars_format::fixed, 26, "71001541.48679338395595550537109375"},
    {0x1.b72203719cba3p+27, chars_format::fixed, 25, "230232091.5503817498683929443359375"},
    {0x1.fd9abcf52a4a5p+28, chars_format::fixed, 24, "534358991.322824776172637939453125"},
    {0x1.2fcaa4b911fc2p+29, chars_format::fixed, 22, "637097111.1337816715240478515625"},
    {0x1.15bbc0a9a86a6p+30, chars_format::fixed, 21, "1164898346.414468288421630859375"},
    {0x1.b00ca87636445p+31, chars_format::fixed, 21, "3624293435.105989933013916015625"},
    {0x1.d840bff2e1059p+32, chars_format::fixed, 20, "7923089394.87899112701416015625"},
    {0x1.6573fbd897a95p+33, chars_format::fixed, 19, "11994134449.1848545074462890625"},
    {0x1.884fb41a62589p+34, chars_format::fixed, 18, "26327568489.536655426025390625"},
    {0x1.ac014e40dd0dap+35, chars_format::fixed, 16, "57445872134.9079132080078125"},
    {0x1.43fc6c60c1eefp+36, chars_format::fixed, 16, "86969337356.1208343505859375"},
    {0x1.2dbd32a11ddb3p+37, chars_format::fixed, 15, "161994920995.732025146484375"},
    {0x1.b0bd32c9becf1p+38, chars_format::fixed, 14, "464650023535.70220947265625"},
    {0x1.a4dd93186c42dp+39, chars_format::fixed, 13, "903801834550.1304931640625"},
    {0x1.e32a7f9fa538ap+40, chars_format::fixed, 11, "2075182210981.22119140625"},
    {0x1.2084411c53fa7p+41, chars_format::fixed, 11, "2478338881703.95654296875"},
    {0x1.0d5a138c14d99p+42, chars_format::fixed, 10, "4627429732435.3994140625"},
    {0x1.0ead5f7d79f3bp+43, chars_format::fixed, 9, "9300399090639.615234375"},
    {0x1.d9bdd70990201p+44, chars_format::fixed, 8, "32555272280322.00390625"},
    {0x1.b1ba144c3c6d7p+45, chars_format::fixed, 7, "59610967410573.6796875"},
    {0x1.56ef390e1980dp+46, chars_format::fixed, 6, "94265107777120.203125"},
    {0x1.d08de26a3153dp+47, chars_format::fixed, 5, "255391392143529.90625"},
    {0x1.96bf8d1fe67eap+48, chars_format::fixed, 3, "447224427308670.625"},
    {0x1.095e52abc0566p+49, chars_format::fixed, 2, "583551390548140.75"},
    {0x1.d639785501ca7p+50, chars_format::fixed, 2, "2068069188110121.75"},
    {0x1.7a69b71f7291ap+51, chars_format::fixed, 0, "3328555513255053"},
    {0x1.6f06d69bea925p+52, chars_format::fixed, 0, "6456802203838757"},
    {0x1.e477d245cfe2cp+53, chars_format::fixed, 0, "17045704215755864"},
    {0x1.94b582e6fb874p+54, chars_format::fixed, 0, "28478866104181200"},
    {0x1.651121f05f90dp+55, chars_format::fixed, 0, "50252702075045992"},
    {0x1.7b487047230f8p+56, chars_format::fixed, 0, "106758663240355712"},
    {0x1.7784c1fbc471cp+57, chars_format::fixed, 0, "211398169908011904"},
    {0x1.7ac4b78ae30e4p+58, chars_format::fixed, 0, "426455335139293440"},
    {0x1.312f35afa81abp+59, chars_format::fixed, 0, "687214204188415360"},
    {0x1.06017fddf665bp+60, chars_format::fixed, 0, "1179969481513261824"},
    {0x1.5637f72135e49p+61, chars_format::fixed, 0, "3082431250837574144"},
    {0x1.027e9b70ce1ccp+62, chars_format::fixed, 0, "4656624004411895808"},
    {0x1.60c83f40c3bc1p+63, chars_format::fixed, 0, "12710318822043551744"},
    {0x1.2689a2af0f3ddp+64, chars_format::fixed, 0, "21223673591718858752"},
    {0x1.6bd7cbc72e9cep+65, chars_format::fixed, 0, "52435295624203190272"},
    {0x1.b4618e9b7fb90p+66, chars_format::fixed, 0, "125778283487165677568"},
    {0x1.b700b394dae46p+67, chars_format::fixed, 0, "253067849876474363904"},
    {0x1.69b9336bb3625p+68, chars_format::fixed, 0, "417038733696760610816"},
    {0x1.2e73980401159p+69, chars_format::fixed, 0, "697405765271726194688"},
    {0x1.9cd16da53fb63p+70, chars_format::fixed, 0, "1903787364496945446912"},
    {0x1.a5f63f3a815d1p+71, chars_format::fixed, 0, "3891911610207935397888"},
    {0x1.b0e3c4047b75cp+72, chars_format::fixed, 0, "7985405687712874233856"},
    {0x1.4d847c6eb42c0p+73, chars_format::fixed, 0, "12304624807151021326336"},
    {0x1.85fc1437b1734p+74, chars_format::fixed, 0, "28775790596421559779328"},
    {0x1.8a7019581e7fap+75, chars_format::fixed, 0, "58208757994689939898368"},
    {0x1.c67cb0e7b2a1cp+76, chars_format::fixed, 0, "134140907927602311725056"},
    {0x1.e9cf376a61382p+77, chars_format::fixed, 0, "289132459907178460872704"},
    {0x1.f3020a5bb1e68p+78, chars_format::fixed, 0, "589124628706466797191168"},
    {0x1.c5c96a4dd9bf3p+79, chars_format::fixed, 0, "1071473736158360648024064"},
    {0x1.9c2cc74cde703p+80, chars_format::fixed, 0, "1946441008779422248992768"},
    {0x1.aba488754df1ap+81, chars_format::fixed, 0, "4038971174128976945741824"},
    {0x1.fad8c14ba9d89p+82, chars_format::fixed, 0, "9574063461859927634477056"},
    {0x1.f2fda18bc958dp+83, chars_format::fixed, 0, "18851337402710215888994304"},
    {0x1.9d8f6c51ed693p+84, chars_format::fixed, 0, "31247728753733906905169920"},
    {0x1.f8236511754b2p+85, chars_format::fixed, 0, "76183220036477407253757952"},
    {0x1.a2d213294f709p+86, chars_format::fixed, 0, "126580760756294165874081792"},
    {0x1.50d2867c287f9p+87, chars_format::fixed, 0, "203596626581082410749788160"},
    {0x1.3bf963799b446p+88, chars_format::fixed, 0, "381989337423178708023246848"},
    {0x1.a12dc41e72c86p+89, chars_format::fixed, 0, "1008676382053808460168953856"},
    {0x1.832bbfda4182fp+90, chars_format::fixed, 0, "1872243572018953219752329216"},
    {0x1.b22ef35aa515ep+91, chars_format::fixed, 0, "4199164189291374906487865344"},
    {0x1.24632dbcf4379p+92, chars_format::fixed, 0, "5655595157253244734125637632"},
    {0x1.5016423c09309p+93, chars_format::fixed, 0, "13001734056457270778428129280"},
    {0x1.bbf972700d65cp+94, chars_format::fixed, 0, "34350855574179920076494340096"},
    {0x1.6e1f3e3e4245fp+95, chars_format::fixed, 0, "56654642115107953004184076288"},
    {0x1.47d35248fe09dp+96, chars_format::fixed, 0, "101457070140041083705704316928"},
    {0x1.d31a67ab2db51p+97, chars_format::fixed, 0, "289122842438625311850965762048"},
    {0x1.ab1253de2af64p+98, chars_format::fixed, 0, "528689023652633609509229559808"},
    {0x1.9cfdf3dc71391p+99, chars_format::fixed, 0, "1022518671042034182622745198592"},
    {0x1.96152f2254ee0p+100, chars_format::fixed, 0, "2010824384227389239008365117440"},
    {0x1.b4de90e5f0095p+101, chars_format::fixed, 0, "4326544962445928561728343244800"},
    {0x1.be778d0492e6ap+102, chars_format::fixed, 0, "8843189919417627285369414221824"},
    {0x1.ebc33e9f0f228p+103, chars_format::fixed, 0, "19480726537977613039106892234752"},
    {0x1.7af455437cc9bp+104, chars_format::fixed, 0, "30023862850183478784012048138240"},
    {0x1.642a6e844551ep+105, chars_format::fixed, 0, "56436715663923718161576574844928"},
    {0x1.41b8b3a301a15p+106, chars_format::fixed, 0, "101957610305533992485037451247616"},
    {0x1.0155b96fbcde0p+107, chars_format::fixed, 0, "163105345367552336552353253556224"},
    {0x1.17b500de21540p+108, chars_format::fixed, 0, "354570802835801091766892577685504"},
    {0x1.fa3527f025531p+109, chars_format::fixed, 0, "1283388839036855097115531068571648"},
    {0x1.12991a738b877p+110, chars_format::fixed, 0, "1392377581640218018121716183597056"},
    {0x1.4bbcfb93f0ee4p+111, chars_format::fixed, 0, "3364225166474354069710570596073472"},
    {0x1.15926f3d7b071p+112, chars_format::fixed, 0, "5629829199100141824040041065742336"},
    {0x1.86dacf9db9927p+113, chars_format::fixed, 0, "15854951477853973766554010496532480"},
    {0x1.6aa8e880f9271p+114, chars_format::fixed, 0, "29422458257062697580352079193440256"},
    {0x1.44db602f65a69p+115, chars_format::fixed, 0, "52711051576274024231085405965910016"},
    {0x1.4aa98d059f6c7p+116, chars_format::fixed, 0, "107306053965661318564328070210125824"},
    {0x1.ad41a77876ac0p+117, chars_format::fixed, 0, "278603372165060620709063210871816192"},
    {0x1.66608302c1ae0p+118, chars_format::fixed, 0, "465199941604955653649793565669195776"},
    {0x1.724a6060561d6p+119, chars_format::fixed, 0, "961329185843412549197741860528848896"},
    {0x1.d6cd57f7afd91p+120, chars_format::fixed, 0, "2444544386985640811823093072529457152"},
    {0x1.ddc593d2d0608p+121, chars_format::fixed, 0, "4961465895993372192136189659616116736"},
    {0x1.cb5644ce1a91fp+122, chars_format::fixed, 0, "9540055986377936639970287777627504640"},
    {0x1.1bc54417de33cp+123, chars_format::fixed, 0, "11787368324472861665867817538046394368"},
    {0x1.0b7025db14e7ap+124, chars_format::fixed, 0, "22217886245582567633425166223452143616"},
    {0x1.c25ad8d3be06dp+125, chars_format::fixed, 0, "74828037824613418029633676794849656832"},
    {0x1.6fa2ef34cd8cep+126, chars_format::fixed, 0, "122168169555880306340177489939782434816"},
    {0x1.2154fd4e3bc1cp+127, chars_format::fixed, 0, "192294090682938928866121043260519481344"},
    {0x1.2b3cd0ab51216p+128, chars_format::fixed, 0, "397754940865523918837358639143272316928"},
    {0x1.088b103a41b0bp+129, chars_format::fixed, 0, "703276498569342686920339511489517846528"},
    {0x1.e53444dfa15a7p+130, chars_format::fixed, 0, "2579787897255990868798456303636608712704"},
    {0x1.19ed8692b24fbp+131, chars_format::fixed, 0, "2997970965091339190918492577226091921408"},
    {0x1.d6393885ae144p+132, chars_format::fixed, 0, "10000548245536083788593238972941513785344"},
    {0x1.6acc29897fd95p+133, chars_format::fixed, 0, "15431699376188799230066746785793442840576"},
    {0x1.f2f9916765d68p+134, chars_format::fixed, 0, "42448087869444726132947292415438599749632"},
    {0x1.a8bb1d24ff93dp+135, chars_format::fixed, 0, "72264220268357129106158415886080664403968"},
    {0x1.c5c3e8df3f2cfp+136, chars_format::fixed, 0, "154408320815216985959484763121150171545600"},
    {0x1.1772e9d5da5a7p+137, chars_format::fixed, 0, "190183053010164648774242281749579802083328"},
    {0x1.14f6d2645603fp+138, chars_format::fixed, 0, "376984063098152793892190666264816558014464"},
    {0x1.24a5b6eb957c8p+139, chars_format::fixed, 0, "796661788291652637963628795803622629703680"},
    {0x1.2ead0eb8af7cbp+140, chars_format::fixed, 0, "1647924923062673765177664088659074522021888"},
    {0x1.f516ab8dbd662p+141, chars_format::fixed, 0, "5456371187228343385170833127692803019636736"},
    {0x1.855d7376918a9p+142, chars_format::fixed, 0, "8479619741110213809967927453284253992747008"},
    {0x1.f44b558dbdfb5p+143, chars_format::fixed, 0, "21790888931872989461006813529845663969312768"},
    {0x1.196a6ab9ee449p+144, chars_format::fixed, 0, "24514764141293366381415554359835359275122688"},
    {0x1.c970123b86b86p+145, chars_format::fixed, 0, "79696901062182934373616907409137788885401600"},
    {0x1.23fe1017a3e0ap+146, chars_format::fixed, 0, "101744513270938959360968970914297622533505024"},
    {0x1.547b58dbe0a82p+147, chars_format::fixed, 0, "237281200493303842948982975659978497995046912"},
    {0x1.6b72d270d534dp+148, chars_format::fixed, 0, "506573307308778511819262316883115987825590272"},
    {0x1.9bfa29a521e6cp+149, chars_format::fixed, 0, "1148424814894339399771081143389126450042896384"},
    {0x1.088e70fa79bf2p+150, chars_format::fixed, 0, "1474951280394658237786084602544572869491294208"},
    {0x1.1d97a9d8999d2p+151, chars_format::fixed, 0, "3184462066193894206844138084970587550398808064"},
    {0x1.1b7ddc6783fe8p+152, chars_format::fixed, 0, "6322074926642195313905924879563454681421185024"},
    {0x1.90f9b356e1fd1p+153, chars_format::fixed, 0, "17884100129279887107935363982167269062471581696"},
    {0x1.04a659aa20643p+154, chars_format::fixed, 0, "23250739609400940032347413152147324745086402560"},
    {0x1.b45db51612c32p+155, chars_format::fixed, 0, "77850303756798823507242277549769146173862445056"},
    {0x1.94f1118511db0p+156, chars_format::fixed, 0, "144488017324739167332291972816201226607422078976"},
    {0x1.74288ae36661ep+157, chars_format::fixed, 0, "265581086928756856691568738355781584549167759360"},
    {0x1.3253541731259p+158, chars_format::fixed, 0, "437202365761853212655650514880767316833467367424"},
    {0x1.9d71f6b97eb99p+159, chars_format::fixed, 0, "1180177332650351500186142018418327053943445651456"},
    {0x1.9c2824d021211p+160, chars_format::fixed, 0, "2352999434252425166009583916770268278726766624768"},
    {0x1.2c37fa039529bp+161, chars_format::fixed, 0, "3427891103047345015228894619797641792100916789248"},
    {0x1.97f764d76e448p+162, chars_format::fixed, 0, "9316305249300850264705734277618344776195427532800"},
    {0x1.a28e124e01121p+163, chars_format::fixed, 0, "19116211540697205399927873627877011998254938718208"},
    {0x1.500cfed695739p+164, chars_format::fixed, 0, "30696171319662410271698897460360354956718064533504"},
    {0x1.2cd97b4ce81a2p+165, chars_format::fixed, 0, "54961511485964129240667100065476685812465949212672"},
    {0x1.d24224f1cf2bcp+166, chars_format::fixed, 0, "170359345069614948406404727167574558656079671066624"},
    {0x1.83b3da401d150p+167, chars_format::fixed, 0, "283313955071286289178391550929804608096590893154304"},
    {0x1.a3b0d2f93d673p+168, chars_format::fixed, 0, "613378673285658591018762418018704374742768855023616"},
    {0x1.6b5cc29017ae4p+169, chars_format::fixed, 0, "1062109320797658708151958249612931353686624780156928"},
    {0x1.e6bf9a05045a3p+170, chars_format::fixed, 0, "2845534590927396736753751979474589830905163889508352"},
    {0x1.cc9ed46d0d98ep+171, chars_format::fixed, 0, "5385580087774829124578596551004441252780605203021824"},
    {0x1.bc208d2b82a15p+172, chars_format::fixed, 0, "10385481005999034803544914290611356999601747138707456"},
    {0x1.6c981eeb98863p+173, chars_format::fixed, 0, "17051361668200266280635006715246243029863394338406400"},
    {0x1.af5d7ade9c17ap+174, chars_format::fixed, 0, "40348216442512827178202027976145404001660863678251008"},
    {0x1.ebfb63d8a468bp+175, chars_format::fixed, 0, "92036158369142271242411353737258443958178349337018368"},
    {0x1.8165629784911p+176, chars_format::fixed, 0, "144193775900760462481135039693825192887594892339970048"},
    {0x1.f561a2a30dd53p+177, chars_format::fixed, 0, "375178096298129453493805795896698130008167991753048064"},
    {0x1.ce7c7938e0eb9p+178, chars_format::fixed, 0, "692146559638991570078851625625319303554674020637999104"},
    {0x1.77bc8cddcf12ap+179, chars_format::fixed, 0, "1124637789574368600447483337148668908930534274783772672"},
    {0x1.3fc175c6f2438p+180, chars_format::fixed, 0, "1914156990649081570063038235013271375259033985125187584"},
    {0x1.914ec58ebe041p+181, chars_format::fixed, 0, "4804705186047787763539909785825820848780520789991489536"},
    {0x1.5114314b07626p+182, chars_format::fixed, 0, "8071435564947532553915773674998525033942233843077480448"},
    {0x1.e2f0276441399p+183, chars_format::fixed, 0, "23128140200050004179900419204722717138007627859971014656"},
    {0x1.cf8d0a2eae505p+184, chars_format::fixed, 0, "44399358958425029747414170378892766455751677599478185984"},
    {0x1.4dda59a8f20a2p+185, chars_format::fixed, 0, "63953515931602618386692877635154528630077627837316071424"},
    {0x1.bab65f6c0e97cp+186, chars_format::fixed, 0, "169613692241034722191343016069607921350219320331459362816"},
    {0x1.0db1e999e5dcep+187, chars_format::fixed, 0, "206653170011853535337803469369851216808403208737925365760"},
    {0x1.16729f78118dbp+188, chars_format::fixed, 0, "426719928808949879800861601633810112450796943718953779200"},
    {0x1.84b2774cd6d15p+189, chars_format::fixed, 0, "1191353245759245872712330749375395405217002847792663625728"},
    {0x1.5e6b2eec1979ep+190, chars_format::fixed, 0, "2148060287120407132486133792062303242882862510466574319616"},
    {0x1.57ac5f28c5822p+191, chars_format::fixed, 0, "4213422729321882403507151670457754635672165551067199700992"},
    {0x1.2c1e6e57e9676p+192, chars_format::fixed, 0, "7358893309664639936881070842796439426339053634941326721024"},
    {0x1.f14d05585f439p+193, chars_format::fixed, 0, "24387563351268131955594715375272838644628307055389846798336"},
    {0x1.18fdf7f764a16p+194, chars_format::fixed, 0, "27559621536224231764973310109769900471295096010340351082496"},
    {0x1.8c82785d38820p+195, chars_format::fixed, 0, "77779106454146886485489687505009291495088393514544036577280"},
    {0x1.e664096512a4fp+196, chars_format::fixed, 0, "190820271006743062589068419007889919427368854321224868691968"},
    {0x1.7ad7e8f87a31fp+197, chars_format::fixed, 0, "297254819348561348142059994275052781258332713659043726491648"},
    {0x1.8fbcbd9143824p+198, chars_format::fixed, 0, "627297873989847920060186967507561121071724081221944431607808"},
    {0x1.fffab418f559fp+199, chars_format::fixed, 0, "1606873109429469790133884014121163665471467983941023660244992"},
    {0x1.da1c6d063ff81p+200, chars_format::fixed, 0, "2976043223039824053749757547207391812994613888441872405233664"},
    {0x1.15fe8ce1e9504p+201, chars_format::fixed, 0, "3489997472879308917395719419357749318529849683153472890863616"},
    {0x1.a8f8f1d983703p+202, chars_format::fixed, 0, "10670380970822515728824154611513147539078615867965386421960704"},
    {0x1.a7c5f2cb7fa9cp+203, chars_format::fixed, 0, "21280541721170621914318415811403250028099879746592336410312704"},
    {0x1.9a069737b82f9p+204, chars_format::fixed, 0, "41180373037668160785451413693672802945556196669733887910346752"},
    {0x1.d7fb39182d06bp+205, chars_format::fixed, 0, "94805596416636166286963836377361743535131113441946788094279680"},
    {0x1.8d79cca5204b4p+206, chars_format::fixed, 0, "159679737690547294653629880448829857591918862991885354225631232"},
    {0x1.640c53e94baf0p+207, chars_format::fixed, 0, "286073663238193178122650589057504705307874404845642118712000512"},
    {0x1.804d768153946p+208, chars_format::fixed, 0, "617550451567674330351768298244433962928282156182053738323640320"},
    {0x1.d56e2fb92f94bp+209, chars_format::fixed, 0,
        "1508691188244574982497059261858774337284894599380994275393142784"},
    {0x1.9de8dda906a1ep+210, chars_format::fixed, 0,
        "2660508539901083172029910702401831570415871079047501730937831424"},
    {0x1.7625e5dbb3e9cp+211, chars_format::fixed, 0,
        "4809861739392636763970911315108253399659550567331225058938978304"},
    {0x1.c66583b372649p+212, chars_format::fixed, 0,
        "11682993418673641507770337381177220245747542216734811616358432768"},
    {0x1.c7dbe2df944fcp+213, chars_format::fixed, 0,
        "23441185866765201891906590922363241098417108629756551288590434304"},
    {0x1.52e75005b7ac3p+214, chars_format::fixed, 0,
        "34854210022549138065076113679839139392004906864670443177957654528"},
    {0x1.61996d6b5a737p+215, chars_format::fixed, 0,
        "72731162770376529778347980921328038690888967732944646841598738432"},
    {0x1.494416e47342cp+216, chars_format::fixed, 0,
        "135452165324500505731674715004755427528854893946418837623752622080"},
    {0x1.d60ab6b85519cp+217, chars_format::fixed, 0,
        "386728003636036058641366871128252569918895873439564907057088823296"},
    {0x1.33e03222aff77p+218, chars_format::fixed, 0,
        "506610974407740673840531052436472518619916156367111801266415599616"},
    {0x1.c180013aacf42p+219, chars_format::fixed, 0,
        "1479308658758350330944201788946768123438076335588933997743174582272"},
    {0x1.a8c4ee725339fp+220, chars_format::fixed, 0,
        "2795839034978863819877803502232039113629062617998185283225294733312"},
    {0x1.e8aaf34741ab6p+221, chars_format::fixed, 0,
        "6432840401396405792365580284144481229273342573010878029692370157568"},
    {0x1.227ef7d830535p+222, chars_format::fixed, 0,
        "7648199062043261318600497597311503711731364104890099198009813237760"},
    {0x1.50d3b96e4614ap+223, chars_format::fixed, 0,
        "17736014170885828821631467083617455696667197990697308887351889494016"},
    {0x1.8199aecb377d9p+224, chars_format::fixed, 0,
        "40608453724544028931786363107981702003718879833309714118046052777984"},
    {0x1.19dbb35474ceep+225, chars_format::fixed, 0,
        "59366267010857000073898171317477288623551476762400866883285525987328"},
    {0x1.dc33701787db2p+226, chars_format::fixed, 0,
        "200599244568418166158633240420166985299541370621581756051323713748992"},
    {0x1.eff20ab8910b4p+227, chars_format::fixed, 0,
        "417833237036618955782462790270901274407866847161169503610707764051968"},
    {0x1.bbe88a3d4104ep+228, chars_format::fixed, 0,
        "747984105847088632825661725590567003356199708795195209233577533243392"},
    {0x1.46b387e75ac05p+229, chars_format::fixed, 0,
        "1100981177656366596121887029311165116283765891574561058397569203306496"},
    {0x1.e666f5cf254cap+230, chars_format::fixed, 0,
        "3278344263502461615618708692041532796484309585052066932644501920940032"},
    {0x1.e6e69845380cep+231, chars_format::fixed, 0,
        "6563409273861357872055846937881366142433814631142651266800757371830272"},
    {0x1.87fc0b17b39efp+232, chars_format::fixed, 0,
        "10567882407580982568830708317724752282141329118524865643643232472530944"},
    {0x1.1d2094524e151p+233, chars_format::fixed, 0,
        "15374031618797994143345255818223153455446312412350835802141987662987264"},
    {0x1.ef0acdf882c82p+234, chars_format::fixed, 0,
        "53385245818425520938354086001407499619172852619721193835236025339740160"},
    {0x1.fcbcd755571cbp+235, chars_format::fixed, 0,
        "109724321606021718480487121388084343129412917209137058037575549878009856"},
    {0x1.5bc325b6842e6p+236, chars_format::fixed, 0,
        "150010446473379751635360522928886290191929534462594299677079810961571840"},
    {0x1.4839844f3a28ep+237, chars_format::fixed, 0,
        "283165431565250843561226845873096957075695083997080472361101646654078976"},
    {0x1.e268bea09d76dp+238, chars_format::fixed, 0,
        "832366412253767450473627272269736199394015241611420074982712040652537856"},
    {0x1.9760fc3633170p+239, chars_format::fixed, 0,
        "1405812739508858068375342755770185891515789882712544527098421327318482944"},
    {0x1.f9780dce1dea1p+240, chars_format::fixed, 0,
        "3488618552580639620123899659132615213727580900417550210713537290046537728"},
    {0x1.06379cf942b94p+241, chars_format::fixed, 0,
        "3619513742366401459360774923805574186193834456864238978452991001371869184"},
    {0x1.54e3dfab69e89p+242, chars_format::fixed, 0,
        "9410948883835140439259712749284374813211962760503227341524256159409635328"},
    {0x1.31e863bfd9bd6p+243, chars_format::fixed, 0,
        "16890382785900103876754997077931661155681683793063575869750399994525908992"},
    {0x1.97cf871c408f0p+244, chars_format::fixed, 0,
        "45033691214168135372365182321155169406467422866316271815207540483596222464"},
    {0x1.1c444bdbdf9c3p+245, chars_format::fixed, 0,
        "62781991287502835294706934796700503444220891091676239343080273452105465856"},
    {0x1.05d2dc08efe95p+246, chars_format::fixed, 0,
        "115650595692360812734551875859766266613142682216011370208563856535394975744"},
    {0x1.ecc77551d4971p+247, chars_format::fixed, 0,
        "435332683162743291871502389653473442925183772482197555090046969989126160384"},
    {0x1.d480cb6589e19p+248, chars_format::fixed, 0,
        "827773333411108944564788528429675414027959576520140010882381647552484212736"},
    {0x1.8d8ef73cf87b1p+249, chars_format::fixed, 0,
        "1404849996452092323181663448719164230590611915347499050189329189348495589376"},
    {0x1.48a0c3b10a317p+250, chars_format::fixed, 0,
        "2322541569987461897646236862872835979235153071147854369984513726383982116864"},
    {0x1.4272a4c4fdd70p+251, chars_format::fixed, 0,
        "4557727968952480904558449925323762902907761772892808327111565265849267781632"},
    {0x1.ae03d804b061ep+252, chars_format::fixed, 0,
        "12156332270976550147325112623712160214870303638258728835579240357786392985600"},
    {0x1.0b5dd53c3113bp+253, chars_format::fixed, 0,
        "15116664880436697889619534522569417861107074808654256101389938332337600200704"},
    {0x1.fdd951416069dp+254, chars_format::fixed, 0,
        "57652801636485908304981079853657826006611591736383711473146661351961829310464"},
    {0x1.3f050c163f528p+255, chars_format::fixed, 0,
        "72148358177064735441715850462253186745656784598757713984413999990820116103168"},
    {0x1.d281ec8a5d188p+256, chars_format::fixed, 0,
        "211007343253573153040916841042569198900237589785514419724926914360700078915584"},
    {0x1.b1ee0f3407c41p+257, chars_format::fixed, 0,
        "392544155933803743324755229116691986569477877247338320380545265297625347784704"},
    {0x1.6832d41e7dc1ap+258, chars_format::fixed, 0,
        "651689727341929711233861882075902356487556403051443857638498564365941253079040"},
    {0x1.e64f563364bdep+259, chars_format::fixed, 0,
        "1759713762122699202687616247528935298815073962848552505418712077302891964006400"},
    {0x1.daa06c44fb425p+260, chars_format::fixed, 0,
        "3434875728114804814685899568021643975684275456343249710170796956248388352868352"},
    {0x1.36affe847782ap+261, chars_format::fixed, 0,
        "4496894013184631719592075324719660880451832741221158646672639002826028676546560"},
    {0x1.5a4251d5f8667p+262, chars_format::fixed, 0,
        "10023515028874743203760034918542228757355688414371945561530461637433189038292992"},
    {0x1.61672219d801dp+263, chars_format::fixed, 0,
        "20460627987672046957993749035049653899503117503129177347274847415982748178841600"},
    {0x1.3d865b7eeb438p+264, chars_format::fixed, 0,
        "36766863868985022220367084943920216131061939418967080566277924324348988351315968"},
    {0x1.2db506dfa8ce9p+265, chars_format::fixed, 0,
        "69870599261497189307442468175452786217368249333102065069521396329647863295377408"},
    {0x1.8390d09306414p+266, chars_format::fixed, 0,
        "179508160415808704712141748605675659243941837354766083639370088277774910089068544"},
    {0x1.9b58ceed26006p+267, chars_format::fixed, 0,
        "381045742515568238106089113337056938315639562315303996957679473250795050372169728"},
    {0x1.2fbe163c69224p+268, chars_format::fixed, 0,
        "562735708283395761680999734220534079897036103282947406804850940523084358392741888"},
    {0x1.ed623087df1bep+269, chars_format::fixed, 0,
        "1828157196786173258110715724311801689865646019514059112947102608834558509445021696"},
    {0x1.c4a8946c5378ap+270, chars_format::fixed, 0,
        "3354513608629342758881183607515227358808179514909005943036597166005055102654611456"},
    {0x1.15c4e12be427fp+271, chars_format::fixed, 0,
        "4116922864713554962262731822113769463098264781458759029065788118035733765689442304"},
    {0x1.6ad5bf3ce75d1p+272, chars_format::fixed, 0,
        "10755434708169830468646961963757742494547372019865450762930913468197267328525664256"},
    {0x1.39e6cc7b696f2p+273, chars_format::fixed, 0,
        "18609826393606468152836428445460492052838500356054137125720357473673460037122523136"},
    {0x1.492f9204fea8cp+274, chars_format::fixed, 0,
        "39031924794474990334523500695205978003245342146820076519433466216752476212355399680"},
    {0x1.10fdf067e1d3ap+275, chars_format::fixed, 0,
        "64737911159818786400194931508236873102720909642740513708334320479730693747677069312"},
    {0x1.4475e6d3ffa4cp+276, chars_format::fixed, 0,
        "153886578090640196755690493218260429593835278923075770789252846079936296641204584448"},
    {0x1.e690de58f29c9p+277, chars_format::fixed, 0,
        "461541222592303232645421887442495089995066619544195472117594256018529300800228818944"},
    {0x1.12d15aa66324bp+278, chars_format::fixed, 0,
        "521367158800009825612598958231777939062375172881031702301591795450637439548805611520"},
    {0x1.c6239933289ecp+279, chars_format::fixed, 0,
        "1723128550002755437133951204996418910562653794534546195856270285892794521746348703744"},
    {0x1.b6563b1fc7692p+280, chars_format::fixed, 0,
        "3326341182536398505347105064878210412153017884659534401506803457160509140679576780800"},
    {0x1.bc57fc9b4e281p+281, chars_format::fixed, 0,
        "6743849062437124540067369460095704859176196480433913929539186007746583809206972841984"},
    {0x1.f8df107311968p+282, chars_format::fixed, 0,
        "15324966500321058049592869611887769487534860026596133853595336640461446056900382687232"},
    {0x1.de346966130bbp+283, chars_format::fixed, 0,
        "29031045606668695079086558896866507278227043543999063147023976978260396987770338279424"},
    {0x1.4bcb7614590adp+284, chars_format::fixed, 0,
        "40285461203337303545331340422939720789741892918160941159647588152564951369732381999104"},
    {0x1.0563f359dbcccp+285, chars_format::fixed, 0,
        "63474382619472774879674901098388887476421241832512569944968136076387350654165612232704"},
    {0x1.31c3c51fb59f0p+286, chars_format::fixed, 0,
        "148499905686861542665053988630525851133259775675492961721942835140068121158861530857472"},
    {0x1.43b14acd508e9p+287, chars_format::fixed, 0,
        "314413721470914827393293275279827694247227625704700173468711358766455498713644557926400"},
    {0x1.7a67288ca2338p+288, chars_format::fixed, 0,
        "735111663943683991924868091407140115848506284972761980234658243157821224316229105221632"},
    {0x1.90ee051acce20p+289, chars_format::fixed, 0,
        "1557747566386344816691965362482515856301711161509577196359183216260647622504160667107328"},
    {0x1.2489551766274p+290, chars_format::fixed, 0,
        "2273205881098212719172251019697290790177862652621182786611096562647157941278227203883008"},
    {0x1.3e54bc6237b93p+291, chars_format::fixed, 0,
        "4947293841380347003020105042807568353223605346291404893299918661932182932360249923862528"},
    {0x1.ecf1cc571a5cdp+292, chars_format::fixed, 0,
        "15322047885180556695270544082527752765618412372787918210678376413654108545252676641751040"},
    {0x1.62c38c686058dp+293, chars_format::fixed, 0,
        "22054038951762964986671726632558697872297075702108276219895533878990952721420526897070080"},
    {0x1.1956cbeae3776p+294, chars_format::fixed, 0,
        "34979111598588176010555116390040342571373179418270620765845075298580332460285709028163584"},
    {0x1.d245370a2c906p+295, chars_format::fixed, 0,
        "115943544996190933856633616414466811022505880808156492718239704433998219084021400875302912"},
    {0x1.77a2ad5be5f22p+296, chars_format::fixed, 0,
        "186812241557541298892557723890372259123352337205389983867335838290407406167752042457595904"},
    {0x1.5e27d63120bc6p+297, chars_format::fixed, 0,
        "348281044472571483629770428112359357931579367395984692863821844484753880315554503889780736"},
    {0x1.6cd5ca4b6a049p+298, chars_format::fixed, 0,
        "725763926599453313576032544399461752503111043260623699604979165837300824089149573789908992"},
    {0x1.21ef16216f087p+299, chars_format::fixed, 0,
        "1153527049014772181210371929535324976526694483335493350780385752130773271127971750637207552"},
    {0x1.39c791a4cdd30p+300, chars_format::fixed, 0,
        "2496797909293860274452611679981864366431273655911171418054054946652601225349601977195036672"},
    {0x1.b84f065ad9c40p+301, chars_format::fixed, 0,
        "7007223778789100460674592112903687638288056977455315141802089640807060683661017463323099136"},
    {0x1.5c980f061d930p+302, chars_format::fixed, 0,
        "11095288700912676850259655407944409623006326764511603357666977203703446579685558999924604928"},
    {0x1.d11d295facde2p+303, chars_format::fixed, 0,
        "29607930405769014382601054795425097838217102889963775497642608889806414863145865310495571968"},
    {0x1.bbf08598a98bbp+304, chars_format::fixed, 0,
        "56520050704947556744896535369107614707599849622347754280995272309160258719009203701942321152"},
    {0x1.ba04cbb38e4d5p+305, chars_format::fixed, 0,
        "112551007727079359585097814946865173194633864244482778621517929765203808143927747684958470144"},
    {0x1.54131d0e410eap+306, chars_format::fixed, 0,
        "173186080336662674773428302451694949383861654865608072294885374856902390005170129581872513024"},
    {0x1.e30ce3214662bp+307, chars_format::fixed, 0,
        "491995461222250678150766955487414849320177453519696863021951432129138251603934668204877545472"},
    {0x1.53b14d0307376p+308, chars_format::fixed, 0,
        "691966009118651520979803296576329218495201852892814426466356352573178600739540460494424899584"},
    {0x1.0db459c95ae0ap+309, chars_format::fixed, 0,
        "1098795518726438366609401980967157225074875139569724076317122730302418377716044842181188386816"},
    {0x1.1c3939899abbap+310, chars_format::fixed, 0,
        "2315894257968477114139855258593793035500513640711965686941821174621775820808713339985182326784"},
    {0x1.373d598ccbedep+311, chars_format::fixed, 0,
        "5072050876594695187143611329349529671804041318752578686754097723389320355895218925355946475520"},
    {0x1.3df92e8f7f25cp+312, chars_format::fixed, 0,
        "10363570999985610218238902711693729605343613482930794977520814186252504820113148082355622117376"},
    {0x1.e43040df434b2p+313, chars_format::fixed, 0,
        "31561899942152433381203488205922856539908726361744071551624952459304620181234055813806189182976"},
    {0x1.bd56a038510a5p+314, chars_format::fixed, 0,
        "58058899603986402390979930533204289636439533662431550984437804920565671771960313337224984788992"},
    {0x1.47a680f7df241p+315, chars_format::fixed, 0,
        "85431764922746352414815315662378944345996354389236714634151510172388323479866864189920524632064"},
    {0x1.0a7083cf6add8p+316, chars_format::fixed, 0,
        "138943198710420748341660043617043022583822760533446236412979829417047860471831997112096984662016"},
    {0x1.ca2d6c8c53bd5p+317, chars_format::fixed, 0,
        "477861849016998188114122579439270994768860615811890514883370859774317648442079613611698244550656"},
    {0x1.e92db2529dbcfp+318, chars_format::fixed, 0,
        "1020389588899609153532580957412143752366703719293632571694846387812362664420354081750298547716096"},
    {0x1.7e9337e01fb65p+319, chars_format::fixed, 0,
        "1596045688776375776841703068858618647181748707273854812785319263912136577406031736557627640905728"},
    {0x1.856a9ca60259dp+320, chars_format::fixed, 0,
        "3249173807353552076769227343856334408112864749547363816303721235276306516121646129315832634802176"},
    {0x1.2954147067244p+321, chars_format::fixed, 0,
        "4961638176380709527864130701814524798785240769392200382075051902521140868022699235320535724326912"},
    {0x1.8a9948a3b5773p+322, chars_format::fixed, 0,
        "13169653838480804261787216771021395751394285182101604350092325078019863042497232905928302772879360"},
    {0x1.9d7f682a48e95p+323, chars_format::fixed, 0,
        "27600802833290057294863365648278498083682974322674559612258381363079661754043107711541518184480768"},
    {0x1.1394946666649p+324, chars_format::fixed, 0,
        "36789758695100667984355585133798803034265640286914369787158051732884080762893646681521731009511424"},
    {0x1.5cf3dcf0c210ap+325, chars_format::fixed, 0,
        "93169776057927388397860971692076748096813463829441115661384293210348344104809158613064035568975872"},
    {0x1.edad497808d6ap+326, chars_format::fixed, 0,
        "263621865809578202632007715175239364465008642226141794355213814208815258090680462442156516792336384"},
    {0x1.0da0103363c19p+327, chars_format::fixed, 0,
        "287958016292024262706195266242702522208665557458094458094772254523203474127145608787359761973641216"},
    {0x1.e0e09ee6fbc77p+328, chars_format::fixed, 0,
        "1027147944933023542626819355716472887371271886832370736047056582372410954517572846778976767599181824"},
    {0x1.9678e5f1a7d71p+329, chars_format::fixed, 0,
        "1736438949946239757715573812462668203854228021142457473943958788246613058128755016444052964993138688"},
    {0x1.4b5b869a8b73ap+330, chars_format::fixed, 0,
        "2831101490449813330351300092716022415336638150557587101281369589000119033315970171347397084924870656"},
    {0x1.fe2c3d2523805p+331, chars_format::fixed, 0,
        "8717780031735017825202945866702741954863254816636562878236216927980533804341886067016970323602964480"},
    {0x1.7a8e2bf190c3ep+332, chars_format::fixed, 0,
        "12937429393963081102936715388735517174575449745661779868560549590564554071876819476341646368012500992"},
    {0x1.c20e9fb7c28cfp+333, chars_format::fixed, 0,
        "30762117874250039643733615885315530924664479523238936706849825774314004483458403504169088362311843840"},
    {0x1.bc64bd3fbb063p+334, chars_format::fixed, 0,
        "60750002047707119351020146056748996020726847090111922770368870774035039300942105887039623283718750208"},
    {0x1.6fa79bcec5d71p+335, chars_format::fixed, 0,
        "100519131923249665159539189045738250625445899193224853577560494867813212309547435281219657555073040384"},
    {0x1.255820e7b40dbp+336, chars_format::fixed, 0,
        "160404356999704584039118751697581736942407721317265568405145483828932537524402503992838476799827509248"},
    {0x1.24e8b96eea468p+337, chars_format::fixed, 0,
        "320332798201769959258478598390469858187503168380540831739211163523937048679598283011990104943469002752"},
    {0x1.296421957b8fcp+338, chars_format::fixed, 0,
        "650468980931338189749732798197360744414144439025939112265821291401038872632313877281859844571396046848"},
    {0x1.2b239b9bcb1b4p+339, chars_format::fixed, 0,
        "1308584396599165566045730161590653878587049789341429936525191989129126795868599529420259141598822006784"},
    {0x1.ea18f74afcc08p+340, chars_format::fixed, 0,
        "4287864653000838387576078081500217988595704090069841900641074208176801061178027675635595638576924065792"},
    {0x1.771193f9d6396p+341, chars_format::fixed, 0,
        "6562953660628768829189264161074367158311572400757453113543576153535820429893027838763351813805739868160"},
    {0x1.5da5e2bf67261p+342, chars_format::fixed, 0,
        "12236285152807307624643628388698918410797745423679381645265829552143290625157094290629079953916645343232"},
    {0x1.58fcd12ad7c3ep+343, chars_format::fixed, 0,
        "24146377765621171182079586051573746443023029345082834585424128063094779334007517592308658607782004523008"},
    {0x1.b981dd551031dp+344, chars_format::fixed, 0,
        "61803976055027187805645727187356890583048090549637147591363651473300874743076219960394574930078255284224"},
    {0x1.3fc3743a41034p+345, chars_format::fixed, 0,
        "89523575061105608238046943579501639205343860863408393270849566318887407646865214523447906339722299965440"},
    {0x1.dd8d36aaec71ap+346, chars_format::fixed, 0,
        "26739842993463813581156554780066217112772220767550736342920483680948044260004126801045126228240727696998"
        "4"},
    {0x1.b602d12c2da7dp+347, chars_format::fixed, 0,
        "49051642185904873558626243255292753780465266746677410227409405159144065675524555006405554665149184763494"
        "4"},
    {0x1.fc12bf0bef890p+348, chars_format::fixed, 0,
        "113795434024829486042338000081810099722588212366244304944366973309627116575158217811445667800351829812838"
        "4"},
    {0x1.3b58efef7ec92p+349, chars_format::fixed, 0,
        "141259541205595997693021666042884440773661567606819789980115193551404322394471748056362736136713555410944"
        "0"},
    {0x1.5b4c0eded4f79p+350, chars_format::fixed, 0,
        "311142743186002630640577638734310077189031292161333511033996767595551835883657601727589498257791590911180"
        "8"},
    {0x1.e85ac6ef41497p+351, chars_format::fixed, 0,
        "875031714552777887225807383376825846159238826560043847494035938723501665994908088640458130401929788915712"
        "0"},
    {0x1.3f23aec99600fp+352, chars_format::fixed, 0,
        "1143665218169053437791696983895095268164468569824714282350958559928889824463345030834752069494306643535462"
        "4"},
    {0x1.dbfc913a56c60p+353, chars_format::fixed, 0,
        "3411483086538129071800118542616399504614130643685414294680318962544798628099321482305174141705247569792204"
        "8"},
    {0x1.1c2ebe7ec1836p+354, chars_format::fixed, 0,
        "4073577415899245225960580860658850498986681199008703896559519292487004890804481986750861338164246566299238"
        "4"},
    {0x1.938cd43ae03ccp+355, chars_format::fixed, 0,
        "1156927033128253405996906832732887656530865035604514520460096825132623670464113645197639515740810767782379"
        "52"},
    {0x1.3b62009235fd5p+356, chars_format::fixed, 0,
        "1808325159908248270287140807249616053067477666022582227265950515643346517298199495919130365860760932633804"
        "80"},
    {0x1.4aa1b1e151343p+357, chars_format::fixed, 0,
        "3791515819931573020870093208989719549053779720350783268479897406115616623025556208847436104017615978684743"
        "68"},
    {0x1.9e1c89c676ae4p+358, chars_format::fixed, 0,
        "9497641000152050533933692352770827532886008297490354102183749813940857555737621815657793630195331519500779"
        "52"},
    {0x1.3c53f9e9b8734p+359, chars_format::fixed, 0,
        "1450995807728975300658374553952345542332188682619160625619541203796573979107950975975929307550493973164326"
        "912"},
    {0x1.e2406d2cc3bf2p+360, chars_format::fixed, 0,
        "4424174112983774166346168063541478892490396153922578140353694059038212329120121626025623387504240176662577"
        "152"},
    {0x1.965c4e0d723edp+361, chars_format::fixed, 0,
        "7455899165473142891410407993445287142678369581757602511443241805608259062452677439719374796291043974872825"
        "856"},
    {0x1.f33c9e28b3fdep+362, chars_format::fixed, 0,
        "1831998212881987847587463179817625260583859227295674763869324737953857333941893959041639880689268798361121"
        "5872"},
    {0x1.9f22e896506fdp+363, chars_format::fixed, 0,
        "3046766945740591268037411649241064495268923737271466586523553924004122130570808853030772156099541307710504"
        "9600"},
    {0x1.b237a63060f12p+364, chars_format::fixed, 0,
        "6373612538460249654292584671694501959756750262508216475854313728962720485103687524257115101524481605949928"
        "2432"},
    {0x1.1dc76d7407d6dp+365, chars_format::fixed, 0,
        "8389552291826710390436149420039271487408725462561403588441786268070424663051774660933458866042972348945635"
        "7376"},
    {0x1.e7fd5979d3140p+366, chars_format::fixed, 0,
        "2865161162150603509344474186833037533735333354175484885199280093460377624949994775110060838906517616340280"
        "27904"},
    {0x1.ff1435c531fe7p+367, chars_format::fixed, 0,
        "6001453332972218932973411842315949625507549531805811536330508301961761394517291791742398897172342756841336"
        "34048"},
    {0x1.5982e576be2d3p+368, chars_format::fixed, 0,
        "8114480333841310431852207106195732624573708335144294291178267067998449502486132131743924808574403664574991"
        "56480"},
    {0x1.e0c0dbb472726p+369, chars_format::fixed, 0,
        "2258139439987612428015336505781481576430206807875363890109017576698987613919603004228509836355729557666733"
        "752320"},
    {0x1.4debd3de5d8eep+370, chars_format::fixed, 0,
        "3136912645074335122364486804207067597209008115968614760745328968164833170677624444463154824550700849672497"
        "397760"},
    {0x1.d1c493d286bdap+371, chars_format::fixed, 0,
        "8751005610037839569078498062403882911460183213677968265282850389208347874248098697335864961077782840591167"
        "520768"},
    {0x1.cd72d6d8a7970p+372, chars_format::fixed, 0,
        "1733970664386912125872693897473560306483505961937588436510286673421890058470855545932258775999383764761746"
        "1321728"},
    {0x1.01627039cb9a4p+373, chars_format::fixed, 0,
        "1934331254218701838453598175217237943737496771352435574889883098268382982283950220943173031097545837069499"
        "1052800"},
    {0x1.a01e0e84d9fcdp+374, chars_format::fixed, 0,
        "6254524509233588212610830596577176659766944453511106755580487048288604005681198831239915598637843698115382"
        "1884416"},
    {0x1.37e20c15e4800p+375, chars_format::fixed, 0,
        "9375622388315127403777672412879065014013388830042759601136502377501286541373592048356259696956137325677691"
        "8499328"},
    {0x1.92565f524e5acp+376, chars_format::fixed, 0,
        "2418960634195268316395495689809143543065258436533233781922790717982079892017737002531449168323857711298954"
        "60536320"},
    {0x1.b27b47d7ee854p+377, chars_format::fixed, 0,
        "5224440098918061370801664236931918267919020204582718655324508727854633555962516699473334315236265293145624"
        "55371776"},
    {0x1.1a868033c3960p+378, chars_format::fixed, 0,
        "6794474678720090780860324238475587283291306410467544848935627504155000240285699245466669806256893372114269"
        "11027200"},
    {0x1.a98ac07f11c9fp+379, chars_format::fixed, 0,
        "2046778382742435131475329556460351029370620189037525051596970511153669678206889113140327658180583658079785"
        "771335680"},
    {0x1.b41b1012636e1p+380, chars_format::fixed, 0,
        "4195175792183929221375982545851813858035036354531575881851302179796683271008989121319242515283719614275851"
        "189747712"},
    {0x1.999b23d856f1ep+381, chars_format::fixed, 0,
        "7880516976947722698439550191495267433356903672490332138766800161609546095955098211605858324954180861896127"
        "374426112"},
    {0x1.305a3f8fdcff6p+382, chars_format::fixed, 0,
        "1171103551432728154956947994964796464091757879395596124696570919141670594706593929522754358987899672236930"
        "8020178944"},
    {0x1.2fd99084e7c85p+383, chars_format::fixed, 0,
        "2338338695923867795487878416772616459210866818291210186069829383612708147973871939101117394698248794781384"
        "7224549376"},
    {0x1.5dec261193077p+384, chars_format::fixed, 0,
        "5385799521445424707984567080296514002385833371920436336634074022526042515878945538534358402227721907605213"
        "3007589376"},
    {0x1.a60cf45de0593p+385, chars_format::fixed, 0,
        "1299190664355894349777676514493340125040798882377073081083767614109492705524812822835944112469544470514561"
        "45233281024"},
    {0x1.206f40c937d33p+386, chars_format::fixed, 0,
        "1775765812386984535762973709984739744765368770153037968730081658466792891896799685313136070777116248291620"
        "63377989632"},
    {0x1.f728c980c890fp+387, chars_format::fixed, 0,
        "6195464634160997608567397112064977934269900151384984023135869099793434721498411944650441148889663785218245"
        "16257087488"},
    {0x1.51e04772f1442p+388, chars_format::fixed, 0,
        "8320622375414998490526200947636548591576611889020858480783546025992168248085458479505569932708677732014340"
        "68744404992"},
    {0x1.0912df6441979p+389, chars_format::fixed, 0,
        "1305554550582523208650674413548860428138330402294494603154556374044385981567373075868022295693702790040894"
        "493689905152"},
    {0x1.857ce22ca5331p+390, chars_format::fixed, 0,
        "3836650434819978138099173880908523539242335231710182630876123447838335232647223635309021017839509241339971"
        "350959226880"},
    {0x1.bc467f73b801fp+391, chars_format::fixed, 0,
        "8752670682427703980486963924525335227103728261943421525466500065475899686463211404336654549717016700389246"
        "819052290048"},
    {0x1.5bfa6323e5cacp+392, chars_format::fixed, 0,
        "1371103427759536945157058907347025668765848614818811279886089945932326262483180610587330682635043434607233"
        "7605128617984"},
    {0x1.82a929b1cf7e9p+393, chars_format::fixed, 0,
        "3047042188071979160224384218657618683166832259466005452103229197857186078753977423920984111729737041395557"
        "2374972661760"},
    {0x1.e182eb353c038p+394, chars_format::fixed, 0,
        "7589006090032981090777813506934998050847755485934492363252721651347512116968716567951239839335895477366321"
        "6863144837120"},
    {0x1.4c41f45ceb5f1p+395, chars_format::fixed, 0,
        "1047329391234229898792724604299179931023116824530959482604334182410534636379573330962109668776108486243319"
        "61409430618112"},
    {0x1.4ce2d62a959bap+396, chars_format::fixed, 0,
        "2098620704538618703579982244064579947907086805961270103883683638080771912066638498186067590507991594924438"
        "99741222207488"},
    {0x1.00a9e2d3e2ec1p+397, chars_format::fixed, 0,
        "3236179661386883652537980615095087002218043250286096069338484678230877725980185831620693744465153385217733"
        "58467766026240"},
    {0x1.3c23db7779f4dp+398, chars_format::fixed, 0,
        "7972193856244526804064977940518293569386570610320672224744772099408870175512300349633667769144281931431455"
        "44747212341248"},
    {0x1.6ad531cf6c4f6p+399, chars_format::fixed, 0,
        "1829931506025344530682223306811607430773233013466737003847562291822667772985002907439024576972932391742019"
        "304962257846272"},
    {0x1.c98a8c0cc02abp+400, chars_format::fixed, 0,
        "4615178541421858608427535142571748466616058402431400157116586682652732762350017641507180191858019795591750"
        "003286534520832"},
    {0x1.2599b4edfd3a2p+401, chars_format::fixed, 0,
        "5923044070696604771732616334920038891861142216152644953252439659806567968691229490833857614766206732681216"
        "489965037289472"},
    {0x1.516e7c40f57a3p+402, chars_format::fixed, 0,
        "1361457289463493935314237753446450714998319678553037909082538558276375972696523741273235641888992343389329"
        "1965665865891840"},
    {0x1.554ae9a6c9824p+403, chars_format::fixed, 0,
        "2754071394910484324330262754279472770629275635858147408834581170878029851593573370011391039087701392669532"
        "7834062687567872"},
    {0x1.9f90524b6d626p+404, chars_format::fixed, 0,
        "6706809109602002050577686360962415983549615927938302295168613079702848036672699210359495237607001832749217"
        "9668721922473984"},
    {0x1.f8c257fe070b8p+405, chars_format::fixed, 0,
        "1629267833580615463068816636091436259012674541563499284744651164979261239615690161190815723817519159242443"
        "92117769349365760"},
    {0x1.5063a56cc31c9p+406, chars_format::fixed, 0,
        "2171602703883232007445315044637402650371728748307807247230177679217019568319384748363585553529475082142819"
        "01658244655349760"},
    {0x1.bb50c0252104cp+407, chars_format::fixed, 0,
        "5723756099896326116405147589905161253505155129585629724986229057913911494779646970912178874582889958310820"
        "88581314451079168"},
    {0x1.0b03b69a2e2b0p+408, chars_format::fixed, 0,
        "6894981730856179454977399200699351382952421263825434670350382928146216714982857029503164685009309440793615"
        "59687185962106880"},
    {0x1.9d8bbd0e57606p+409, chars_format::fixed, 0,
        "2135757459649774324586064399778297415231258353092828891422462165385184090655843737056294676809425852734520"
        "620544272774463488"},
    {0x1.1eafceb2b72f1p+410, chars_format::fixed, 0,
        "2961187277322293084826589494183329859405148034286470192676108441112739159224626669459295069493706626656429"
        "936634490345488384"},
    {0x1.b82d31fcfdc41p+411, chars_format::fixed, 0,
        "9093166616854772671085259933316902762675289165630758054798840586372002897018168748438268762277481698283521"
        "876304509982998528"},
    {0x1.29779ec1c6410p+412, chars_format::fixed, 0,
        "1229015698960275453718867366877057613832971743412023643196250163102555790726222410132492891884972489296110"
        "5935201229760102400"},
    {0x1.8e05bee28280bp+413, chars_format::fixed, 0,
        "3288938903330379644961065400716518295356796477246364769269321501289872171996397168853799928443477130589346"
        "4950312791814701056"},
    {0x1.cd14abd1e732dp+414, chars_format::fixed, 0,
        "7620004493567339864262219508861490396730034227755039046102041308274422419447425700846542223513787194922125"
        "6838888880477306880"},
    {0x1.f2ef51feb4de6p+415, chars_format::fixed, 0,
        "1649119286271774345950461353968056960543958011297083266118687289447733111976663588544385731322405061236194"
        "54700176498963251200"},
    {0x1.413ce3f0889cfp+416, chars_format::fixed, 0,
        "2123562001812472576282352525406745359031883428304103919104057801647664893836115806076980101637483462694271"
        "23500298885388042240"},
    {0x1.80779e1506fc3p+417, chars_format::fixed, 0,
        "5083087486236233448745112973325131705774710931332862654480044921708376763073241202766613658492942259875031"
        "03152602026665312256"},
    {0x1.f4593e67fd929p+418, chars_format::fixed, 0,
        "1323033736481405611984914410448319784704839252810423411622406266681117431920348308595863755130254039143802"
        "571352312329397075968"},
    {0x1.5e1972e7208f0p+419, chars_format::fixed, 0,
        "1851482434708501404103498234936607544635241391027063475792961593090611345556654935908485171605594743656239"
        "041462410004345651200"},
    {0x1.96497bf3d6e91p+420, chars_format::fixed, 0,
        "4297255645889242100707192159028895803971338559378666988081520720039810159447749167245761309264741132760920"
        "631315371878690848768"},
    {0x1.b393f1a1dd519p+421, chars_format::fixed, 0,
        "9214123983353544230749526470476701347062870723863628075041458455922502614934820003680619969053137653170758"
        "109561988952788828160"},
    {0x1.7a530210739cfp+422, chars_format::fixed, 0,
        "1600598424093753155397712357077769847897455502347635013084207171497664728521311793589988812962803594763390"
        "7591684080627204751360"},
    {0x1.e3afa67c26cadp+423, chars_format::fixed, 0,
        "4092718156465024566468401022680098550827493157588909049631574478958824919079525184918827554889609347791335"
        "2511764494291847610368"},
    {0x1.9c6025d074da1p+424, chars_format::fixed, 0,
        "6978645415917667486470063740679674095350598585981813321409810080272375693303149978674913039493630586998768"
        "3275467906968807538688"},
    {0x1.065f9b19a0340p+425, chars_format::fixed, 0,
        "8880309352590179059498223684649858027191485335587402324325827563998301861860081801736437654883429022720020"
        "3210514836291613360128"},
    {0x1.28065949e7553p+426, chars_format::fixed, 0,
        "2003854959702457433859473247861663167756833310526516747728979606354202126480766110129519255313792933991224"
        "33770669620377086328832"},
    {0x1.dbade2e06f07dp+427, chars_format::fixed, 0,
        "6439948347184868699932802270952994310521984742682642596361657347416623542119782895493907710484400942495650"
        "42561286390284027953152"},
    {0x1.67ec7d8c1da11p+428, chars_format::fixed, 0,
        "9745603385424578690730660575093745942192046027152353304115685895989977292131017126112277202152017894440157"
        "03751438749985539096576"},
    {0x1.36a68148c8217p+429, chars_format::fixed, 0,
        "1682287066188509095838534603217685796480060545513558888885974825635003665102457636118829044285076747296724"
        "564008491547307408359424"},
    {0x1.dc66b421571e7p+430, chars_format::fixed, 0,
        "5159777854912000122928945827116304465245126926206087972652025252644964871647187410067802690996029806092759"
        "584457166981263691612160"},
    {0x1.e15c9d78ea3edp+431, chars_format::fixed, 0,
        "1042700947903679763559181336620334898147474113646804750154068255204432600426309066113873074271593564213747"
        "9038773324522255424684032"},
    {0x1.ae724dbf30ac9p+432, chars_format::fixed, 0,
        "1864821815977769417748150360069980614504309430537735078622917784360533485567205024779803878816031745385873"
        "2791008998841995499667456"},
    {0x1.430c116f28682p+433, chars_format::fixed, 0,
        "2799071930288179263470020809214476562706602883320362880904959545252059753768545020523217205576861504948855"
        "2388925979796926720114688"},
    {0x1.b320abff3a613p+434, chars_format::fixed, 0,
        "7540407358942798252149214581448140611354124493751246358199578400762702984088032060250929879092048787838884"
        "4654553206928916206321664"},
    {0x1.18baac522a7acp+435, chars_format::fixed, 0,
        "9729616533270472304570417119172291888449393973617088395124676104067103572505711292487799535537200023307996"
        "1207242515380010313842688"},
    {0x1.4fbbb115a5ca8p+436, chars_format::fixed, 0,
        "2327192970289217603736376862480172183581025603660473458778209701502726441931437480495336959507404143716963"
        "44356185425416667875246080"},
    {0x1.5d9b4105ffe61p+437, chars_format::fixed, 0,
        "4846716195431876557020677208945267951902487885369065798328001026837854178458864809207130091946624378546702"
        "35875578368509717239562240"},
    {0x1.382005bbee766p+438, chars_format::fixed, 0,
        "8654197708736782692147011384996386386958546737598990044532749569816649505721539326066810068414534675805441"
        "58666736089780468257390592"},
    {0x1.c059a164fbd82p+439, chars_format::fixed, 0,
        "2486253574248309139019190958645794670602442405535326377843846617565779445181345847239819375592637266262345"
        "183038540336851637686501376"},
    {0x1.979cf64e101fdp+440, chars_format::fixed, 0,
        "4520706326672799065936892964499821241321414973892041429149405822266443181534229880251214464630186822608598"
        "050594119641896654588608512"},
    {0x1.83251647fd9bfp+441, chars_format::fixed, 0,
        "8587398813646014313498373382639609467752907323052773992789373868056394750880784700092369195591424184346777"
        "023720872944875812390174720"},
    {0x1.955ba92aaabeep+442, chars_format::fixed, 0,
        "1798278368931096142222750131079175510458587196459837877316863923206918321102064028659266499971075439621763"
        "4910130253608134690434187264"},
    {0x1.8bb4dd0dfbad4p+443, chars_format::fixed, 0,
        "3510922927497369934786449067775999722388108766381702391354561276314694730648943789975155980344813142572626"
        "0143262853014497255579713536"},
    {0x1.f2ffa36c6b9eep+444, chars_format::fixed, 0,
        "8854772868346543081884861642413599775854015649396963765701944773200152753763141152896936319959895472749176"
        "6342717137006267941580177408"},
    {0x1.632ab9a3bbcbap+445, chars_format::fixed, 0,
        "1260493422715540281381879048109037109089648025900867074500376421044953131588905720338440064105352720966599"
        "73119538989418847848208793600"},
    {0x1.7d9bd6980a8cfp+446, chars_format::fixed, 0,
        "2708671992994250418398087494151796097713969623989579473281302487040823853967100300115519498762952432972348"
        "69643886677394157405489594368"},
    {0x1.a0ffc9a223266p+447, chars_format::fixed, 0,
        "5919748927113358584497548577785785622444408238661178056481236239642105233604233073908017593353418287904776"
        "76111442443375110521989627904"},
    {0x1.2f2d555f5fce4p+448, chars_format::fixed, 0,
        "8607845504713467860443481861845557158816229480521445772939116212383850781617004168771192161082373845996311"
        "64804764816415732192769998848"},
    {0x1.a65f9697c0d52p+449, chars_format::fixed, 0,
        "2398416696381307213030425486681554471977877905811241459414850746590388262421129199754985504543718795097719"
        "717531387216891723088847175680"},
    {0x1.1e2be5c1a5196p+450, chars_format::fixed, 0,
        "3250007960862917778646959436106261588596497868644218319552582445607073449461147239873581615651891772642481"
        "239481297672424409886179196928"},
    {0x1.47b6e3f5377a9p+451, chars_format::fixed, 0,
        "7443610248681702639133038491090496037720936627920146034222488686717712668090730441114098755897550999531316"
        "963156312332013839122343919616"},
    {0x1.aad9cc8c1c972p+452, chars_format::fixed, 0,
        "1939072965661521519650681200061745147977671151244914278784845930334126060919102833109367328343544061792595"
        "8437747265492354517993099624448"},
    {0x1.8cc0ea5310fdep+453, chars_format::fixed, 0,
        "3604698283522465641291575497692050182403054427234986326616462122334470132905824957460303056026474511799313"
        "7684398776063481336351546146816"},
    {0x1.e8e380e2826ccp+454, chars_format::fixed, 0,
        "8883580710031505936495757285305375888511826205311995823147371443859957282195109866977037424844826203876940"
        "1918432797048903756272554213376"},
    {0x1.2033b9d066e11p+455, chars_format::fixed, 0,
        "1047382066517004887875515440857871933032526992118894922460416678442332126944080997079388354371913743391220"
        "09603229883686875857626060554240"},
    {0x1.7564b97a79d61p+456, chars_format::fixed, 0,
        "2713968226205329724198839272443779204420828521124700044786578904741141482697647869109259519421773680942058"
        "28453389512306293635710562861056"},
    {0x1.2b82c2280c26fp+457, chars_format::fixed, 0,
        "4353920593614510470582072622828484344506092106572839403272182983522103949524464205352878226077641587001129"
        "20667363070863633573415250558976"},
    {0x1.bf1f7396a6e57p+458, chars_format::fixed, 0,
        "1299944829366616991485980598548860151230651968759817944646322876723765795715004216987647604565446053438109"
        "738523479554490524610468784373760"},
    {0x1.a657699d2c0dfp+459, chars_format::fixed, 0,
        "2455792996647105319987264946698174035669223140410363354394221901033041745005367433246369672312355030457831"
        "875446589644026555749761133051904"},
    {0x1.288594faed777p+460, chars_format::fixed, 0,
        "3448376481821884742599997031703064023879309720647762419738450097130822453852343817969276956489783419047227"
        "298470342228861543277801557196800"},
    {0x1.2375adab19290p+461, chars_format::fixed, 0,
        "6779013852180731642062803877328743866864466400459437016702545211778164705716580098240222579585037005161048"
        "665824473078182953740522326327296"},
    {0x1.83324c05e70f4p+462, chars_format::fixed, 0,
        "1801148096883475019636536919296742071541586298507160412177605739972045947153374096003240644881783751921622"
        "6379536264641695755986389226749952"},
    {0x1.97873666d985cp+463, chars_format::fixed, 0,
        "3791452902390206955710500442840086836755207186104228602225717818522441363532172058874581012257504841425551"
        "7018518297768531087665402960936960"},
    {0x1.5bfa9fa8f352fp+464, chars_format::fixed, 0,
        "6474870054646572123288894968827209553499800984017510519629220257247365090779349079369962488899365434134790"
        "1931540117631355075040339017334784"},
    {0x1.b42b6a79cf7afp+465, chars_format::fixed, 0,
        "1623167748474864773828424688913270302178709053686288141707027608624181277656422760878504097983468045273062"
        "76739512993900734621330821705891840"},
    {0x1.da02be394de37p+466, chars_format::fixed, 0,
        "3527980476981337987773962526579022198834297486895530721521967825754560658125868500395457050798650594544364"
        "49176466265315274091295259079213056"},
    {0x1.3eeed2ed5a952p+467, chars_format::fixed, 0,
        "4747525868091625374589753173451404493876080871121742834882965854600562461662497927915612971112492170124392"
        "30326495036221766234765211123843072"},
    {0x1.3666a3d10b839p+468, chars_format::fixed, 0,
        "9241043811243548973437968577443506942126123215765079382499053019235772992464791613721718056244982972392322"
        "68381394165934174203311772747694080"},
    {0x1.2570fb22b2de6p+469, chars_format::fixed, 0,
        "1747226815890356797048937639487427006091339387805682507872537441725533023977464453765330869945960255161837"
        "902768182371165254880871258817298432"},
    {0x1.b07e20dfa1d42p+470, chars_format::fixed, 0,
        "5150350285544563391812484307981437266024721816515492278648187712670078428969897604590305016815911078869385"
        "475223702592482681568973998545436672"},
    {0x1.c0fecaa34903bp+471, chars_format::fixed, 0,
        "1069374361345412834422973850765955406904111310411630553855176363664113300074916419053549457280270184284477"
        "5713873914174897214881753809553457152"},
    {0x1.6a93c2fdb14e2p+472, chars_format::fixed, 0,
        "1727103927590087870232006461316111421173476006202037902235061715895198996726977765096839369534642467691936"
        "0350528737280818370651311134702829568"},
    {0x1.ed356c6ec0f02p+473, chars_format::fixed, 0,
        "4698710632023436530935786534852661707629543086484094036770090925468610387543334690177440820673497567004141"
        "6172724241468670572852355997846470656"},
    {0x1.fa2a9a922005bp+474, chars_format::fixed, 0,
        "9644313300615437562954467377321799557173735190605188996537216951703287357068462671044572325619359963134707"
        "4349343808996878649261861384554020864"},
    {0x1.7779f5e06053dp+475, chars_format::fixed, 0,
        "1430838540572183040958898684234122121763075160751964220576820347672694960847168624017385087570938384997742"
        "04490512832595931739164387055612461056"},
    {0x1.2ae00f64ca014p+476, chars_format::fixed, 0,
        "2277864578225410212402417046529252532595308641192361449872591767217736129023733728821577739245924409722402"
        "57516688035006692022253572705950367744"},
    {0x1.14617f48912ccp+477, chars_format::fixed, 0,
        "4212849184362801569012349144749918377557914068975855440238329095456615077937044063548270484212352853989881"
        "46300675184394950248081186488630378496"},
    {0x1.0e36f018afe63p+478, chars_format::fixed, 0,
        "8237715226546192746890447503120997923455595181879649723647619197005184957111250965472231223461180995981164"
        "14799396399785995085176935884420808704"},
    {0x1.b52a83911a3c4p+479, chars_format::fixed, 0,
        "2665473721535922617453686564760605460217249995998770698831673228524989243942728182577687690040115887181965"
        "731696893395851534226381642953140469760"},
    {0x1.ed98b659547bdp+480, chars_format::fixed, 0,
        "6019079138812161786404322771424209890074870865812828805359552352323665383150698386003738456164231488395169"
        "844387225601064643184790911958453846016"},
    {0x1.fcce356c4ec85p+481, chars_format::fixed, 0,
        "1240908469029254165252761304543777501804893547322477854855421458145658884001133973362920340485889792403751"
        "7041939851403445857567862463857852153856"},
    {0x1.3dc01483d63ddp+482, chars_format::fixed, 0,
        "1549900904806158881464152699552360093970738879528261717476769716034424926686904372943175161706160101858976"
        "1944702337982434466462060034234811154432"},
    {0x1.4557a7b0057d8p+483, chars_format::fixed, 0,
        "3173866166356781626428551682280197297172815165120646996350638069618889027783736539668210630975874228200635"
        "3922475242220366972514288404986230472704"},
    {0x1.669d69cbaf0ddp+484, chars_format::fixed, 0,
        "6996909564666351480656445883823347269335803932073664184743953878251805093112232960317695851202157645208611"
        "6368782676471010501175026121646448574464"},
    {0x1.6a4308943f906p+485, chars_format::fixed, 0,
        "1413613005000349527596558070519024536027300340645688986079557743371441028796468956524778334197919542401370"
        "13541670491478732029287175906702745665536"},
    {0x1.7e7001ab289dap+486, chars_format::fixed, 0,
        "2984684476732969973080482346008839779751088774198073117054414068625023704835748482292748918191379061402125"
        "47533066937938143958203611335491240067072"},
    {0x1.44fa24aa8c90fp+487, chars_format::fixed, 0,
        "5072484297164672655753850075984225346401905228983528238839567946741940798379964728683087188822779499088842"
        "45889023882897106195080463734761662185472"},
    {0x1.25d657eccb0e9p+488, chars_format::fixed, 0,
        "9172861001485727556863079465865253123173810000291904525320024949451214146915356704665580883376317239026339"
        "49642595917883820840553955755394812870656"},
    {0x1.fdc48127436c0p+489, chars_format::fixed, 0,
        "3182732505899356703333123375269121290337735260803631099135633282182290195491466337751897766996078264788587"
        "642034976623676783849309720668272859283456"},
    {0x1.50cc21e5e879dp+490, chars_format::fixed, 0,
        "4205587083947036897361115167889316607808963711580165158947458467902039543371629868331531359330796414315624"
        "528062235406626283210983955984299738529792"},
    {0x1.5a4e10fb478ccp+491, chars_format::fixed, 0,
        "8648615720577232960260010237860665878489921627977706971167413716473182293562488282429974320988334381296634"
        "069075898792649120978628662820343688200192"},
    {0x1.e6b342df1851fp+492, chars_format::fixed, 0,
        "2430969225495933253645053867907956025352941506654104238038342052727418957827445358505456938458399248773145"
        "5483906898199659271966077737111144370274304"},
    {0x1.bf189fba46a51p+493, chars_format::fixed, 0,
        "4466309998082111170073506282370706108196457943209416122250434976487611411198060243493917472961323197528069"
        "7191542952742623676348156107248907356995584"},
    {0x1.7744c67ce2733p+494, chars_format::fixed, 0,
        "7497564003947888936804623213880607410569882473110233428100677524964392839094983634660845809216505266606930"
        "3519645320456702179748989546565091612164096"},
    {0x1.dc39acc6db7a8p+495, chars_format::fixed, 0,
        "1902919189559358251304225442961393389251981946644000818136247545166144987405523096628331483536251762254461"
        "84345874717099016754240440378652340420345856"},
    {0x1.db93ed9dfa8dcp+496, chars_format::fixed, 0,
        "3800664183367710249288782490611872596137966173896218961044788164668898811254379468178194199678384504219632"
        "36989721829537772787957124251662568730394624"},
    {0x1.b0906aca51c5dp+497, chars_format::fixed, 0,
        "6913824994082101377604034173352491535191266177664483054837067552426279897762927143757444035702927195098300"
        "91288971999328682925119460651701964793446400"},
    {0x1.108f1f5365715p+498, chars_format::fixed, 0,
        "8712815483801715739257252286091866880067213418600853446340019791507392408796585979762097162000700841120209"
        "22177725097537079407027753889855794306875392"},
    {0x1.73f5a2326daefp+499, chars_format::fixed, 0,
        "2378063972746060671897133818731680998752821318138463059978993349603226525259879320538960465423866875653875"
        "431703645955198350097511963193717040609230848"},
    {0x1.5d60e9bc96714p+500, chars_format::fixed, 0,
        "4467392649638728970803009590025830597303866011670781488243987805549781170269232221346075088554896404581063"
        "190784109692968975073166801707596473568329728"},
    {0x1.3b69dd2b0a7b8p+501, chars_format::fixed, 0,
        "8066185078159116167712295472117206859173225720179896603658517103726174861169657859726094564340370120252442"
        "441673563796215351159644731012365795563929600"},
    {0x1.70986ba3519c3p+502, chars_format::fixed, 0,
        "1885244836996482542892823600943986116713564594995534344272830669658301681623735404806000618410629544582208"
        "7646981385967186957895722281604432060701736960"},
    {0x1.5c9ead10d3adep+503, chars_format::fixed, 0,
        "3566152723739795234467018637155560524159413361159391842517155401062532273143246648879880582906919677326033"
        "9528369728020651143141594374865566386412847104"},
    {0x1.2199c7c3b4ea1p+504, chars_format::fixed, 0,
        "5924851411681644640503417927190379494222823593778565459127443443668591444400551269545237672213501034354348"
        "0884465555148433997142511793829160779635490816"},
    {0x1.7012b5d2cf305p+505, chars_format::fixed, 0,
        "1506058732121946655301287035109368639724991640175947243409282754446485613331818703580697336292409066290374"
        "91671355128894869419427983062506453820908765184"},
    {0x1.5d488913a6d62p+506, chars_format::fixed, 0,
        "2858352024928191633886631432755921098706556519067353362046901478558781313878813883999231511122842403911018"
        "78885418173061097660244197201776411569329012736"},
    {0x1.151c3720960e0p+507, chars_format::fixed, 0,
        "4535449894907774216903444340621604929977002891827276445632867693279801638271688849603199225842871662382499"
        "92218941837638686010641196013298349788803104768"},
    {0x1.3557fa79ed04ap+508, chars_format::fixed, 0,
        "1012602649962377004457699442379863701200241750146498587811776078299649301264839681749775832225005049204134"
        "901434458455631896130313812311189422436650057728"},
    {0x1.34632efda2f08p+509, chars_format::fixed, 0,
        "2018945071699849221312114766647416600939271104509438172852900806111729366941794283528300927782339248654747"
        "013008590709252183660814342129605380010212851712"},
    {0x1.d18dd31d25525p+510, chars_format::fixed, 0,
        "6095760398208723298290951312121146581559974158820441582039629822285159626651555080140482022426506592227887"
        "431158650579821218458724165898660363966842142720"},
    {0x1.9deef9f325dcdp+511, chars_format::fixed, 0,
        "1083972828702817904110477939440299843114904486633296890600374236556171888340430592781362784246092831970240"
        "3984206679307763828828827451150213226478513946624"},
    {0x1.80ef70407b9d2p+512, chars_format::fixed, 0,
        "2016069787519307328105835041424551032020164488279653199409142566727146565023499640467691810358820470380298"
        "0632898021029981572024314647222500081978631520256"},
    {0x1.b15f90e524369p+513, chars_format::fixed, 0,
        "4539520336739885202903530520810936804269492388269902813984327324977051420435023147430028294370432243418817"
        "3617390582015018290214912507195023522743860592640"},
    {0x1.7d04016826a78p+514, chars_format::fixed, 0,
        "7982163447075078500581630705245379670915140040243916863725922660021993611757550398339375577457747355423547"
        "5350529315775591347087019497446187187442089459712"},
    {0x1.09207e9aeb4cep+515, chars_format::fixed, 0,
        "1110865930994822323207372198105848601563976392119606356275524650260339658645638045517835592013731934565135"
        "31979239601685059643816826533951965329199816769536"},
    {0x1.5eb84ec7e3693p+516, chars_format::fixed, 0,
        "2938991096845654049714530881766572299372468632666686578038784692824308992083021347310144229689848355329552"
        "08915016266000487049786013109396266423674162118656"},
    {0x1.cd831a4414f7bp+517, chars_format::fixed, 0,
        "7734832320107849406975915415314845221690643354561217179632760627826757853193585968251996352889799583975116"
        "47543570671668790057093880969098511595082212179968"},
    {0x1.3c41b73edbcf8p+518, chars_format::fixed, 0,
        "1060077280433434182449867323875464300059011229631163811669364109849227173188103395063538656771476964158203"
        "812970364575007765811558050041484967816046261043200"},
    {0x1.7de6915655786p+519, chars_format::fixed, 0,
        "2560225316421401979422803492998633063406956866791362756726796134688568349944844143386491471677961456075665"
        "903377049407345319868363294328606411349469066952704"},
    {0x1.e47a65469d029p+520, chars_format::fixed, 0,
        "6495789416268922401553168716966856796994063997872865919646022617543716396397164326215179203658207493313865"
        "250447186614103438727429420216590467896398839808000"},
    {0x1.866eb1b2a52cdp+521, chars_format::fixed, 0,
        "1046968522959716567924247286778170756423223211506659389759754782355273358650062373117565585265466103667594"
        "4667470248283335770956666084386262948697191024164864"},
    {0x1.508c027c49129p+522, chars_format::fixed, 0,
        "1804942547168450381169233647180574434039267609096655991415816782969324893685745177245502281954665102041939"
        "5086693907597563666097234994451590506212471517216768"},
    {0x1.61ee1b28cecdep+523, chars_format::fixed, 0,
        "3796341461730841578780959690416055511432134825264742076212103463147953812002640039488541870094600932014886"
        "9300117380342424037408264379528162055292585638887424"},
    {0x1.a7da0d015e36cp+524, chars_format::fixed, 0,
        "9092676802446734182033317648157748339291866285256612138324008080153551839181017108363268562797239004416443"
        "0686884665469961819946851131278768884750528251166720"},
    {0x1.f343d287ffc8dp+525, chars_format::fixed, 0,
        "2142095457187479618186780355817389739087362820361209981629963953818884718187142470744282955503944630514476"
        "51015663758672875883679550666916401541316002057289728"},
    {0x1.9c9c3a3327bfep+526, chars_format::fixed, 0,
        "3540607460490399649379648607162695350285243859533520233883922296148930609534314973215695090528711232136078"
        "08354960582121162245411977647195367953750953520267264"},
    {0x1.610edb058ff32p+527, chars_format::fixed, 0,
        "6059179837113681950743099036006662055373279197285707406415028557873237442313731316660613237670511973318738"
        "95394455715612868333780052349810329711384825746685952"},
    {0x1.f30c74ca208cap+528, chars_format::fixed, 0,
        "1712934026663283474995357785834399393951624952986783508184917269255378176824789737438473421087542152442662"
        "795936288492656745381512223241233513801086791472644096"},
    {0x1.1c138fed7032dp+529, chars_format::fixed, 0,
        "1950127108367380265978789840612705413832446328076573867485880615095436437393072425261010441833325963717934"
        "862664034468096428283397061878573723884854136941838336"},
    {0x1.78c95f77c873ep+530, chars_format::fixed, 0,
        "5173127718232939980745023901479711875074678603456290138612335116072095562130741558337106215138151055677886"
        "848632459023665184850001400687968418400453658547322880"},
    {0x1.6459f93baec50p+531, chars_format::fixed, 0,
        "9785122654459946377156492136855692182754204044558544765901824636932439040204770643127601540321477379216964"
        "153369345749073097713940190208348710065187772895854592"},
    {0x1.7906aa9a30611p+532, chars_format::fixed, 0,
        "2070565985519521146028617020903893764173127242228915282585821249629480716329796518060418640315424317976790"
        "7958537137222057332190533942595916677783931001302417408"},
    {0x1.fa515f09e2725p+533, chars_format::fixed, 0,
        "5561231417700302612291035723276700921862313641901478942608981704822095236478468533450021103273631092111317"
        "2928546161625907053067205424290791219411580020307525632"},
    {0x1.54d8573fb9596p+534, chars_format::fixed, 0,
        "7487464053324147073027985156251864960201268556410853848339298317867059869862354923570380271660107398895386"
        "0606902557706179876262726589838088595804228576518078464"},
    {0x1.87e0d2f66b2bfp+535, chars_format::fixed, 0,
        "1721705395889040085230484290177093700112635956558847354390801559210296136488400633064531368996046204338082"
        "51320307524080356734627614383764502179134363483408171008"},
    {0x1.60fc1327a06edp+536, chars_format::fixed, 0,
        "3101655447037900802206864434665525751926566828861379496861490211946029427633689466104445558270823162523042"
        "68825795213378323348966049009545989957974376346959216640"},
    {0x1.992c8531ab31fp+537, chars_format::fixed, 0,
        "7190773969829954854476175955344126385509454725611500646868974906575026924567060298765274709735419930980006"
        "46708518252563177681082336014920325874693801095389511680"},
    {0x1.cddee01e85f4ap+538, chars_format::fixed, 0,
        "1623371911267483481925060254083224874793319516602544418050392885957058564653246713426343598398954248921447"
        "620240933830255782920769862417050715330898449264684302336"},
    {0x1.99388c768c3b8p+539, chars_format::fixed, 0,
        "2876639877916821718682171274884552699886270156870449470065976716669949296867873810397188727080135624623289"
        "844646359504438367801675052210339168690365297101300039680"},
    {0x1.6c2ad6bba6ed8p+540, chars_format::fixed, 0,
        "5119867078891216752868300961559184243391774358043130873214522170176541422335876910061550665577816751144687"
        "884279178798057513594382918680535607030620295902798020608"},
    {0x1.8121da546cf38p+541, chars_format::fixed, 0,
        "1082922960564749728749181147172534066701998238229528744199876607002722024796828928873682969768759332687491"
        "6164752948106530119043799024142733614166064793545183592448"},
    {0x1.cc5c0ae184fdep+542, chars_format::fixed, 0,
        "2588897361986241005529795338682328544797589617536924774421046652734108621468962075520384347322252943006850"
        "6678735966744366849758761825149394672284437121408260112384"},
    {0x1.afe092d15aefbp+543, chars_format::fixed, 0,
        "4857446184407045659245281466971101032273355703136282585341361993811637469258567653006024918127832386005581"
        "7101089476270147525185193144865210540198232007480243650560"},
    {0x1.5f1a1433b9174p+544, chars_format::fixed, 0,
        "7897885248231480976572569148942549464110847839825749737884750938765890487107457976553278218726644590993528"
        "8393542325707257672246926784385310159883948368526709882880"},
    {0x1.8ab67f98bb5f2p+545, chars_format::fixed, 0,
        "1775779240824860821984065029088456210333160939606438319025292868447492342699690750546360447139157960257192"
        "83383611834930550575178173514581572666518402542001715150848"},
    {0x1.f62458acb73c6p+546, chars_format::fixed, 0,
        "4518186943899558415594287998616160732723580088808462627420793528636818628997768184974309329576692162223176"
        "68812532970018869401576788745672335158605915636428814942208"},
    {0x1.4fe1a6ba1c0e3p+547, chars_format::fixed, 0,
        "6044406760379019868077037578408273873990355824829759644956313772837374257794918228456495998047454720738464"
        "53804398133039311346050607936591463621343012361379329867776"},
    {0x1.063123904b927p+548, chars_format::fixed, 0,
        "9436631806093061427504203624500918508929173467950768498563951691995406365724812023159411207645424547667477"
        "29956337135685250388333452322276527666526976611670460203008"},
    {0x1.c3e4c9bc47a76p+549, chars_format::fixed, 0,
        "3252849304270332114141330920099667655586309723577617203784379378032680392500513565776995824888509641060398"
        "758716325831107713950320367933304627208668064052102524043264"},
    {0x1.594ccd81bd096p+550, chars_format::fixed, 0,
        "4971119941681659246429900277695016189863900011324524097738682426150509372935284398658270040527707830632488"
        "868641461825918412782352354477687969196944687248446058397696"},
    {0x1.0c6555b87dfb8p+551, chars_format::fixed, 0,
        "7727934358856249540712628004988530049108022935118936582350134536455368772614055294662838998154536874398727"
        "685060343548384620139502630275174727089552646218700654903296"},
    {0x1.b1efe87fe7322p+552, chars_format::fixed, 0,
        "2498874613076679837682780019982381395325675770876787651723828199748718199155198556530355267680902179245809"
        "2123757308008963935169221303180214415444334488294696842952704"},
    {0x1.674a2eb4f0902p+553, chars_format::fixed, 0,
        "4138019138142108089524058702370011058866958085656593606829430376209068415463061793950055250788145237903012"
        "2575643692667026093292813010368028679921072693955370544005120"},
    {0x1.4d10ab628902cp+554, chars_format::fixed, 0,
        "7671967953519935527988835422723451725742864531269712353438836332441022123915831674052826962836486534105217"
        "3890153833114361977767211690942890884469581914980429066141696"},
    {0x1.348910101b05bp+555, chars_format::fixed, 0,
        "1421387953398881298880148949989246131415966016590209275959301216019884063155091433154061854986924572094303"
        "85915732641654474120803055851072564038321516443810452985610240"},
    {0x1.f9213f77afaa5p+556, chars_format::fixed, 0,
        "4654153239076367382507751909873960041617365750592820377780564748261536571017284247911250926211719639526121"
        "54921251227290320071201201332495977153680975614053869829488640"},
    {0x1.39148decde7a0p+557, chars_format::fixed, 0,
        "5769302991727879083534369344622854115108324627932898949190215146826105443397486515578648274397540068588579"
        "68022384319234650521865502886831850045752670251564620807405568"},
    {0x1.dbecf9a36abebp+558, chars_format::fixed, 0,
        "1754028954197855453667927844908089896111067495596717096095862590203926162827983922996020492251206894850008"
        "881110629079605516679136092848462020350119138244956800543621120"},
    {0x1.d4b8e3838c0c9p+559, chars_format::fixed, 0,
        "3454961038953493961416329266507926190098571820556925301139707205531339797053249053274907174887330950161588"
        "768433100280033360041954344387894356034343704057173414445580288"},
    {0x1.0a21e645d2c72p+560, chars_format::fixed, 0,
        "3923334972089951622565300641907308211115105939015666440336500180781584271475526051495013014994682723202516"
        "176590662854806987645471308169316788500685330937565504795049984"},
    {0x1.af01dfd28918fp+561, chars_format::fixed, 0,
        "1270785497029221059358757388587580343725199627810931207192376637355335173867515445571721127388807720391413"
        "2749180314815054893523728069064065041255302851675835296773046272"},
    {0x1.92f36b46cac74p+562, chars_format::fixed, 0,
        "2376127169235011089198021521294622742280859027700317730068935393573426739498506711549038426666364463532190"
        "5607600207437156411377406544504086631781775691133562731288854528"},
    {0x1.bfe04dfec51e0p+563, chars_format::fixed, 0,
        "5282087226424358235534033223248192160927276354617411186625887374972589898961096536046003769963641126001271"
        "8784674393928472275175596068580609021329456130597064239797501952"},
    {0x1.94670a2ba70e6p+564, chars_format::fixed, 0,
        "9538748971891788210294826959447321562285701368048121126900779431593940381208373712228668831047181893306861"
        "2563309998840782226852329612567449648252694634073100841335652352"},
    {0x1.bf6363fec4e21p+565, chars_format::fixed, 0,
        "2110533030324335695114644743880526517325317990927054481372423252496835520201472625558431700825477706902190"
        "86744514884262890299095847660667744123821425839198582550323789824"},
    {0x1.130ebe426a4a0p+566, chars_format::fixed, 0,
        "2595142529235476807803390558661695672500621537095263774513524541786122460498753198121422520070124017510893"
        "08402019833593780464399940409144513916301021676563350656888340480"},
    {0x1.4846fccf0db5fp+567, chars_format::fixed, 0,
        "6194530882320718305868353746876073825832971695709799346530285196479882855956178146629021151145597515239212"
        "61814494546071943712322858477374811036408749349113740468449968128"},
    {0x1.cce40bc89d5a7p+568, chars_format::fixed, 0,
        "1739384579276981315759148533472828942133919101747611403307763949041755917155463866885761903090731725408142"
        "081878718092529513244534671322128694195746568199203839343494955008"},
    {0x1.4cbb8d52adc91p+569, chars_format::fixed, 0,
        "2511440849787250488984960823661023170015960694172379166961908852483508502473802800840227243962307657672948"
        "104995738811198515357386384926071278483707177078191869448614313984"},
    {0x1.cd56ecd7c5ed1p+570, chars_format::fixed, 0,
        "6964312528803397312815501717085672958841099480084848887578166052741502930919084645175071070482730543501969"
        "067430731268878668278955626743849683963257233143847666633043607552"},
    {0x1.974548f633393p+571, chars_format::fixed, 0,
        "1229619287434227939803550366058587498426821564041569261418575489361230644061872194638787745903436688341360"
        "9369181520067792869295968147404310797964224428121711225529989857280"},
    {0x1.785df63f7e7e1p+572, chars_format::fixed, 0,
        "2272632099172039380608214248568621755833020263807784815055087523001108297661296988698182950893022720120741"
        "7730127845908876453052097589780463041422857268424951597133270614016"},
    {0x1.fa98d2372e253p+573, chars_format::fixed, 0,
        "6118009224455289447910813350384693683637135923396090328815184313947469439908628988159696066060199969027417"
        "0051304615631465749824618705719721448275602824998439000878232895488"},
    {0x1.44f76f3ef0c7ap+574, chars_format::fixed, 0,
        "7849033701858733657333338224128967925188228188034754443320631773380593836151809534076527696243184197506404"
        "7569375644124507699361497786620173012597660819648747164399097085952"},
    {0x1.845aee96c611dp+575, chars_format::fixed, 0,
        "1876016568195346041307282911895873269227056466128613116705598354597979107703442092519735290845838762519764"
        "12473853052506364697656419609232890365789316383760219161065634660352"},
    {0x1.6abc94e260cffp+576, chars_format::fixed, 0,
        "3504523456271905044456328981793031211960672504956564247152194223246017794606940815368454050419459725899057"
        "31168807151668054670532129843180363278721230005822552578189869187072"},
    {0x1.77e7f7ab33101p+577, chars_format::fixed, 0,
        "7263516584915378549456374754019148312952164487273374523757947663309932008898383542324381521377534959347339"
        "36104514254970171070110867729784675843986648873395065583346126946304"},
    {0x1.ec2c8c72e6720p+578, chars_format::fixed, 0,
        "1902024960720674749038357856571117617159007367233488763764304962629532853766003841254145827765451340202248"
        "656704594513309856716357813392938070159279476826318762074068165328896"},
    {0x1.ffa5d013ee4f4p+579, chars_format::fixed, 0,
        "3954563518862104166845868151963509202256503857762504705099964158993333535956221899163073808878713121193560"
        "993015277645286678140294132386511219265217225137785123722280327708672"},
    {0x1.0e5c252b8b844p+580, chars_format::fixed, 0,
        "4179264564957456691890915787876071213030222891346247026060219448541493116407958328849777616319472384674792"
        "667771126097789471772132138304456722148757124945602576369254706184192"},
    {0x1.b285d8728f853p+581, chars_format::fixed, 0,
        "1343383837208860839275954186578316568515086448937253404985304962119681977311432677737360729858283175807327"
        "3139400905288866876199471807470183600176123459886516500946100328333312"},
    {0x1.830d570659ed5p+582, chars_format::fixed, 0,
        "2393243838635075239890606048013413118442674938278013875033863115012797924647747394912560603984121018844185"
        "8566259800113585445368689288040865119179350881451516413561225814736896"},
    {0x1.5b7cf521730bap+583, chars_format::fixed, 0,
        "4297218754414362476458685406454566259504125701200572410097020758545576989569800779521715384386228436874078"
        "8374177134573090336400694437095719918344517831582150115611945321103360"},
    {0x1.5f8ba5e3fe8cdp+584, chars_format::fixed, 0,
        "8694788966088642431551733491737923768147338900455502528714742557618068865137761911350308021080809708024830"
        "3065713994383176911387666854498724374888010555657160403443732556283904"},
    {0x1.3c656382359c3p+585, chars_format::fixed, 0,
        "1565087239595795330934751186537463572020863629652884408657506889375456678915794287957461217526054518782303"
        "36009199988423048858224043380759941961868932909470130132231537427480576"},
    {0x1.0cf69f601cbcbp+586, chars_format::fixed, 0,
        "2660912725174955503734445132971699373273287252301595838621179120991141885609266880422595257944145394659821"
        "61018353954777170666779903498891261251335885914232419435941537077264384"},
    {0x1.712601f59010fp+587, chars_format::fixed, 0,
        "7304131091528227731828312715634128626367832710671257456567167856205625711803589283602777730033690938295994"
        "39489279348564634343854478223995096490083834564122961187316938125082624"},
    {0x1.d9cb25c6870d5p+588, chars_format::fixed, 0,
        "1874936763830119511088272644435099293590064609044781767075844089889019757217295841065279840107191149534805"
        "711539366541500871745028252870081743197260064203842403729644908114345984"},
    {0x1.3f0bce2a16035p+589, chars_format::fixed, 0,
        "2525113715353648212566127731316531176076410374319204644551422849547789865636458756542087902666897521096233"
        "621580712956165193248559493345236489976046311451102680851980278768336896"},
    {0x1.4e046f64ace9fp+590, chars_format::fixed, 0,
        "5287208897505957815290500832701101436902153212758737317151324637067933559773024823268717155802178796499285"
        "469008136051884913289117970821444349734733325693898128129470005715664896"},
    {0x1.81c96c18da3b8p+591, chars_format::fixed, 0,
        "1221335110809534390008730330642654428571831649641697488678924465058412297932751547521957833726239537659335"
        "3901364495415734234777395486829707907374874417711021037161711853711130624"},
    {0x1.4d6f7e4292164p+592, chars_format::fixed, 0,
        "2111199772350984424078474304802331723537273011414249046667007794843906302772854287028348243792549228029403"
        "8014573739362326768950393557886221693829978829496324438880160656306208768"},
    {0x1.8c09c58dce2d5p+593, chars_format::fixed, 0,
        "5015156723398376688851854823300132149131573532544219395842307346143156886967502714035629323131767733754309"
        "6676819898009801602967325844127445604533459507481195933684935651668000768"},
    {0x1.35c34702001c9p+594, chars_format::fixed, 0,
        "7845248843802527862130310181565492504090475974055418073866337795403937821966496554816098802133004458154408"
        "6790884596615125296396497742047656667223884572601517271224748933535236096"},
    {0x1.29c65d36b40dep+595, chars_format::fixed, 0,
        "1508326924899240484807552920022043764387734351669090850005123902047388054400367006990834771993864001929354"
        "79514139200504582847173176153264857561337534047601980885310892466243633152"},
    {0x1.f096b560fea30p+596, chars_format::fixed, 0,
        "5030767976647529790064331000378597835371837602093398599444274006283104679786516943952146567331123886883869"
        "36471483606502720156765698268474401719617647826060798815782857201376296960"},
    {0x1.2ebc1ebd45cb7p+597, chars_format::fixed, 0,
        "6133803460001548253354885670013712055949309064595983732574734284700889696143012218271572983257819531370501"
        "34105978358652455249997921465483648671250142659113169108289945909053095936"},
    {0x1.bb1e534cd7220p+598, chars_format::fixed, 0,
        "1795631779932945645555691631836738572066334162075671104303499810331329716359776792806247250058684612113955"
        "614358367020579719652520207053724496150314508797330293943336699424736804864"},
    {0x1.5a25ad40029b8p+599, chars_format::fixed, 0,
        "2805357599815182909589240522552000727461710491417322927673538624867192724211245350712114196927545716327289"
        "356897590584828984871288054571880759699213224815050910018022191678672076800"},
    {0x1.920574253404cp+600, chars_format::fixed, 0,
        "6516381475942178867787353079663494921228558365294741624560836268083158617627742153482261039838305294655484"
        "394073977159925482307630138907365278448422568005135582757883527066002915328"},
    {0x1.4b2834aafe474p+601, chars_format::fixed, 0,
        "1073547929579207822146146257824192599715982860748705307246504619358397447410866184277944300935443663486800"
        "4476810418060601519121547906362418385449487160625577520457386019933969711104"},
    {0x1.1a6d55bf92261p+602, chars_format::fixed, 0,
        "1831149383814210354275261703611810370718850345053913553803807148059546706723549001290145156791548554767939"
        "6737058601282328571489161236550988761960486022562870032145767653310556274688"},
    {0x1.939b15b62b48fp+603, chars_format::fixed, 0,
        "5233651721774457828930143547397259937500061905380822296675964663237327978958491501013819915288110106550653"
        "2687557038424526575845468735889436101248308704643094047464453357888117669888"},
    {0x1.3323559810654p+604, chars_format::fixed, 0,
        "7965462598423407056084302378673355917335731484889156733217607393926632478128285248888903323232860319051286"
        "4441919949753844338711395543768065444398593130152687221530109421623170826240"},
    {0x1.333eb164f7174p+605, chars_format::fixed, 0,
        "1593646840569022296301553121368170395099167364084121635931507149141390227879906775324655193952504627810761"
        "36435039410295432478253760955315056455838993587622326715302371758119667630080"},
    {0x1.d0f59fe9d68e5p+606, chars_format::fixed, 0,
        "4823391413011240786328500371068980348345666540130652185217498297528052654536190138187741079967132340015234"
        "09728884313284382907823478860910903091121695170799862320491542129699840851968"},
    {0x1.84e2b5e2c9a1ep+607, chars_format::fixed, 0,
        "8068434006659676654457255650625273153880247845815410845450429043686140437620851632121083255356331396926281"
        "89202172627621495205007691501867201659515859130020754039123809607454929453056"},
    {0x1.18d12c4dbc048p+608, chars_format::fixed, 0,
        "1165254854887318129432253341611849244005128740776362876484341916238137446011434288707560292719458464014737"
        "894962911847266193570440892019218458606795787156430221022282467463389239050240"},
    {0x1.7af5d345c6d23p+609, chars_format::fixed, 0,
        "3145002956331294992170525256755601269251814902720329120259308009316667046885009501073150613005267467412015"
        "774348292634459749772960881227292173172198041386149418679539742007941742460928"},
    {0x1.975ab947edb1dp+610, chars_format::fixed, 0,
        "6761293527838664139820472719407404184606964850712365515757111169491961757654459712979691921318465965400569"
        "804885376202390953715006070422295318330113570714871272953215654160102661816320"},
    {0x1.c1d0737b292d5p+611, chars_format::fixed, 0,
        "1493209026956578329458803613558608105114935104513446644261768856600601200183754016845867017291711870176878"
        "6867474604627194399095522425450416452953980195186577171892642417347609543835648"},
    {0x1.aa02efe9f3794p+612, chars_format::fixed, 0,
        "2828385985536288646739600925330248187306124521764350039266631456163504031832715154244217269958526893063262"
        "2241589973221227709826283976490647011264056279643437090782685578260187550056448"},
    {0x1.3d7dc9ffbee8cp+613, chars_format::fixed, 0,
        "4215793138787126201592687095074940538481765045595017468901634442009813796975044491572801611250986027715006"
        "0601492917876180907845520932017756677408045726864238056988978424999333691654144"},
    {0x1.c6879a9f1b649p+614, chars_format::fixed, 0,
        "1207089970866236509803893135776239030792924490943617610122250493112943793228292109367666090691032798784025"
        "27125214963888503868333527614117931372209142616050590653014235608250452260421632"},
    {0x1.ab65674d500bdp+615, chars_format::fixed, 0,
        "2270063106824027339748931657665787482441271129863506482565758064680942773085932165051194821233066802535430"
        "56092075426388221410551611143867357719504542651007243174106278126401989803769856"},
    {0x1.7c53e1b833ab0p+616, chars_format::fixed, 0,
        "4040129430311583696732143007957685754304307731082292367345730826427069599704857090760582991485791697151631"
        "73120245949614126178698831517102780044385664344470114797725850999704214300524544"},
    {0x1.2e77c927411a0p+617, chars_format::fixed, 0,
        "6426088010351117377696578205088747577220357388110480717002637520690262509475860031400023069785596865878141"
        "52496590594469715368836313131660803069753435961872139875035538111189185036550144"},
    {0x1.91af529276bf6p+618, chars_format::fixed, 0,
        "1706800695515592043638178774221120688990002250514497596097161346863020672135118420251354652187393164201601"
        "670059306842801510185352447629065196450702180793164841642105280807255981179273216"},
    {0x1.e2ffeafa53641p+619, chars_format::fixed, 0,
        "4104631682494188864369935361376767857643384088875573814265459751005633416294618032797301016990143507953959"
        "788936681276555602164867149581334764589758388426211227129842787556178265657835520"},
    {0x1.5650db2b156bfp+620, chars_format::fixed, 0,
        "5818142413455796337262350052901214703926549122335030954752626652312814127222961805733762821859560957230112"
        "471018315948488391977542573706585784859374641921502790939786006178741349999706112"},
    {0x1.bf7ae95e29007p+621, chars_format::fixed, 0,
        "1521111645270472022091693248054533383629375050697674028247841213400615883747873299312668828654731448130511"
        "3926160400673257953300679831181284416307088159652747412468645675852976258440757248"},
    {0x1.7f3b57b7768f3p+622, chars_format::fixed, 0,
        "2605426852604141837012475826173618188600935104429295284097984287919101203867074790892872048677747768749544"
        "2139696169653926332331688473761049756433252163195764050763466390084322743208116224"},
    {0x1.2df5ab759d94ap+623, chars_format::fixed, 0,
        "4105785371952792797923544609781390593778788901965417025328883762106784109780846493843594945671150262919884"
        "5047066360505800379087691836395031068487812569438457407732512474227630214523912192"},
    {0x1.f86e4bfeb9a95p+624, chars_format::fixed, 0,
        "1371762624713213935603103021290409397649002657176806388466624917414582863372923705620850015249707047610369"
        "79181678894768420162515624483582843225609804010781295565639720290288781607684800512"},
    {0x1.f40819bbe6e34p+625, chars_format::fixed, 0,
        "2719598623051542762828931204662829393792666006819729241065131463908221573347443568905277808876497139692162"
        "20975232992872917430431261712729880546657888244648604349740292101232975795214876672"},
    {0x1.bb810fa7ba591p+626, chars_format::fixed, 0,
        "4824307741692702581214748969871257413043521313431692823365156172118433687874991849451910101780637851580927"
        "86083355584001575840555363877550523501868437389941728201417346022675028135672545280"},
    {0x1.b49cba268e605p+627, chars_format::fixed, 0,
        "9498678712086855135485612482817386035484744399978252985762738418810197130887400026957427601514257406777053"
        "71858937491969553131423202713212361520698537802948066370938491409647594429525000192"},
    {0x1.6794724f38a2dp+628, chars_format::fixed, 0,
        "1564561653734616153139558477069017581635904986153700450417153427550585234667770125429143748064852361268797"
        "206642428914737885631574981113215615320879524124007390426980020724645404028254027776"},
    {0x1.d885c64ec1963p+629, chars_format::fixed, 0,
        "4111969199449787965653113376666097187490284584408598385740832809666652014310023661412103549412319639123668"
        "277588476017765557295002078594048079978501293546557091940850855608591393411787915264"},
    {0x1.d4b6a8ce4e210p+630, chars_format::fixed, 0,
        "8157644542642784322824447550827509442465557032724520145904709409993018687708215050514757144043629528032384"
        "532254436218938771670398095496674453158624970127845737803157578586920398874979860480"},
    {0x1.0dfc30c10a8f6p+631, chars_format::fixed, 0,
        "9397820074087552582334670996735885114551745878387262711305976908588636667440528918796299652112796230215736"
        "762416233629290695818905123073123846308612952343782071766983440677059709153069498368"},
    {0x1.b0ee3365acf4bp+632, chars_format::fixed, 0,
        "3013945875484752466087128275705590665501410175077108295441341008911665790630027227962526962250783999602813"
        "1322069003748345377672125070777019272622112701902180304760314555069924255238207832064"},
    {0x1.e8516d69c2517p+633, chars_format::fixed, 0,
        "6799079050215054775581744115108883498204609734318503991003788727899458010588519952316616029248028234629401"
        "0872791245755968359936256756521776307578874668802788800843559936168472480219628830720"},
    {0x1.678bfe66c299ap+634, chars_format::fixed, 0,
        "1001227511687842883269531626638627505957747284820345284888879957505431285757627837509417299025524139625340"
        "78869424254770151616712433286627933649089597511713238066169913296314718460937108455424"},
    {0x1.04700a1049e6bp+635, chars_format::fixed, 0,
        "1450477696477973922762246127213778090456662698013927848380973425482356287729579824529546003515261730125140"
        "67058098025582676058384729733566966350382985119197142132911172845321643870781582606336"},
    {0x1.42ccf6b7f926ap+636, chars_format::fixed, 0,
        "3595602416094139549672415248140651783040570008089519417160381034595515860995858594543511319122030731248523"
        "97179554337917085081215107409583937953090530652396114892869575308843675129211185528832"},
    {0x1.62da3942f3ba2p+637, chars_format::fixed, 0,
        "7905240079936543650845642299739737677916396108750875835655292602652947056851599230847124600851685285594996"
        "04255099654858809141476957078618577590864095604243342920714026320377441054472831762432"},
    {0x1.6617ede33b7d7p+638, chars_format::fixed, 0,
        "1595488485333753846793096016195937937357422696318152564775792115138249157053382604410670802109663452372280"
        "622563873071483865155214731195109515482575780647056162170021909878210640606642688753664"},
    {0x1.5c71e4b115269p+639, chars_format::fixed, 0,
        "3104998331330945794715310828569883404674067176884556565218284351444638269692991313496681903293609511189575"
        "808859645677809012205688992155876799240651615710401257329009039104082564451422481416192"},
    {0x1.f38de0551cfd8p+640, chars_format::fixed, 0,
        "8903071845176859294355195227333545858376729955660332574912590438489416396405665802642435013033256079391183"
        "097998040901449719178200967412709547407175233106220746691802662083191769493569324187648"},
    {0x1.7d3104213fa96p+641, chars_format::fixed, 0,
        "1358721439433228783163696740912347417319867778111461068847750924006676727003630439658300200733836148834243"
        "4701826146857086210638259037086627062270667811911963671153223450792336088526500973772800"},
    {0x1.05c12199a4ce0p+642, chars_format::fixed, 0,
        "1865998426328270109596191066112710566261944234007108999996633524706671600899536342001290451786915606541494"
        "3288271814177193884147313963724468713128901740026751426896821846885684778228695338844160"},
    {0x1.e7c493c1e5eb2p+643, chars_format::fixed, 0,
        "6954412455796678146528360174052816146865715601627035821935282887515245554692031453812033436021460189574846"
        "8949215676482982196512810670940274921427074192952089823830554753893672379339452513779712"},
    {0x1.7be4b24c3e84ap+644, chars_format::fixed, 0,
        "1083275518981697368683840011739492511756715007425316867107301035743708290842980251168573814582538402274720"
        "02871294262996952385717718556772469494577025756255588922017376406338209071473684947927040"},
    {0x1.2de39fee556c2p+645, chars_format::fixed, 0,
        "1721689201890626802206847153738774326055755959039803125874910835109420415058963881416982285197817618611176"
        "35178753721442312474618140545615242891098913632068282120236765154238166534743448711331840"},
    {0x1.064ef464f3256p+646, chars_format::fixed, 0,
        "2991916436302712369274961966062721088927127529515002223774472011939456628835037710472812168912508987641012"
        "02070770195820265912330897451258503380258144675789025947161960842321190442166624672808960"},
    {0x1.53c83ee0f3068p+647, chars_format::fixed, 0,
        "7751180767767666666899380129819749585309620493445974661962731435913506659391803434757712578145745216133072"
        "22499090718182469027512595486412104282224089391808118934952932553489010283810329970343936"},
    {0x1.3d245fcdf38e0p+648, chars_format::fixed, 0,
        "1446941938650359502812707550148484621797920097057112024108610898616783602909172115320888205220428417615869"
        "692393014844961294938705227221973480785926757243856237171772712052212742533379530998939648"},
    {0x1.e08347f6d354fp+649, chars_format::fixed, 0,
        "4384622385640972648784313774534524001623349767718470283874553407158311176981697096756222623282787499801445"
        "184284881420975108036710110563126305622808224088979432579122289231488107948520961449394176"},
    {0x1.26dd41c959944p+650, chars_format::fixed, 0,
        "5381203163606890165258076803310873532138500227958540514963357066178342157170894073191972046689622720739079"
        "961349180699018841380453909336296408176168776915809695465869463868037226981151032054120448"},
    {0x1.32a46cf0469cdp+651, chars_format::fixed, 0,
        "1119229781219803145367253890487858392054631005778719691968056460280400602163527505290471657839323070554979"
        "2391736916811871536801023058717321491817885637178624494387092346840642879252645460150583296"},
    {0x1.f735cacad6b34p+652, chars_format::fixed, 0,
        "3673386106091207688913621569679455389408175004806918381792022879329286736717206172122567128325786514905976"
        "2373032895575586250199621890834068293240362884267618309008853943697973367517798399718981632"},
    {0x1.6f9e96b3a07d3p+653, chars_format::fixed, 0,
        "5367174654182726101120335408762410892287859708091264622292238086266828749180259713752371134773469445613757"
        "7512510066286097290894101024991650054347426329814100070532676175900514872055547324115451904"},
    {0x1.9a7be8fdf7d97p+654, chars_format::fixed, 0,
        "1198597749534963449090887841757613913366429242741488267748319817517257217935798001692677071594436579670425"
        "74692923571443314746208884004956936450441535729663397603260741070812981369093068197195677696"},
    {0x1.da6e03fe5ee66p+655, chars_format::fixed, 0,
        "2770633669736967207955811227572999198966350253747669664564192146259917827699577293046495164147025849303833"
        "69099948172126078628543391675565516869571467232515617030599512982766562717569725701405278208"},
    {0x1.46bfd17446d76p+656, chars_format::fixed, 0,
        "3816382032421530207865505258110516936220607788988249066818195596533133561278357699046241911001476280204084"
        "28932624183905960507058168406385765800174407011359638209862028651785169944480326048859291648"},
    {0x1.4da5bdbbe28e6p+657, chars_format::fixed, 0,
        "7793902438347514440640181011113478123571429987141646872526553782378647727817064069370690092739024473577040"
        "23377635205357481997520059613138340462342666890730126616251260546972142434062110654323490816"},
    {0x1.794508278de11p+658, chars_format::fixed, 0,
        "1762580890481987881425283457135501712972354397557805894287268773125378566000519027633345144060799112376632"
        "196892933953973742848878173535542830691929043392759764761692511349391854787965137532076687360"},
    {0x1.eb532e6f9d7d9p+659, chars_format::fixed, 0,
        "4590880368222410865791218998205211387879524770061966448373098808296105923369755568747442330158655870441628"
        "405972833885899442431367846953537758531668062429844500799658848386004026176785845424421339136"},
    {0x1.de74ebce4a37fp+660, chars_format::fixed, 0,
        "8941282866369576915713370199438403724519950866233398403869742470051018098969851229255072872351236953241690"
        "859581044027690123952861405038640439793801150984027335811429652593548499275325847981191593984"},
    {0x1.f37efe81f6078p+661, chars_format::fixed, 0,
        "1866892216382209310267021259030272441213816077293731544355198853523532726972700428318806768509799391577996"
        "7857553550469160341100795009241978760744022819053953305820738316178892052108850291867761246208"},
    {0x1.b9ac64ed3cc40p+662, chars_format::fixed, 0,
        "3301554140624012765282790128531799465425225910829272462785463242343111222529183299371460170183709253222898"
        "4666842289569788469418213910100041040541661269705317791388661975141778219886098547588248633344"},
    {0x1.be00282b03f5ep+663, chars_format::fixed, 0,
        "6667800778670079956212752630731020775230819347039281550267183886354694984178437069741548386845262392466246"
        "5852932499279515268041523524885590999171088727718673563969761030301929187013508451729059872768"},
    {0x1.1f0bfd13ebd68p+664, chars_format::fixed, 0,
        "8582818157212463310752411961628465729198777979420078115831657234410521524747640969126433265024863686225058"
        "7399330494835558065432909058158755560573757532140879843155127845886935663226690006104546476032"},
    {0x1.214942705de21p+665, chars_format::fixed, 0,
        "1729955066348232585429815277483881150466681399421002179444051004008466615998235776770997963716272572012183"
        "71431466580295993674478312273890911112115116201849407598813746738002168025760524577720667996160"},
    {0x1.09671a2b2cb1dp+666, chars_format::fixed, 0,
        "3174260421239594152016080747569458769344202387931082624539750316063638950221427193166837534132027948222893"
        "65003537922894512928901216347580242808688118038808320342245310580635968754349465019243816812544"},
    {0x1.ba3141cf23cb4p+667, chars_format::fixed, 0,
        "1057738779050305784552396788296549265592250669951790118469054139525164892325553676596807312345243283118942"
        "831396109005239237295468261418029835948558091906860873139381555038608771496710686082370958786560"},
    {0x1.86d43f758f915p+668, chars_format::fixed, 0,
        "1869752072792986020220533348187109263480606863609304000134747658299718635099101474955456658558244951782785"
        "217425143964153188049690824639256727086482834546449274691729012173091390685981881574798938603520"},
    {0x1.34d8186824c10p+669, chars_format::fixed, 0,
        "2955061165839853772981208410423327958188619742299599743973924802358463375106307770696982606800232882190255"
        "835984668412855709756751449286828670454146045729913364117793350552523245031469165393183309299712"},
    {0x1.e78ec2e502b07p+670, chars_format::fixed, 0,
        "9330031602327954656442973471013148617216548090389767979285186157977640513319499144517329482317159161851973"
        "382886503720740495065769351149280072967849485120060333190450091919271255293415847165484888752128"},
    {0x1.f9eb8df3b3791p+671, chars_format::fixed, 0,
        "1936284144316907161772597733814696981306853769463077283378952353594060538695960758739103558415536199157147"
        "7218864349571847687751095323036013647599983792758341840892977146731474886476017173416410244710400"},
    {0x1.f3bf2b7fd9993p+672, chars_format::fixed, 0,
        "3825314140412423908755344513507823014921817162983591500590046869105515725317702843347518172188803135347414"
        "3805960645601659788841709440240831940652256561820866616777441445506068582195950276620332646268928"},
    {0x1.7028723b0868bp+673, chars_format::fixed, 0,
        "5636134524042644799624360279347731171505187833022937509490065520174547633917857823469204278320358667440081"
        "4536523693629016758628762237700239395376218700185658748567853569033785027091761965807224097865728"},
    {0x1.557c7c726b2c5p+674, chars_format::fixed, 0,
        "1045563380046825437365920810881259039404331704270752953532059165345715816638411672391964039153381490213019"
        "73914820975343519675720107557611312716650944578510886085691231275003492219818521525260187846311936"},
    {0x1.871a220cf573fp+675, chars_format::fixed, 0,
        "2394954328277625827509482699780047544816392970258196966572178130341032941744783245157743671000112247232460"
        "04426134549707543279835675223903160643688382643597490008860447048746541065340198566551705264062464"},
    {0x1.7ab1f57987853p+676, chars_format::fixed, 0,
        "4637958398638087339937761182227231049124921246399686678310748497379066375957972167038729798670423059318812"
        "77246512300341294333647657347794641948475142092198438521343984711625050786905805143040315550072832"},
    {0x1.5d3ddba3b5f62p+677, chars_format::fixed, 0,
        "8554470028680689905457374439889878323873796764466467132577542178041331259462261869701820360932262177458633"
        "57936953692366755947421731246318689169626782187431645178224405902434053217838696105015610359939072"},
    {0x1.ca1c22f39b22bp+678, chars_format::fixed, 0,
        "2244226984310112282742144219425634400342236553116225944706361966321023853693220234245975607038739590449436"
        "608778953178834695527378455121099232622455529116651588866259062455701860787333589107721957541937152"},
    {0x1.5571570a3d877p+679, chars_format::fixed, 0,
        "3345376225949994309590611550813489342004449480811488957688296398330964853387848361151560473842736697054901"
        "754178011537224573858899467011609733043254823463231975478542474685169259633176067748962831236595712"},
    {0x1.4094b51955758p+680, chars_format::fixed, 0,
        "6281953454630420202275618993069739417385914224011807043883040480576055123863345303309775160680768851364379"
        "633566498059922977393145681190563895952411661162198926892429054001662376306285334661068344151506944"},
    {0x1.9048c53155909p+681, chars_format::fixed, 0,
        "1568756700441442943044558061390767244029799937223654185010977731065696663028938068251290166098424314781816"
        "4720305606372514460855651668937589154968441803492390245562381549787491329484096179468977774843133952"},
    {0x1.648fda1b8573dp+682, chars_format::fixed, 0,
        "2794808396725350715827089206220430492466901029150428816331326145852645634881970757182065470525400283782009"
        "5403692983421401206915761523316550794340500753951807995473779905072062573759605370231867493790515200"},
    {0x1.43618fcb01bb4p+683, chars_format::fixed, 0,
        "5069460081666643483191504695700656896976847410731048356974618354537795358421749857202239066682444420690680"
        "2716110058524003006214659535848234793606862153660055012848214798236108687160590757085244967798964224"},
    {0x1.e3c671ad8c424p+684, chars_format::fixed, 0,
        "1516773194655658235833854536387364152085560407344589363868960388430608227631836747794729508003104381911044"
        "08642304100789891065969740635351032828526812314484068150876373570965277810326480540295924136407990272"},
    {0x1.0083712d8f528p+685, chars_format::fixed, 0,
        "1608485680821464130401617152690420948765452504210405669849278686501554120481720167768747957104967730689737"
        "19496544120901191625200109058676087802871541264829133196190867040924564024017823724146856414240833536"},
    {0x1.1b815b8ce81ebp+686, chars_format::fixed, 0,
        "3555480059704266891152127019844250818474388230010407876343909993680505839762945849831409995743368702241891"
        "63184788239468910565398744819870703830959835692636607007655630104135189425612387037272246775462232064"},
    {0x1.3cb5cc09f23b0p+687, chars_format::fixed, 0,
        "7943813334385863056542324297969427490956423776670584086879015121252165848927147198380473925309566136676102"
        "94102333273655557547426416548788317016668008395432111323108190919984834221381915705192746329317572608"},
    {0x1.0eb891e353010p+688, chars_format::fixed, 0,
        "1358060002850566437569066220742424529363053836777337432911324154271055107224126127159061222794072519157552"
        "514226831664192131528047596624496198846425386719665197330596236999383282901549238870689594008508825600"},
    {0x1.fe4392ee89698p+689, chars_format::fixed, 0,
        "5119433935571944306515549418307175275418107317058191945931032384985682786535454037617883736252238990787931"
        "721861923842646425087948083052097162063136700891783482967154133027296156365640453753060081736636956672"},
    {0x1.2dcb28f24e477p+690, chars_format::fixed, 0,
        "6055737748179178377512325376707318300605078432844880119433017225619267638501958744950585870381817183479615"
        "888079777486184355096973374331860638106502031077122796354840154902424520732833513406609567524824547328"},
    {0x1.7ef16a0343a29p+691, chars_format::fixed, 0,
        "1536813620100941815107574661221297808607802168437717593395633411458486095019910602689208855230840582685968"
        "1198673424970533136301013108806903613888941328528246657716715762818718782183405530137798396072563834880"},
    {0x1.2a242729206abp+692, chars_format::fixed, 0,
        "2392979962823187453355916259567570068822526719044600258305185299632665771293612449132450526507765384681411"
        "3912468376263785578115495854111182179778355706863388202457043252998698055736229924100641739854177107968"},
    {0x1.6fdb131897c76p+693, chars_format::fixed, 0,
        "5905063752643222946004667242915201851227615746616101168136118801285565321724762394852682484876204660705111"
        "7422917669609347806672777830684801992638883640836819494802345454688968856603084866279004383014876610560"},
    {0x1.828b9edabf8bcp+694, chars_format::fixed, 0,
        "1241016416991475698698772118485852513075185422886339439749369509075818634822479531883472862044460482461759"
        "26376358164303658206374976185443979610307101254760486194833808768397406617592883545020705987606790275072"},
    {0x1.561155e6ffb7ap+695, chars_format::fixed, 0,
        "2196438817181218637691314999391606891510435803326604653926564567070596714147497981058947196199772411280070"
        "38529115316543316991123904985184012949857407673490871091790599594254663632479001321411805904083076775936"},
    {0x1.b770da1a7923bp+696, chars_format::fixed, 0,
        "5643355654143248139826986782450695013725739782459251895015817609507287513867479349111552688940177778096787"
        "96605880934558431966021135949322020945206483833796818557605415476191440013445527768217391316223846776832"},
    {0x1.f39e870744604p+697, chars_format::fixed, 0,
        "1283234933019471834475596491074664947666560060020456820709639275619096610751496707012812799558712552505735"
        "78716443502946802448442620802618959976978767428487544804073805963064736494872215411812100040796649449062"
        "4"},
    {0x1.e0e0a24f508c7p+698, chars_format::fixed, 0,
        "2470196171073976436158323491514639764649528138296820506628253098079754232389193902786402931911170832742473"
        "76819180283870144825478353453772049798438963755599572352833066699197991588948065122208085779596633230540"
        "8"},
    {0x1.8ac9f3659f1e2p+699, chars_format::fixed, 0,
        "4055943573502298873950637595005545513320818153972933685470356192365077737900912446855672017311174986257853"
        "22257531748255933833911596322305908820799861570096445826119055025147325835330550150749374733298534711296"
        "0"},
    {0x1.c6c3610ba0783p+700, chars_format::fixed, 0,
        "9344204033720964789099166968585434806191233691620277011040269619659764889119933446640827820888154718264556"
        "48106587676761185019235392954314227170622662103422697806457896662312360195041629483904435021403511586816"
        "0"},
    {0x1.7ab499967a977p+701, chars_format::fixed, 0,
        "1556282993207826838292053664483252529563220742278206524558245294858801442634545164766259333234394269335904"
        "367303824148104384395607953259617983621977672054433130933810767395696883211282676150003579684530450281267"
        "2"},
    {0x1.f024a7d24b0d3p+702, chars_format::fixed, 0,
        "4077782162006019326633431827559285349135566446998944937268116760733940953107973573104987444727500132792603"
        "016716647774810946339317774614675085229067529724067990247981819516824938089923609051324757764430419197952"
        "0"},
    {0x1.d17a4e72d8ab9p+703, chars_format::fixed, 0,
        "7651488357127853276242132761864036422814454022471530147218920574712855733986768331218923431269999172230480"
        "187508384059736711183902958629060763487777480969265193074898840268978802200642734863912959964269495975936"
        "0"},
    {0x1.bdb5292735f65p+704, chars_format::fixed, 0,
        "1465301787337399869276363583724019621305256722912708038903280860517766226744000444820382608869987867026571"
        "6119895040590223473662415362562185577545483877918682484885072367719780856613420653419248587697138004131840"
        "0"},
    {0x1.d857daf79aa6dp+705, chars_format::fixed, 0,
        "3105736681090479780414240556022157098684844918477547872130010461066190932436462163526080163763369129773061"
        "4260626133495600176265734381520800838613263216443343936742775300303226983614380976086743674850864273974886"
        "4"},
    {0x1.09c435c527cc1p+706, chars_format::fixed, 0,
        "3494919053072309175675748445269104771306176491933340563145977157106258428646610880710294082136226924489793"
        "3428086956552905322744082047362472421201551180358972335992195302859220811917676779815344923699394346221568"
        "0"},
    {0x1.9eeba5c11bf2dp+707, chars_format::fixed, 0,
        "1091269103804911780335617842758026759298792073797386346264391405742828944445972629343078246464517280056710"
        "6461406826996303424238234353669224948290555453511829403527677778524266812157553084925288785765222710163537"
        "92"},
    {0x1.711ce33669c35p+708, chars_format::fixed, 0,
        "1941583711865697204746256015156518944019741559908299207229008834844625781875330586526456945344115576020927"
        "5642068221511536635242993712997814887667227461258100922151180021454095730001569776360303611499916502635642"
        "88"},
    {0x1.e1545d8e4756cp+709, chars_format::fixed, 0,
        "5063717719666343978161956101987079543887170989961124525040709065924399985127971621370596120381841856193051"
        "5753883747499226964119454731907400047677810621416560130132110719738999828696690103485087370985049811090145"
        "28"},
    {0x1.87047e172162ep+710, chars_format::fixed, 0,
        "8227221790228980671257499469705287291730768045242473279959358582346511385783401335164982153939474653321232"
        "6263547497673971000449241653499551540968272330271569995570944583513505428002922386656793469347367810246901"
        "76"},
    {0x1.23af3f8b0f756p+711, chars_format::fixed, 0,
        "1227440354851668993456839977968899869468735345520167925651503238281582135096466232431925258215419562610191"
        "1191474444485124744373216236838038919013796336290985868971128189541024231417124227566422090476366803561873"
        "408"},
    {0x1.15ac6c4e78557p+712, chars_format::fixed, 0,
        "2336960786523523960259537098118818102270133123628378374095278087135612248329180736851269495018599953027852"
        "1810012639497784971753531338904066858624412827095937168137934366276318155094307389715761670889176261000691"
        "712"},
    {0x1.0c56bc2aeaa8dp+713, chars_format::fixed, 0,
        "4516795524723723359179339019491606525273423400192020762180542320617453299983205014338704947737188575834177"
        "4049089350088820445306091663288005992999760075869205707071166753317023001654263861551683890717335067755020"
        "288"},
    {0x1.1d43438f94121p+714, chars_format::fixed, 0,
        "9603333317066072371349453366599550684514556512675701199979085982192340107867858726361550496438065106481326"
        "8845510440564013868695648869083373584373867869269917305531784840327501073368826901361601492333604453279072"
        "256"},
    {0x1.22061a1f36b39p+715, chars_format::fixed, 0,
        "1952722934421129620483274849139197031365929863015778953867693034306903376020819758959987970287392899249952"
        "3660899069569792928747578376452370917853369774868866779572702655138554220853982914990475716478533124237557"
        "7600"},
    {0x1.b4c6aa9857545p+716, chars_format::fixed, 0,
        "5881603409821294314490532969861265375773324536229858509467145703084398100107690323994373648175249156266885"
        "4322761516142693345396666266461470068359281734322103363387243546308238464659220797411699881100100073352803"
        "1232"},
    {0x1.fc44623e54a39p+717, chars_format::fixed, 0,
        "1368859723229009103731168614635019692992509093194960531475270498326709289521745405065946018254320406117476"
        "4948358136090265427597894075060438725634965524048386906052855831441518644686937797919299173004683502086772"
        "49024"},
    {0x1.aa3773f76d3c6p+718, chars_format::fixed, 0,
        "2295764284659215143576575537617792224453034112312240455390484925314195149688610525887087606485161503643446"
        "9487640122992188236785253589413174035526802275272496248351134708835699120438951179663704960111131110779723"
        "44832"},
    {0x1.678f5a3aaf4abp+719, chars_format::fixed, 0,
        "3873452666452653040977800502103291280830376123603932314519000754253255961367122662804153620709055411954929"
        "4806165642693765246793612927583829780398517402958999267072228701042868544358203143993858786679510868442270"
        "92480"},
    {0x1.75d7f7f1fed35p+720, chars_format::fixed, 0,
        "8054654093095745571857803131829974735040217155795720972996527382749299243187278634624462721156563160664825"
        "7005986783765190678460254789257444743374938027880768711231300036742824114502555294053396292678677992113449"
        "20576"},
    {0x1.ecd6547f3a750p+721, chars_format::fixed, 0,
        "2123686535515559562273528586395505800313514483395745075298085135171798735233109223304560074674700126056193"
        "7291158946718173896569296039531604856733284152037686012749260529207824319250135096395495352516915944992763"
        "019264"},
    {0x1.0a596dfac622cp+722, chars_format::fixed, 0,
        "2295453607950479536310528485623837004757586382379191488457881203273698650584404729967997754495888886488744"
        "2951056669952071781052790473826029299953021688768115856412305379354233814949593640298703702046027442239383"
        "273472"},
    {0x1.2787de7be85a1p+723, chars_format::fixed, 0,
        "5093889959692539576182619568129398286405410583783652444177945234158735336533724146392768476042360567250313"
        "6464819499023258784989583342649665721431826274705734325984972248516667725996772046163212974917654538257698"
        "914304"},
    {0x1.017035217c70ap+724, chars_format::fixed, 0,
        "8874626256790000244076336222069640077467713258416463773717347636815937384815717327682486531603138365405751"
        "1691703267627156659382229317277215514890808408496917480416674632400398136402895339939119899965737997460146"
        "487296"},
    {0x1.520d5af29b2e0p+725, chars_format::fixed, 0,
        "2330722763749368558325721472615163327901421757587933088529200799908478224799659671505075666225503013905885"
        "9680585650409357736245667774031018743688729855165660056396607022699316763797442861823666088645738211778673"
        "5607808"},
    {0x1.07577e25bec05p+726, chars_format::fixed, 0,
        "3631254054969045478394538534108073927018626053514348146178073154620545943900950162158636224366305088996445"
        "7871752131739439415577000104889353026296447622197049676919909822289694967906242744230734591647156614148244"
        "1113600"},
    {0x1.8e96d600a22cfp+727, chars_format::fixed, 0,
        "1099239719563048539304802974519333248720009988612645868221010247563255776583817687910234874086417481675345"
        "7433974739024870404593839667345575652949301794831043532859325960191677592937324697516311201831048403427646"
        "91390464"},
    {0x1.d58382d6bdbc0p+728, chars_format::fixed, 0,
        "2589674385756993492602399990611460265698002203137296410164233119645313914901079606471826933858404098518098"
        "9593038354058654753675686443392283446651614202408033168533185669827718314096479456553169530746246086290573"
        "10949376"},
    {0x1.dadcdbd4e3d3dp+729, chars_format::fixed, 0,
        "5238355375759047679718444801493998575722879567001090086493441713989645048600536493575093493176666817520705"
        "9862764586622862769820594672704713785528525150031742372621400280257565057235276397330683769676485155549679"
        "10612992"},
    {0x1.9368fd03b4a42p+730, chars_format::fixed, 0,
        "8900279560041490619979192723221632347611057883537554951306638995371024216929437445872303513774467149318672"
        "2234462396480190553216899841333725945022797124710083138285057710837640319331020800463716341487970600766913"
        "49569536"},
    {0x1.f845eb76e5443p+731, chars_format::fixed, 0,
        "2225116158761087766363348913942892039519802036376171305139767829547062077205969578841514901877534556356255"
        "5762777495118665261832821781371260756638778983883714666146446905425278001279688706219809518432225998751748"
        "784652288"},
    {0x1.2f3e996a88e6fp+732, chars_format::fixed, 0,
        "2676146191342833504034301295321913182412616832450020227274467870190931847781381491185289873065187374317510"
        "1425081977800077877770735697038879718637455326844951298257413736161884021836125708342242902075069447996397"
        "458554880"},
    {0x1.4a45683f62e2cp+733, chars_format::fixed, 0,
        "5829314115768354071597483488729876648514915998500096356960323028164937936867867297910462603022001770665310"
        "9780865614743215820832575027607418817847904297376017943402827508775808108531296093503913514229899714127169"
        "872461824"},
    {0x1.271f30e62182bp+734, chars_format::fixed, 0,
        "1041785244206836381482082569848538480096152452290912090875765575273930405227173007583543796714117570489723"
        "6255641041287157462180544590035841136272606482818447031698519086284298653682594108090391640145979587298963"
        "2111050752"},
    {0x1.320dd43436bdcp+735, chars_format::fixed, 0,
        "2160752056028688461743683297576498790902096878235063080433213244844666904753916384825496258413341301758118"
        "7899511015448441435915632057733803456589470033458768226512926713973314665173167551963813546320158531267851"
        "8261284864"},
    {0x1.d4492eadb2bbdp+736, chars_format::fixed, 0,
        "6612229146655117441168711686094444532436910098228026264275635783330347752449760489501084085477318895305025"
        "4952524079915063414419338956574698098611454290489494124898739202330237178653780186955601485401625450255165"
        "4684950528"},
    {0x1.7244f0d2e016fp+737, chars_format::fixed, 0,
        "1045645670773271637283661690345001000283115449429739664757508063194100654200851508498050167472695411837384"
        "0973552191616310412396016632996447033707258871187435688521599916928549468974662428654817829704874331915703"
        "60707842048"},
    {0x1.79783032b55c8p+738, chars_format::fixed, 0,
        "2131958191762413466353988942080877003390278263413142880580362127448798568211133167351017171417321177966109"
        "1103962982927755433640136765454273679309575775884064681827819011941847150896169556773632828022579674932529"
        "14289311744"},
    {0x1.0b80e405b47b0p+739, chars_format::fixed, 0,
        "3021734238681330196986086098675130970728131350248726308811240224908928405470052917525002475086011480736989"
        "6624843157291087679036263473270864818434041899624889329937851637732532800509498117442029880517462687772083"
        "01410582528"},
    {0x1.8c7da56899335p+740, chars_format::fixed, 0,
        "8957564546729513618700519346747272746107736055861506709457313341941037304392681464987938562259463523737640"
        "0948996618304363198022425918235806365729809664546715654847344117952840077801654196792979507517085335923130"
        "91309174784"},
    {0x1.642033bd8f523p+741, chars_format::fixed, 0,
        "1609126720952320784150002291081965503718696293038888149012934381940650942573719189611286824497427701209601"
        "1103846798799626483018174230774059177771202072628613312351980968314129006419829400748219701186026293005375"
        "228012920832"},
    {0x1.9bc991377fc41p+742, chars_format::fixed, 0,
        "3721258517697667524776603268792357806534625490986603100725174894625343008775348017057145675495549590962407"
        "4965147809435188568377268619875477540828907199705993963484184077353272851049733783025187657054342901373829"
        "994915037184"},
    {0x1.84a5ddbd8f438p+743, chars_format::fixed, 0,
        "7024301672009425838025662912126814595330470868115541671156926539644327945801957358311540156486313337589557"
        "9685909656995177174501875343122585231807531330311572313079292529543335146246164661218890443786186808043029"
        "385978052608"},
    {0x1.812a1f8314ee5p+744, chars_format::fixed, 0,
        "1392268859877182592349746773363535658333138149954293042940913594792764552210250115600054769290737506972972"
        "5342408628685239141847531223744719982978027470592653996762274804719172717669993358845520936049681972313975"
        "2620522995712"},
    {0x1.7c836a459d446p+745, chars_format::fixed, 0,
        "2750911960497591307884445748945284629758653802877648998968329372262619130678842796735210842450431070421229"
        "2151035888750950130882002322209950733340085450796423070978342873426401731887124393590376154252845693353298"
        "0757779185664"},
    {0x1.c6fd7c21c37e9p+746, chars_format::fixed, 0,
        "6578680864102577255707787019589983476528158564831344882323922191623997676810847854751781441935898349486881"
        "2196179213854821347805334962449803183900781467628953637713061092827366412942137406533401622084266250098110"
        "4964844650496"},
    {0x1.1910872193e4ap+747, chars_format::fixed, 0,
        "8127797721199312242409160908564874766877148108242791968380748492961207149792226473298600227146464993385549"
        "7569272362343740219167487183252229672093518947250855792119297436241311866040388542951564096258269136861772"
        "1565208903680"},
    {0x1.e7a0dc9273731p+748, chars_format::fixed, 0,
        "2820237949529470317762890891723491551677048500394606994256036437109310202078844450723666505267762564382294"
        "1616984584405761190431901079604324140883095468794558317571713910406741983588147750896322217239015660195789"
        "35599446360064"},
    {0x1.2e360651c6029p+749, chars_format::fixed, 0,
        "3495723738255211452744482178604527955830110169457050715565323051837075097793915869045419749814682707345393"
        "7935704146076704637189922374483332301500880617531694966435700931973663656797146377969581204122663768815174"
        "61737018753024"},
    {0x1.228638d331517p+750, chars_format::fixed, 0,
        "6721082912592892884197305896435679801878082782522381596685281346194817706914936055514139398315616473575172"
        "3582381838767364218423428900386923688554615255663544151664465105180194395018816205593085597697340457992620"
        "01243453652992"},
    {0x1.daad7920d9184p+751, chars_format::fixed, 0,
        "2196269058711356995331145282266004942125027540578994118360011960462533544403705214740007357954957868218513"
        "0515293337008075180533249529233350875198357980735191485985215759870956129913862215075486089748283668061691"
        "205360990289920"},
    {0x1.fc367b64a56a0p+752, chars_format::fixed, 0,
        "4702863683113725194063960973499747891654249089450258901606867986817928359509157131107166631127688744378523"
        "7186911133931305617838775969338327695100395080327930114607085822544817999883326112098494441309084006252415"
        "055825045815296"},
    {0x1.f6e5591a0bc39p+753, chars_format::fixed, 0,
        "9307324517542514697582244145176573210676397705683421188857166552145538571574192836598914525078519041089662"
        "0874452920641540661618903444865624546490778050170641236480653815602064266888930904612434348648660578681855"
        "108771838164992"},
    {0x1.0816210e741d9p+754, chars_format::fixed, 0,
        "9775137400232788245461979249328995347121969007448197063448461677154947355085479118128329526481778292235270"
        "6061326551287759687592915176722475045491362638732590059161507195395361478829422139931404206375588728573521"
        "807551598952448"},
    {0x1.bf4ddbb28ff78p+755, chars_format::fixed, 0,
        "3311384964585959032265962955408561029446842687666536252928361389826655908935433788371333793983157636535123"
        "6093952819619349852838092193945849100746223855816339303226875615954020173611648688061774736290148116460246"
        "5147231123013632"},
    {0x1.22340a9f27993p+756, chars_format::fixed, 0,
        "4296740089682653693619685204778787784222879549477758054736502741042587518192457642311991948337153228278755"
        "6223245593515136178433188143859836126303866310125792739941803487391969403811804336856169218976067287564221"
        "7165115690582016"},
    {0x1.c854c0ff61dd4p+757, chars_format::fixed, 0,
        "1351284488894256863343170670736999106280589629940727361352870919021737282813860003548731361411054650613017"
        "5979693662379954907245475777505034921707218865345263170876295764424200712121307128446231005054445073917483"
        "68719761509449728"},
    {0x1.a7ae27d0d4485p+758, chars_format::fixed, 0,
        "2509198468783754807731074334607032605711544625671057970995270512460643375264697520099044738808832338356216"
        "3179133403072384380098770989766972936437787507921796438332243405697413234717967017145922177620585767891811"
        "92769609255616512"},
    {0x1.63661358f7264p+759, chars_format::fixed, 0,
        "4209617328858550063205172225821872247014562312759675821174391466759774447231632596434331599555608445851494"
        "1174841089432312006819740350812602890591275373093111608274027906458049964325438650357074434395519882088005"
        "20321808449142784"},
    {0x1.0300bf26fd68ep+760, chars_format::fixed, 0,
        "6135661532855285869388899909021584997918770086045081468884709171479140787335530685203769912073225861728157"
        "9976366131392745072658904926119270002620328679520460157302155135408495181252847469474891525082879692534900"
        "79718987125489664"},
    {0x1.838123317bff2p+761, chars_format::fixed, 0,
        "1835960873424024875517009489326813800794881719596271084010300050215417037045759768802256925129327995282374"
        "5128929061396141929193591727629831823122413292887614537118714335123297684397196955209175428403825140165978"
        "466839424002949120"},
    {0x1.e3927b4212b34p+762, chars_format::fixed, 0,
        "4582242303370037772517265893885039611467246975245114775017096258551843583443468789786320930086482741689432"
        "1621534738378345133903881085198621733196221263896490459158348094524594289256006654057327248264693927568182"
        "907234209828438016"},
    {0x1.08cedaf963229p+763, chars_format::fixed, 0,
        "5018545601421532348212036414344703817574522237982615692173102373360462854025661488977284181406693000830032"
        "7360291067623446675802184137931993722552424250060175975563339633154061405272636075589386122667206698254309"
        "997744334718369792"},
    {0x1.91fca0dbce025p+764, chars_format::fixed, 0,
        "1523661683782226118359498355280462120810387201488444694707261852709568760522785950774120035981225647992415"
        "3268915648163391081256988008659617489616827001996746290980908042429063287469300251546686342201121807506874"
        "6265517706895687680"},
    {0x1.5297454425c1bp+765, chars_format::fixed, 0,
        "2566740718632855257682720329872108144883467487982934883991455376873707477105015183243411439956531965728204"
        "6508184153037576504248082493404189817144671486439215924512664024164129548551829584530145455399199341923594"
        "4180577661756637184"},
    {0x1.b0f443954c717p+766, chars_format::fixed, 0,
        "6564151959920961394230714502378331091738070637090186507523556135132147620443368837558214636894653939964132"
        "3757357718309683648453607080686817494059905169659449441693854905244032325127240563529969529142354605262556"
        "9523937164155420672"},
    {0x1.393f28adab23bp+767, chars_format::fixed, 0,
        "9498460772305780158082815662200183788619996980168963578500885537080626445137280799527872282820358818068031"
        "6231943703208129193287071326187029635778260356608440247828283834974689386054468533040795027311516162612591"
        "1382367174150586368"},
    {0x1.6ccee9de5f09bp+768, chars_format::fixed, 0,
        "2212388350553618292420425099312874149231992615598473809512626321690009127813173003495667900190943719071414"
        "1747046126548457112475553582140540745337526832671513502626909215811246736089331236321064270002482113615770"
        "77814685419605852160"},
    {0x1.aa7e5f5e5358cp+769, chars_format::fixed, 0,
        "5172961691829431933248287579057345034013744858429135071862722341405867374003880179589023614028215961960709"
        "8551590682320344905318670742656945039835931120666701570376183397568895102563277958752907801635934970948509"
        "97541669026700197888"},
    {0x1.cfc195e85b968p+770, chars_format::fixed, 0,
        "1124984189175588147030728857463349109632082181606108725108487909044481063280737954738616935134527634142463"
        "9949923511787252203981278243393110031850908641735138673909363057517667235391316307036804051909753689540172"
        "298591886940406022144"},
    {0x1.09d290fc51ebap+771, chars_format::fixed, 0,
        "1289669622190386579505521508298314100924637069061856532549363250469091591549993083219228616468381610205336"
        "2794942573420188170207590463294324183021031144947921860119527768018916893440763094280421949876583300156098"
        "252472908447697862656"},
    {0x1.ec76d7e7f32e2p+772, chars_format::fixed, 0,
        "4778497687103401765782899829107866823662348724264464491426484752300467160540534520506038266413147798664677"
        "2258193692599429358101302845147423102623897277011177375231975113197123433649841218533372666759429462798413"
        "899670124201699704832"},
    {0x1.d3759f7354154p+773, chars_format::fixed, 0,
        "9071740946235158251287920731264087922543112315784837645934036269104431986336047583397267115172715330911699"
        "5361329976139758184944638155058103560006767186294083681213986399683839132287337191340066977329985766803820"
        "023594898696504868864"},
    {0x1.60b6f9a6cb668p+774, chars_format::fixed, 0,
        "1368990064881959941999107885865686935605076541647508860978116265485948578198942963140863016455072112996766"
        "4667516382760065619975526997593096805480179373298731763239363650046238044145819507509521293323522558851884"
        "1565183013015978508288"},
    {0x1.a3c77db35f695p+775, chars_format::fixed, 0,
        "3258574493508666018008553768521673233102666339162590006158823465137249432920844666175034388106202817984130"
        "3500039379610492680263601798272490077729409636622352080862648395718996514972162139998925573766807273439211"
        "4018704118688163823616"},
    {0x1.eef5de3f62c58p+776, chars_format::fixed, 0,
        "7684350108718560325979481137518322482583512302483039083444334579698521690597104346246846782506582514504791"
        "2125738690485015567714875966771104682742067063862563612299284919405566108773824093990980786495874767991700"
        "6112904357735921876992"},
    {0x1.51ba28979a120p+777, chars_format::fixed, 0,
        "1048655120284885337518169926227744033792394532324263004849928007006875812471199069193755306709216330637991"
        "9042222290411966518177587635202468049196307870481158562870784314762941147915175052356129505961049598992785"
        "28033246763355767570432"},
    {0x1.9fd38f9f73f2bp+778, chars_format::fixed, 0,
        "2582312100746456704688510497983240938087288076216159666463403105145689378876467211854319776664742325252471"
        "7030763325540754649522816359243310063589936180121186606349690383577731425411204043316011649101011138512368"
        "91366615266610552766464"},
    {0x1.2fd85095f4029p+779, chars_format::fixed, 0,
        "3773798625179518109583592016493956431363308988441257087538348984874057927950097725103248996261286271801445"
        "9504193445120757407907189144301239661918136593193902219208925392669956632345212178865841386145270040898321"
        "16221541501954953314304"},
    {0x1.53a0df58b1308p+780, chars_format::fixed, 0,
        "8436467969179780625631377211487559312289964624443803691434778920125581556110900971849535077994352112888125"
        "9866112492343121758586264732710993325312136019615856768634924854433723542000359250601083417088260802375174"
        "77068626899846633095168"},
    {0x1.7853413f16c1bp+781, chars_format::fixed, 0,
        "1869605452284401350966455748990065935657282749067601745091617896710631154777985649130718834954210111265800"
        "5309841330321848604882393473276054144615855579516887007677523075927100196811708898963044271945765289659745"
        "596271845019699344572416"},
    {0x1.290f64c0a0f5ep+782, chars_format::fixed, 0,
        "2951623859521487739101901213624124592744216909981376421903987777371997968009748939217464138961035292271386"
        "2890286875729093249384003468174984823770703901224171760339808769937674915783537892674723102222457228291092"
        "854470262186353488822272"},
    {0x1.20679eb9f303dp+783, chars_format::fixed, 0,
        "5731246293623384930592518792088171426875067753335138844047765715105180926544030424537223802071732817759314"
        "2906472135329915628413376794410081606252471037985964411085601427663278020515065794450484176067501754271955"
        "222237400714209314996224"},
    {0x1.0ae6422a72abbp+784, chars_format::fixed, 0,
        "1060777524386811571192682510470248509957696072219117046158801607497241668618913582255749491059035492778565"
        "6708385039524821654945192201535605651865304171288436653698763647134905201762897504751962718699517740042220"
        "0235531877206380605603840"},
    {0x1.1fae68f6d3324p+785, chars_format::fixed, 0,
        "2286747679664497534205554820454828927543556018383534640120745275210123608679924533448915923631726795718462"
        "3487958174401142746027141560134475739267031997849080010403748431538207450354945415157572851306313404367335"
        "7388907554946695678656512"},
    {0x1.82f324bb4860dp+786, chars_format::fixed, 0,
        "6151644498588618172735745322111653547376394984545317383496026169036854401054954348948745430831246702302444"
        "7096775770639942903909845800613304121256033397557768223233230631826204287457231590026392480924434621501204"
        "0747327614291824074555392"},
    {0x1.e9086a4bb3d72p+787, chars_format::fixed, 0,
        "1554907917153526716656803341341787099174423118479183580971929971098600551279942568153827669834650970330580"
        "5461720353769109082196396069244292976260367817803845536052864117867862067002385049227084017353940632371031"
        "78254440605458957894418432"},
    {0x1.d652f229fd243p+788, chars_format::fixed, 0,
        "2990844031338327836891237353397536704971767675697261294098476758674947546686058981804225247042123381016366"
        "8374978356069521116571142232050936063138545081542868704073789670857785639211755749310612200689386520737978"
        "26470503447254389439332352"},
    {0x1.4c659adeeaf67p+789, chars_format::fixed, 0,
        "4227499559860197203222233767875123584297822581753641873717198937790374846968884348564739920913211517986804"
        "8924005008223799969450036931121190620382214101903000673561461881968860844134242897684375608705162392591795"
        "78450042045898033696079872"},
    {0x1.101c96a3868a6p+790, chars_format::fixed, 0,
        "6921556727173319655887206352719470806468048123722709757972998609127519477299193350955438774717540810522808"
        "1623379691915880174302604761306788949477588944381065447240434730475228438357558161499124050506798805084031"
        "51299257176295521537490944"},
    {0x1.2feaa8c33880fp+791, chars_format::fixed, 0,
        "1546112461847910546445348354554596107735033597804106630847643414096179866373830585260952857725317754100426"
        "4067492187536698174721711543425404914756440588618774810564134699064876355999283612602885953257730947009317"
        "381536957859327362761490432"},
    {0x1.1c3506245949bp+792, chars_format::fixed, 0,
        "2891688859897640505584546769937114410872191007854790954272597962268918205318854546446664629639680565380631"
        "7083603620047115733397089340005717523905233899895025268253712612400331831340802733561147803039200537312857"
        "618649039581864838165430272"},
    {0x1.a53b315cae3e6p+793, chars_format::fixed, 0,
        "8571703697432336776259303005661112424926161972106533192411599787181789783810931630989223874694406417468552"
        "3298415045821806142729843989226217029888046933855786313871277036806878976792362171343885325239651091342746"
        "563574845645114888312324096"},
    {0x1.745bcebb9e730p+794, chars_format::fixed, 0,
        "1515437423092638262978661792606846218941593274821459310029012942349890659796552949227892210838643058225056"
        "7923072041370855924935681800468808621847966030009447663099018897310419613175132792095915905646233854346265"
        "2696067619761155130246823936"},
    {0x1.ea5c1c862f610p+795, chars_format::fixed, 0,
        "3991365102553956977414843677791519944343743790311148869394033396640593391345027585196296350367269990471335"
        "4504427874733144849750183333296788088457049747772037562065867416762573328521955000945049895640840653170792"
        "1573265195554001334403334144"},
    {0x1.fe4e1de13002cp+796, chars_format::fixed, 0,
        "8307426908068282803540365946978841862357902074740613326241075620528922761174857890768232952985491976183267"
        "2867604799739972210630251318172645992742856821927579552970736456855546954531695286593950166665764538037316"
        "4457301122656345267900514304"},
    {0x1.7cd4c04d040c6p+797, chars_format::fixed, 0,
        "1239935058473939862037066836327773954243830981321230556331574290302494015706921369193076927157947232372911"
        "6213126325550744155497240306155654567083745539780429796709211518313992024634904110755279532028184517046087"
        "71159860186649204109959233536"},
    {0x1.5f73b78bc87a6p+798, chars_format::fixed, 0,
        "2288561658292481653078407007381331103925098745031711071330343296205097293734492877075269266829308919460552"
        "9060821113789935131401962213671725689253950098470905996306499422990661339588450775885820505219195445982215"
        "11781291374084313853894590464"},
    {0x1.b69a2039b5067p+799, chars_format::fixed, 0,
        "5712118804366145667832800887250609354813890366337728128504160852009563760948598247640707542424040272944587"
        "7433960467866392390833301820873588395274966080813386511823961252706217774910416144157537907529737908129314"
        "79009600857785548295886602240"},
    {0x1.c9318f56346cep+800, chars_format::fixed, 0,
        "1190849015382164461928315809352810998742665517099636576545835465666502659226083121166027373632019722882400"
        "6880796304542534239787601078478908535518751474443340950600663728659390276471029585583316392190821272919100"
        "890475871653745707435922817024"},
    {0x1.3401abd9cab1ap+801, chars_format::fixed, 0,
        "1604524982308389588136171371286056339117115657816499157541428929533472973745493835204494845668092659796968"
        "6305092574512088968876212563904777324043086752591850228821125008177060006660886576153892544511940324884821"
        "831835718200815935339827822592"},
    {0x1.9451509f4d594p+802, chars_format::fixed, 0,
        "4212493492663987282069870516407756103315064532224695147298337436025008475450945614045277189389181165008270"
        "0847670320208342765294646599932122764460906189699523260166816565950753728514288339317887195081398510133952"
        "380834671272890871310960295936"},
    {0x1.693311304ae2fp+803, chars_format::fixed, 0,
        "7526510477008029533217836706512965204545627504360913284782433660866906782601795240020495594009429312405425"
        "7485247578525344530160009990515022610474543667187401009294509851019000843576260401621898754055451537764710"
        "133944076096837889877193261056"},
    {0x1.df089519e462bp+804, chars_format::fixed, 0,
        "1996376537011996848163492602603437495127794008523924859342071894757509158912938350902427917115985800435928"
        "6350468855830663667815926292170746949096087192572572966237704650573370437541674493107777514668378661892953"
        "4332115383984329784377263259648"},
    {0x1.ab89beb8aabe9p+805, chars_format::fixed, 0,
        "3563537496925402543056858551702721779279944490842035581834286172617816179453272341074919578171269082403107"
        "9431001734386981290710014877418384909788408128871528946477050155988048786430527173515903821312085439904020"
        "9060513455780040766296470585344"},
    {0x1.46cc5273da02bp+806, chars_format::fixed, 0,
        "5447736670805846656665513461167279050903754617246093489061362387012944240167651720678399312897003918195803"
        "6242638454467435113135932680475257141457664214432930589585363496292167588600276715581165797704432034558568"
        "8095697352462571132700896264192"},
    {0x1.4ea090983d564p+807, chars_format::fixed, 0,
        "1115649520754066141825316480918547216227289171323499149438066261329661653154086524459648427649786830971943"
        "7361717764366564551984078700024030142469279336151783283919122538685386893777627674303720356444516323162330"
        "89241962428253771093052393259008"},
    {0x1.629961b8658adp+808, chars_format::fixed, 0,
        "2364472232372920253063237690872446146400710959736874190253892071675979723440181782464807358732399469995571"
        "2564826445273203285839586934088438487705413425312976170764839421218724081281682131154222867366230870489789"
        "95832395381703408449220174151680"},
    {0x1.6fa68b72c2677p+809, chars_format::fixed, 0,
        "4902998551512005499121979386692421692075087225195339730719012538687165637654721543582061012112162991857046"
        "9293222996503651249004514458173108261277398557745366069257648850697333865449354730396352670301570284464788"
        "99210225561647442056843991449600"},
    {0x1.1d5ddcb816159p+810, chars_format::fixed, 0,
        "7611315740938819323872953271895211474478635171584276234311828630336066670802750378506600304395259658449273"
        "0804170954707332095689951255177723791503672412271913757545450746479319606169521707407309632709639593796882"
        "23847143281208387082485955035136"},
    {0x1.19fad786740bfp+811, chars_format::fixed, 0,
        "1504196573819294620072221293976191131314995724591337689338444383576314616541453011609664146082128939293104"
        "4063007870455881079716967466386033030370578182092136818306440233919949340491000711108339985451730457325151"
        "769785159894859363338510334427136"},
    {0x1.3ae2c0e08d1efp+812, chars_format::fixed, 0,
        "3359460420577639957154773556272317452852829619828788020649144926132106369426775645911856906989669446631580"
        "7906039419673583392967765692370244386385047651586952866565244333476675839923690163169345406150878194065043"
        "083480115234578972233121652539392"},
    {0x1.07a5540e2223ap+813, chars_format::fixed, 0,
        "5625581093732572236416854419059991991994498811559912626037135945476694864145392239558158835183631144394271"
        "7007487728670828857067991157217165524572799961876816278123518260519471151953818299245832510132263127425745"
        "862693517199538881917101906329600"},
    {0x1.956e83e8c51e2p+814, chars_format::fixed, 0,
        "1730191634549963935228963857706197899605878404309509182469829469997962268328403783011174669150365085584104"
        "7699993972684677150016631413169402888903555377860700178101361347206102235441687905789332819243706206641953"
        "6392847325840865191718208676036608"},
    {0x1.b8b498637dbdap+815, chars_format::fixed, 0,
        "3761446787869432004084730692080982350594833255547042465216645842029569230353458866080714139839104585830958"
        "4141396787481704217326088717302817844437379170170392971444715003056624059162595716398338029459517985630959"
        "4723079708839024149840998296453120"},
    {0x1.f84238ea4240fp+816, chars_format::fixed, 0,
        "8607754656034729561427290991846434064767392401247219233672032402104931170328457753495749992781302088893851"
        "2877391794685587259569734402818667907894609702812978464548898674996480210321564492153592126714177787136947"
        "2698001655905751301072163396648960"},
    {0x1.52ad71035d8cbp+817, chars_format::fixed, 0,
        "1156252925981560513023673029610029010612362487558668509342358557887466871845476721005725551361299230675461"
        "8734201369323089831816399817329232592863381700962243268612592850117666906932663256884093296640944090463628"
        "56182501376346373114543815180419072"},
    {0x1.48fec7d03fd3dp+818, chars_format::fixed, 0,
        "2246394864375403980527326651485669245197727286620258385556923004315903268604175938971458874735319469158314"
        "7445290290847570784974917937550331548102278822775549310561617178951205260309221459391881943682444534678651"
        "83485659375409167115085108199030784"},
    {0x1.cf3c351de21d2p+819, chars_format::fixed, 0,
        "6325983032753726918904466251966929693126179117236422132936159363701941407139819508033767151405383036826201"
        "7948525407473371253598635858146097053504774680735754482019607694763760820411748962021488173778012204928851"
        "55229266752654874064585229395296256"},
    {0x1.04cfee010a1b0p+820, chars_format::fixed, 0,
        "7123352302648311812940977486599229363261654775925341829761368591273751849955008690383072143433739887164748"
        "1668106254028095527161169584321562092295142705858087011879671879920126685204347898998829081808527814331340"
        "90565968448841286218356104624078848"},
    {0x1.16ff034ddceb6p+821, chars_format::fixed, 0,
        "1523998978888332123850341808023231376640526668535020235447451882314731950193068418024079537155527291003257"
        "7904995435484867544853612253420558684289105266512226510797182253949450660096518781961412812869756857962735"
        "233879680013030703241961011578667008"},
    {0x1.87edf8de5b8c5p+822, chars_format::fixed, 0,
        "4281781595885279200969093983754069266765794250026164885822575561843206962781965631728547934791532920197423"
        "6177409037100598864435472911580957551260375351969260803535135570444517991763118151440245553428809692987954"
        "301004090162477967508729042667831296"},
    {0x1.669c114e230f8p+823, chars_format::fixed, 0,
        "7835530851123770953093081028147155644797778410666203544060056438937022323217689692118563142956249032576041"
        "8404067879533744997877544132389700374854166750696823903333514961763178001608219775679211864880497413015784"
        "159154833577142573195961256835547136"},
    {0x1.58d031c626c98p+824, chars_format::fixed, 0,
        "1506816682188536976124153210817529317132690221642794406751235066145605476647359331234683559547435727310615"
        "5044335297597502204853441775603760283465417548518949886551088247631916208127990346238716541173557612796468"
        "2682475050190476626348021385449701376"},
    {0x1.e34e95fb1fd7cp+825, chars_format::fixed, 0,
        "4224054580562566278800555322953830721086485763030663401123107902783677682725866824330966129891633282135040"
        "0989972207524406875637464954757287300296947794590995851382436932573238352590829031255025844799715155456302"
        "8850116547816966945718645194204643328"},
    {0x1.63711d42e8969p+826, chars_format::fixed, 0,
        "6213052410467450431270982463955752348355173033745885014933541691585524013767370983607152968031929306742033"
        "8431231775899914561268433126058276909759843058020187831906516203457340365795454903377639957069803699072801"
        "4309370022216068485544971660370640896"},
    {0x1.badc307c28bf7p+827, chars_format::fixed, 0,
        "1548221225307829013732351507699867200850643838692622432926966118774203067949246826649292137547628864781537"
        "7097910782288154181892834450581675945757048759722797843011259402057553060481527845525865412393984431641481"
        "12432800361003761689682808487570046976"},
    {0x1.0a9ffb84993f8p+828, chars_format::fixed, 0,
        "1864220165682573503248704544573713126420209039174088273052618099771941502058018171093140670039757003258252"
        "9172581079437000463650236868314242803350408171226231094176077790370649433717215623690613479838917057288218"
        "81800728029892690586075143474451054592"},
    {0x1.b4b37e4289e69p+829, chars_format::fixed, 0,
        "6106758858401295192990763513258752902279342216308475928570546668419196513534241765078705675222282547813767"
        "2227260745563449247475678199017566904097722140187438878011594369887686491510102675185119821049956290047267"
        "53068810448767555137722058562680651776"},
    {0x1.cb3dec22a459bp+830, chars_format::fixed, 0,
        "1284392988511442720522350990489730817592865155726864254510601255073031521416911372712405349672907685990662"
        "1705804846558955256076772476796097947443390854266265023216884341939532691642354710576066588831667847670780"
        "415959665868837863306341265182751195136"},
    {0x1.540046039353bp+831, chars_format::fixed, 0,
        "1901808189069232606083254993296292379380305020093059713712129166634331190765923177464970865624014143988537"
        "7299585288916853409200970017152319393354685852544254621762314547664713839797551310372046651176253573040983"
        "944733060790144155006131906575106834432"},
    {0x1.ba087c8abd72fp+832, chars_format::fixed, 0,
        "4945056610126362443442155269122662718800616069058287822687952843025422076351881963897871117005979636902498"
        "9982232464755664534044906334523871075990243816865616746254709873074943650481520843847600213234428706056019"
        "068656667598654710477124012188526182400"},
    {0x1.c630424f784bfp+833, chars_format::fixed, 0,
        "1016207902406094190275298627859289824485403781057097083553634725388418440581122258598691835551052369976071"
        "0872056273862002012903688540268455594486445835463898257422670306160249841786788398348038840152794723614255"
        "4900694304483602071758702926508016533504"},
    {0x1.85e91d57faa7fp+834, chars_format::fixed, 0,
        "1744783175737113597186847175580875344959143617382329610748081764033990986358949500374522811749920338252020"
        "6953932415196777197734382850955740955244809434074211350191162855135535868180438163052388866943904443337965"
        "9770369684768166645860973519914758307840"},
    {0x1.dd2774ff825b7p+835, chars_format::fixed, 0,
        "4270366017096213024430304816302644483514757455804197397017597895636270238670332252715517948929123803387223"
        "1920206653955204731086891213619258712521980972880073023676067188100942561595631388393387964151624752024353"
        "8505407157611049161933934195472429219840"},
    {0x1.7fb49456f0d6fp+836, chars_format::fixed, 0,
        "6868063596101005477854773261348464798524701803638108696305813468648434233818175939873557846428699096151224"
        "2386052408235307774656820233556520688039217201186384292423872595060052482109916471906309998393757750274297"
        "8451517889868589043980171636988524363776"},
    {0x1.fd01873113f1bp+837, chars_format::fixed, 0,
        "1822171630415365027221376415900069388448512648916632407044265005972434698491503673653271725521188620061704"
        "5155914097009770418589105106014891964691625388056866497850700742112600992456056688660396679887212004750422"
        "74986829577278501646953779544646546882560"},
    {0x1.16ae49bfdd770p+838, chars_format::fixed, 0,
        "1995278255623411223561838811400002441969697691888401298519688370608009240561398085852420583577874589413332"
        "1086828543677591975072573617228550610964643982443403065033000858901323188317634398220391439107359665243029"
        "17790375371341763162002626475342277115904"},
    {0x1.f3ef2c4210cacp+839, chars_format::fixed, 0,
        "7158784748789307949969845835595916478416054901970935629863198516380218616008225858778587086953722042834129"
        "5915495376232539137464579618172301533684206003008057044823541560840931727308747349996468853672501067388492"
        "88705506701643342594415108812000139935744"},
    {0x1.ad8a77a22e9ccp+840, chars_format::fixed, 0,
        "1230158021942028825875071007396724280360324415718175980720572439129494273595706678295852991935378192763498"
        "1033217885766306081107285243057170341353162586149662027251521923877920840694271005199283603156734903699862"
        "760042508068641111106629716312501667233792"},
    {0x1.ee0e5ceddd957p+841, chars_format::fixed, 0,
        "2829845067072680803956902071361137076975224769326587773897721877667181587196689079704822930978717609673291"
        "3155757502472485831512123279954649837442464127269154272613516821521630339389264106498596269220549475390239"
        "525928386877340201687282618195535303016448"},
    {0x1.5b0d6e76dda47p+842, chars_format::fixed, 0,
        "3975680900562016767396350006329006137574382693692484391606729898396076898830929892237233312586174934007206"
        "0319381459938511026797859287500066223711437605222773712234232452529346847725476192414516164592103296163916"
        "103009892150560428500460332836507332116480"},
    {0x1.7c22aee81fa83p+843, chars_format::fixed, 0,
        "8709330821451115252810768012306876235448235163094084495303789891774493820572710069011933753303159801293283"
        "0589918351604190230926986452939490818860258825739176922187483816730793944102196336984779405191945284891319"
        "207064962654856171425270750844538014662656"},
    {0x1.b84441e72b707p+844, chars_format::fixed, 0,
        "2017400597162605500108220584766212678179271387642471349142610713520015337763696332779691942567060685401387"
        "6918822816913092901838605660349967306574048902985017926926426922160650954888618275276621627594251124039331"
        "6495487843867292364651919029871904141869056"},
    {0x1.0552b62c8e128p+845, chars_format::fixed, 0,
        "2394882217848989055998021901272348484946734193824049053308304008127035096528397948456683197420620656420009"
        "7781339190803475544405899998776573917536603926647654712961320719180783745038114302763496065029848115885312"
        "8823296817588537874887085684399549987160064"},
    {0x1.81940cda93532p+846, chars_format::fixed, 0,
        "7067225914874603278195309678783902788952905693466699540646916425206238350149546831618361587886219325008989"
        "4282472966768898902676484983322004983046061423598299625822191743493982170676938693601430832593152728997132"
        "6515959112034442052657625648636244137082880"},
    {0x1.feca14e0d5431p+847, chars_format::fixed, 0,
        "1872441344926455400091247936601365542939173878682525765085721936043640550857611134838492817476006232364176"
        "7835596392820292836312216640738452980201778183460534804882548357947050721479578811476564710237054936967982"
        "03822670734824380038945947831900155722858496"},
    {0x1.8827ec23206d4p+848, chars_format::fixed, 0,
        "2875114620119347314751104891458095780576296877403992097321919590508164098045297604906359687771050438445633"
        "7894213348208064628861252826958842376155582047096680535216544097198269378299696222611619735831458977428420"
        "31555441896836579508527488730801254267092992"},
    {0x1.b5f64571e8768p+849, chars_format::fixed, 0,
        "6421888796776797314705011140285443102597625958543774418067324499776215242475777117088431755748962538349353"
        "8836139322647535605059491506707955299358332456485148910350945632728518921433840059928128363509048830632031"
        "54505532895528456078517711521452946616221696"},
    {0x1.008a415b3183ap+850, chars_format::fixed, 0,
        "7523354749558753381321504126418980468327364467997733415241858639174563751769064813649450220534917850754493"
        "0498222695867201696750601432670286057874645177617496411241789337938266747670617067998955517887930280575309"
        "11086833369059608532445683217794338830417920"},
    {0x1.80ce08985395dp+851, chars_format::fixed, 0,
        "2256975509232508697520349372403327938500010740841229327571034734529741007531663576440705215671731130503406"
        "7651464732222278229950875188438096097098693500593626499599354701491292045641155779313893754223307594582684"
        "179285274438822126930926929605644194834022400"},
    {0x1.c93e2e3575dd3p+852, chars_format::fixed, 0,
        "5363685485901033415692746617568400373839471412857340052632708960330998535677262977256461309418795083601149"
        "0798191875830540965012329992024243324117031846353213527619614592845421867993288949952792623418731091948867"
        "505567571032101385441229409672592337764614144"},
    {0x1.3585fd503289fp+853, chars_format::fixed, 0,
        "7261725338002667344403557962076252731488250874157549810506892522025645778055352124763904040337562208354323"
        "1648655026449962873077602676162884366704660038431773595102305961345607259687165580266364076404492328554914"
        "262493008301528885911022370188177304688001024"},
    {0x1.9437b5f9e6b1dp+854, chars_format::fixed, 0,
        "1896669117686693401777021420771323384015443949488432429213078011540411126315791788541394387891583182076222"
        "5058330334818765453192129841460076462100278905976046462701327439153034708797371088216020877561782110688248"
        "8293831053109873906677004142654823373750665216"},
    {0x1.da62d2c072d77p+855, chars_format::fixed, 0,
        "4451826363670248396549505385686540617023686346289028207919451611843297399671101675106088626630849538390346"
        "4274615058609336233573902160355269482964859583649202118665701266245040516275542749883320102331873934011769"
        "5425270114186248731818945622702296059546173440"},
    {0x1.ed1dc3f094314p+856, chars_format::fixed, 0,
        "9255196758728659170628432222281064940522665134527304285689591325037815345134519735549576304322147319069694"
        "6061186095546366289667553400008860697281408511467619926809726405412032641298125263623772004155953749934964"
        "0773600892533856516647510713166368494906769408"},
    {0x1.ef52edd00039ap+857, chars_format::fixed, 0,
        "1859326412250149517440318386767823383636145550418147260619727093181932132349756416174915336580715499132256"
        "7239047603041733193284570448432621621493452795476340307700011017173112736992081146083085951648580275260201"
        "73336192319696495016121803920946730655041978368"},
    {0x1.e3bb125744a76p+858, chars_format::fixed, 0,
        "3631616735798308771484482403701891749284436082651744295745696697342549405994811692287823083013729596879413"
        "3601595743191760740027506247438700268348905775276841544555486608339876006515235523778892658740265032528362"
        "67137258982023926052809172133449146986873749504"},
    {0x1.ca0a9344ec42dp+859, chars_format::fixed, 0,
        "6877505680971993677356223994766405151817451988281518147786054815774896356806164354151008565525247288890027"
        "4616992886440167995443209864499119340293256783020656323405023028901182987695422028798186742630385862743115"
        "15637490526902098135179090001625391964633432064"},
    {0x1.2411970d3d9abp+860, chars_format::fixed, 0,
        "8770843055493249554337003797751135193930869338351211266532326494187446377060919013016157045519857725860413"
        "3463667990793725821857704198963233115305098870860255165375119695025968781016709927809377866554971062327795"
        "18706602377059819914819060153907843977606856704"},
    {0x1.1ec5847492eb6p+861, chars_format::fixed, 0,
        "1722353804283123934154885356186319398364249521348739434817004802619859209033620424007877073816549604463711"
        "1234221725032105102445473636296300051447379818587313307592113774148603508162327681282960135174331968357051"
        "909828327505871566528836256883770889417414148096"},
    {0x1.1cea572360825p+862, chars_format::fixed, 0,
        "3422411361841638766098396890912778062110215083235591295477425870401383700624137793701609836743389409704423"
        "9954855931215654655245594021586821160094007218215126558146592472447256293895464127754087059265613739944595"
        "777869883504853717504448659641688579757020545024"},
    {0x1.24cde6b8208dep+863, chars_format::fixed, 0,
        "7034346313302069062208036352091525036813417238043122241246694209155837679835944501243406823556247629126691"
        "9226348349396456332785024497156913097466497146801025653409515217997991299068775518325672380319261943020463"
        "197815031497056680470826442214372237094403702784"},
    {0x1.b585d7749984ep+864, chars_format::fixed, 0,
        "2102214352271264253492770247036383359536174278809825156593980866095788231465504791195079200685516624483476"
        "7974238452880747833657553115523757453706247811119231305566117991707028803571386513969815087824748113955083"
        "4505719033737546841534219073919609942945929625600"},
    {0x1.9d037445325cdp+865, chars_format::fixed, 0,
        "3968903357983933358608727332954549720255202522310155795436817007368559434650835388166519178973310116260096"
        "3383266612663095036871450059647424477583739650992874497048749911010885461405122997713224429117789959480089"
        "8868953265027415713662233602012993288552077852672"},
    {0x1.164c006e21d01p+866, chars_format::fixed, 0,
        "5348655415676104112296627231336027614772247455222989517318724204212535141535787074057847747019139160458778"
        "4754476204610495001217242198509021954156308395167323086093598109092711835065649588273506598990479176828659"
        "2793842156241914783340450390835867251603190841344"},
    {0x1.b1ad1c32ca51ep+867, chars_format::fixed, 0,
        "1666985705607390429587775732842376945344938593849607460304845439141852821517546371531540378752848387892102"
        "6973498524768435298612726230798966730370437462696763889738984928558335195928667058746022231367700484346228"
        "33020129626133155057078829236175711168725220589568"},
    {0x1.48aec4c5297d8p+868, chars_format::fixed, 0,
        "2526813006151518389667254108319381996281495836901716186191646269200481823010555095296010845425738392254772"
        "5943004728504424314232279742164538882547748511112862045767026624443840850898104066993831432965637261265926"
        "26063461209454637519696384115499033283572944338944"},
    {0x1.c82791a9d61b3p+869, chars_format::fixed, 0,
        "7013556395550644732713437677960885824232179454919940941733675843924747332970407521161486450429823685670910"
        "8949158012385329466580458908760752813984573839567147974220450311565993202087303566982247820891777751736306"
        "69756457138689042468036550644721521533789925277696"},
    {0x1.6aa8c3fa4676cp+870, chars_format::fixed, 0,
        "1115205775476796964301853677986532252724053391631523006783932486795640689627158211225755787090339150921580"
        "9195632789412681309373034474766406403061693337475881591270220542310410239308185757421756844791871208146352"
        "914785075306301854988292533485142861808237092536320"},
    {0x1.283c03e3922cap+871, chars_format::fixed, 0,
        "1821888512887940305090770184170025435370538532340970862763355080572458243737111367835994275658085505961990"
        "9538709666000002011321068157020717799489188568193711493428769991799596587365795492155389826329926058586931"
        "943076794661977482279539782871784104567717178114048"},
    {0x1.8cea9120f82c5p+872, chars_format::fixed, 0,
        "4882195462759246829703414410105290231642364141974658055501208851097584791737463457393972405597895853250544"
        "5891082483486470444055187191754168905827274986635863594922760299653897737620629889319691907799041544243274"
        "680302980924347818100188562495929432829251712712704"},
    {0x1.d973ddd6f5b77p+873, chars_format::fixed, 0,
        "1164723286943979714412861252695173553894699809557870844274049721549991630300598205809621513464867749602277"
        "8358864404661060686053224949400602494602798264027880378735346953581981252068246346395442398647143674042475"
        "9351730369993756319745282998559730184772104807776256"},
    {0x1.f6b246aa65daap+874, chars_format::fixed, 0,
        "2473329697422188379677866136282734288797075908262518592553912042991205032900868671443809141867214598649217"
        "4712383120756613999577307274079478417359093011890491477801895294832335120235586751351155563827535637086305"
        "8697535795005475738555744173010248664718303031197696"},
    {0x1.84c43fcdfd3c9p+875, chars_format::fixed, 0,
        "3825561477223161940909066356275172054969566444174064538170425904720803636562220825079748903740377780168750"
        "2125182070591173860405139598415006826786757186196918837171900669579489297074184154948051992668950786538289"
        "5043590951293226573743254266501415406206108651487232"},
    {0x1.0d0cf61c34917p+876, chars_format::fixed, 0,
        "5295052253043566414814853105036228490760127517204856884408776032345879648761285187994569004351367730582363"
        "1102796350947825488118113691790816687071197390110822056596096408387588685451868082682101442224663390047094"
        "2204464313973177246167132074412483179319922517868544"},
    {0x1.b7470f572ca34p+877, chars_format::fixed, 0,
        "1729040905959649116039266062978022412098767092460049212752183312254455963818193835565116157857112293790820"
        "0473656272615115635506694725695789350352789294789049086487856655594758061394221120471704052919548629963620"
        "14302506768477688217193036724104566863122371314712576"},
    {0x1.6f579373cf416p+878, chars_format::fixed, 0,
        "2891791152281736301264549189434588087795914065874816462645721514493356769747884874824655769404114014714839"
        "7377315468913188395342221247645370902831663236894162732903279151485411243258636823652251212667685402060878"
        "88147820900177311817262558184006103887903947191484416"},
    {0x1.53e61c25b3dd6p+879, chars_format::fixed, 0,
        "5351505058163175503652058032511868767394723684533712565005116472708972201531957327960367320564218058163391"
        "8282724749280618985202123345078679545965226942036726728362612905208892639318252391998042303703012201843022"
        "82653816452437377175209751915703117701073210525614080"},
    {0x1.58f3a1aff6692p+880, chars_format::fixed, 0,
        "1086211736015682871178201808371556770114085500668976884921131075669192339015059615536150975742301212266201"
        "4754360662152557532516891404769476679247276552896246224430104845687946909316451861550395289285067068085578"
        "438933939908261673483684160060573765056449123499114496"},
    {0x1.6f410a840c9f6p+881, chars_format::fixed, 0,
        "2312878548854693148927226057436939416607481867761090154735580617724218000218069708609072504549106446673135"
        "6012755303159383848137622563092094031187881508973383084384539684615575106546531259506154293856692731122850"
        "835008617650833500338712484495998333181450026401923072"},
    {0x1.c55ec45991240p+882, chars_format::fixed, 0,
        "5710434640774436687944252402632832187382931183484960546332215146951620929538763952710132764959079242165178"
        "2951431574791056980025135631843782634495352278149730287773075570419732894928870641548934721248253607083129"
        "769835264604896319470976595601519978424881761413496832"},
    {0x1.c4390577e353fp+883, chars_format::fixed, 0,
        "1139196396986594757331448843265504374699007604247900558085799169137172910546920893033401160303193176552766"
        "0091780587343007352327219771495560339070418923068233497051337143519196747439316990323902864187453335448826"
        "6172291445223237400317190676258012429832003316365656064"},
    {0x1.80024108442cep+884, chars_format::fixed, 0,
        "1934716715728560130377491523269741559556228665287449407899292044892513832493911335485524695854150038538231"
        "4141665000205632676217046647143481267927344531839859463734603434565955221843700375092631112068208053096052"
        "5914602333952472305588169963643877194149734083891036160"},
    {0x1.d3b49d281769fp+885, chars_format::fixed, 0,
        "4712796592581909901464405653979535403089398515730991561956578413609172347048908316116205111181226290245342"
        "5226280174204303599890024674277497778601021197796448799795592252510655609106998838901008333274706593494509"
        "8638325018724512951515441851702692596765254267021819904"},
    {0x1.e1d71a9ff3f96p+886, chars_format::fixed, 0,
        "9710448034768052672438865544056372222995727213376149307819679901447985404814649941002228957783222378765871"
        "1062208242783252241446793505138663514822554836844556379096450419132358720919983927412907785103887365784823"
        "4049424161572976854377951240964017540898697569732919296"},
    {0x1.a7027ae520191p+887, chars_format::fixed, 0,
        "1704969060094782137012516806549265874882449222201912813733844769685659623879006461411669620124848296484672"
        "2518462807667744540705666302709252842576014145658047281594604891967429804362794845167186197178572452825634"
        "39952765212043058091006226485989331945084763383877599232"},
    {0x1.07cadff975a25p+888, chars_format::fixed, 0,
        "2126466744696046684318576412480136845262899390351427851316858719774877299823980329883929311149178616597969"
        "7663098254550908257893030425271048814655986545809835832964003552304933355297148396313644011966126361581743"
        "08868271748374352726432722496121159510184514510133395456"},
    {0x1.cae05e4bb900cp+889, chars_format::fixed, 0,
        "7398129672423321236891546220313461863382778134828859908120447392860538203573489607075482174702569716820477"
        "7583116464493949889475906863189257955793241183126856649701183576356686203323841536973682145865612956531461"
        "78255710476500506024135400500117736967485460947838959616"},
    {0x1.2eca1796b7a01p+890, chars_format::fixed, 0,
        "9763305417386078757841193044134229981258193838309690644218924513612095217887121067326401043257117670497734"
        "2514487550716649052565855329517679750642028726369749103281829751867350631505109649754054709211049472430115"
        "98819166228787969713283529575588634229583035259655553024"},
    {0x1.406a4282d1f80p+891, chars_format::fixed, 0,
        "2066327308007577766833899464818023159095202282183745303888528727906769831359206965416391205884101072304850"
        "8495601646678371226001698307406776245558511131355442285854719325498394303806171354078769112539750147173245"
        "571337587193911747858038040870387038252781816931388751872"},
    {0x1.c19ff8bce5676p+892, chars_format::fixed, 0,
        "5799178955588580313832306342422037232935263407438997728060381032097221940423277929510634820591793468939452"
        "2696868454464534088801848427247833969714525921428289335535887239762367821662440215785554881872891842616713"
        "432471899850352776136551900415744006197797151659494735872"},
    {0x1.1fe38d5e73e29p+893, chars_format::fixed, 0,
        "7426275326973986307109725841089426303810630611482086956620672977458763980477014672584491894651874473403114"
        "3021208649756677091082854170767961435325955672189926474505080435972623659757700322004879574080770168925556"
        "162933649281172853594080068740031755532479512733798105088"},
    {0x1.9c33b1b47ba39p+894, chars_format::fixed, 0,
        "2126601811602286541187938193096706979065079846562191464812921314485909577776359845661852533080170964146096"
        "2028398488852935375727252011109343683483602631716719725691820861554885109306800026106728345769222998602010"
        "8923825094600902604570400447656671508873522451105426964480"},
    {0x1.a26d55f602cabp+895, chars_format::fixed, 0,
        "4317436423117040120255173529974772254323235675770027155253316788607303528397784489420760216277657108415801"
        "0663748782798132127212331576235229379897954206215901379520328422222986940242262655513958777505518613483473"
        "1324943467913151240603384480045011193118883243399917338624"},
    {0x1.9dbb95083d899p+896, chars_format::fixed, 0,
        "8537997866147937932086834687042925869634241520388951292562346438046647370424983316565328470216235333526243"
        "0230771873812455596864771052946798377042963587130199342368960172506445248640601133589873999711363352992996"
        "2577600432036682866890623144100588419524680589002758160384"},
    {0x1.6af76358f5a1dp+897, chars_format::fixed, 0,
        "1498071428134464007780032439163174763167202332182014380288094036026713263422148028378476693939489341254974"
        "3315175699118176690271333694409422931200364970973511204512283805793412413859670303911008205859277025423927"
        "45474290298130286461010207645790970715880496072204117606400"},
    {0x1.158ee8ababa48p+898, chars_format::fixed, 0,
        "2291132798223344322425528260625168395481817822410114209681417059379907822605362481686082523041084930740179"
        "4938727064039609130634410288293576360996716827534463250611775991152913987383288931208041580642553098466749"
        "31418822021358105569854772475004960990822479556624116613120"},
    {0x1.e6e6e63b2d752p+899, chars_format::fixed, 0,
        "8038363677318396556327995029242470843427070979195756285674397867806939706054063657340754465439219700365983"
        "1038449891623303013878338875318325631427410892018306533606911326540623970940303221704531171196604168492964"
        "37886880687688620940240142624597135728868058798902940270592"},
    {0x1.efb1c88f1b917p+900, chars_format::fixed, 0,
        "1636704223662971872926840290537429665604677025536594739761280558558457785326068421608580561357786593980305"
        "4001782845885335284671227368945859246103833671693334164044042289382713736631949286817233118852275703561244"
        "866825763146062984617418588471703105453076171109553535975424"},
    {0x1.09f8f19708f4bp+901, chars_format::fixed, 0,
        "1756397294592382415052517689161246267131678221066068467955384132387050320961040549809226331126283062084869"
        "8166590963200352421549351353875253525073670122197955377023314616064284302191866777213148361838762790664534"
        "151448437648021580687531829596950159719152557277080794955776"},
    {0x1.4baeba8c6048ap+902, chars_format::fixed, 0,
        "4380651719659701842753667118788096548119882730465151319847756488243301147358915122419429882591601057332012"
        "2560946841358828401716933827331252587490410058843369730851775004171339659600872446832576319585490739885084"
        "627694863349688275377814547997028444578550781519051836358656"},
    {0x1.8cd2d20b35045p+903, chars_format::fixed, 0,
        "1048198470642523089013530392748711464398080640979325475829251742340865045400400469041038616402002492140675"
        "8023326193163199208178263907297254325852268667229134068205337257475898950610434088667461413488546122578876"
        "7794959454342911064675144442738585353876408558614225881137152"},
    {0x1.8d927eecfed2cp+904, chars_format::fixed, 0,
        "2100352450013366284006250575121905479173193823358442030929326332974074473721348101789506582305920565707468"
        "8049500391598287165020222155439212117567418053301191773649724638145328284276963660489615382389845607705999"
        "3174472058950185123299125702872712090700453722243307694718976"},
    {0x1.de6575ee0f842p+905, chars_format::fixed, 0,
        "5054683304672061692864435304560463853057759841471498625299266222670932528434682480388950556864210430734961"
        "0745686492335174847122681791105437393107199395330577293772004982994402169453900947397780936299569536029307"
        "5326737012260339556128535967312245217254998376141704004632576"},
    {0x1.02c1c5af5c860p+906, chars_format::fixed, 0,
        "5467994685893837449997609347765145422775816265185433717909013393764555697633751412155483408337916351152336"
        "7881555527904092175910124413639262604316896685329523998863702831302843811023239789592084285241318631843763"
        "1699837025581837989426185144833604274121548536678718694752256"},
    {0x1.2768e4c0016e5p+907, chars_format::fixed, 0,
        "1248506802584477596000296381325595823899084298806631818341080575665422070104596445969399915381961342690079"
        "5383590162064612193316865424619794643903302734626850573312008182104701579872562992665748874207984281817223"
        "37305318589783277454941621557207209980815620697038786742190080"},
    {0x1.4e3237606f16cp+908, chars_format::fixed, 0,
        "2824864037182867265786832939505776926630190358252825076250422918149873869976549288344262960437848810553667"
        "7304966408485930117454283136933325649318713255058864473449520856540751730462432817977102406488174610171466"
        "88589267521771449097578821541542067925624384510543111693271040"},
    {0x1.f05eff930a17ep+909, chars_format::fixed, 0,
        "8391364185949281078730467478434105301469327044667898156427634520643283841258489468377232362710673433136105"
        "4141658193657015933422048691419008684025794061262560633236970279407026026036348678823852303620175883505767"
        "75298560150181764281568949818405610899480408885000428278775808"},
    {0x1.a23308e004343p+910, chars_format::fixed, 0,
        "1413967563097096406875742717145065364248098469922373112994589166932341330249858694062498748232834710600680"
        "6484626321798080789159899076997530742562675118931815996780577004550133730682895284794882090573608603158127"
        "782382700611832530867974120984653500223207142925287346782863360"},
    {0x1.adec4218e0233p+911, chars_format::fixed, 0,
        "2907211624912509104293964104641252481386999589819741298574261094284127769400019140858119197500533647040686"
        "0867099952709291831619257475813220345780370284209521826263838930895900491215237741201831235226009613342628"
        "929616172359221046711196391821853929650939211266126599721844736"},
    {0x1.43575d8295151p+912, chars_format::fixed, 0,
        "4372977278689427877236502163972562771699874994097304454599200555409637724464561940790454875669360177626160"
        "5615295200492259789871959536407924132018575110763477868487909192353678882153936012938840005244167449993900"
        "225872455306119622800921723936421051368987504900833416633647104"},
    {0x1.be237fd05844bp+913, chars_format::fixed, 0,
        "1206746209172920482170599633284351836454918481996205499641452818517689706180565661779093468811074768725352"
        "9554430671093693945109004776514605936882161265486545965646225296699839245523651426685943492273535620908804"
        "7813317803540270554003913049746492043246213723402668101888638976"},
    {0x1.9b2ed63fe7c22p+914, chars_format::fixed, 0,
        "2224391242910452089394265492861286224565291679092267752042654313557463335787427426545405741454442859262956"
        "8379696465864381006010330236280104796233517428393217620546060560500561730793581895811886061533870316879439"
        "2925077735391135331507600083390485205139796785562476991788089344"},
    {0x1.8f0f2f60d3781p+915, chars_format::fixed, 0,
        "4317611102271228016786766022531685100130220110302580177975195343044698965579434264332022946212614737569659"
        "8605775461407182773007642219213516445390389123848992334909970910238843879068149759722430499092666200101257"
        "9367979653974531063520144552196830827397549438193507868325445632"},
    {0x1.0f15d62fc5633p+916, chars_format::fixed, 0,
        "5865999613363234252700168815533860482840110507026517794916844472138470831888862579919090376343668284567592"
        "2730628471596350822289204633373699926178697527728077742905055274347940911164236314416470252478837343332484"
        "8215428458862120335468197775176023691718933345373884546130378752"},
    {0x1.a13ca388420aep+917, chars_format::fixed, 0,
        "1805713053858883406104851593475653439099582248912919271115374307068690633711321393048815859078302345184508"
        "3465161474658957443597810256405268781492023550128803260698464598891187343705079596513727680472912274227377"
        "09200512048695849494656431906847973487558358759169627465021652992"},
    {0x1.362f096e14122p+918, chars_format::fixed, 0,
        "2684819410822477793708256238350630736813343293691974759958661230424045665709441797057694534150520273102535"
        "2063275298234271972808874370984715108465723496226338093227554271807748758643262677764928395101867239839748"
        "93363047437618046657896564635520646493576084143889699133523492864"},
    {0x1.8fa644035b86cp+919, chars_format::fixed, 0,
        "6918394090981146226785687442953296005321447370756312589232517452386875269326743628444757932344169576551728"
        "5646175201331338042161461746613473883912731283814472816602655230909845500767906523138071198103622194492559"
        "16170496306109571246026337759461802379014512053313539039259787264"},
    {0x1.15b58f82ad041p+920, chars_format::fixed, 0,
        "9614934849906352674358034435479122825920101781110432900338739296670040296523161810516872068575955352142297"
        "7296912242109228430307817710278651885395410719800083878262080058331389980609961031707718320455514485161454"
        "21691615264016637411219377961498887240480935611881565575031291904"},
    {0x1.f7e12b4722058p+921, chars_format::fixed, 0,
        "3489094951176538191756448922762501897909321313118756025897457429641264386812815448542183831292379977515087"
        "5900331696123219592163852102918951996190712669180312837102264190402832310860371995836019024677086930099795"
        "038164349707939106070027734238634052910612717651260495359532597248"},
    {0x1.b833396267bb9p+922, chars_format::fixed, 0,
        "6096297720785518608574674377078686626285827627514784985195986467454224269253458521661432057320196649552268"
        "4402506847391756764778571074538281511211662153889677898205224268147436074860209243421539375176420987837673"
        "061179473769012230731773379533894549326703303424138194371446046720"},
    {0x1.14ff9cd90c1c8p+923, chars_format::fixed, 0,
        "7672262077744884713006179696715340903528000014352038531009845561189201595373630367297725355798413612216176"
        "4185528003926174615453610917327502734566699395900378162311162518292368170942093585324272092751570123402213"
        "897816199751137235767500308035447734094150706669707498282849140736"},
    {0x1.3b1721167a5c2p+924, chars_format::fixed, 0,
        "1745464936311234645811401977433317791686625810948837881843693942930207804590615270733673133973235453137169"
        "4122805547505004347758078536486493581755512213069064244897552740702857411771169051007082046815909825346386"
        "1923710066771866278518787343952413380888028548678629320352600162304"},
    {0x1.8a85c622c377ep+925, chars_format::fixed, 0,
        "4370970349088264546054714374521499700800536247675600541593305086751230639015535006074440112662211818338562"
        "8893591634130105303841351355397209148823854049801509535957224449805744852508078737748916601046347509145089"
        "1077867871890421144700651238367267845567414870002937756298860560384"},
    {0x1.e4116b8770eb9p+926, chars_format::fixed, 0,
        "1072611467186610255195699506318180541083425968946164931134440429099562983560928544709327414517696838220957"
        "7691730267516961838342769956003080500876256414283245766395028552439100716792168169716485434629515242084910"
        "92988143024833061601691689500187256255660717629109506653574802702336"},
    {0x1.2a7f9aaaa274cp+927, chars_format::fixed, 0,
        "1322842383136168734928622730847522068939123185484208729581124710591394860823608943009661178928087703936241"
        "9368574467625772869761730012815322556071849734683009244912396242799723939287778432072347819320371304931625"
        "33391015168714982268831422978156810759831148502703022726522467254272"},
    {0x1.a112cefbcbd73p+928, chars_format::fixed, 0,
        "3696652073770944856273351710081500846137573512247897431984400690049962982301430688264874239621891367390318"
        "3546159606857447498580939661393897508899821878961259077566193093886939323505877645667047538744838184254565"
        "14513165432860037804808051299109674905178839116525770357448709767168"},
    {0x1.36a61081043f2p+929, chars_format::fixed, 0,
        "5506752176655331636540502711187914206125441362527193317710706989807069317439740848973809289220786628648288"
        "4555468373410435455551618029155808631495073624818014753049295448518557218260967701007209684333957186507186"
        "21788286669569369424999561392550693981389439225370897223798604431360"},
    {0x1.98a5de28ff8fbp+930, chars_format::fixed, 0,
        "1448789521114117706527948813277710811636971804841690812426970987651058323754991832082697037916638492848371"
        "6101996728969550512264207242838202930575130917335244421316614871820771276485711677143869529909844813431086"
        "965217307420056734039126102817769912404692662944189803753694493147136"},
    {0x1.a53cb3ab922ddp+931, chars_format::fixed, 0,
        "2986844610156001710864236368072401577881219531149747865967245252598017194972088926670171107217136906198783"
        "7071939787390239299888828179058855299293313493226990708575337541149492181146116029745447674832615420430400"
        "026329727925506366389563259476775092305734497599186276417667617259520"},
    {0x1.6b6f105002edfp+932, chars_format::fixed, 0,
        "5153963748435939514516999808660875241420128731405238955009857222166696819972142821916309711156802563600992"
        "8986897494774746273899778268774215432730115194070459068770093986304086255655853502296108142313212957976196"
        "434291429763959675488362249598031403354267911828901663515648043515904"},
    {0x1.e1d1de4ed51d6p+933, chars_format::fixed, 0,
        "1366566061134506230069941581515647669827904936836285130400736863784619905434228544398880080255337218763675"
        "2324891733745382843204984168669747013968741907785597040206188442129899863626975509018118326693510940704481"
        "5321573786764986943900426058733725257337715070032077314544904538423296"},
    {0x1.e13c425396dcfp+934, chars_format::fixed, 0,
        "2729817037657254325059517605869105999979835898346602030017530624179319470998467167048603329846025958530473"
        "8501728333112429756703714831032291130699430391210776604669442298269223815481168903858143661297681669637595"
        "7552397722265738220831655238058438853369422480860721573835123332218880"},
    {0x1.68969e0aaf976p+935, chars_format::fixed, 0,
        "4090888763436565805231231198228123996924301709315778863528206262378427584688159426565175279451403860690231"
        "0680067407782231685539629405417040770224791051919994786609519766686041876831448351089711686675879007780782"
        "2288950357706699724262413392756445470735520054260852996798068314603520"},
    {0x1.3b22da0fe1911p+936, chars_format::fixed, 0,
        "7150463385743894057149162397872189291435428618033227483316583541735978883828817453589766203220592565947382"
        "9125446783819711875924634269631560072360273768476625962809137486564949723089779828896658245987950759317776"
        "6553940950035435273202528651698676033968867504991057070045076471676928"},
    {0x1.4e66e432f39f8p+937, chars_format::fixed, 0,
        "1517521083327295139731717177109312053302870069107147008113001038704411865779896400819123412159105395310825"
        "9695586208869550977455645030770653241052540848617869176493307109783276761933251361810228255632506295550694"
        "27362782422201363564357317874795808595718985906746009234596759127195648"},
    {0x1.cd42a1d8134ddp+938, chars_format::fixed, 0,
        "4186412589165421767898716015432613056024086300173594109569805451109295806380953057478024743232263219866313"
        "6541830262217102389440103279083308727370318469472103959648186828128018472091852429202120707467480690510312"
        "54669662460887222261960281257747458512455969074216563763504450258337792"},
    {0x1.5f2cf251a2c3cp+939, chars_format::fixed, 0,
        "6374560719497041460701147329748632119440885185527182640520984137567315850917823015770083842564974131596515"
        "3178749077315627273694181974600394749841554191816591821625859252389807056373440212382991527479956896621112"
        "51632663075464418798824836792784408317689148157466121016089825903640576"},
    {0x1.adc9e02b49a66p+940, chars_format::fixed, 0,
        "1560309767506257489675888790428458001466658874729292990232938636478392151994043561909739907020146439250200"
        "2502889071505906047799714943906021193927813417932587342250037464291164675731708499008092045363925855484561"
        "813254903791863073045978225400887637841137225271718710407150443264212992"},
    {0x1.3d3363cbf2d84p+941, chars_format::fixed, 0,
        "2303138994294190935226852719823449637957706839633620331774487681516157647997617198352065945583102472309907"
        "8395391265344133836092564623529452001123181686993342188668630395503520019686951640906920797579123077911005"
        "311195074484622555449838749756095271033619639701182005144598929173643264"},
    {0x1.d766f62bf7f84p+942, chars_format::fixed, 0,
        "6845537430162202819243635547282384623865630523052170655812924234493680000202051886886806429640053035219178"
        "9103446622679054710651824601063699795212899145117894716268443433970383665653774839680179902031305021971768"
        "776346231778021269958063780588872346431583200394283187585456728088510464"},
    {0x1.184991c55d18cp+943, chars_format::fixed, 0,
        "8140470197133931734428738306748654022124701675695596709329038381281146508844610735228040868008048242819544"
        "3285984630102297259934379258403210539301744278637153895956503034979477752839009780477841202724566363451047"
        "078458089708094639868097495758509389693820290367400727907449779154583552"},
    {0x1.e8b3dcebeba57p+944, chars_format::fixed, 0,
        "2838707086595763604355226460215788354155062149456756370153617957977613916383732094422601856621444842168281"
        "3914671499422962520918011100090623468091757683486424953487526144699470112884738808560838601800306510869156"
        "6848732851954616351985795075190456971406831718621827217641148650350444544"},
    {0x1.967cd81cba730p+945, chars_format::fixed, 0,
        "4722297205156322451935033800902271657380330388166781249078844472531184077055662309294098918683511277263521"
        "1274322478383143828515091907403699999613777913405300109811578199243818649554348924986028138120740783254364"
        "8176623038761068209741353579116977976801854769065041573240303400423260160"},
    {0x1.4cf2067674a05p+946, chars_format::fixed, 0,
        "7735866498835462963282098049100353143835588059605679122181958735546473359301043785113342800098653584376820"
        "2881339731579242843976021772296755652531739255043642318470742741165059640807778747078183625844484565756622"
        "1704456125209427655591152156570845479024339183607328000005037882486030336"},
    {0x1.396e85b33c0bdp+947, chars_format::fixed, 0,
        "1456494620618158084459208459420770422214927536576777900279771118932370050161556521689788247934469660196579"
        "8721400180531472919608601157825242581481197718827532284397109804084993643161754366273822504660151826112811"
        "32374308583508656325781250344038137418380156687680087240907535210346708992"},
    {0x1.95206484ce576p+948, chars_format::fixed, 0,
        "3765187536411293767607982637363828513465621054834409479462724471987875949761786891019151855075713264875716"
        "5903363847317049616325971892969467450305542675957244941206979207543253336290149657218116776965368316485391"
        "66571141383041739341196077037239708754641370459694088122009910159310061568"},
    {0x1.22e9ba39c791ap+949, chars_format::fixed, 0,
        "5407406833340396522675098123764498345666847968993094015226717680122502831876966735794037632907460591643106"
        "1417922843845411520165846890927266983643524214231220854779294391058028067273539481325897959134379456820216"
        "27098020277135686194888669422944751029317284553997638270499385873918853120"},
    {0x1.c10015e885bf5p+950, chars_format::fixed, 0,
        "1669177722518344273415549369518463866259090463325810047247048853359097793051530435198906482304997332747712"
        "6189569201847643531679905439914069521049750350740191646900576278399142863638015589023698201833596072165979"
        "582528813031375076284990869886696245331704707225600453047248955585985511424"},
    {0x1.7e47eb8f41b03p+951, chars_format::fixed, 0,
        "2842291093748382815920588173319061198852991689166578053613126094345711868593940607258163435142829954632057"
        "6039674947354409622194167614647980942927688441394664988769965156684016039562858582192035802389832782256588"
        "289515506812686376870544138120305268181385592824850132930562312484883005440"},
    {0x1.09d0d2a526197p+952, chars_format::fixed, 0,
        "3952724615386466556695108729477857830462388988363697022489397885452303811179772031609082741394749308321289"
        "6784472224927371790261412898525223903773488834898026836686461131769297466001418605340737269644574857450341"
        "578296133621137927482641494123749218905855394522144524531019546018141175808"},
    {0x1.329393888f7bep+953, chars_format::fixed, 0,
        "9117687890595328511827970113600540178658790276010227086543682999888533832962609232164085312077801071266945"
        "1037369846018808184155729548970048798771986716809691514577371817315812422363402546217710091494507737209116"
        "100467436142545614804211132806327613747648211271222880398152942507767365632"},
    {0x1.bbe7721540300p+954, chars_format::fixed, 0,
        "2640371517686009502269944905314196857610042416188409329493154957126231977636983134735640750000859434586857"
        "8388667060393589683456601684868123235871260277660661634949848655415180774643363104994880195726190507098086"
        "6218863512709255609194971921954793897583681193907186498977864992248177885184"},
    {0x1.88cbea96e97dbp+955, chars_format::fixed, 0,
        "4672760871330719181173159500896037529822132598379668723322679962219636658645173408958383205774241418852472"
        "9979082356117106965134483252910595432217633340497939646058701055096633058521775335290507969016326805223029"
        "4873047744394947965285062467179754729677808277337626448692513961219618504704"},
    {0x1.92de904946e55p+956, chars_format::fixed, 0,
        "9585177496788628387142470355015742212486238917360070658610426925030214990977153058152176450356649681790336"
        "7952042515523493507436053813331569470420445822249123926247567133249307863703233304674289976290756088612297"
        "8562137242199024883969219071166888547570446344670542408167905350651582873600"},
    {0x1.7f42451f5dfadp+957, chars_format::fixed, 0,
        "1823719730845467935252133288969682350721256183200026152024966384902247490319395306206450777775000728278230"
        "5584468898799588965916746439892707001557996930464421414003555234003365385838436499046029165006649216313147"
        "24659998243129794062500661512152097902395046413344222843293713779303676641280"},
    {0x1.5bcb0fe12ff45p+958, chars_format::fixed, 0,
        "3309916067143353509308422467251436064739440112327605203935023467392925583502528567943381470440057281325203"
        "7631616540337974591546356439900881755771350580349423907729282667309320200818403594129982607779730691504764"
        "84721278024806918523029143876241835657869581941341018295520569998556732063744"},
    {0x1.b90465a9c592cp+959, chars_format::fixed, 0,
        "8394239974695799137286907828194240402021747779379374890348748683653987512151853218238504873099131553545012"
        "9606629267347365557213473538261645610678099731825426593053238188159102648963799654267675617881491720751224"
        "85056808596585496363951473489693787263841753239641456480490412640309010759680"},
    {0x1.69983d358fd5ep+960, chars_format::fixed, 0,
        "1376505367275418285918454682799556281744180366785115914292380535790408233716300592361359449030062026887964"
        "6442765727268093432290312608512568298649956460735499043421724231696037756319710881966456670774643933394816"
        "839437145361195475585915790038086938448416859756069308137927266057545163210752"},
    {0x1.de946c1935bebp+961, chars_format::fixed, 0,
        "3643679829326756854990321834751813757472665171774164410575176353619125026671266145125877525563560599822883"
        "4201290124600643409144591004477627247750056004662162883889308925062806886760585732591401156829935941514163"
        "437151042307371112230166232390702102964620484295971653304142427375365317984256"},
    {0x1.b5842f82a9de7p+962, chars_format::fixed, 0,
        "6662084711556888737073947375644206506568119676991133168261109249671533671871515559697788361716287852384144"
        "9119524422880539955471646835289884068563042614219856260062907517310146636867204299065684544126277649452338"
        "127010045221858188132828582061277352981469985490408290156135533130942236327936"},
    {0x1.e8b22ed3af96bp+963, chars_format::fixed, 0,
        "1488280074828332439997705846927264592847263285162991620634919457926813570888474496724375189954581591825810"
        "6356476421281172420190532891044532412190612016616999360124778825918915150278377287131102941985635431929293"
        "8359404923519710627910962261670847242925348963282404187971202996261023196905472"},
    {0x1.29a2da729cdddp+964, chars_format::fixed, 0,
        "1812848563407435318665103271085141879976583019164804492079628993979783986655462858316005770828764150814783"
        "5341699166075715528253946274407735707796002959684745400447999976115259511453484550003661419801563141426559"
        "0188431157433539282197161887547513163560678186514777300223161756952567350296576"},
    {0x1.276a30d060d86p+965, chars_format::fixed, 0,
        "3598637576458590111840117385743543166539334422813404319599309026721155733548251740840399891127183593846656"
        "3457897348603351501555761876916814911543024120253006764961962489310312473579522696109479433342243946843578"
        "7861000044261520862271340282348921123669443147738197112216532212442847112069120"},
    {0x1.d01246917497dp+966, chars_format::fixed, 0,
        "1130630353072375755137934754023028387880106704619578987854459135758905369025219831719631830560829247104804"
        "2657351042564933344721639117478343535402443188370987099319116504280182849360957780070321495820864051770889"
        "65595898416550699038646583977157339794314844188021211564490649717795032156602368"},
    {0x1.980e6a27628afp+967, chars_format::fixed, 0,
        "1988318424383897673041093229690321504377325734772213979328273102004376962789771142769689221409494405615587"
        "4577353288025561072120486850801011342519919802442507756487497529091100008383128788061631909192385819609445"
        "98491001794144386958052292241630342045252697101128134565354695877741983337283584"},
    {0x1.437c0e85d91f7p+968, chars_format::fixed, 0,
        "3152458971727972088271522584576841595017476408350484024213020426351601306009874958691305503495873140344934"
        "4120837209365039614219706654045911383418740437970714190615897363229882508602521223101844253649126244343767"
        "12560730512038580641775599869341924017562703624377521765695489143064395748737024"},
    {0x1.1ceddebc11368p+969, chars_format::fixed, 0,
        "5553448658483889498581539525533215555459922290832105470455447395778318808756164465828978162299776557137749"
        "8025486036130367992289300205712003021474148459088330889275882646754413619478328989089270521743646337866976"
        "08550809012398518292302677846190666214723168559532363121548103075175628747571200"},
    {0x1.f13408b3aaf95p+970, chars_format::fixed, 0,
        "1938160749820337358617569655781794481265906440306510868326219063396137205587268584015394903508566804558057"
        "2727168483169888813544953159009656580157426651582270490076171843265331366857398808751854868343334950335271"
        "862852572593152703307164355455704785758224484450798612380768726365918063744778240"},
    {0x1.af9922dbfa336p+971, chars_format::fixed, 0,
        "3364847896300296869862042374928307250449248589901973524911036178856186397043114384289618133383868345881461"
        "2459859556927825860962493899864961836754799336153280681646256720300580617990328257017412749516118667033519"
        "617412877924128534588246437115544693678681843960583893836646823695670362570227712"},
    {0x1.b6d988f35196fp+972, chars_format::fixed, 0,
        "6842765724941905947916115492736327014329278437219995077727487152277149907130550370856295447076940886213887"
        "3147480237432588536217362770348126910744372289332447477347428161691026629351599796138689644770675420773355"
        "753525455403314756439454112546882384282443317925562970942312363902161635738910720"},
    {0x1.90c721972c4a2p+973, chars_format::fixed, 0,
        "1249825938708992998754460472922920104746118308100169669591179198566756416920144596218021866266429717325722"
        "4078341600170450617006812468031203181675314567467906310050431941451480055567229392119043931302728285141041"
        "6527131226964653068028871701489323868875661390179301613620908627438519900539191296"},
    {0x1.7fa5032ebc8e7p+974, chars_format::fixed, 0,
        "2392791615385826139439300643911146437558959126293906788098470369938702999795441688618776497596037571666377"
        "4732492933413361697395279766660762163053855741928754105932265202987225221490104027741592772916452744334157"
        "3258308076333446631106547639938187560726465677882789688970890598968747947810881536"},
    {0x1.4ce903c008152p+975, chars_format::fixed, 0,
        "4152722646899414980588312000821606280564937630876292475856059543224122545953509575582972272632353876168181"
        "0010924491150575390692502270005249227743759120939016515218117336974702624879803738329131066638102954845430"
        "5977457986611411122735356736460608954225433970661515041585228932440487179403132928"},
    {0x1.1033cfd825bfep+976, chars_format::fixed, 0,
        "6790906283978801716186671042844327340884324357258325691213782880964393725253636056605757532196239247651641"
        "0929537382448923715002547882415900908088044125341808699192055187776245203855785821826033218217154724236274"
        "5152998922247516579175346880356048429165046724254554702021353471037187691525439488"},
    {0x1.0fcd0f994c6c3p+977, chars_format::fixed, 0,
        "1356178576074932367866978726568836556568964094970861971405416012976711060180517427903380593329117322963023"
        "4969453438982442226392090195313512065880006858358710235243352553689909557144367669578006873842586434861599"
        "80898573992763548701523679724999841102526974236295406990913753746951524692055293952"},
    {0x1.4ecd6004d6052p+978, chars_format::fixed, 0,
        "3341059095259842031705908954890593902583462891609397252245762351681423524432142389594976840618913063366843"
        "1736876048481591920402160526446886009029718998138187592518899712938766195979432452826614892642216860271597"
        "31679090731728037603430553370313415095082805462245669418052893304307800157894737920"},
    {0x1.f3efb39a62b6fp+979, chars_format::fixed, 0,
        "9977930881477502672654523893810822539174262015181547528004373399914172651650280510114050036517851280729310"
        "3483270287908172488479635472429852391205913527184601284844129823533288723242328051246858569389855346025180"
        "65129004909212362943512437101234020643757629011735714458250584381888822081044348928"},
    {0x1.7b90e1f7acd5fp+980, chars_format::fixed, 0,
        "1515106038250911930323007269661608539782400613824485269823157871706838649963809208560431197661416733417210"
        "5906748535235901980708457410198184620788093383477763282778952752339058653659862971112147616374073340458735"
        "624035902430001740279680217097916130499458182712540460766316226317254024325738004480"},
    {0x1.780e24e541603p+981, chars_format::fixed, 0,
        "3002184910089352024335822557467088962081515655444957457325005191265432611398728483535314520167667352571888"
        "7504269788180664121841910641245353435449304351855214142643335804597316032113489460467008188118235798768059"
        "751952649200503215287587191207086694028505970883124170608147640357927402985570172928"},
    {0x1.700d3d3809014p+982, chars_format::fixed, 0,
        "5876579596327993022784810363786560100394378705653137636003630290527375252110556752828674598502825538487545"
        "7149035636796524147140419906897446621971953601388118050607284035635741728837647620217411773045592902437770"
        "451522858269571663877746249378744932425279354599869012839882446798078904889967116288"},
    {0x1.b688d558b5f6cp+983, chars_format::fixed, 0,
        "1400391748829508427561371989828628654390094654379685278620574834010309817686902745427193392136512471350624"
        "2484004346866449563603204670620822309825395187688945258116375683563999776785955197613481703986052348446144"
        "0124895585825179963559084955205686769325898379507940166327523415178499971301572083712"},
    {0x1.f01912b454894p+984, chars_format::fixed, 0,
        "3168423262194204738527726410150703955606744016936273104761288141601799242343771061184655532204415834272239"
        "8891527757901336200227044450107894273649413104299236004814623370181797955251848674554964186894050852024727"
        "8182505289084695487280862714932759338066051522762627957622658669625057321641956081664"},
    {0x1.1006d98e085bcp+985, chars_format::fixed, 0,
        "3474700589684215405676624171022493925327895749427976470785052614733461449521266111222951339227123391215685"
        "4476185107350635385308364780059851509940573215572464022804595298279648920878313271543040662798316640519213"
        "1258940257292542957476413248506076428650670534137201954640611227376407648222278844416"},
    {0x1.2c3916e2ff373p+986, chars_format::fixed, 0,
        "7669723855021268596083260991127614609891577065725339072773146046237811451796225273821871338898440274475341"
        "0064405524435047487136748243837561974513860830823109563623271246170547844427171279359216631158125320663533"
        "0061153560207434566610596179623433497342212224379877437918600098792472693553791762432"},
    {0x1.0a7487f857db1p+987, chars_format::fixed, 0,
        "1361413192509653322735827730429732760562001096467427339051917514610198108671646239003496382177992474878573"
        "9562008053248180518804706631518893074790348471379835377058536186780287202477849752237696900243942214620588"
        "98780565314051488693571227506727823926105057168671455333801700670110926825836349751296"},
    {0x1.3857c488fe8b8p+988, chars_format::fixed, 0,
        "3191738550947262240174196390274179831602084289146737287163911427996850154072007438579318347355028923084754"
        "0653134695263194519450157220167768105073651723636444589362144051985825621212239253696269866857190204603967"
        "38617495507842843305566526087166039077960918279884459165757255575108034221542182223872"},
    {0x1.b2e84c3dce473p+989, chars_format::fixed, 0,
        "8888378843987562418516420774536055875880215587503712519853284905673607825016375290440927071139925425341818"
        "5944446973470003066186698313761897833628284399899232296260594245626950225486569896197452836176842807847393"
        "76094743421421524562002257540912448826271782010926639892392033944710549976982451388416"},
    {0x1.71b76b7215201p+990, chars_format::fixed, 0,
        "1511209083597545648269104847032413667646182441103813783087500083922331916924246476808237041403566025416915"
        "8866970278017087147522752922506066201760164519286966821272286952676676235656098321740107241152698605542660"
        "799442146505061129659657887076900042124590387275392937317008374397153245502302047961088"},
    {0x1.21b184ed36242p+991, chars_format::fixed, 0,
        "2368232792394045592907485540473183588520053039663596736804105159275720662485864569862671071322557174526923"
        "3572952364463497530622281253432330216494969540793671013008494434510222402947619422751718115470589045753965"
        "396355529469848408434057376579487220386627111660172302509770187382123275691926545760256"},
    {0x1.37ea2520488ccp+992, chars_format::fixed, 0,
        "5099780421145732430172796978002178493219657773712465197446157433528141629291114053707851380034951605816623"
        "0665102398926509396805097666543921332551215402491474991834159110468760387855787708151727786027845789596274"
        "715728449794070641109346128933556201664107191668445099152331696871514428213048815648768"},
    {0x1.4664dbcd00eb0p+993, chars_format::fixed, 0,
        "1067303337764472558207612827956225689002076275259891270726186261290460562838896340306131448503546150701933"
        "7443849092619515427015813868732735904065717939244093070771192416618279480647059892487980542131200172770395"
        "8919211691346875357854618106887096598976434119814713819831043038372307216901286490275840"},
    {0x1.6b9cbc489e09ap+994, chars_format::fixed, 0,
        "2378013021177000863542879802805495514342840555979292208592408212522200120751056466262068322605779601917414"
        "5264041745386355521909812299455547924135316999304726429467529717059753209028061780043768961726888620722928"
        "5482891877778657703920272278134074512640642342772726595535234502682602103798938923433984"},
    {0x1.f513bbd25d6dep+995, chars_format::fixed, 0,
        "6554057728282088273408989938670419534562784654004749964505990799598384510911984945454308319586877780571247"
        "0709246155198754800325729039870071334566159482962115836603561764337220699871656323296193675700388227695912"
        "2708936001833829616557908400458109782703568488107962693518959628276723172599697604870144"},
    {0x1.3e00e64a007e5p+996, chars_format::fixed, 0,
        "8318933161474208239138244783031393295429686149692453351817687406202137819571369672461631470905243568748045"
        "2344945385840798908154889072644700471440528658396399806034644184126184960179911705204764348714709297955755"
        "6891805175387244452772540164096096030738843539931931830599736589422869440330138761822208"},
    {0x1.04358f2000393p+997, chars_format::fixed, 0,
        "1361408270105775828299160551697548957928811747469574257703326768944182915799744952896263039627607256777184"
        "6656327797897499210538162973482767373033877343410507704148182660523911686944081033779016427297188372354934"
        "34622743766811503326558480996563151364510469225186261976905322157612487935439550111809536"},
    {0x1.ff5ca45dac07fp+998, chars_format::fixed, 0,
        "5350865811014990284942192842849390562587048732242189849768215440609076563721324457217609971532665543149436"
        "7692959167382963109998027962870458639423046259352855553385281696899266289307733673015832615500102062652623"
        "98738807874995959199986290114910339936114860975870138690918797206511003398780232983904256"},
    {0x1.95dfb7963208bp+999, chars_format::fixed, 0,
        "8494089296675852658549484918212622743316661665812171612122175668006467773461153903337808047969308652843259"
        "5426418755589765576772662481710377489716568772207399586386914619422465426427181541276443218386030711267423"
        "11092793152059699473302461456023443866238021717620357163817975956645460032632423773634560"},
    {0x1.042ea27af2ccfp+1000, chars_format::fixed, 0,
        "1089013402778421431393034800940209922880478638830842757754958900049052483817153688008331659437650336092382"
        "0392795616711337787448876524123449490254769141101794549844398669582520673639828304310115553416089199219491"
        "153554556979108530787196381372092387340130982723560970359575450657479047437786029202866176"},
    {0x1.19cacda6d507cp+1001, chars_format::fixed, 0,
        "2358927877102592004528582798246123679681703630087718597748855427933584215878224419198599063292612150307790"
        "7652000366655921124159236733668993049853618779829576694619427973473812537072705272983173672330636015433777"
        "950412177760641174727204088780046261172088405036986621286405986734378144157024874903109632"},
    {0x1.e4dc48c30aebdp+1002, chars_format::fixed, 0,
        "8117690363105264865533708088415713875742879852292905831990096302089005205398271218130044634633378782912170"
        "0353552736846220325179555283701149493529159663325631748303262086329374073949673246604454694795266625030867"
        "472373502272570181905030453820398128968285453872513665526905113335684193781314404248190976"},
    {0x1.16fa9da90f9d8p+1003, chars_format::fixed, 0,
        "9341511426794587620836724813109834191208553050520394301727004450386313219789396277145074527533329034785481"
        "0996060014050974256615370965247946833602288854220636677899882124481182200368284438935937724411219747755380"
        "016760116417262780962600310403215068957481809727018548258602677622354836648271052026150912"},
    {0x1.8a86318c46281p+1004, chars_format::fixed, 0,
        "2642100432019359922222064335914842088328155609718907491375831812404861631551113883459814041718784949039679"
        "1244080065878607868133673114397037915538043969012145635567418878924141006499653329450812671793356195918577"
        "8192754757376080092862115085847862393689963492786526884623762776875632820851286300067627008"},
    {0x1.ff462fd806bd7p+1005, chars_format::fixed, 0,
        "6847933389378864334995195437342870627133767658067754565611112423454867889953014019812264031670380814132469"
        "5411179000499603182801500020515071507814898324063724387150008288842134297762012303937455168173797787865578"
        "8295179567168650606205377274978890097754212420262333936960341237630114805596678852383342592"},
    {0x1.9abb3e1c6258dp+1006, chars_format::fixed, 0,
        "1100255620018400702308143874179289094708076257600082156362901433283474967995224448775775348330029825350784"
        "5587920641953420422722195404300554251098322908384237964741427980219082903574723830698253480240845466355370"
        "91282385282353501007663737911321641626869306594390707034645320031413007213532753781288075264"},
    {0x1.de0bd3c1f52abp+1007, chars_format::fixed, 0,
        "2561153089209499451450108883187135838431944890345289232562567670790474032784993077517551433824974196965788"
        "3859230897100388642398768469698484561986559132752389503697246954564350968078109699787924474173314642916495"
        "93820790500115221658520513179659203340914713114632244088248136782610390183342216645609259008"},
    {0x1.d9c1bbc9b76a1p+1008, chars_format::fixed, 0,
        "5076344585537475813761151329271831544962994883865596230707128468133757349486378718111403188008801550695642"
        "1091981481286994724230486016166000868612123718765692513777948923292191374860899741743361159897078289821867"
        "70681263550628277966122021347502889218558140981978778760709565257654468755221733041969823744"},
    {0x1.838389973dca2p+1009, chars_format::fixed, 0,
        "8304487832500948763665787260588002793145134106225464617649330176041142787088124576577881178863433513982288"
        "7779176818155851598178824680178566717352111022359529341838998629315886484033406785875117879478875959346386"
        "43446637560952598376682571125723765484978607914917947356221830413431528356893552064082214912"},
    {0x1.060853e168c00p+1010, chars_format::fixed, 0,
        "1123080444666546301777878963934799099664396571463402334381500916124078024627094771314789772593194701733562"
        "3763019109215938315064399499114678702426677155196395562512625676973629490891725699048630439538271293954132"
        "944471985636790260821195763195960709126795406948190820263635402442656971341237103098326941696"},
    {0x1.f308c45ea73d7p+1011, chars_format::fixed, 0,
        "4277755922081604265385731003870414636675211815528525166515441193283173524515214526116577671174238835415601"
        "6987199321943069906953191709200985805991473654422677796863026046204131122140632089138619896078253943359779"
        "967819804460846041770466218522657499957662378458077745646242495542457900501384540282123452416"},
    {0x1.6e7f0598d9a7ap+1012, chars_format::fixed, 0,
        "6283260967439312321793941478600472136834781014816953260382384706038874291670268315757003036986538537806169"
        "5042342257016325640854560981897007228730601664309292490339180773764661159594282018922741338839585531864854"
        "596993614806461429966237140466546002145002610631737886461529165004165330118612673778600116224"},
    {0x1.90ee34c61a4e4p+1013, chars_format::fixed, 0,
        "1374721516419186455736032890241718308090950277398005330501602487559466724973474834596108952144525149107676"
        "0161371030946104850545438257754381973659153645099708064799494869929937271094708615446698975028528698722301"
        "0010358709717485396216234719231061846048602963736424188145247774330747094015196695990582116352"},
    {0x1.e2a0a3d09f949p+1014, chars_format::fixed, 0,
        "3309692927391868361486967991604904234511951653533894719501226432521292268347453245940663906285425386625813"
        "5771915111168736218389811776587927240863291205346055402758901819603218140364375221704644685454587645911827"
        "0311328170300273241053563917737426045554632200608705001740820709150305846610578306477689143296"},
    {0x1.c1f1e31fb56a1p+1015, chars_format::fixed, 0,
        "6171133478197849282390517627431306460094801359895025970562404481097657813763533609936439679151871466284237"
        "0928051624194822539865806340825894402647560060436739555106052989538844073638999851345424789758896392741219"
        "9886596463797584431228714343905526280539044788020033342657437500226579170692177128139530436608"},
    {0x1.c021a05af3889p+1016, chars_format::fixed, 0,
        "1229252101049421320220839212091034737197493286199636265221535468362635428677845097705645798882340660785186"
        "2663713256576958288897748280964823036198994326915865563426861434381481536883642706185724402134855112796978"
        "11055580445126773330393578734970725834547100511308555559785816417647601996123490828625750523904"},
    {0x1.a0ba4fb02d02bp+1017, chars_format::fixed, 0,
        "2286220295463317826172353650964968564170727985030029086980398242025886246164731357645492228106511645621918"
        "2959097742681117375627065808719653571450868551945456981280565103995670323842785460796863662205525864729263"
        "46841213905402221500853475646279673353994324548018463119634259994839858773138984052848465018880"},
    {0x1.3f966b0ddcfd7p+1018, chars_format::fixed, 0,
        "3506594130884535498475346454243139100767422760433561214852206574801782510453884430705755089558040841617942"
        "4711841630794438578685520836445166676048320954617860819651051369003901818091804579152460658452242729354433"
        "46243739881419482228334516326372503115386643937845878401903583322133727281304761523559911653376"},
    {0x1.f28cb9c6710a9p+1019, chars_format::fixed, 0,
        "1094042224758922774331628525752344677114912160862655925310463893100615228912566476241883748789051728586854"
        "4197084268693535114301521886251172039242934377863244918632927972972091308702040655975609483203160018660194"
        "642090669215782471906632775672148557149263319590356475272060941885997193903260433671483161575424"},
    {0x1.c941430ebe2afp+1020, chars_format::fixed, 0,
        "2006845819301448565923369096504654157715022292244887680207969874959492765948492536407905186369307992254996"
        "2370234075267907510104030015375054184658913782338904892471130339388202458928273358393081217222561624956342"
        "978681689679366741339635310316349500249207446752433563045842746492341156586638953143467738398720"},
    {0x1.3e04900b4e89ep+1021, chars_format::fixed, 0,
        "2791496372374563643332709866809290981114730224378050606994822818228326594781000162780323911104517277890639"
        "3098707244757298090886194248239218943139090593484015407218496749128358376605186663256302502757258571365175"
        "630215388510334525743239925811352693280111872637884811742138711874263709333351600610928924557312"},
    {0x1.5cd1470a36d2ep+1022, chars_format::fixed, 0,
        "6123699292104194981771404189192852883978693833694232208413709518604296181981393604802892672354866046897127"
        "8496965458693991743225149388783817396573788778128574099251588335294401179946164342339300212146009105558717"
        "985452576260185887979241983673503558946414035103004649802078842226017422195444929429676453003264"},
    {0x1.e4ed787bb244bp+1023, chars_format::fixed, 0,
        "1702638774998990104935280334555195796750436559084917131548593325784866486976081021679835107118659466855126"
        "2984927294793703708001158120333242616861941586246075606910029233718147847851055755750691813753282576963131"
        "0693972479511748662180221113394836543075210717029725044946195117678217681054268005181200990732288"},
};

#endif // DOUBLE_FIXED_PRECISION_TO_CHARS_TEST_CASES_3_HPP
